/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements handling of video stream probe/commit requests 
 *
 */

#include <linux/string.h>
#include "uvcdescript.h"
//#include "codec_defs.h"
#include "uvc_codec_if.h"
#include "platform_caps.h"
#include "uvc_vs_ctrl.h"
#include "dbgout.h"
#include "mjpg_frame_descript.h"

extern void DumpStreamControlRequest(struct uvc_streaming_control_request *pReq);


#if HAS_VIDCAP_ISOCH == 1
#define MIN_ENC_PL_SIZE PKT_SIZE_ISOC1
#define MAX_ENC_PL_SIZE PKT_SIZE_ISOC1	// TODO: Change PKT_SIZE_ISOC1 to a higher value if device support negotiation
#define MAX_ENC_FRM_SIZE 128000
#else
#define MIN_ENC_PL_SIZE (2800 * TS_PACKET_SIZE + 2)
#define MAX_ENC_PL_SIZE  MIN_ENC_PL_SIZE
#define MAX_ENC_FRM_SIZE MAX_ENC_PL_SIZE
#endif

static struct uvc_streaming_control_request	h264_param_table[1][PROBE_INDEX_LAST] = 
{
/*
**  bmHnt     bFormatIndex   bFrameIndex    dwFrameInterval     wKeyFrmRate    wPFrmeRate     wCompQuality   wCompWindowSize     wDelay         dwMaxVideoFrameSize      dwMaxPayloadTransferSize
*/
 {
  { 0x0000,   0,           0,               333333,             1,              0,	          1000,          0,	                 50,            MAX_ENC_FRM_SIZE,        MIN_ENC_PL_SIZE},   /* MIN */
  { 0x0000,   0,	       0,	            3333330,            1000,	        0,	          10000,	     0,	                 50,	        MAX_ENC_FRM_SIZE,        MAX_ENC_PL_SIZE},   /* Max */
  { 0x0000,   0,	       0,	            333333,	            15,	            0,	          5000,	         0,	                 50,            MAX_ENC_FRM_SIZE,        MAX_ENC_PL_SIZE},   /* Def */
  { 0x0000,   0,	       0,	            333333,	            15,	            0,	          5000,	         0,	                 50,            MAX_ENC_FRM_SIZE,        MAX_ENC_PL_SIZE},   /* Cur */
  { 0x0000,   0,	       0,	            333333,	            1,	            0,	          100,	         0,	                 0,             0,                       0},                /* Res */
 }
};

#undef MIN_ENC_PL_SIZE
#undef MAX_ENC_PL_SIZE
#undef MAX_ENC_FRM_SIZE

#if HAS_VIDCAP_ISOCH == 1
#define MIN_ENC_PL_SIZE PKT_SIZE_ISOC1
#define MAX_ENC_PL_SIZE PKT_SIZE_ISOC1	// TODO: Change PKT_SIZE_ISOC1 to a higher value if device support negotiation
#define MAX_ENC_FRM_SIZE 128000
#else
#define MIN_ENC_PL_SIZE ((2800 * TS_PACKET_SIZE + 2) // Note: 1400 is max frame size
#define MAX_ENC_PL_SIZE MIN_ENC_PL_SIZE
#define MAX_ENC_FRM_SIZE MAX_ENC_PL_SIZE
#endif

#if HAS_H264_ENCODE_VEN == 1
static struct uvc_streaming_control_request	h264_ven_param_table[1][PROBE_INDEX_LAST] = 
{
 {
  {0x0000,    0,            0,	            10000000,           1,	             0,	            0,	          0,	              50,            MAX_ENC_FRM_SIZE,       MIN_ENC_PL_SIZE},	/* MIN */
  {0x0000,    0,            0,              330000,             1000,            0,             10000,        0,                  50,            MAX_ENC_FRM_SIZE,       MIN_ENC_PL_SIZE},	/* Max */
  {0x0000,    0,            0,              330000,             15,              0,             5000,         0,                  50,            MAX_ENC_FRM_SIZE,       MIN_ENC_PL_SIZE},	/* Def */
  {0x0000,    0,            0,              330000,             15,              0,             5000,         0,                  50,            MAX_ENC_FRM_SIZE,       MIN_ENC_PL_SIZE},	/* Cur */
  {0x0000,    0,            0,              330000,             1,               0,             100,          0,                  0,             0,                      0},	/* Res */
 },
};
#endif

static struct uvc_streaming_control_request probe_cache = {0};
static int probe_state = 0;

static int ValidateParams(
		struct uvc_streaming_control_request *pCrnt, 
		struct uvc_streaming_control_request *pMin, 
		struct uvc_streaming_control_request *pMax)
{
	UAV_DBG_MSG("\n");
	if((pCrnt->bmHint & BMHINT_FRAME_INTERVAL_MASK) == 0) {
		if(pCrnt->dwFrameInterval <= pMax->dwFrameInterval && 
			pCrnt->dwFrameInterval >= pMin->dwFrameInterval) {
			/* Frame interval is allowed be changed and requested value is in the range*/
			// Do nothing
		} else {
			UAV_DBG_ERR("dwFrameInterval out of range min=%d max=%d req=%d\n", pMin->dwFrameInterval, pMax->dwFrameInterval, pCrnt->dwFrameInterval);
			return -1;
		}
	}
	if((pCrnt->bmHint & BMHINT_KEYFRAME_RATE_MASK)  == 0){
		if(pCrnt->wKeyFrameRate <= pMax->wKeyFrameRate && 
			pCrnt->wKeyFrameRate >= pMin->wKeyFrameRate) {
			/* wKeyFrameRate is allowed be changed and requested value is in the range*/
			// Do nothing
		}else  {
			UAV_DBG_ERR("wKeyFrameRate out of range min=%d max=%d req=%d\n", pMin->wKeyFrameRate, pMax->wKeyFrameRate, pCrnt->wKeyFrameRate);
			return -1;
		}
	}	
	if((pCrnt->bmHint & BMHINT_PFRAME_RATE_MASK) == 0) {
		if(pCrnt->wPFrameRate <= pMax->wPFrameRate && 
			pCrnt->wPFrameRate >= pMin->wPFrameRate) {
			/* Frame interval allowed be changed and requested value is in the range*/
			// Do nothing
		}else  {
			UAV_DBG_ERR("wPFrameRate out of range min=%d max=%d req=%d\n", pMin->wPFrameRate, pMax->wPFrameRate, pCrnt->wPFrameRate);
			return -1;
		}
	}
	if((pCrnt->bmHint & BMHINT_COMP_QUALITY_MASK) == 0) {
		if(pCrnt->wCompQuality <= pMax->wCompQuality && 
			pCrnt->wCompQuality >= pMin->wCompQuality) {
			/* Frame interval allowed be changed and requested value is in the range*/
			// Do nothing
		}else  {
			UAV_DBG_ERR("wKeyFrameRate out of range min=%d max=%d req=%d\n", pMin->wCompQuality, pMax->wCompQuality, pCrnt->wCompQuality);
			return -1;
		}
	}
	if((pCrnt->bmHint & BMHINT_COMP_WINDOW_SIZE) == 0) {
		if(pCrnt->wCompWindowSize <= pMax->wCompWindowSize && 
			pCrnt->wCompWindowSize >= pMin->wCompWindowSize) {
			/* Frame interval allowed be changed and requested value is in the range*/
			// Do nothing
		}else  {
			UAV_DBG_ERR("wCompWindowSize out of range min=%d max=%d req=%d\n", pMin->wCompWindowSize, pMax->wCompWindowSize, pCrnt->wCompWindowSize);
			return -1;
		}
	}
	return 0;
}

static int SetProbeResponse(
		struct uvc_streaming_control_request *pProbe, 
		struct uvc_streaming_control_request *pMin, 
		struct uvc_streaming_control_request *pMax)
{
	UAV_DBG_MSG("pProbe->wCompQuality = 0x%x pMax->wCompQuality = 0x%x pMin->wCompQuality = 0x%x\n", pProbe->wCompQuality, pMax->wCompQuality, pMin->wCompQuality);
	/* TODO: Offer decrenting values in subsequest steps of probe get */
	if(pProbe->dwFrameInterval > pMax->dwFrameInterval)
		pProbe->dwFrameInterval = pMax->dwFrameInterval;
	if(pProbe->dwFrameInterval < pMin->dwFrameInterval)
		pProbe->dwFrameInterval = pMin->dwFrameInterval;

	if(pProbe->dwMaxPayloadTransferSize > pMax->dwMaxPayloadTransferSize)
		pProbe->dwMaxPayloadTransferSize = pMax->dwMaxPayloadTransferSize;
	if(pProbe->dwMaxPayloadTransferSize < pMin->dwMaxPayloadTransferSize)
		pProbe->dwMaxPayloadTransferSize = pMin->dwMaxPayloadTransferSize;

	if(pProbe->wCompQuality > pMax->wCompQuality)
		pProbe->wCompQuality = pMax->wCompQuality;
	if(pProbe->wCompQuality < pMin->wCompQuality)
		pProbe->wCompQuality = pMin->wCompQuality;

	UAV_DBG_MSG("pProbe->dwMaxVideoFrameSize = 0x%x pMax->dwMaxVideoFrameSize = 0x%x pMin->dwMaxVideoFrameSize = 0x%x\n", pProbe->dwMaxVideoFrameSize, pMax->dwMaxVideoFrameSize, pMin->dwMaxVideoFrameSize);
	if(pProbe->dwMaxVideoFrameSize > pMax->dwMaxVideoFrameSize)
		pProbe->dwMaxVideoFrameSize = pMax->dwMaxVideoFrameSize;
	if(pProbe->dwMaxVideoFrameSize < pMin->dwMaxVideoFrameSize)
		pProbe->dwMaxVideoFrameSize = pMin->dwMaxVideoFrameSize;


	if(pProbe->wKeyFrameRate > pMax->wKeyFrameRate)
		pProbe->wKeyFrameRate = pMax->wKeyFrameRate;
	if(pProbe->wKeyFrameRate < pMin->wKeyFrameRate)
		pProbe->wKeyFrameRate = pMin->wKeyFrameRate;

	return 0;
}

static int GetUvcStreamingControl(
		struct stream_format_if_t *pCtx,
		struct uvc_streaming_control_request *pCtrl, 
		__u8  bIsProbe, 
		__u8  bFormatIndex, 
		__u8  bFrameIndex, 
		__u8  bProbeIndex)
{
	struct uvc_streaming_control_request *pCur;
	int val = sizeof(struct uvc_streaming_control_request);
	UAV_DBG_MSG("bIsProbe = %d format = %d frame = %d bProbeIndex=%d\n", bIsProbe, bFormatIndex, bFrameIndex,bProbeIndex);
	
	if(bIsProbe && probe_state == 0) {
		UAV_DBG_MSG("bIsProbe = %d format = %d frame = %d probe_state=%d\n", bIsProbe, bFormatIndex, bFrameIndex,probe_state);
		return val;
	}
	switch (bFormatIndex)
	{
#if HAS_MJPEG_ENCODE ==  1
		case MJPEG_FORMAT_INDEX:
		if(bFrameIndex < MJPEG_FRAME_INDEX_LAST && bFrameIndex > 0) {
			// Change bFrameIndex to base 0
			bFrameIndex -= 1;

			/* If probe_state is not set, return current to satisfy some buggy host applications */
			if(bIsProbe && probe_state && bProbeIndex == PROBE_INDEX_CUR) {
				/* Get the prob_cache for now */
				UAV_DBG_ERR("Returning from probe_cache bFrameIndex(base 0)=%d bProbeIndex=%d\n", bFrameIndex,bProbeIndex);
				memcpy(pCtrl, &probe_cache, sizeof(struct uvc_streaming_control_request));
				SetProbeResponse(pCtrl, &mjpeg_param_table[bFrameIndex][PROBE_INDEX_MIN], &mjpeg_param_table[bFrameIndex][PROBE_INDEX_MAX]);
				DumpStreamControlRequest(pCtrl);
				return val;
			} else {
				UAV_DBG_ERR("Returning current bFrameIndex(base 0=%d bProbeIndex=%d\n", bFrameIndex,bProbeIndex);
				pCur =  &mjpeg_param_table[bFrameIndex][bProbeIndex];
				memcpy((unsigned char *)pCtrl + 4, (unsigned char *)pCur + 4, sizeof(struct uvc_streaming_control_request)-4);
				DumpStreamControlRequest(pCtrl);
				return val;
			}
		} else {
			UAV_DBG_ERR("Index outof range %d %d\n", bFormatIndex, bFrameIndex);
			return -1;
		}
		break;
#endif
#if HAS_H264_ENCODE == 1
		case H264_FORMAT_INDEX:
		{
			if(bIsProbe && probe_state && bProbeIndex == PROBE_INDEX_CUR) {
				/* Get the prob_cache for now */
				memcpy(pCtrl, &probe_cache, sizeof(struct uvc_streaming_control_request));
				SetProbeResponse(pCtrl, &h264_param_table[0][PROBE_INDEX_MIN], &mjpeg_param_table[0][PROBE_INDEX_MAX]);
				DumpStreamControlRequest(pCtrl);
				return val;
			} else {
				pCur =  &h264_param_table[0][bProbeIndex];
				memcpy((unsigned char *)pCtrl + 4, (unsigned char *)pCur + 4, sizeof(struct uvc_streaming_control_request)-4);
				DumpStreamControlRequest(pCtrl);
				return val;
			}
		} 
		break;
#endif
#if HAS_H264_ENCODE_VEN == 1
		case H264_FORMAT_VEN_INDEX:
		{
			if(bIsProbe && probe_state && bProbeIndex == PROBE_INDEX_CUR) {
				/* Get the prob_cache for now */
				memcpy(pCtrl, &probe_cache, sizeof(struct uvc_streaming_control_request));
				SetProbeResponse(pCtrl, &h264_ven_param_table[0][PROBE_INDEX_MIN], &mjpeg_param_table[0][PROBE_INDEX_MAX]);
				return val;
			} else {
				pCur =  &h264_ven_param_table[0][bProbeIndex];
				memcpy((unsigned char *)pCtrl + 4, (unsigned char *)pCur + 4, sizeof(struct uvc_streaming_control_request)-4);
				DumpStreamControlRequest(pCtrl);
				return val;
			}
		} 
		break;
#endif

	}
	return 0;
}

static int SetUvcStreamingControl(
	struct stream_format_if_t *pCtx,
	struct uvc_streaming_control_request *pCtrl, 
	__u8  bIsProbe, 
	__u8  bFormatIndex, 
	__u8  bFrameIndex)
{
	struct uvc_streaming_control_request *pCur = 0;
	
	UAV_DBG_MSG("bIsProbe = %d, format = %d frame = %d\n", bIsProbe, bFormatIndex, bFrameIndex);
	DumpStreamControlRequest(pCtrl);

	if(bIsProbe) {
		if(probe_state == 0) {
			UAV_DBG_MSG("Enter probe state\n");
			probe_state = 1;
		}
		memcpy(&probe_cache, pCtrl, sizeof(struct uvc_streaming_control_request));
		return 0;
	} else {
		UAV_DBG_MSG("Leave probe state\n");
		probe_state = 0;
	}
	switch (bFormatIndex)
	{
#if HAS_MJPEG_ENCODE ==  1
		case MJPEG_FORMAT_INDEX:
			if( bFrameIndex < MJPEG_FRAME_INDEX_LAST && bFrameIndex > 0) {
				// Change bFrameIndex to base 0
				bFrameIndex -= 1;

				pCur = &mjpeg_param_table[bFrameIndex][PROBE_INDEX_CUR];
				memcpy(pCur, pCtrl, sizeof(struct uvc_streaming_control_request));

				return 0;
			} else {
				UAV_DBG_ERR("Index outof range %d %d\n", bFormatIndex, bFrameIndex);
				return -1;
			}
			break;
#endif
#if HAS_H264_ENCODE == 1
		case H264_FORMAT_INDEX:
			//bFormatIndex = bFormatIndex - H264_FORMAT_INDEX;	// Change index relative to h264
			//if(bFormatIndex < ENCODE_FORMAT_INDEX_LAST && bFormatIndex >= 0 ) 
			{
				pCur =  &h264_param_table[0][PROBE_INDEX_CUR];
				memcpy(pCur, pCtrl, sizeof(struct uvc_streaming_control_request));
				return 0;
			}
			break;
#endif
#if HAS_H264_ENCODE_VEN == 1
		case H264_FORMAT_VEN_INDEX:
			//bFormatIndex = bFormatIndex - H264_FORMAT_VEN_INDEX;	// Change index relative to h264
			//if(bFormatIndex < ENCODE_FORMAT_INDEX_LAST && bFormatIndex >= 0 ) 
			{
				pCur =  &h264_ven_param_table[0][PROBE_INDEX_CUR];
				memcpy(pCur, pCtrl, sizeof(struct uvc_streaming_control_request));
				return 0;
			}
			break;
#endif
	}		
	
	return 0;
}

static int VerifyUvcStreamingControl(
		struct stream_format_if_t *pCtx,
		__u8  bFormatIndex, __u8  bFrameIndex)
{
	struct uvc_streaming_control_request *pCur = 0;
	struct uvc_streaming_control_request *pMin = 0;
	struct uvc_streaming_control_request *pMax = 0;

	UAV_DBG_MSG("format = %d frame = %d\n", bFormatIndex, bFrameIndex);
	switch (bFormatIndex)
	{
#if HAS_MJPEG_ENCODE ==  1
		case MJPEG_FORMAT_INDEX:
			if( bFrameIndex < MJPEG_FRAME_INDEX_LAST && bFrameIndex > 0) {
				// Change bFrameIndex to base 0
				bFrameIndex -= 1;

				pCur = &mjpeg_param_table[bFrameIndex][PROBE_INDEX_CUR];
				pMin = &mjpeg_param_table[bFrameIndex][PROBE_INDEX_MIN];
				pMax = &mjpeg_param_table[bFrameIndex][PROBE_INDEX_MAX];

				return 0;
			} else 
				return -1;
			break;
#endif
#if HAS_H264_ENCODE == 1
		case H264_FORMAT_INDEX:
			{
				pCur = &h264_param_table[0][PROBE_INDEX_CUR];
				pMin = &h264_param_table[0][PROBE_INDEX_MIN];
				pMax = &h264_param_table[0][PROBE_INDEX_MAX];

				return 0;
			}
			break;
#endif
#if HAS_H264_ENCODE_VEN == 1
		case H264_FORMAT_VEN_INDEX:
			{
				pCur = &h264_ven_param_table[0][PROBE_INDEX_CUR];
				pMin = &h264_ven_param_table[0][PROBE_INDEX_MIN];
				pMax = &h264_ven_param_table[0][PROBE_INDEX_MAX];

				return 0;
			}
			break;
#endif
	}
	if(pCur && pMin && pMax){
		DumpStreamControlRequest(pCur);
		return ValidateParams(pCur, pMin, pMax);
	} else {
		UAV_DBG_ERR("pCur && pMin && pMax == 0\n");
	}
	return 0;
}


static int GetFrameParams(
	struct stream_format_if_t *pCtx,
	struct uvc_streaming_control_request *pCtrl, 
	__u8 bFormatIndex, 
	__u8 bFrameIndex, 
	long *pFormat, 
	long *pWidth, 
	long *pHeight,
	long *plMinBitrate,
	long *plMaxBitrate)
{
	struct uvc_streaming_control_request *pCur;
	UAV_DBG_MSG("format = %d frame = %d\n", bFormatIndex, bFrameIndex);

	switch (bFormatIndex)
	{
#if HAS_MJPEG_ENCODE ==  1
		case MJPEG_FORMAT_INDEX:
		if(bFrameIndex < MJPEG_FRAME_INDEX_LAST && bFrameIndex > 0) {
			struct uvc_vs_frame_descriptor_mjpg *pFrameDescript = 0;
			// Change bFrameIndex to base 0
			bFrameIndex -= 1;
			pCur =  &mjpeg_param_table[bFrameIndex][PROBE_INDEX_CUR];
			memcpy((unsigned char *)pCtrl + 4, (unsigned char *)pCur + 4, sizeof(struct uvc_streaming_control_request)-4);
			pFrameDescript = get_frame_descriptor(bFrameIndex);
			if(pFrameDescript){
				*pWidth = pFrameDescript->wWidth;
				*pHeight = pFrameDescript->wHeight;
				*plMinBitrate = pFrameDescript->dwMinBitRate;
				*plMaxBitrate = pFrameDescript->dwMaxBitRate;

			}
			*pFormat = FORMAT_MJPEG;
			return sizeof(struct uvc_streaming_control_request);
		} else {
			UAV_DBG_ERR("Index outof range %d %d\n", bFormatIndex, bFrameIndex);
			return -1;
		}
		break;
#endif
#if HAS_H264_ENCODE == 1
		case H264_FORMAT_INDEX:
		 {
			pCur =  &h264_param_table[0][PROBE_INDEX_CUR];
			memcpy((unsigned char *)pCtrl + 4, (unsigned char *)pCur + 4, sizeof(struct uvc_streaming_control_request)-4);
			// TODO Set proper value
			*pWidth = 0;
			*pHeight = 0;
			*plMinBitrate = 0;
			*plMaxBitrate = 0;
			*pFormat = FORMAT_H264_TS;
			return sizeof(struct uvc_streaming_control_request);
		}
		break;
#endif
#if HAS_H264_ENCODE_VEN == 1
		case H264_FORMAT_VEN_INDEX:
		 {
			pCur =  &h264_ven_param_table[0][PROBE_INDEX_CUR];
			memcpy((unsigned char *)pCtrl + 4, (unsigned char *)pCur + 4, sizeof(struct uvc_streaming_control_request)-4);
			// TODO Set proper value
			*pWidth = 0;
			*pHeight = 0;
			*plMinBitrate = 0;
			*plMaxBitrate = 0;

			*pFormat = FORMAT_H264_TS;
			return sizeof(struct uvc_streaming_control_request);
		}
		break;
#endif
	}
	UAV_DBG_MSG("Unknown Format or Frame %d %d\n", bFormatIndex, bFrameIndex);
	return 0;
}

static int IsAltSettingVaiable(struct stream_format_if_t *pObj)
{
#if HAS_VIDCAP_ISOCH == 1
	return 1;	
#else
	return 0;
#endif
}

struct stream_format_ctx_t {
	struct uvc_streaming_control_request **pStrmFormatInfoH264;
	struct uvc_streaming_control_request **pStrmFormatInfoMjpeg;
} StreamFormatCtx = 
{
	.pStrmFormatInfoH264 = (struct uvc_streaming_control_request **)h264_param_table,
	.pStrmFormatInfoMjpeg =(struct uvc_streaming_control_request **) mjpeg_param_table
}; 

struct stream_format_if_t vid_cap_strm_format_if =
{
	GetUvcStreamingControl,
	SetUvcStreamingControl,
	VerifyUvcStreamingControl,
	GetFrameParams,
	IsAltSettingVaiable,
	/* Context information */
	(void *)&StreamFormatCtx
};
