#ifndef __UVC_EXT_API_H__
#define __UVC_EXT_API_H__
/*
 *  uvc_ext_api.h : UVC Extension API
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 * This file may be included in both UVC gadget driver code as well host code that 
 * implements UVC Video Extensions (.e. both Linux and Windows hosts).
 */

/**
 * GUID for UVC Capture Video Extension
 */
// {303B461D-BC63-44c3-8230-6741CAEB5D77}
#define GUID_VIDCAP_EXT	{0x1d,0x46,0x3b,0x30, 0x63, 0xbc, 0xc3, 0x44, 0x82, 0x30, 0x67, 0x41, 0xca, 0xeb, 0x5d, 0x77}


/**
 * GUID for UVC Encode Video Extension
 */
// {6DF18A70-C113-428e-88C5-4AFF0E286AAA}
//0x6df18a70, 0xc113, 0x428e, 0x88, 0xc5, 0x4a, 0xff, 0xe, 0x28, 0x6a, 0xaa);
#define GUID_VIDENC_EXT	{0x70, 0x8a, 0xf1, 0x6d, 0x13, 0xc1, 0x8e, 0x42, 0x88, 0xc5, 0x4a, 0xff, 0xe, 0x28, 0x6a, 0xaa}


/**
 * GUID for UVC Decode Video Extension
 */
// {4106AB99-EF0C-4d1a-9E57-41494DFA70FF}
//0x4106ab99, 0xef0c, 0x4d1a, 0x9e, 0x57, 0x41, 0x49, 0x4d, 0xfa, 0x70, 0xff);
#define GUID_VIDDEC_EXT	{0x99, 0xab, 0x06, 0x41, 0x0c, 0xef, 0x1a, 0x4d, 0x9e, 0x57, 0x41, 0x49, 0x4d, 0xfa, 0x70, 0xff}

#ifdef WIN32
#pragma pack(push)
#pragma pack(1)
/*
** The following guids are for use with DirectShow property pages.
*/
#define ATTTRIB_PACK
DEFINE_GUID(KSPROPERTYSET_MobiKsproxy, 0x303b461d, 0xbc63, 0x44c3, 0x82, 0x30, 0x67, 0x41, 0xca, 0xeb, 0x5d, 0x77);
DEFINE_GUID(KSPROPERTYSET_MobiUvcEncode, 0x6df18a70, 0xc113, 0x428e, 0x88, 0xc5, 0x4a, 0xff, 0xe, 0x28, 0x6a, 0xaa);
#else // LINUX

#define ATTTRIB_PACK	__attribute__ ((packed))

#endif


#define UVC_CAP_EXT_VERSION	(2 << 16 | 16)

struct uvc_ext_cmd_t
{
	unsigned long	data;
	//unsigned long	ext_data;
} ATTTRIB_PACK;

/**
 *	Enumeration for PCITURE_CODING
 */
typedef enum _PCITURE_CODING_T
{
	PCITURE_CODING_FRAME,
	PCITURE_CODING_FIELD,
	PCITURE_CODING_MBAFF
}PCITURE_CODING_T;

/**
 *		Enumeration for AVC_PROFILE
 */
typedef enum _AVC_PROFILE_T
{
	AVC_PROFILE_BASELINE,
	AVC_PROFILE_MAIN,
	AVC_PROFILE_HIGH,
} AVC_PROFILE_T;

/**
 *		Enumeration for VID_SRC_RES
 */
#define VID_SRC_RES_640X480			1
#define VID_SRC_RES_1280X720		2

/**
 *		Enumeration for VID_DST_RES
 */
typedef enum _VID_DST_RES_T
{
	VID_DST_RES_160X120,
	VID_DST_RES_176X144,
	VID_DST_RES_320X240,
	VID_DST_RES_352X288,
	VID_DST_RES_384X240,
	VID_DST_RES_640X480,
	VID_DST_RES_720X480,
	VID_DST_RES_704X576,
	VID_DST_RES_1280X720,
	VID_DST_RES_1920X1080,
	VID_DST_RES_INDEX_LAST
}VID_DST_RES_T;
/**
 *		Enumeration for VID_SRC_TYPE
 */
typedef enum _VID_SRC_TYPE_T
{
	VID_SRC_TYPE_INTERLACE,
	VID_SRC_TYPE_PROGRESSIVRE
} VID_SRC_TYPE_T;

/**
 *		Enumeration for GOP_STRUCTURE
 */
typedef enum _GOP_STRUCTURE_T
{
	GOP_STRUCTURE_IP,
	GOP_STRUCTURE_IBP,
	GOP_STRUCTURE_IBBP,
	GOP_STRUCTURE_IBBRBP
}GOP_STRUCTURE_T;

/**
 *		Enumeration for FRAME_RATE
 */
typedef enum _FRAME_RATE_T
{
	FRAME_RATE_FULL,
	FRAME_RATE_1_2,
	FRAME_RATE_1_4,
	FRAME_RATE_1_8,
}FRAME_RATE_T;

/**
 *		PARAM_XXX
 */
typedef enum _UVCEXT_PARAM_ID_T
{
	PARAM_VID_BIT_RATE = 0x0001,
	PARAM_VID_AVC_PROFILE,
	PARAM_VID_AVC_LEVEL,

	PARAM_VID_PICTURE_CODING,	
	PARAM_VID_GOP_STRUCTURE,	
	PARAM_VID_GOP_LEN,			
	PARAM_VID_FRAME_RATE,		
	PARAM_VID_DST_RES,			

	PARAM_AVMUX_ENABLE,			
	PARAM_AUD_BIT_RATE,			
	PARAM_SAMPLE_RATE,			
	PARAM_NUM_CHAN,	

	/*
	 * Stop the capture. This is used in bulk mode
	 * to mimic the behavious ISOC altsetting to zero
	 * and stop the capture session.
	 */
	PARAM_CAP_STOP,

	/*
	 * Query if EoS is reached on capture or encoded stream
	 */
	PARAM_CAP_QUERY_EOS,

	/*
	 * Forces an I frmae
	 */
	PARAM_VID_FORCE_I_FRAME,

	/*
	 * Forces an I frmae
	 */
	UVC_CAP_EXT_GET_VERSION,

	UVC_EXT_PARAM_ID_LAST
} UVCEXT_PARAM_ID_T;

/**
 *		number of controls enabled capture
 */
#define UVC_EXT_CTRL_COUNT_MASK		{0xFF, 0xFF, 0x00, 0x00}


/**
 *		PARAM_XXX
 */
typedef enum _DEC_PAYLOAD_FORMAT_T
{
	DEC_PAYLOAD_MPEG2_TS,
	DEC_PAYLOAD_H264_TS
} DEC_PAYLOAD_FORMAT;

/**
 *		PARAM_XXX
 */
typedef enum _UVCEXT_DEC_PARAM_ID_T
{
	PARAM_VID_DEC_PID = 0x0001,
	PARAM_VID_DEC_FORMAT,
	PARAM_VID_DEC_WIDTH,
	PARAM_VID_DEC_HEIGHT,
	PARAM_VID_DEC_EOS,
	PARAM_VID_DEC_PROGRESSIVE,
	PARAM_VID_DEC_FRAME_INTERVAL,
	UVC_EXT_DEC_PARAM_ID_LAST
} UVCEXT_PARAM_DEC_ID_T;

/**
 *		number of controls enabled for decoder
 */
#define UVC_DEC_EXT_CTRL_COUNT_MASK	{0x7F, 0x00,0x00, 0x00}

#define RES_IDX_MIN	0
#define RES_IDX_MAX	1
#define RES_IDX_DEF	2

/**
 * The following table specifies bitrare ranges for 
 * for various resolutions. The table can be used by host applications
 * to simplify the implementation of UVC Extension.
 * If the table needs to be used, define the flag INIT_UVC_MG3500_BITRATE_TABLE 
 */

#ifdef INIT_UVC_MG3500_BITRATE_TABLE 
static long listBitRates[][3/*0-MIN, 1-MAX, 2-DEF*/]=
{
	{   64000,  640000,  128000},		//VID_DST_RES_160X120,
	{   64000,  640000,  128000},		//VID_DST_RES_176X144,
	{ 100000, 1000000,  512000},		//VID_DST_RES_320X240,
	{ 100000, 1000000,  512000},		//VID_DST_RES_352X288,
	{ 100000, 1000000,  512000},		//VID_DST_RES_384X240,
	{ 100000, 4000000, 2000000},		//VID_DST_RES_640X480,
	{ 100000, 4000000, 2000000},		//VID_DST_RES_720X480,
	{ 100000, 4000000, 2000000},		//VID_DST_RES_704X576,
	{ 100000, 8000000, 4000000},		//VID_DST_RES_1280X720
	{ 100000, 8000000, 4000000},		//VID_DST_RES_1920X1080
	{ 100000, 8000000, 4000000},		//VID_DST_RES_INDEX_LAST
};
#endif


#ifdef WIN32
#pragma pack(pop)
#endif
#endif  //__UVC_EXT_API_H__
