/*
 * usb_cap_interface.k USB Video Class interface
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file defines class specific requests to uvc interface 
 *
 */

#ifndef __UVC_CAP_INTERFACE_H__
#define __UVC_CAP_INTERFACE_H__
#include "uvcdescript.h"

int handle_uvc_cap_control(char *req_buf, const struct usb_ctrlrequest *ctrl);
int handle_uvc_stream_if_req(char *req_buf, const struct usb_ctrlrequest *ctrl);

/**
 * This fucntion can be called direclty or indirectly(through uvc_cap_set_interface)
 */
int uvc_cap_init_interface(int intf_num, int alt_setting);

int uvc_cap_set_interface(const struct usb_ctrlrequest *setup);


/**
 * This fucntion can be called direclty or indirectly(through uvc_dec_set_interface)
 */
int uvc_dec_init_interface(int intf_num, int alt_setting);

int uvc_dec_set_interface(const struct usb_ctrlrequest *setup);

int	UpdateStreamStateForBulkEps(int intf_num);

struct usb_endpoint_descriptor *uvc_cap_get_int_decsc(void);

int handle_uvc_enc_control(char *req_buf, const struct usb_ctrlrequest *ctrl);
int handle_uvc_dec_control(char *req_buf, const struct usb_ctrlrequest *ctrl);

#endif //__UVC_CAP_INTERFACE_H__
