#ifndef __UAC_DESCRIPT_H__
#define __UAC_DESCRIPT_H__ 
/* A.2 Audio Interface Subclass Codes */
#include <linux/version.h>
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 20)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif
#include <asm/byteorder.h>
#include "platform_caps.h"


struct uac_ac_interface_descriptor{
        __u8  bLength;			/* 8+n */
        __u8  bDescriptorType;		/* USB_DT_CS_INTERFACE */
        __u8  bDescriptorSubType;	/* USB_MS_HEADER */
        __u16 bcdADC;			/* 0x0100 */
        __u16 wTotalLength;		/* includes Unit and Terminal desc */
        __u8  bInCollection;		/* n */
        __u8  baInterfaceNr;		/* [n] */
} __attribute__ ((packed));

#define UAC_DT_AC_HEADER_SIZE(n)	(8+(n))

struct uac_ac_cluster_descriptor{
	__u8  bNrChannels;
	__u32 bmChannelConfig;
	__u8  iChannelNames;
}__attribute__((packed));


/*Class Specific Interface Descriptor*/
struct  uac_class_interface_descriptor{
        __u8  bLength;
        __u8  bDescriptorType;
        __u8  bDescriptorSubType;
        __u16 bcdADC;
        __u8  bCategory;
        __u16 wTotalLength ;
        __u8  bmControls;
} __attribute__ ((packed));

struct uac_clk_src_descriptor{
	__u8  bLength;			/* 8 bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* CLOCK_SOURCE */
	__u8  bClockID;			/* Constant Value used in all request*/
	__u8  bmAttributes;		/* Clock Type/Ext/Int Fixed/Int Var/Int Prog */
	__u8  bmControls;		/* Clock Freq Control / Clock Validity Control */
	__u8  bAssocTerminal;		/* Terminal ID associated with Clk Source */
	__u8  iClockSource;		/* Index in String Desc */
}__attribute__((packed));


struct uac_clk_selector_descriptor{
	__u8  bLength;			/* 7 + p bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* CLOCK_SELECTOR */
	__u8  bClockID;			/* Constant Value used in all request*/
	__u8  bNrInPins;		/* Number of Input Pins of this Unit: p */
	__u8  baCSourceID[2];		/* ID of the Clk Entity to which first Clk Input Pin of this Clk Selector Entity is connected */
	__u8  bmControls;		/* Clk Selector Control */
	__u8  iClockSelector;		/* Index in String Desc */
}__attribute__((packed));

struct uac_clk_multiplier_descriptor{
	__u8  bLength;                  /* 7 + p bytes */
        __u8  bDescriptorType;          /* CS_INTERFACE */
        __u8  bDescriptorSubType;       /* CLOCK_MULTIPLIER */
	__u8  bClockID;			/* Constant - Clock Multiplier Entity*/
	__u8  bCsourceID;		/* ID of the Clock Entity */
	__u8  bmControls;		/* Clk Num Ctrl / Clk Deno Ctrl */
	__u8  iClockMultiplier;		/* Index of String Desc */
}__attribute__((packed));

struct uac_input_terminal_descriptor{
	__u8  bLength;			/* 17 bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* INPUT_TERMINAL */
	__u8  bTerminalID;		
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  bNrChannels;		/* Number of logical output channels */
	__u16 wChannelConfig;
	__u8  iChannelNames;		/* Index of String Desc */
	__u8  iTerminal;
}__attribute__((packed));

						
struct uac_output_terminal_descriptor{
	__u8  bLength;			/* 17 bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* OUTPUT_TERMINAL */
	__u8  bTerminalID;		
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  bSourceID;		/* ID of the Clock Entity */
	__u8  iTerminal;
}__attribute__((packed));

struct uac_mixed_unit_descriptor{
	__u8  bLength;			/* 13 + p + N bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* MIXER_UNIT */
	__u8  bUnitID;
	__u8  bNrInPins;		/* Number of Input Pins of this Unit: p */
	__u8  baSourceID[2];		/* ID of the Unit or Terminal to which first Clk Input Pin of this Mixer Unit is connected */
	__u8  bNrChannels;		/* Number */
	__u32 bmChannelConfig;		/* spatial location of logical chnls*/
	__u8  iChannelNames;		/* Index of String Desc */
	__u8  bmMixerControls[2];	/* Bmp indicate which Mixer Ctls are programmable */
	__u8  bmControls;		/* Cluster/UnderFlow/OverFlow Control*/
	__u8  iMixer;			/* Index of String Desc, describing Mixer Unit */
}__attribute__((packed));

struct uac_selector_unit_descriptor{
	__u8  bLength;			/* 7 + p bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* SELECTOR_UNIT */
	__u8  bUnitID;
	__u8  bNrInPins;		/* Number of Input Pins of this Unit: p */
	__u8  baSourceID[2];		/* ID of the Unit or Terminal to which first Clk Input Pin of this Mixer Unit is connected */
	__u8  iSelector;
}__attribute__((packed));

struct uac_feature_unit_descriptor{
	__u8  bLength;			/* 6 +(ch+1)*4  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* FEATURE_UNIT */
	__u8  bUnitID;
	__u8  bSourceID;		/* ID of the Unit or Terminal to which first Clk Input Pin of this Mixer Unit is connected */
	__u8  bControlSize;
	__u8  bmaControls00;		/* Mute/Vol/Bass/Mid/IPGAIN/Flow Control*/
	__u8  bmaControls01;		/* Mute/Vol/Bass/Mid/IPGAIN/Flow Control*/
	__u8  bmaControls10;		/* Mute/Vol/Bass/Mid/IPGAIN/Flow Control*/
	__u8  bmaControls11;		/* Mute/Vol/Bass/Mid/IPGAIN/Flow Control*/
	__u8  iFeature;			/* Index of String Desc, describing iFeature Unit */
}__attribute__((packed));


struct uac_sample_rate_converter_unit_descriptor{
	__u8  bLength;			/* 8  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* SAMPLE_RATE_CONVETER */
	__u8  bUnitID;
	__u8  bSourceID;		/* ID of the Unit or Terminal to which fSRC Unit is connected */
	__u8  bCSourceInID;		/* ID of Clock Entity to which SRC Input connected */
	__u8  bCSourceOutID;		/* ID of Clock Entity to which SRC Output section is connected */
	__u8  iSRC;			/* Index of String Desc, describing SRC Unit */
}__attribute__((packed));


struct uac_effect_unit_descriptor{
	__u8  bLength;			/* 16+(ch*4)  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* EFFECT_UNIT */
	__u8  bUnitID;
	__u16 wEffectType;		/* */
	__u8  bSourceID;		/* ID of the Unit or Terminal to which fSRC Unit is connected */
	__u32 bmaControls[1];		/* Control Bmp for Master Channel n: */
	__u8  iEffects;			/* Index of String Desc, describing SRC Unit */
}__attribute__((packed));

/*Processing Unit Descriptor */

struct uac_updownmix_processing_unit_descriptor{
	__u8  bLength;			/* 18+4*m  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* PROCESSING_UNIT */
	__u8  bUnitID;
	__u16 wProcessType;		/* UP/DOWNMIX_PROCESS */
	__u8  bNrInPins;		/* Num of Input Pins p */ 
	__u8  baSourceID;		/* ID of the Unit or Terminal to which iInput pins if this Processing Unit is connected */
	__u8  bNrChannels;		/* Num of Logical Output Channels */
	__u32 bmChannelConfig;		/* Spatial Location of Logical Channels in Audio Channels cluster */
	__u8  iChannelNames;		/* Index of a String Desc */
	__u16 bmControls[1];		/* Enable Control & Process-specific alloc  */
	__u8  iProcessing;		/* Index of a String Desc */
	__u8  bNrModes;			/* Number of Modes */
	__u32 daModes[1];		/* active logical channels in mode 1 */
}__attribute__((packed));

	
struct uac_dolby_processing_unit_descriptor{
	__u8  bLength;			/* 18+4*m  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* PROCESSING_UNIT */
	__u8  bUnitID;
	__u16 wProcessType;		/* DOLBY_PROLOGIC_PROCESS*/
	__u8  bNrInPins;		/* Num of Input Pins p */ 
	__u8  baSourceID;		/* ID of the Unit or Terminal to which iInput pins if this Processing Unit is connected */
	__u8  bNrChannels;		/* Num of Logical Output Channels */
	__u32 bmChannelConfig;		/* Spatial Location of Logical Channels in Audio Channels cluster */
	__u8  iChannelNames;		/* Index of a String Desc */
	__u16 bmControls;		/* Enable Control & Process-specific alloc  */
	__u8  iProcessing;		/* Index of a String Desc */
	__u8  bNrModes;			/* Number of Modes */
	__u32 daModes[1];		/* active logical channels in mode 1 */
}__attribute__((packed));

	
struct uac_stereo_ext_processing_unit_descriptor{
	__u8  bLength;			/* 17  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* PROCESSING_UNIT */
	__u8  bUnitID;
	__u16 wProcessType;		/* STEREO_EXTENDER_PROCESS*/
	__u8  bNrInPins;		/* Num of Input Pins p */ 
	__u8  baSourceID;		/* ID of the Unit or Terminal to which iInput pins if this Processing Unit is connected */
	__u8  bNrChannels;		/* Num of Logical Output Channels */
	__u32 bmChannelConfig;		/* Spatial Location of Logical Channels in Audio Channels cluster */
	__u8  iChannelNames;		/* Index of a String Desc */
	__u16 bmControls;		/* Enable Control & Process-specific alloc  */
	__u8  iProcessing;		/* Index of a String Desc */
}__attribute__((packed));

	
	
struct uac_extension_unit_descriptor{
	__u8  bLength;			/* 17  bytes */
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* EXTENSION_UNIT */
	__u8  bUnitID;
	__u16 wExtensionCode;		/* Vendor Specific Code*/
	__u8  bNrInPins;		/* Num of Input Pins p */ 
	__u8  baSourceIDi[2];		/* ID of the Unit or Terminal to which iInput pins of this Extension Unit is connected */
	__u8  bNrChannels;		/* Num of Logical Output Channels */
	__u32 bmChannelConfig;		/* Spatial Location of Logical Channels in Audio Channels cluster */
	__u8  iChannelNames;		/* Index of a String Desc */
	__u8  bmControls;		/* Enable/Cluster/Under/OverFlow Control*/
	__u8  iExtension;		/* Index of a String Desc */
}__attribute__((packed));


struct uac_endpoint_descriptor {
        __u8  bLength;
        __u8  bDescriptorType;
        __u8  bEndpointAddress;
        __u8  bmAttributes;
        __u16 wMaxPacketSize;
        __u8  bInterval;
} __attribute__ ((packed));


struct uac_interface_descriptor{
	__u8  bLength;
	__u8  bDescriptorType;
	__u8  bInterfaceNumber;
	__u8  bAlternateSetting;
	__u8  bNumEndpoints;
 	__u8  bInterfaceClass;
	__u8  bInterfaceSubClass;
	__u8  bInterfaceProtocol;
	__u8  iInterface;
}__attribute__((packed));


struct uac_as_interface_descriptor{
	__u8  bLength;
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* AS_GENERAL */
	__u8  bTerminalLink;		/* Terminal ID */
	__u8  bmControls;		/* Active / Valid Alternate Settings*/ 
	__u8  bFormatType;
	__u32 bmFormats;		/* USB Audio Data Format */
	__u8  bNrChannels;		/* Num of Physical Channels*/
	__u32 bmChannelConfig;		/* spatial location of physical chnl */	
	__u8  iChannelNames;		/* Index of String Desc */
}__attribute__((packed));


struct uac_encoder_descriptor{
	__u8  bLength;
	__u8  bDescriptorType;
	__u8  bDescriptorSubType;
	__u8  bEncoderID;
	__u8  bEncoder;
	__u8  reserverd[3];
	__u32 bmControls; 		/* bitrate/Quality/VBR/Type/Flow/Error*/
	__u8  iParam1;			/* Index of String Desc */
	__u8  iParam2;			/* Index of String Desc */
	__u8  iParam3;			/* Index of String Desc */
	__u8  iParam4;			/* Index of String Desc */
	__u8  iParam5;			/* Index of String Desc */
	__u8  iParam6;			/* Index of String Desc */
	__u8  iParam7;			/* Index of String Desc */
	__u8  iParam8;			/* Index of String Desc */
	__u8  iEncoder;			/* Index of String Desc */
}__attribute__((packed));

struct uac_mpeg_decoder_descriptor{
	__u8  bLength;
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* DECODER */
	__u8  bDecoderID;
	__u8  bDecoder;			/*MPEG_DECODER */
	__u16 bmMPEGCapabilities;
	__u8  bmMPEGFeatures;
	__u8  bmControls;		/* Under/Over Flow Decoder Err Ctrl */
	__u8  iDecoder;			/* Index of String Desc */	
}__attribute((packed));


struct uac_ac3_decoder_descriptor{
	__u8  bLength;
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* DECODER */
	__u8  bDecoderID;
	__u8  bDecoder;			/* AC-3_DECODER */
	__u32 bmBSID;			/* bit set to 1 enabled BSID mode */
	__u8  bmAC3Features;
	__u8  bmControls;		/* Under/Over Flow Decoder Err Ctrl */
	__u8  iDecoder;			/* Index of String Desc */	
}__attribute((packed));



struct uac_dts_decoder_descriptor{
	__u8  bLength;
	__u8  bDescriptorType;		/* CS_INTERFACE */
	__u8  bDescriptorSubType;	/* DECODER */
	__u8  bDecoderID;
	__u8  bDecoder;			/* DTS_DECODER */
	__u8  bmCapabilities;		/* Core/LoseLess/LBR/DualDecode/Multi */
	__u8  bmControls;		/* Under/Over Flow Decoder Err Ctrl */
	__u8  iDecoder;			/* Index of String Desc */	
}__attribute((packed));

struct uac_isoch_endpoint_descriptor  {
        __u8  bLength;
        __u8  bDescriptorType;
        __u8  bDescriptorSubType;
        __u8  bmAttributes;
        __u8  bLockDelayUnits;
        __u16 wLockDelay;
} __attribute__ ((packed));

struct uac_as_general_descriptor {
        __u8  bLength;       
        __u8  bDescriptorType;
        __u8  bDescriptorSubType;         // General
        __u8  bTerminalLink;
        __u8  bDelay;         // Interface delay
        __u16 wFormatTag;       // PCM
} __attribute__ ((packed));

struct uac_as_type1_format_descriptor_singlefreq {
        __u8 bLength;                   //     = 0x0B,
        __u8 bDescriptorType;           //     = 0x24,
        __u8 bDescriptorSubType;        //     = 0x02, // FORMAT Type
        __u8 bFormatType;               //     = 0x01, // Format Type 1
        __u8 bNrChannels;               //     = 0x01,
        __u8 bSubFrameSize;             //     = 0x02, // Two bytes per slot
        __u8 bBitResolution;            //     = 0x10, // 16 bit
        __u8 bSamFreqType;              //     = 0x01, // One sampling freq
        __u8 tSamFreq00;                //     = 0x40,
        __u8 tSamFreq01;                //     = 0x1F,
        __u8 tSamFreq02;                //     = 0x00,
} __attribute__ ((packed));

struct uac_as_type1_format_descriptor {
        __u8 bLength;                   //     = 0x0B,
        __u8 bDescriptorType;           //     = 0x24,
        __u8 bDescriptorSubType;        //     = 0x02, // FORMAT Type
        __u8 bFormatType;               //     = 0x01, // Format Type 1
        __u8 bNrChannels;               //     = 0x01,
        __u8 bSubFrameSize;             //     = 0x02, // Two bytes per slot
        __u8 bBitResolution;            //     = 0x10, // 16 bit
        __u8 bSamFreqType;              //     = 0x01, // One sampling freq
        __u8 tSamFreq00;                //     = 0x40,
        __u8 tSamFreq01;                //     = 0x1F,
        __u8 tSamFreq02;                //     = 0x00,
        __u8 tSamFreq10;                //     = 0x11,
        __u8 tSamFreq11;                //     = 0x2B,
        __u8 tSamFreq12;                //     = 0x00,
} __attribute__ ((packed));


extern const struct usb_descriptor_header *uac_interface_descriptors[];

struct usb_endpoint_descriptor *uac_get_endp_desc( int alt_setting );
int handle_uac_cap_control(char *req_buf, const struct usb_ctrlrequest *ctrl);
int uac_init_audio(void);

#endif // __UAC_DESCRIPT_H__
