/*
 * usb_cap_interface.c USB Audio Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements handling of class specific requests to uac interface 
 *
 */
#include <linux/version.h>
#include <linux/types.h>

#include "uvc_codec_if.h"
#include "uacdescript.h"

#include "uac_cap_interface.h"
#include "dbgout.h"
#include "uac_defs.h"
#include "uvc_callback.h"

extern int call_feature_ctrl(char *req_buf, const struct usb_ctrlrequest *ctrl);


int uac_cap_set_interface(const struct usb_ctrlrequest *setup)
{
	//int status = 0;
	//struct stream_format_if_t *pStrmIf;
	aud_codec_config_t Param = {0};
	__u16	alt_setting = __le16_to_cpu(setup->wValue);
	__u16	w_index = __le16_to_cpu(setup->wIndex);
	struct usb_endpoint_descriptor *pEpDescript = 0;
	int intf_num = (w_index & 0x00FF);
	UAV_DBG_MSG("intf=%d alt_setting=%d \n", intf_num, alt_setting);
	
	aud_codec_get_state(&Param);
	Param.dwStreamId = STREAM_ID_AUDCAP;
	switch(intf_num) {
#if HAS_AUD_CAP == 1
		case UAC_STRM_INTERFACE_INDEX:
			if(alt_setting)
				Param.dwStreamState = CODEC_STATE_RUN; 
			else
				Param.dwStreamState = CODEC_STATE_STOP; 
			break;
#endif
		default:
			UAV_DBG_MSG("incorrect stream id\n");
			return 0;
			break;
	}


	pEpDescript = uac_get_endp_desc(alt_setting);
	if(pEpDescript){
		Param.dwEpInterval = pEpDescript->bInterval;
		Param.dwEpPacketSize = pEpDescript->wMaxPacketSize;
		Param.dwEpIsoc = 1;
	}

	aud_codec_set_state(&Param);

	return 0;//success

}
int process_input_selection(char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int retval = -1;

	switch(ctrl->bRequest)
	{
		case SET_CUR:
			retval = 0;
			break;
		case GET_CUR:
			// TODO Verify
			req_buf[0] = 1;
			break;
		case GET_MIN:
		case GET_RES:
			req_buf[0] = 0x01;
			retval = 1;
			break;
		case GET_MAX:
			req_buf[0] = 1;
			retval = 1;
			break;
		default:
			break;
	}		
	return retval;
}
int handle_uac_cap_control(char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	//__s32 retval   = -1;
	__s32 retval   = 0;
	__u16 w_value  = (ctrl->wValue);
	__u16 w_Index  = (ctrl->wIndex); 
	__u32 CS       = ((w_value & 0xFF00) >> 8);
	__u32 unitID   = ((w_Index & 0xFF00) >> 8);
	UAV_DBG_MSG("Unit ID=%d , CS=%d \n", unitID, CS );
	/*SELECT INTERFACE CALL WILL GIVE SUB TYPE*/
	/*STORE IT FOR USE BELOW */
	switch(unitID)
	{
	/*Terminal Control Selector*/
		case INPUT_TERMINAL_MIC_ID: 	
		case INPUT_TERMINAL_LINE_ID: 	
			switch(CS)
			{	
				case COPY_PROTECT_CONTROL:
					if(ctrl->bRequest == GET_CUR){
						req_buf[0] = 0x00;
						return 0x01;
					}
			}
			break;
		case OUTPUT_TERMINAL_ID:
			switch(CS)
			{	
				case COPY_PROTECT_CONTROL:
					if(ctrl->bRequest == GET_CUR){
						req_buf[0] = 0x00;
						return 0x01;
				}
			}
			break;
		case SELECTOR_UNIT_ID:
			retval = process_input_selection(req_buf, ctrl);
			break;
	/*Feature Unit Control Selector*/
		case FEATURE_UNIT_ID:
			retval = call_feature_ctrl(req_buf, ctrl);
			break;


#ifdef EXTRA_AUDIO_FEATURES
	/*Processing Unit Control Selector*/
		case UD_CONTROL_UNDEFINED:
		break;
		case UD_ENABLE_CONTROL:
		break;
		case UD_MODE_SELECT_CONTROL:
		break;

	/*Dolby Prologic Processing Unit*/
		case DP_CONTROL_UNDEFINED:
		break;
		case DP_ENABLE_CONTROL:
		break;
		case DP_MODE_SELECT_CONTROL:
		break;

	/*Stereo Extender */
		case 3D_CONTROL_UNDEFINED:
		break;
		case 3D_ENABLE_CONTROL:
		break;
		case SPACIOUSNESS_CONTROL:
		break;

	/*Reverberation Processing Unit*/
		case RV_CONTROL_UNDEFINED:
		break;
		case RV_ENABLE_CONTROL:
		break;
		case REVERB_LEVEL_CONTROL:
		break;
		case REVERB_TIME_CONTROL:
		break;
		case REVERB_FEEDBACK_CONTROL:
		break;

	/*Chorus Processing Unit*/
		case CH_CONTROL_UNDEFINED:
		break;
		case CH_ENABLE_CONTROL:
		break;
		case CHORUS_LEVEL_CONTROL:
		break;
		case CHORUS_RATE_CONTROL:
		break;
		case CHORUS_DEPTH_CONTROL:
		break;

	/*Dynamic Range Compressor Processing Unit*/
		case DR_CONTROL_UNDEFINED:
		break;
		case DR_ENABLE_CONTROL:
		break;
		case COMPRESSION_RATE_CONTROL:
		break;
		case MAXAMPL_CONTROL:
		break;
		case THRESHOLD_CONTROL:
		break;
		case ATTACK_TIME:
		break;
		case RELEASE_TIME:
		break;

	/*Extension Unit*/
		case XU_CONTROL_UNDEFINED:
		break;
		case XU_ENABLE_CONTROL:
		break;
#endif	
	
		default:
			break;			
	}
  return retval;

}
