#include "uacdescript.h"
#include "uac_defs.h"
#include "dbgout.h"
#include "uvc_codec_if.h"

extern uint32_t dbg_mask;

#define A_INDX_MIN	0
#define A_INDX_MAX	1
#define A_INDX_CUR	2
#define A_INDX_RES	3
#define A_INDX_LAST	4

extern int aud_codec_get_state(aud_codec_config_t *pParam);
extern int aud_codec_set_state(aud_codec_config_t *pParam);

struct uac_dev {
	unsigned char  bCopyProtect; 	/* Current Copy Protection Setting*/
	unsigned char  bSelector;
	unsigned char  bMute;
	unsigned char  bAGC;
	unsigned short wVol[A_INDX_LAST];
	unsigned char  bMid[A_INDX_LAST];
	unsigned char  bBass[A_INDX_LAST];
	unsigned char  bTreb[A_INDX_LAST];
	unsigned short wDelay[A_INDX_LAST];
};

/*struct uac_dev iUAC;*/

/*struct uac_dev *pAudDev = &iUAC;*/
struct uac_dev AudDev =
{
	.wVol =  {0x8001,  0x7FFF,  0x0000,  0x0001},
	.bMid =  {0x80,    0x7F,    0x01,    0x01},
	.bBass = {0x80,    0x7F,    0x01,    0x01},
	.bTreb = {0x80,    0x7F,    0x01,    0x01},
	.wDelay ={0xFFFF,  0x0000,  0x0000,  0x0000},
	.bMute = 1
};
struct uac_dev *pAudDev = &AudDev;


int call_feature_ctrl(char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int retval = -1;
	aud_codec_config_t AudCfg = {0};
	aud_codec_config_t *pAudCfg = &AudCfg;
	__u16 w_value  = (ctrl->wValue);
	//__u16 w_Index  = (ctrl->wIndex); 
	__u32 cs       = ((w_value & 0xFF00) >> 8);
	__u16 req = ctrl->bRequest;
	UAV_DBG_MSG("cs=%d req=%d\n",cs,req );
	aud_codec_get_state(&AudCfg);
	switch(cs)
	{
		case VOLUME_CONTROL:
			switch(req)
			{
		 		case SET_MIN:
					pAudDev->wVol[A_INDX_MIN] = __le16_to_cpup((__le16 *)&req_buf[0]);
					retval = 0;
					break;
				case SET_MAX:
					pAudDev->wVol[A_INDX_MAX] = __le16_to_cpup((__le16 *)&req_buf[0]);
					retval = 0;
					break;
				case SET_RES:
					pAudDev->wVol[A_INDX_RES] = __le16_to_cpup((__le16 *)&req_buf[0]);
					retval = 0;
					break;
				case SET_CUR:
					pAudDev->wVol[A_INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
					pAudCfg->dwVol = pAudDev->wVol[A_INDX_CUR];
					retval = 0;
					break;
				case GET_MIN: 
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wVol[A_INDX_MIN]);
					retval = 2;
					break;
				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wVol[A_INDX_MAX]);
					retval = 2;
					break;
				case GET_CUR:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wVol[A_INDX_CUR]);
					retval = 2;
					break;
				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wVol[A_INDX_RES]);
					retval = 2;
					break;
				default:
					break;
			}
		
			break;
		case MID_CONTROL:
			switch(req)
			{
		 		case SET_MIN:
					pAudDev->bMid[A_INDX_MIN] = ( req_buf[0] );
					retval = 0;
					break;
				case SET_MAX:
					pAudDev->bMid[A_INDX_MAX] = ( req_buf[0] );
					retval = 0;
					break;
				case SET_RES:
					pAudDev->bMid[A_INDX_RES] = ( req_buf[0] );
					retval = 0;
					break;
				case SET_CUR:
					pAudDev->bMid[A_INDX_CUR] = ( req_buf[0] );
					pAudCfg->dwMid = pAudDev->bMid[A_INDX_CUR];
					retval = 0;
					break;
				case GET_MIN: 
					req_buf[0] = pAudDev->bMid[A_INDX_MIN];
					retval = 1;
					break;
				case GET_MAX:
					req_buf[0] = pAudDev->bMid[A_INDX_MAX];
					retval = 1;
					break;
				case GET_CUR:
					req_buf[0] = pAudDev->bMid[A_INDX_CUR];
					retval = 1;
					break;
				case GET_RES:
					req_buf[0] = (__u8)pAudDev->bMid[A_INDX_RES];
					retval = 1;
					break;
			}
			break;
		case BASS_CONTROL:
			switch(req)
			{
		 		case SET_MIN:
					pAudDev->bBass[A_INDX_MIN] = ( req_buf[0] );
					retval = 0;
					break;
				case SET_MAX:
					pAudDev->bBass[A_INDX_MAX] = ( req_buf[0] );
					retval = 0;
					break;
				case SET_RES:
					pAudDev->bBass[A_INDX_RES] = ( req_buf[0] );
					retval = 0;
					break;
				case SET_CUR:
					pAudDev->bBass[A_INDX_CUR] = ( req_buf[0] );
					pAudCfg->dwBass = pAudDev->bBass[A_INDX_CUR];
					retval = 0;
					break;
				case GET_MIN: 
					req_buf[0] = (__u8)pAudDev->bBass[A_INDX_MIN];
					retval = 1;
					break;
				case GET_MAX:
					req_buf[0] = (__u8)pAudDev->bBass[A_INDX_MAX];
					retval = 1;
					break;
				case GET_CUR:
					req_buf[0] = (__u8)pAudDev->bBass[A_INDX_CUR];
					retval = 1;
					break;
				case GET_RES:
					req_buf[0] = (__u8)pAudDev->bBass[A_INDX_RES];
					retval = 1;
					break;
			}
			
			break;
		case TREBLE_CONTROL:
			switch(req)
			{
		 		case SET_MIN:
					pAudDev->bTreb[A_INDX_MIN] = ( req_buf[0] );
					retval = 0;
					break;
                    case SET_MAX:
					pAudDev->bTreb[A_INDX_MAX] = ( req_buf[0] );
					retval = 0;
					break;
                    case SET_RES:
					pAudDev->bTreb[A_INDX_RES] = ( req_buf[0] );
					retval = 0;
					break;
                    case SET_CUR:
					pAudDev->bTreb[A_INDX_CUR] = ( req_buf[0] );
					pAudCfg->dwTreb = pAudDev->bTreb[A_INDX_CUR];
					retval = 0;
					break;
                    case GET_MIN: 
					req_buf[0] = (__u8)pAudDev->bTreb[A_INDX_MIN];
					retval = 1;
					break;
                    case GET_MAX:
					req_buf[0] = (__u8)pAudDev->bTreb[A_INDX_MAX];
					retval = 1;
					break;
                    case GET_CUR:
					req_buf[0] = (__u8)pAudDev->bTreb[A_INDX_CUR];
					retval = 1;
					break;
                    case GET_RES:
					req_buf[0] = (__u8)pAudDev->bTreb[A_INDX_RES];
					retval = 1;
					break;
			}
			
			break;
			case DELAY_CONTROL:
			switch(req)
			{
		 		case SET_MIN:
					pAudDev->wDelay[A_INDX_MIN] = __le16_to_cpup((__le16 *)&req_buf[0]);
					retval = 0;
					break;
                    case SET_MAX:
					pAudDev->wDelay[A_INDX_MAX] = __le16_to_cpup((__le16 *)&req_buf[0]);
					retval = 0;
					break;
                    case SET_RES:
					pAudDev->wDelay[A_INDX_RES] = __le16_to_cpup((__le16 *)&req_buf[0]);
					retval = 0;
					break;
                    case SET_CUR:
					pAudDev->wDelay[A_INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
					pAudCfg->dwDelay = pAudDev->wDelay[A_INDX_CUR];
					retval = 0;
					break;
                    case GET_MIN: 
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wDelay[A_INDX_MIN]);
					retval = 2;
					break;
                    case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wDelay[A_INDX_MAX]);
					retval = 2;
					break;
                    case GET_CUR:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wDelay[A_INDX_CUR]);
					retval = 2;
					break;
                    case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pAudDev->wDelay[A_INDX_RES]);
					retval = 2;
					break;
			}
			break;

			case MUTE_CONTROL:
							
				switch(req)
				{
					case SET_CUR:
						UAV_DBG_MSG("SET_CUR Mute\n");
						pAudDev->bMute = req_buf[0];
						pAudCfg->dwMute = pAudDev->bMute;
						retval = 0;
						break;
					case GET_CUR:
						req_buf[0] = pAudDev->bMute;
						UAV_DBG_MSG("GET_CUR Mute = %d\n", retval);
						retval = 1;
						break;
				}
				break;

			case LOUDNESS_CONTROL:
			case AUTOMATIC_GAIN_CONTROL:
				switch(req)
				{
					case SET_CUR:
						pAudDev->bAGC = req_buf[0];
						pAudCfg->dwAGC = pAudDev->bAGC;
						 retval = 0;
						break;
					case GET_CUR:
						req_buf[0] = pAudDev->bAGC;
						retval = 1;
						break;
				}		
			case GRAPHIC_EQUALIZER_CONTROL:
				break;
			case BASS_BOOST_CONTROL:
				break;
			break;

		default:
			break;
	}
	aud_codec_set_state(pAudCfg);
	return retval;
        //Implement SDK related functionality here
}
