/*
 * USB Video anf Audio Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 * This file defines paltform capabilities
 *
 */
/*
 * platform_caps.h defines the constants,enumerations used in UVC descriptors.
 * A set of HAS_XXX features can define the capabilities of the device.
 * HAS_XXX set to 1 (if feature available) or set to 0( if feature not availble)
 * These compile flags are used to define the appropriate UVC descriptors to export the features.
 * This technique gives the flexibility of adapting the driver for different platforms with any modifications
 * to the core driver code.
 * This file contains the macros for generation of descriptor constants and enumerations based on the capabilities
 * file ddd_caps.h where ddd can be any platform name.
 */
#ifndef __PLATFORM_CAPS_H__
#define __PLATFORM_CAPS_H__

/*
** Include the file defining device capabilities here
*/
#include "mg3500_caps.h"

/* Note: At least one of the inputs should present */
typedef enum tag_vid_input_terminal_id_t
{
	VID_CONNECTOR_INPUT_ID_FIRST = 0,
#if HAS_CAMERA_INPUT	== 1
	CAMERA_CONNECTOR_INPUT_ID,
#endif
#if HAS_COMPOSITE_CONNECTOR_INPUT == 1
	COMPOSITE_VID_CONNECTOR_INPUT_ID,
#endif
#if HAS_SVIDEO_CONNECTOR_INPUT	== 1
	SVIDEO_VID_CONNECTOR_INPUT_ID,
#endif
#if HAS_COMPONENT_CONNECTOR_INPUT == 1
	COMPONENT_VID_CONNECTOR_INPUT_ID,
#endif
#if HAS_HDMI_CONNECTOR_INPUT == 1
	HDMI_VID_CONNECTOR_INPUT_ID,
#endif
	VID_CONNECTOR_INPUT_ID_LAST,
} vid_input_terminal_id_t;

typedef enum _vid_output_terminal_id_t
{
	VIDCAP_OUT_TERMINAL_ID = VID_CONNECTOR_INPUT_ID_LAST,
	VIDCAP_OUT_TERMINAL_ID_LAST
} vid_output_terminal_id_t;

typedef enum _vid_unit_id_t
{
	VIDCAP_UNIT_SELECTOR_ID = VIDCAP_OUT_TERMINAL_ID_LAST,
#if HAS_VIDCAP_UNIT_PROCESSOR
	VIDCAP_UNIT_PROCESSOR_ID,
#endif
#if HAS_VIDCAP_UNIT_EXT == 1
	VIDCAP_UNIT_EXT_ID,
#endif
	VIDCAP_UNIT_ID_LAST
} vid_unit_id_t;

// DO not modify the following
typedef enum tag_usb_interface_index_t
{
#if HAS_VID_CAP == 1
	UVC_CTRL_INTERFACE_INDEX,
	UVC_CAP_STRM_IN_INDEX,
#endif
#if HAS_AUD_CAP ==  1
	UAC_CTRL_INTERFACE_INDEX,
	UAC_STRM_INTERFACE_INDEX,
#endif
#if HAS_VID_TRANS == 1
	UVC_ENC_CTRL_IN_INDEX,
	UVC_ENC_STRM_IN_INDEX,
	UVC_TRANS_CTRL_OUT_INDEX,
	UVC_TRANS_STRM_OUT_INDEX,
#endif
	USB_INTERFACE_INDEX_LAST
}usb_interface_index_t;

// Do not modify the following
typedef enum tag_encode_format_index_t
{
	ENCODE_FORMAT_INDEX_UNDEF = 0,
#if HAS_YUV420_ENCODE == 1
	YUV420_FORMAT_INDEX,
#endif
#if HAS_MJPEG_ENCODE ==  1
	MJPEG_FORMAT_INDEX,
#endif
// TODO Add more formats for different resolutions
#if HAS_H264_ENCODE == 1
	H264_FORMAT_INDEX,
#endif
#if HAS_H264_ENCODE_VEN == 1
	H264_FORMAT_VEN_INDEX,
#endif
	ENCODE_FORMAT_INDEX_LAST
}encode_format_index_t;

typedef enum _enc_input_terminal_id_t
{
	ENC_INPUT_ID_FIRST = 0,
	ENC_INPUT_ID_LVPP,
	ENC_INPUT_ID_AVDEC,
	ENC_INPUT_ID_LAST,
} enc_input_terminal_id_t;

typedef enum _enc_unit_id_t
{
	ENC_UNIT_SELECTOR_ID = ENC_INPUT_ID_LAST,
	ENC_UNIT_ID_PROCESSOR,
	ENC_UNIT_ID_EXT,
	ENC_UNIT_ID_OUT_TERMINAL,
	ENC_UNIT_ID_LAST,
} enc_unit_id_t;

typedef enum tag_dec_vid_unit_id_t
{
	DEC_UNIT_ID_FIRST = 0,
	DEC_UNIT_ID_INPUT,
	DEC_UNIT_ID_PROCESSOR,
	DEC_UNIT_ID_EXT,
	DEC_UNIT_ID_OUT_TERMINAL,
	DEC_UNIT_ID_LAST,
} dec_vid_unit_id_t;

typedef enum tag_trans_sink_format_index_t
{
	TRANS_SINK_FORMAT_INDEX_UNDEF = 0,
#if HAS_MJPEG_PREV ==  1
	MJPEG_FORMAT_TRANS_SINK_INDEX,
#endif
#if HAS_H264_MP2TS_TRANS_SINK == 1
	H264_FORMAT_MP2TS_TRANS_SINK_INDEX,
#endif
#if HAS_H264_VEN_STREAM_TRANS_SINK == 1
	H264_FORMAT_VEN_STREAM_TRANS_SINK_INDEX,
#endif
#if HAS_H264_VEN_FRAME_TRANS_SINK == 1
	H264_FORMAT_VEN_TRANS_SINK_INDEX,
#endif
	TRANS_SINK_FORMAT_INDEX_LAST
}transcode_format_index_t;

typedef enum tag_trans_source_format_index_t
{
	TRANS_SOURCE_FORMAT_INDEX_UNDEF = 0,
// TODO Add more formats for different resolutions
#if HAS_H264_MP2TS_TRANS_SOURCE == 1
	H264_FORMAT_MP2TS_TRANS_SOURCE_INDEX,
#endif
#if HAS_H264_VEN_TRANS_SOURCE == 1
	H264_FORMAT_VEN_TRANS_SOURCE_INDEX,
#endif
	TRANS_SOURCE_FORMAT_INDEX_LAST
}transcode_source_format_index_t;

/* 
** Frame index generation for MJPEG.
** Important : Each resolution can be selectively enabled, but
** The order of these entires should correspond to mjpeg_param_table 
*/
typedef enum tag_mjpeg_frame_index_t
{
	MJPEG_FRAME_INDEX_UNDEF = 0,
/* defualt frame as first index follopwed by most widely used resolutions*/
#if HAS_MJPEG_RES_480P == 1
	MJPEG_FRAME_INDEX_RES_480P,
#endif

#if HAS_MJPEG_RES_288 == 1
	MJPEG_FRAME_INDEX_RES_288,
#endif

#if HAS_MJPEG_RES_240 == 1
	MJPEG_FRAME_INDEX_RES_240,
#endif

#if HAS_MJPEG_RES_144 == 1
	MJPEG_FRAME_INDEX_RES_144,
#endif

#if HAS_MJPEG_RES_120 == 1
	MJPEG_FRAME_INDEX_RES_120,
#endif

#if HAS_MJPEG_RES_720 == 1
	MJPEG_FRAME_INDEX_RES_720,
#endif

#if HAS_MJPEG_RES_240W == 1
	MJPEG_FRAME_INDEX_RES_240W,
#endif
#if HAS_MJPEG_RES_480I == 1
	MJPEG_FRAME_INDEX_RES_480I,
#endif
#if HAS_MJPEG_RES_480W == 1
	MJPEG_FRAME_INDEX_RES_480W,
#endif
#if HAS_MJPEG_RES_576I == 1
	MJPEG_FRAME_INDEX_RES_576I,
#endif
#if HAS_MJPEG_RES_576P == 1
	MJPEG_FRAME_INDEX_RES_576P,
#endif
#if HAS_MJPEG_RES_800 == 1
	MJPEG_FRAME_INDEX_RES_800,
#endif
	MJPEG_FRAME_INDEX_LAST
}mjpeg_frame_index_t;


typedef enum tag_h264_vendor_frame_index_t
{

	H264_FRAME_INDEX_UNDEF = 0,
#if HAS_H264_RES_120 == 1
	H264_FRAME_INDEX_RES_120,
#endif
#if HAS_H264_RES_144 == 1
	H264_FRAME_INDEX_RES_144,
#endif
#if HAS_H264_RES_240 == 1
	H264_FRAME_INDEX_RES_240,
#endif
#if HAS_H264_RES_240W == 1
	H264_FRAME_INDEX_RES_240W,
#endif
#if HAS_H264_RES_288 == 1
	H264_FRAME_INDEX_RES_288,
#endif
#if HAS_H264_RES_480I == 1
	H264_FRAME_INDEX_RES_480I,
#endif
#if HAS_H264_RES_480P == 1
	H264_FRAME_INDEX_RES_480P,
#endif
#if HAS_H264_RES_480W == 1
	H264_FRAME_INDEX_RES_480W,
#endif
#if HAS_H264_RES_576I == 1
	H264_FRAME_INDEX_RES_576I,
#endif
#if HAS_H264_RES_576P == 1
	H264_FRAME_INDEX_RES_576P,
#endif
#if HAS_H264_RES_720 == 1
	H264_FRAME_INDEX_RES_720,
#endif
#if HAS_H264_RES_800 == 1
	H264_FRAME_INDEX_RES_800,
#endif
	H264_FRAME_INDEX_LAST
}h264_frame_index_t;

typedef enum tag_h264_trans_vendor_frame_index_t
{

	H264_TRANS_SINK_INDEX_UNDEF = 0,
#if HAS_H264_TRANS_SINK_RES_120 == 1
	H264_TRANS_SINK_INDEX_RES_120,
#endif
#if HAS_H264_TRANS_SINK_RES_144 == 1
	H264_TRANS_SINK_INDEX_RES_144,
#endif
#if HAS_H264_TRANS_SINK_RES_240 == 1
	H264_TRANS_SINK_INDEX_RES_240,
#endif
#if HAS_H264_TRANS_SINK_RES_240W == 1
	H264_TRANS_SINK_INDEX_RES_240W,
#endif
#if HAS_H264_TRANS_SINK_RES_288 == 1
	H264_TRANS_SINK_INDEX_RES_288,
#endif
#if HAS_H264_TRANS_SINK_RES_480I == 1
	H264_TRANS_SINK_INDEX_RES_480I,
#endif
#if HAS_H264_TRANS_SINK_RES_480P == 1
	H264_TRANS_SINK_INDEX_RES_480P,
#endif
#if HAS_H264_TRANS_SINK_RES_480W == 1
	H264_TRANS_SINK_INDEX_RES_480W,
#endif
#if HAS_H264_TRANS_SINK_RES_576I == 1
	H264_TRANS_SINK_INDEX_RES_576I,
#endif
#if HAS_H264_TRANS_SINK_RES_576P == 1
	H264_TRANS_SINK_INDEX_RES_576P,
#endif
#if HAS_H264_TRANS_SINK_RES_720 == 1
	H264_TRANS_SINK_INDEX_RES_720,
#endif
#if HAS_H264_TRANS_SINK_RES_800 == 1
	H264_TRANS_SINK_INDEX_RES_800,
#endif
	H264_TRANS_SINK_FRAME_INDEX_LAST
}h264_trans_frame_index_t;


#define POS_CT_SCANNING_MODE_CONTROL			0
#define POS_CT_AE_MODE_CONTROL					1
#define POS_CT_AE_PRIORITY_CONTROL				2
#define POS_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL	3
#define POS_CT_EXPOSURE_TIME_RELATIVE_CONTROL	4
#define POS_CT_FOCUS_ABSOLUTE_CONTROL			5
#define POS_CT_FOCUS_RELATIVE_CONTROL			6
#define POS_CT_IRIS_ABSOLUTE_CONTROL			7
#define POS_CT_IRIS_RELATIVE_CONTROL			(8 - 8)
#define POS_CT_ZOOM_ABSOLUTE_CONTROL			(9 - 8)
#define POS_CT_ZOOM_RELATIVE_CONTROL			(10 - 8)
#define POS_CT_PANTILT_ABSOLUTE_CONTROL			(11 - 8)
#define POS_CT_PANTILT_RELATIVE_CONTROL			(12 - 8)
#define POS_CT_ROLL_ABSOLUTE_CONTROL			(13 - 8)
#define POS_CT_ROLL_RELATIVE_CONTROL			(14 - 8)

#define POS_CT_FOCUS_AUTO_CONTROL				(17 - 16)
#define POS_CT_PRIVACY_CONTROL					(18 - 16)

#define CT_BM_CONTROLS_0 \
((HAS_CT_SCANNING_MODE_CONTROL			<<	 POS_CT_SCANNING_MODE_CONTROL			) | \
(HAS_CT_AE_MODE_CONTROL					<<   POS_CT_AE_MODE_CONTROL					) | \
(HAS_CT_AE_PRIORITY_CONTROL				<<   POS_CT_AE_PRIORITY_CONTROL				) | \
(HAS_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL	<<   POS_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL	) | \
(HAS_CT_EXPOSURE_TIME_RELATIVE_CONTROL	<<   POS_CT_EXPOSURE_TIME_RELATIVE_CONTROL	) | \
(HAS_CT_FOCUS_ABSOLUTE_CONTROL			<<   POS_CT_FOCUS_ABSOLUTE_CONTROL			) | \
(HAS_CT_FOCUS_RELATIVE_CONTROL			<<   POS_CT_FOCUS_RELATIVE_CONTROL			) | \
(HAS_CT_IRIS_ABSOLUTE_CONTROL			<<   POS_CT_IRIS_ABSOLUTE_CONTROL			))


#define CT_BM_CONTROLS_1 \
((HAS_CT_IRIS_RELATIVE_CONTROL			<<   POS_CT_IRIS_RELATIVE_CONTROL			) | \
(HAS_CT_ZOOM_ABSOLUTE_CONTROL			<<   POS_CT_ZOOM_ABSOLUTE_CONTROL			) | \
(HAS_CT_ZOOM_RELATIVE_CONTROL			<<   POS_CT_ZOOM_RELATIVE_CONTROL			) | \
(HAS_CT_PANTILT_ABSOLUTE_CONTROL		<<   POS_CT_PANTILT_ABSOLUTE_CONTROL		) | \
(HAS_CT_PANTILT_RELATIVE_CONTROL		<<   POS_CT_PANTILT_RELATIVE_CONTROL		) | \
(HAS_CT_ROLL_ABSOLUTE_CONTROL			<<   POS_CT_ROLL_ABSOLUTE_CONTROL			) | \
(HAS_CT_ROLL_RELATIVE_CONTROL			<<   POS_CT_ROLL_RELATIVE_CONTROL			))

#define CT_BM_CONTROLS_2 \
((HAS_CT_FOCUS_AUTO_CONTROL				<<   POS_CT_FOCUS_AUTO_CONTROL				) | \
(HAS_CT_PRIVACY_CONTROL					<<	 POS_CT_PRIVACY_CONTROL					))

/* Modify the following based on camera sensor capabilities */
#define CAP_PAN_MAX		(15 * 3600)
#define CAP_PAN_MIN		(-15 * 3600)
#define CAP_PAN_RES		(100)	
#define CAP_TILT_MAX	(15 * 3600)
#define CAP_TILT_MIN	(-15 * 3600)
#define CAP_TILT_RES	(100)	
#define CAP_ZOOM_MAX	100
#define CAP_ZOOM_MIN	0

#define	POS_PU_BRIGHTNESS							0
#define	POS_PU_CONTRAST								1
#define	POS_PU_HUE									2
#define	POS_PU_SATURATION							3
#define	POS_PU_SHARPNESS							4
#define	POS_PU_GAMMA								5
#define	POS_PU_WHITE_BALANCE_TEMPERATURE			6
#define	POS_PU_WHITE_BALANCE_COMPONENT				7

#define	POS_PU_BACKLIGHT_COMPENSATION				(8 - 8)
#define	POS_PU_GAIN									(9 - 8)
#define	POS_PU_POWER_LINE_FREQUENCY					(10 - 8)
#define	POS_PU_HUE_AUTO								(11 - 8)
#define	POS_PU_WHITE_BALANCE_TEMPERATURE_AUTO		(12 - 8)
#define	POS_PU_WHITE_BALANCE_COMPONENT_AUTO			(13 - 8)
#define	POS_PU_DIGITAL_MULTIPLIER					(14 - 8)



#define PU_BM_CONTROLS_1 \
((HAS_PU_BRIGHTNESS						<<   POS_PU_BRIGHTNESS						) | \
 (HAS_PU_CONTRAST						<<   POS_PU_CONTRAST							) | \
 (HAS_PU_HUE							<<   POS_PU_HUE								) | \
 (HAS_PU_SATURATION						<<   POS_PU_SATURATION						) | \
 (HAS_PU_SHARPNESS						<<   POS_PU_SHARPNESS						) | \
 (HAS_PU_GAMMA							<<   POS_PU_GAMMA							) | \
 (HAS_PU_WHITE_BALANCE_TEMPERATURE		<<	 POS_PU_WHITE_BALANCE_TEMPERATURE		) | \
 (HAS_PU_WHITE_BALANCE_COMPONENT		<<	 POS_PU_WHITE_BALANCE_COMPONENT))

#define PU_BM_CONTROLS_2 \
((HAS_PU_BACKLIGHT_COMPENSATION			<<   POS_PU_BACKLIGHT_COMPENSATION			) | \
 (HAS_PU_GAIN							<<   POS_PU_GAIN							) | \
 (HAS_PU_POWER_LINE_FREQUENCY			<<   POS_PU_POWER_LINE_FREQUENCY			) | \
 (HAS_PU_HUE_AUTO						<<   POS_PU_HUE_AUTO						) | \
 (HAS_PU_WHITE_BALANCE_TEMPERATURE_AUTO	<<   POS_PU_WHITE_BALANCE_TEMPERATURE_AUTO	) | \
 (HAS_PU_WHITE_BALANCE_COMPONENT_AUTO	<<   POS_PU_WHITE_BALANCE_COMPONENT_AUTO	) | \
 (HAS_PU_DIGITAL_MULTIPLIER				<<	 POS_PU_DIGITAL_MULTIPLIER				))

#define MJPEG_BMCAPABILITIES (HAS_MJPEG_STILL | HAS_MJPEG_FIXED_FRAME_RATE << 1)

#endif //dePOS_PU_WHITE_BALANCE_COMPONENT	fine __PLATFORM_CAPS_H__
