/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file declares mjpeg frame descriptors. These desciptors are common
 * for capture and encode interfaces.
 *
 */

#include "uvcdescript.h"
#include "dbgout.h"

#ifndef __MJPG_FRAME_DESCIPT_H__
#define __MJPG_FRAME_DESCIPT_H__

extern struct uvc_vs_format_descriptor vs_format_descriptor_mjpg;
#if HAS_MJPEG_RES_120	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_120;
#endif

#if HAS_MJPEG_RES_144	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_144;
#endif

#if HAS_MJPEG_RES_240	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_240;
#endif

#if HAS_MJPEG_RES_240W	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_240W;
#endif

#if HAS_MJPEG_RES_288	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_288;
#endif

#if HAS_MJPEG_RES_480I	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_480I;
#endif


#if HAS_MJPEG_RES_480P	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_480P;
#endif

#if HAS_MJPEG_RES_480W	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_480W;
#endif

#if HAS_MJPEG_RES_576I	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_576I;
#endif


#if HAS_MJPEG_RES_576P	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_576P;
#endif

#if HAS_MJPEG_RES_720	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_720;
#endif

  
#if HAS_MJPEG_RES_800	== 1
extern struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_800;
#endif


#if HAS_MJPEG_RES_480P	== 1
#define	ADD_MJPEG_RES_480P (struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_480P,
#else
#define	ADD_MJPEG_RES_480P
#endif

#if HAS_MJPEG_RES_288	== 1
#define	ADD_MJPEG_RES_288	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_288,
#else
#define ADD_MJPEG_RES_288
#endif

#if HAS_MJPEG_RES_240	== 1
#define	ADD_MJPEG_RES_240	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_240,
#else
#define	ADD_MJPEG_RES_240
#endif

#if HAS_MJPEG_RES_144	== 1
#define	ADD_MJPEG_RES_144	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_144,
#else
#define	ADD_MJPEG_RES_144
#endif

#if HAS_MJPEG_RES_120	== 1
#define	ADD_MJPEG_RES_120	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_120,
#else
#define	ADD_MJPEG_RES_120
#endif

#if HAS_MJPEG_RES_720	== 1
#define	ADD_MJPEG_RES_720	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_720,
#else
#define	ADD_MJPEG_RES_720
#endif

#if HAS_MJPEG_RES_240W	== 1
#define	ADD_MJPEG_RES_240W	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_240W,
#else
#define	ADD_MJPEG_RES_240W
#endif

#if HAS_MJPEG_RES_480I	== 1
#define	ADD_MJPEG_RES_480I	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_480I,
#else
#define	ADD_MJPEG_RES_480I
#endif

#if HAS_MJPEG_RES_480W	== 1
#define	ADD_MJPEG_RES_480W	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_480W,
#else
#define	ADD_MJPEG_RES_480W
#endif

#if HAS_MJPEG_RES_576I	== 1
#define	ADD_MJPEG_RES_576I	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_576I,
#else
#define	ADD_MJPEG_RES_576I
#endif

#if HAS_MJPEG_RES_576P	== 1
#define	ADD_MJPEG_RES_576P	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_576P,
#else
#define	ADD_MJPEG_RES_576P
#endif

#if HAS_MJPEG_RES_800	== 1
#define	ADD_MJPEG_RES_800	(struct usb_descriptor_header *) &vs_frame_descriptor_mjpg_800,
#else
#define	ADD_MJPEG_RES_800
#endif

#define DEFINE_MJPG_FRAME_DESCRIPT \
	ADD_MJPEG_RES_480P	\
	ADD_MJPEG_RES_288	\
	ADD_MJPEG_RES_240	\
	ADD_MJPEG_RES_144	\
	ADD_MJPEG_RES_120	\
	ADD_MJPEG_RES_720	\
	ADD_MJPEG_RES_240W	\
	ADD_MJPEG_RES_480I	\
	ADD_MJPEG_RES_480W	\
	ADD_MJPEG_RES_576I	\
	ADD_MJPEG_RES_576P	\
	ADD_MJPEG_RES_800


extern const struct usb_descriptor_header *mjpeg_frame_descriptors[];
extern struct uvc_streaming_control_request	mjpeg_param_table[MJPEG_FRAME_INDEX_LAST][PROBE_INDEX_LAST];

#endif //__MJPG_FRAME_DESCIPT_H__
