/*
 * This file indicates the device capabilities of MG3500 based designs.
 * This file is inluded in platform_caps.h to generate UVC/UAC descriptors
 * at compile time.
 */
#ifndef __MG3500_CAPS_H__
#define __MG3500_CAPS_H__

/*
** List of supported boards
*/
#define BOARD_ID_EVP			1	
#define BOARD_ID_MOBICAM3		2

// TODO: Supply the BOARD_ID throgh make file
#ifndef BOARD_ID
#define BOARD_ID	BOARD_ID_EVP
#endif

/*
** Specify endpoint addresss
** VID_CAP_EP_ADDR : End point address for video capture
** AUD_CAP_EP_ADDR : End point address for audio capture
** VID_TR_EP_ADDR  : End point address for video transcode
** VC_INT_EP_ADDR  : End point address for interrupt
*/
#if (BOARD_ID == BOARD_ID_MOBICAM3)

#define VID_CAP_EP_ADDR		0x01
#define AUD_CAP_EP_ADDR		0x03	
#define VC_INT_EP_ADDR		0x04
#define VID_TR_EP_ADDR		0x02

#elif (BOARD_ID == BOARD_ID_EVP)

#define VID_CAP_EP_ADDR		0x01
#define AUD_CAP_EP_ADDR		0x03	
#define VC_INT_EP_ADDR		0x04
#define VID_TR_EP_ADDR		0x02

#endif

// Following constant definitions specify supported video capture, audio capture and 
// transcode features
// uncomment the interfaces available
#if (BOARD_ID == BOARD_ID_MOBICAM3)

#define HAS_VID_CAP						1
#define HAS_AUD_CAP						1
#define HAS_VID_TRANS					1

#elif (BOARD_ID == BOARD_ID_EVP)

#define HAS_VID_CAP						1
#define HAS_AUD_CAP						1
#define HAS_VID_TRANS					1

#endif

#define HAS_AVMUX_AS_DEFAULT			1

// Following constant definitions specify inputs available on the hardware
// uncomment the terminals available
#if (BOARD_ID == BOARD_ID_MOBICAM3)

#define HAS_CAMERA_INPUT				1
#define HAS_COMPOSITE_CONNECTOR_INPUT	0
#define HAS_SVIDEO_CONNECTOR_INPUT		0	
#define HAS_COMPONENT_CONNECTOR_INPUT	0	
#define HAS_HDMI_CONNECTOR_INPUT		0	

#elif (BOARD_ID == BOARD_ID_EVP)

#define HAS_CAMERA_INPUT				0
#define HAS_COMPOSITE_CONNECTOR_INPUT	1
#define HAS_SVIDEO_CONNECTOR_INPUT		1	
#define HAS_COMPONENT_CONNECTOR_INPUT	1	
#define HAS_HDMI_CONNECTOR_INPUT		1	
#endif

//If HAS_VIDCAP_ISOCH == 1, video Capture streaming interface end point type  is ISOCH else BULK
#ifndef HAS_VIDCAP_ISOCH
#define HAS_VIDCAP_ISOCH				1
#endif
//If HAS_ENC_ISOCH == 1, video transcode streaming interface IN end point type  is ISOCH else BULK
#ifndef HAS_ENC_ISOCH
#define HAS_ENC_ISOCH						0
#endif

//If HAS_DEC_ISOCH == 1, video transcode streaming interface OUT end point type  is ISOCH else BULK
#ifndef HAS_DEC_ISOCH
#define HAS_DEC_ISOCH						0
#endif
// Following constant definitions specify processing or extension units available
// uncomment the terminals avilable

#define HAS_VIDCAP_UNIT_PROCESSOR		1
#define HAS_VIDCAP_UNIT_EXT				1

// Following constant definitions specify outputs available on the hardware
// uncomment the terminals avilable

#define HAS_DISPLY_OUTPUT				0
#define HAS_MEDIA_TRANSPORT_OUTPUT		0
#define HAS_COMPOSITE_CONNECTOR_OUTPUT	0
#define HAS_SVIDEO_CONNECTOR_OUTPUT		0
#define HAS_COMPONENT_CONNECTOR_OUTPUT	0


// Following constant definitions specify 
// input compression formats available on the hardware
// uncomment the formats available terminals available

#define HAS_YUV420_ENCODE			0
#define HAS_MJPEG_ENCODE			0
#define HAS_H264_ENCODE				1 	// MPEG2TS
#define HAS_H264_ENCODE_VEN			0 	// Elementary, Frame based

/**
 * Only one of the following options should be selected
 * HAS_H264_MP2TS_TRANS_SINK is used in devices with preview or transcode is using MP2TS stream
 * HAS_H264_VEN_STREAM_TRANS_SINK or  HAS_H264_VEN_FRAME_TRANS_SINK(implementaion incomplete) is enalbled 
 * with devices supporting transcode using h264 annexB stream.
 */
#define HAS_H264_MP2TS_TRANS_SINK			0
#define HAS_H264_VEN_STREAM_TRANS_SINK		1
#define HAS_H264_VEN_FRAME_TRANS_SINK		0

#define HAS_MJPEG_PREV				1
#define HAS_H264_MP2TS_TRANS_SOURCE	1


#define HAS_H264_VEN_TRANS_SOURCE	0


// Following constant definitions specify 
// output compression formats available on the hardware
// uncomment the formats available terminals available

#define HAS_YUV420_DECODE	0
#define HAS_MJPEG_DECODE	0
#define HAS_H264_DECODE				1	// MPEG2TS


// default frame index here
#define HAS_MJPEG_RES_480P	1	// VGA		640 x 480	Variable frame rate
#define HAS_MJPEG_RES_120	1	// SQVGA	160 x 120	Variable frame rate
#define HAS_MJPEG_RES_144	1	// QCIF		176 x 144	Variable frame rate
#define HAS_MJPEG_RES_240	1	// QVGA		320 x 240	Variable frame rate
#define HAS_MJPEG_RES_240W	0	// WQVGA	384 x 240	Variable frame rate
#define HAS_MJPEG_RES_288	1	// CIF		352 x 288	Variable frame rate
#define HAS_MJPEG_RES_480I	0	// SD		720 x 480	Interlaced
#define HAS_MJPEG_RES_480W	0	// VGA-B	768 x 480	Variable frame rate
#define HAS_MJPEG_RES_576I	0	// 4CIF		704 x 576	Interlaced
#define HAS_MJPEG_RES_576P	0	// 4CIF		704 x 576
#define HAS_MJPEG_RES_720	1	// 720P		1280x 720	Variable frame rate
#define HAS_MJPEG_RES_800	0	// WXGA		1280 x 800

#define HAS_MJPEG_STILL					0	// WXGA		1280 x 800
#define HAS_MJPEG_FIXED_FRAME_RATE		0	// WXGA		1280 x 800

#define HAS_H264_RES_120	0	// SQVGA	160 x 120	Variable frame rate
#define HAS_H264_RES_144	0	// QCIF		176 x 144	Variable frame rate
#define HAS_H264_RES_240	0	// QVGA		320 x 240	Variable frame rate
#define HAS_H264_RES_240W	0	// WQVGA	384 x 240	Variable frame rate
#define HAS_H264_RES_288	0	// CIF		352 x 288	Variable frame rate
#define HAS_H264_RES_480I	0	// SD		720 x 480	Interlaced
#define HAS_H264_RES_480P	0	// VGA		640 x 480	Variable frame rate
#define HAS_H264_RES_480W	0	// VGA-B	768 x 480	Variable frame rate
#define HAS_H264_RES_576I	0	// 4CIF		704 x 576	Interlaced
#define HAS_H264_RES_576P	0	// 4CIF		704 x 576
#define HAS_H264_RES_720	1	// 720P		1280x 720	Variable frame rate
#define HAS_H264_RES_800	0	// WXGA		1280 x 800

#define HAS_H264_TRANS_SINK_RES_120		0	// SQVGA	160 x 120	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_144		0	// QCIF		176 x 144	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_240		0	// QVGA		320 x 240	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_240W	0	// WQVGA	384 x 240	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_288		0	// CIF		352 x 288	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_480I	0	// SD		720 x 480	Interlaced
#define HAS_H264_TRANS_SINK_RES_480P	0	// VGA		640 x 480	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_480W	0	// VGA-B	768 x 480	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_576I	0	// 4CIF		704 x 576	Interlaced
#define HAS_H264_TRANS_SINK_RES_576P	0	// 4CIF		704 x 576
#define HAS_H264_TRANS_SINK_RES_720		1	// 720P		1280x 720	Variable frame rate
#define HAS_H264_TRANS_SINK_RES_800		0	// WXGA		1280 x 800


#if (BOARD_ID == BOARD_ID_MOBICAM3)

#define HAS_CT_SCANNING_MODE_CONTROL			0
#define HAS_CT_AE_MODE_CONTROL					0
#define HAS_CT_AE_PRIORITY_CONTROL				0
#define HAS_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL	0
#define HAS_CT_EXPOSURE_TIME_RELATIVE_CONTROL	0
#define HAS_CT_FOCUS_ABSOLUTE_CONTROL			0
#define HAS_CT_FOCUS_RELATIVE_CONTROL			0
#define HAS_CT_IRIS_ABSOLUTE_CONTROL			0
#define HAS_CT_IRIS_RELATIVE_CONTROL			0
#define HAS_CT_ZOOM_ABSOLUTE_CONTROL			0
#define HAS_CT_ZOOM_RELATIVE_CONTROL			0
#define HAS_CT_PANTILT_ABSOLUTE_CONTROL			1
#define HAS_CT_PANTILT_RELATIVE_CONTROL			0
#define HAS_CT_ROLL_ABSOLUTE_CONTROL			0
#define HAS_CT_ROLL_RELATIVE_CONTROL			0
#define HAS_CT_FOCUS_AUTO_CONTROL				0
#define HAS_CT_PRIVACY_CONTROL					0

#elif (BOARD_ID == BOARD_ID_EVP)

#define HAS_CT_SCANNING_MODE_CONTROL			0
#define HAS_CT_AE_MODE_CONTROL					0
#define HAS_CT_AE_PRIORITY_CONTROL				0
#define HAS_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL	0
#define HAS_CT_EXPOSURE_TIME_RELATIVE_CONTROL	0
#define HAS_CT_FOCUS_ABSOLUTE_CONTROL			0
#define HAS_CT_FOCUS_RELATIVE_CONTROL			0
#define HAS_CT_IRIS_ABSOLUTE_CONTROL			0
#define HAS_CT_IRIS_RELATIVE_CONTROL			0
#define HAS_CT_ZOOM_ABSOLUTE_CONTROL			0
#define HAS_CT_ZOOM_RELATIVE_CONTROL			0
#define HAS_CT_PANTILT_ABSOLUTE_CONTROL			0
#define HAS_CT_PANTILT_RELATIVE_CONTROL			0
#define HAS_CT_ROLL_ABSOLUTE_CONTROL			0
#define HAS_CT_ROLL_RELATIVE_CONTROL			0
#define HAS_CT_FOCUS_AUTO_CONTROL				0
#define HAS_CT_PRIVACY_CONTROL					0

#endif

#if (BOARD_ID == BOARD_ID_MOBICAM3)

#define	HAS_PU_BRIGHTNESS							1
#define	HAS_PU_CONTRAST								1
#define	HAS_PU_HUE									0
#define	HAS_PU_SATURATION							1
#define	HAS_PU_SHARPNESS							0
#define	HAS_PU_GAMMA								1
#define	HAS_PU_WHITE_BALANCE_TEMPERATURE			0
#define	HAS_PU_WHITE_BALANCE_COMPONENT				0

#define	HAS_PU_BACKLIGHT_COMPENSATION				0
#define	HAS_PU_GAIN									0
#define	HAS_PU_POWER_LINE_FREQUENCY					0
#define	HAS_PU_HUE_AUTO								0
#define	HAS_PU_WHITE_BALANCE_TEMPERATURE_AUTO		0
#define	HAS_PU_WHITE_BALANCE_COMPONENT_AUTO			0
#define	HAS_PU_DIGITAL_MULTIPLIER					0

#elif (BOARD_ID == BOARD_ID_EVP)

#define	HAS_PU_BRIGHTNESS							0
#define	HAS_PU_CONTRAST								0
#define	HAS_PU_HUE									0
#define	HAS_PU_SATURATION							0
#define	HAS_PU_SHARPNESS							0
#define	HAS_PU_GAMMA								0
#define	HAS_PU_WHITE_BALANCE_TEMPERATURE			0
#define	HAS_PU_WHITE_BALANCE_COMPONENT				0

#define	HAS_PU_BACKLIGHT_COMPENSATION				0
#define	HAS_PU_GAIN									0
#define	HAS_PU_POWER_LINE_FREQUENCY					0
#define	HAS_PU_HUE_AUTO								0
#define	HAS_PU_WHITE_BALANCE_TEMPERATURE_AUTO		0
#define	HAS_PU_WHITE_BALANCE_COMPONENT_AUTO			0
#define	HAS_PU_DIGITAL_MULTIPLIER					0

#endif

#endif //__MG3500_CAPS_H__
