/*
 *  linux/drivers/serial/8250_mobidw.c
 *
 *  Modified from  linux/drivers/serial/8250_accent.c
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 *  Copyright (C) 2005 Russell King.
 *  Data taken from include/asm-i386/serial.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/serial_8250.h>
#include <linux/serial.h>

#include <mach/platform.h>
#include <mach/mobi_clock.h>
#include <mach/mobi_reset.h>

#define PORT(_base, _irq)		\
{					\
	.iobase		= 0,			\
	.mapbase	= _base,		\
	.irq		= _irq,			\
	.uartclk	= 0,			\
	.iotype		= UPIO_MEM32,	\
	.regshift	= 2,			\
	.flags		= UPF_BOOT_AUTOCONF|UPF_IOREMAP,	\
}

static struct plat_serial8250_port dw_uart_portdata[] = {
	PORT(UARTDBG_BASE, MOBI_IRQ_UARTDBG),
	PORT(UART0_BASE, MOBI_IRQ_UART0),
	PORT(UART1_BASE, MOBI_IRQ_UART1),
	{ },
};

static u64 serial_dma_mask = ~0;

static struct platform_device dw_uart_device = {
	.name	= "serial8250",
	.id		= PLAT8250_DEV_MOBI,
	.dev	= {
		.dma_mask           = &serial_dma_mask,
		.coherent_dma_mask  = ~0,
		.platform_data		= dw_uart_portdata,
	},
};

static int __init dw_uart_init(void)
{
	/* this is set by the bootloader */
	dw_uart_portdata[0].uartclk = mobi_clock_get_rate(CLOCK_ID_UARTDBG);

	mobi_reset_disable(RESET_ID_UART01);

	/*
	 * these clocks cannot be zero, but we don't really have an
	 * easy way to change them if we want???
	 */
	mobi_clock_set_rate(CLOCK_ID_UART0,
			dw_uart_portdata[0].uartclk);
	mobi_clock_set_rate(CLOCK_ID_UART1,
			dw_uart_portdata[0].uartclk);
	dw_uart_portdata[1].uartclk = mobi_clock_get_rate(CLOCK_ID_UART0);
	dw_uart_portdata[2].uartclk = mobi_clock_get_rate(CLOCK_ID_UART1);

	return platform_device_register(&dw_uart_device);
}
module_init(dw_uart_init);

MODULE_AUTHOR("Jeff Hane");
MODULE_DESCRIPTION("8250 serial module for DW UARTS");
MODULE_LICENSE("GPL");
