/*
 * Copyright (C) Mobilygen Corp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "codec_reset_qccdefs.h"

struct qcc_cmd_def qcc_reset_cmds[] = {
	/* cmd       blkID addr  size    data     mask */
	/* set pmc waterLevel to 0 */
	{ QCC_WRITE,   17, 0x001e, 1, 0x00000000, 0x00000000 }, /* PMC      */
	/* codec reset in chipctl */
	{ QCC_WRITE,    8, 0x00c8, 0, 0x00000001, 0x00000000 }, /* CHIPCTL  */
	/* this is table is mostly automatically generated but some editing must be */
	/* done to complete the task.  All PMC write must occur first, move any     */
	/* other blkID writes to the end of the table, after the last MMU command,  */
	/* in the order they are found. Also note, sizes are converted to the qcc   */
	/* format so 4 byte writes will appear as 0 in the table                    */
	{ QCC_WRITE,   17, 0x0016, 1, 0x00000035, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0015, 1, 0x00000024, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0014, 1, 0x00000003, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0011, 1, 0x00000022, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0012, 1, 0x00000004, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0013, 1, 0x000000ff, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0053, 1, 0x000000ff, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x007a, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0017, 1, 0x00000093, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0018, 1, 0x0000008f, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0019, 1, 0x000000ff, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x001a, 1, 0x000000a0, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x001b, 1, 0x00000017, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x001c, 1, 0x00000006, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x001d, 1, 0x00000060, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x001e, 1, 0x00000045, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x001f, 1, 0x000000c7, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0078, 1, 0x00000020, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0079, 1, 0x00000059, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0020, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0021, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0022, 1, 0x00000002, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0023, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0024, 1, 0x00000042, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0025, 1, 0x00000007, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0026, 1, 0x00000042, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0027, 1, 0x00000006, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0028, 1, 0x00000082, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0029, 1, 0x00000003, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x002a, 1, 0x00000002, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x002b, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x002c, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x002d, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x002e, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x002f, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0030, 1, 0x0000004a, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0031, 1, 0x000000d0, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0032, 1, 0x000000b0, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0033, 1, 0x000000d1, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0034, 1, 0x00000081, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0035, 1, 0x000000c2, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0036, 1, 0x00000002, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0037, 1, 0x00000003, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0038, 1, 0x00000009, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0039, 1, 0x00000010, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x003a, 1, 0x00000081, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x003b, 1, 0x000000c2, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x003c, 1, 0x000000c1, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x003d, 1, 0x00000018, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x003e, 1, 0x00000021, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x003f, 1, 0x00000029, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0040, 1, 0x00000044, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0041, 1, 0x000000b2, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0042, 1, 0x000000e3, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0043, 1, 0x000000d9, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0044, 1, 0x000000f0, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0045, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0046, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0047, 1, 0x00000000, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0050, 1, 0x00000002, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0051, 1, 0x00000015, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0052, 1, 0x00000022, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0054, 1, 0x000000db, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0055, 1, 0x000000d8, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0056, 1, 0x0000003b, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0061, 1, 0x0000000c, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0062, 1, 0x00000028, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0063, 1, 0x0000004c, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0064, 1, 0x00000068, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0068, 1, 0x00000007, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0010, 1, 0x000000ba, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0010, 1, 0x000000fa, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   17, 0x0010, 1, 0x000000ba, 0x00000000 }, /* PMC      */
	{ QCC_WRITE,   16, 0x0010, 2, 0x00003da5, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0012, 2, 0x00000050, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00c0, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00c2, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00c4, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00c6, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00c8, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00ca, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00cc, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00ce, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00d0, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00d2, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00d4, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00d6, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00d8, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00da, 2, 0x00000030, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00dc, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00de, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00e0, 2, 0x00000008, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00e2, 2, 0x00000008, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0080, 2, 0x00000000, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0082, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0084, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0086, 2, 0x00000060, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0088, 2, 0x00000080, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x008a, 2, 0x000000a0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x008c, 2, 0x000000e0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x008e, 2, 0x00000120, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0090, 2, 0x00000140, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0092, 2, 0x00000180, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0094, 2, 0x00000190, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0096, 2, 0x000001b0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0098, 2, 0x000001f0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x009a, 2, 0x00000230, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x009c, 2, 0x00000260, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x009e, 2, 0x00000280, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00a0, 2, 0x00000290, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x00a2, 2, 0x00000298, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0028, 2, 0x00005528, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x002a, 2, 0x0000a100, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x002c, 2, 0x00000000, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0060, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0062, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0064, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0066, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0068, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x006a, 2, 0x00000048, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x006c, 2, 0x00000048, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x006e, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0070, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0072, 2, 0x00000040, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0074, 2, 0x00000030, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0076, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0078, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x007a, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x007c, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x007e, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0040, 2, 0x00000000, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0042, 2, 0x00000010, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0044, 2, 0x00000020, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0046, 2, 0x00000030, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0048, 2, 0x00000050, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x004a, 2, 0x00000070, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x004c, 2, 0x000000b8, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x004e, 2, 0x00000100, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0050, 2, 0x00000110, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0052, 2, 0x00000140, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0054, 2, 0x00000180, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0056, 2, 0x000001b0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0058, 2, 0x00000120, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x005a, 2, 0x000001d0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x005c, 2, 0x000001e0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x005e, 2, 0x000001f0, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0020, 2, 0x00005a2a, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,   16, 0x0022, 2, 0x00008000, 0x00000000 }, /* MMU      */
	{ QCC_WRITE,    1, 0x0014, 0, 0x00097e7d, 0x00000000 }, /* QDBG_SYS */
	{ QCC_WRITE,    3, 0x0014, 0, 0x00097e7c, 0x00000000 }, /* VID      */
	{ QCC_WRITE,   18, 0x0008, 2, 0x00000008, 0x00000000 }, /* PMU      */
};
