/*
 *  linux/arch/arm/mach-merlin/codec_reset.c
 *
 *  Copyright (C) 2008 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef DOXYGEN_SKIP

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/errno.h>
#include <linux/proc_fs.h>
#include <linux/platform_device.h>
#include <linux/major.h>
#include <linux/cdev.h>
#include <linux/device.h>
#include <asm/uaccess.h>

#include <mach/platform.h>

#endif

#define DEV_NAME "mhifnor"

static struct class *dev_class = NULL;
int major;
static struct cdev cdev = {
    .kobj   =   {
		.name = DEV_NAME, 
	},
    .owner  =   THIS_MODULE,
};

#define MG_MHIFNOR_DEBUG 0

#if MG_MHIFNOR_DEBUG
#define dprintk(x...) printk(x);
#else
#define dprintk(x...) 
#endif


static int mhifnor_ioctl(struct inode *inode, struct file *file,
        unsigned int cmd, unsigned long arg)
{
	return 0;
}

/* we don't have anything to do! */
static int mhifnor_open(struct inode *inode, struct file *filp)
{
	return 0;
}

static const struct file_operations dev_fops = {
    .owner  = THIS_MODULE,
    .llseek = no_llseek,
    .open   = mhifnor_open,
    .ioctl  = mhifnor_ioctl,
};

static int mg_mhifnor_probe(struct platform_device *dev)
{
	dev_t devt_id = 0;
	int err = 0;

	/* 1 device, minor 0 */
	dev_class = class_create(THIS_MODULE, DEV_NAME);
	if (dev_class == NULL)
		return -EIO;

	err = alloc_chrdev_region(&devt_id, 0, 1, DEV_NAME);
	if (err) {
		class_destroy(dev_class);
		return err;
	}

	major = MAJOR(devt_id);

	cdev_init(&cdev, &dev_fops);
	err = cdev_add(&cdev, devt_id, 1);
	if (err) {
		unregister_chrdev_region(devt_id, 1);
		class_destroy(dev_class);
	}
	else {
		device_create(dev_class, NULL, devt_id, NULL, DEV_NAME);
	}

	return err;
}

static int mg_mhifnor_remove(struct platform_device *pdev)
{
	dev_t devt_id = MKDEV(major, 0);

	device_destroy(dev_class, devt_id);
	class_destroy(dev_class);
	cdev_del(&cdev);
	unregister_chrdev_region(devt_id, 1);

	return 0;
}

static void mg_mhifnor_shutdown(struct platform_device *dev) { }

#ifdef CONFIG_PM
static int mg_mhifnor_suspend(struct platform_device *dev, pm_message_t state)
{
	return 0;
}

static int mg_mhifnor_resume(struct platform_device *dev)
{
	return 0;
}
#else 
#define mg_mhifnor_suspend NULL
#define mg_mhifnor_resume  NULL
#endif

static struct platform_driver mg_mhifnor_driver = {
	.probe		= mg_mhifnor_probe,
	.remove		= mg_mhifnor_remove,
	.suspend	= mg_mhifnor_suspend,
	.resume		= mg_mhifnor_resume,
	.shutdown	= mg_mhifnor_shutdown,
	.driver		= {
		.name	= "mg_mhifnor",
	},
};

static int __init mg_mhifnor_init(void)
{
	return(platform_driver_register(&mg_mhifnor_driver));
}

static void __exit mg_mhifnor_exit(void)
{
	platform_driver_unregister(&mg_mhifnor_driver);
}

/// @cond
module_init(mg_mhifnor_init);
module_exit(mg_mhifnor_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Jeff Hane");
MODULE_DESCRIPTION("Maxim NOR via MHIF driver");
/// @endcond
