/*
 *  Copyright (C) 2008 Mobilygen Corp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/init.h>
#include <linux/bootmem.h>
#include <linux/version.h>
#include <asm/setup.h>

/* FIXME - someone could update this to be an array such that we might take
 * multiple memmap=xx$xx parameters
 */
unsigned long reserve_start __initdata;
unsigned long reserve_end __initdata;

/*
 * Pick out the memory size.  We look for memmap=size@start,
 * where start and size are "size[KkMm]"
 */
static void __init early_memmap(char **p)
{
	reserve_start  = memparse(*p, p);
	/* **p == '%' */
	reserve_end = memparse(*p + 1, p);
}
__early_param("memmap=", early_memmap);

void __init mgx_adjust_zones(int node,
		unsigned long *size, unsigned long *holes)
{
	pg_data_t *pgdat;
	unsigned long start, end;

	pgdat = NODE_DATA(node);

	/*
	 * we are going to reserve anything mapped with memmap=x%x
	 */
	start = pgdat->bdata->node_min_pfn;
	end = pgdat->bdata->node_low_pfn << PAGE_SHIFT;

	if (reserve_start < start)
		reserve_start = start;
	if (reserve_end > end)
		reserve_end = end;

	if (reserve_start < reserve_end)
		reserve_bootmem_node(pgdat, reserve_start,
				reserve_end-reserve_start, 0);
}
