/*
 * arch/arm/plat-mgx/include/mach/mobi_hmux.h
 *
 *  Copyright (C) 2007 Mobilygen Corp.
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ARCH_ARM_PLAT_MGX_MOBI_HMUX_API_H
#define __ARCH_ARM_PLAT_MGX_MOBI_HMUX_API_H

#ifdef CONFIG_MACH_MERLIN

#include <mach/hmux_defs.h>
#include <linux/platform_device.h>

/* this is the driver_data in the platform_device */
struct mobi_hmux_drvdata {
    enum hmux_chipen chipen;
};

/** 
 * \brief mobi_hmux_request:
 * 	Request access to the hmux.  This function 
 * 	must not be used in interrupt context.
 *
 * \retval Zero - upon success
 *
 * \remark
 *   The function grants the access to the hmux and locks 
 * it so that only a single device can use it at a time.  
 * The call will block until access can be granted to the hmux.
 * 
 */

int mobi_hmux_request(void);
/** 
 * \brief mobi_hmux_request_try:
 * 	Request access to the hmux
 *
 * \retval Zero - upon success, -1 on failure
 *
 * \remark
 *   The function tries to grant access to the hmux and locks 
 * it so that only a single device can use it at a time.  
 * The call will not block but still must not be used
 * in interrupt context.
 * 
 */
int mobi_hmux_request_try(void);

/** 
 * \brief mobi_hmux_release:
 * 	Release access to the hmux
 *
 * \retval Zero - upon success
 * \retval -EACCES - not the current owner and trying to unlock mutex 
 *
 * \remark
 *   This function releases the hmux.
 * 
 */
int mobi_hmux_release(void);

/** 
 * \brief mobi_hmux_owner:
 * 	Get current owner of the hmux
 *
 * \retval NULL    - no owner
 * \retval POINTER - thread info of the owner 
 *
  */
void* mobi_hmux_owner(void);

/* register the platform device */
int mobi_hmux_register(struct platform_device*);
/* unregister the platform device */
void mobi_hmux_unregister(struct platform_device*);

#else

/* maintain for driver compatability with mg3500 */
int mobi_hmux_request(void) { return 0; }
int mobi_hmux_request_try(void) { return 0; }
int mobi_hmux_release(void) { return 0; }
void *mobi_hmux_owner(void) { return NULL; }
#endif

#endif  /* __ARCH_ARM_PLAT_MGX_MOBI_HMUX_API_H */
