/*HEADER_START*/
/*HEADER_STOP*/
#include <linux/init.h>
#include <linux/module.h>
#include <linux/mm.h>
#include <linux/types.h>
#include <linux/time.h>
#include <linux/proc_fs.h>
#include <linux/delay.h>

#include <mach/hardware.h>
#include <asm/mach-types.h>
#include <asm/setup.h>
#include <asm/io.h>
#include <asm/fiq.h>
#include <asm/mach/arch.h>

#include <mach/platform.h>
#include <mach/dma.h>
#include <mach/mobi_clock.h>
#include <mach/mobi_qcc.h>
#include <mach/mobi_timer.h>
#include <mach/mobi_fiq.h>

struct proc_dir_entry *debug_proc_dir = NULL;

static void proc_advance_ptr(char **ptr, uint32_t buffer, unsigned long count)
{
	char *buf = (char *)buffer;
	while(((**ptr==' ') || (**ptr=='\t') || (**ptr=='\r') ||
				(**ptr=='\n')) && (*ptr-buf<count)) {
		(*ptr)++;
	}
}

static int proc_get_next_arg(char **ptr, uint32_t buffer, unsigned long count)
{

	char *buf = (char *)buffer;
	proc_advance_ptr(ptr, buffer, count);
	if (*ptr-buf >= count) {
		return -EINVAL;
	}
	return 0;
}

/* use this function after getting fixed number of input */
static int  __attribute__((unused)) proc_check_for_arg(char **ptr,
		uint32_t buffer, unsigned long count)
{

	char *buf = (char *)buffer;
	proc_advance_ptr(ptr, buffer, count);
	if (*ptr-buf != count) { //then there is data
		if (*ptr-buf >= count) {
			return -EINVAL;
		}
		return 1;
	}
	return 0;
}

/**************************************************************************/
/* system timer testing code */
/**************************************************************************/

struct proc_dir_entry *systimer_proc_dir;
/* define in the system timer code but modified here */
//extern int systimer_debug_enable;

static int systimer_proc_wr_debug(struct file *file,
		const char *buffer, unsigned long count, void *data)
{
	char *ptr = (char *)buffer;

	while(((*ptr==' ') || (*ptr=='\t') || (*ptr=='\r') ||
				(*ptr=='\n')) && (ptr-buffer<count))
		ptr++;

	if (ptr-buffer >= count) {
		return -EINVAL;
	}
	//systimer_debug_enable=simple_strtoul(ptr, &ptr, 0);

	while(ptr-buffer<count)
		ptr++;

	return ptr - buffer;
}

static void  __attribute__((unused)) systimer_procfs_init(void)
{

	struct proc_dir_entry *pentry;

	if (systimer_proc_dir == NULL)
		systimer_proc_dir = proc_mkdir("driver/systimer", NULL);

	if (systimer_proc_dir == NULL) {
		systimer_proc_dir = proc_mkdir("driver", NULL);
		if (systimer_proc_dir != NULL)
			proc_mkdir("driver/systimer", NULL);
		else
			return;
	}

	pentry = create_proc_entry("driver/systimer/debug",
			S_IRUSR | S_IRGRP | S_IROTH, NULL);
	if (pentry) {
		pentry->write_proc = systimer_proc_wr_debug;
	}
}

/*************************************************************************/
static void  __attribute__((unused))
clk_api_test(uint32_t clk_id, unsigned long rate, char set)
{

	printk("\nMobilygen Driver Test.... executing %s\n", __func__);
	printk("Current clock settings\n");
	printk("got a freq for pll0    = %lu\n", mobi_clock_get_rate(CLOCK_ID_PLL0));
	printk("got a freq for scaler0 = %lu\n", mobi_clock_get_rate(CLOCK_ID_SCALER0));
	printk("got a freq for arm     = %lu\n", mobi_clock_get_rate(CLOCK_ID_ARM));
	printk("got a freq for ahb     = %lu\n", mobi_clock_get_rate(CLOCK_ID_AHB));
	printk("got a freq for apb     = %lu\n", mobi_clock_get_rate(CLOCK_ID_APB));
	printk("===========================================\n");

	printk("\nCurrent clock rate for requested clock %d: %lu\n",
			clk_id, mobi_clock_get_rate(clk_id));

	if (set == 0)
		return;

	printk("Requesting new rate of %lu for clock %d\n", rate, clk_id);
	mobi_clock_set_rate(clk_id, rate, 0);

	if (clk_id == CLOCK_ID_PLL0 || clk_id == CLOCK_ID_SCALER0 ||
			clk_id == CLOCK_ID_ARM || clk_id == CLOCK_ID_AHB  ||
			clk_id == CLOCK_ID_APB) {
		printk("Updated clock settings\n");
		printk("got a freq for pll0    = %lu\n", mobi_clock_get_rate(CLOCK_ID_PLL0));
		printk("got a freq for scaler0 = %lu\n", mobi_clock_get_rate(CLOCK_ID_SCALER0));
		printk("got a freq for arm     = %lu\n", mobi_clock_get_rate(CLOCK_ID_ARM));
		printk("got a freq for ahb     = %lu\n", mobi_clock_get_rate(CLOCK_ID_AHB));
		printk("got a freq for apb     = %lu\n", mobi_clock_get_rate(CLOCK_ID_APB));
		printk("===========================================\n");
	}
	else {
		printk("Updated clock rate for clock %d: %lu\n",
				clk_id, mobi_clock_get_rate(clk_id));
	}
	printk("\n");
}

void clk_test(void)
{
	printk("\ndriver_test:  running clk_internal_test\n");
	clk_internal_test();
	printk("\ndriver_test:  running clk_api_test for PLL0 & ARM\n");
	clk_api_test(CLOCK_ID_PLL0, 2160000000, 1);
	clk_api_test(CLOCK_ID_ARM,  240000000, 1);
	clk_internal_test();
	printk("\n");
	printk("\ndriver_test:  running clk_api_test for TIMER\n");
	clk_api_test(CLOCK_ID_TIMER, 12000000, 1);
	printk("\ndriver_test:  running clk_api_test for QMM\n");
	clk_api_test(CLOCK_ID_QMM, 180000000, 1);
}


/*************************************************************************/
static void  __attribute__((unused)) qcc_api_test(void)
{
	int bid, addr, len;
	unsigned long data;
	int ret;

	bid = 8;
	addr = QCC_CHIPCTL_SOC_RESETVEC_SET;
	len = 4;
	ret = mobi_qcc_read(bid, addr, &data, len);
	printk("cmd: mobi_qcc_read(%d, 0x%x, <rdata>, %d)\n", bid, addr, len);
	printk("returned: %d\n", ret);
	if (ret >= 0)
		printk("qcc_read read 0x%lx(%lu)\n", data, data);
	else
		printk("qcc_read returned an error\n");

	bid = 8;
	addr = QCC_CHIPCTL_SOC_RESETVEC_SET;
	len = 2;
	ret = mobi_qcc_read(bid, addr, &data, len);
	printk("cmd: mobi_qcc_read(%d, 0x%x, <rdata>, %d)\n", bid, addr, len);
	printk("returned: %d\n", ret);
	if (ret >= 0)
		printk("qcc_read read 0x%lx(%lu)\n", data, data);
	else
		printk("qcc_read returned an error\n");


	bid = 8;
	addr = QCC_CHIPCTL_SOC_RESETVEC_SET;
	len = 1;
	ret = mobi_qcc_read(bid, addr, &data, len);
	printk("cmd: mobi_qcc_read(%d, 0x%x, <rdata>, %d)\n", bid, addr, len);
	printk("returned: %d\n", ret);
	if (ret >= 0)
		printk("qcc_read read 0x%lx(%lu)\n", data, data);
	else
		printk("qcc_read returned an error\n");


	/*
	   }
	   else {
	   ret = mobi_qcc_write(bid, addr, wdata, len);
	   printf("cmd: mobi_qcc_write(%d, 0x%x, 0x%x, %d)\n",
	   bid, addr, wdata, len);
	   if (ret >= 0)
	   printf("qcc_write success\n");
	   else
	   printf("qcc_read returned an error: %d\n", ret);

	 */
}

/************************************************************************/

void mobi_timers_tst(void);
void mobi_timers_fiq_tst(void);
//static struct work_struct timer_ws;
int timer_tick_count;
int timer_stop_tick_count;
static int timer_waitq_flag;
static DECLARE_WAIT_QUEUE_HEAD(timer_wq);
timer_handle th32;
timer_handle fiq_timer;

static int timers_proc_wr_run(struct file *file,
		const char *buffer, unsigned long count, void *data)
{
	char *ptr = (char *)buffer;
	int cmd = 0;

	timer_tick_count = 0;
	timer_stop_tick_count = 0;
	timer_waitq_flag = 0;

	if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
		timer_stop_tick_count = simple_strtoul(ptr, &ptr, 0);
		if(cmd < 0) {
			printk(KERN_ERR "Invalid debug command\n");
			return -1;
		}
	}
	else {
		printk("Invalid cmd string\n");
		return -1;
	}

	if (timer_stop_tick_count > 0) {
		printk("preparing to run timers_tst, count %d interrupts\n",
				timer_stop_tick_count);
		//schedule_work(&timer_ws);
		//mobi_timers_tst();
		mobi_timers_fiq_tst();
		//printk("mobi_timers_tst scheduled\n");
	}

	/* read everything we don't care about */
	while(ptr-buffer<count)
		ptr++;

	printk("mobi_timers_tst scheduled returning\n");
	return ptr - buffer;
}

static void __attribute__((unused)) timers_procfs(void)
{
	struct proc_dir_entry *pentryt;

	//	INIT_WORK(&timer_ws, (void(*)(void*))mobi_timers_tst, NULL);

	if (debug_proc_dir == NULL)
		debug_proc_dir = proc_mkdir("driver/debug", NULL);

	proc_mkdir("driver/debug/timers", NULL);
	pentryt = create_proc_entry("driver/debug/timers/run",
			S_IRUSR | S_IRGRP | S_IROTH, NULL);
	if (pentryt) {
		pentryt->write_proc = timers_proc_wr_run;
	}
}

/* callback for timer3 but get info for 64bit timer */
static void timer_callback(void)
{
	int ret = 0;
	struct mobi_timeval running;

	timer_tick_count++;

	ret = mobi_get_timer(th32, &running);

	if (ret >= 0)
		printk("driver_test: id: %d, running time is %ld hours, %ld min, %ld secs, %ld usec\n",
				th32, running.tv_hour, running.tv_min, running.tv_sec, running.tv_usec);
	else
		printk("driver_test: timer %d not running, retval %d\n", th32, ret);

	timer_waitq_flag = 1;
	wake_up_interruptible(&timer_wq);
}

void mobi_timers_tst()
{
	//struct mobi_timeval running;
	int ret;

	struct mobi_timeval tv2;

	th32 = mobi_request_timer((void *)timer_callback, TIMER_USE_FIQ);
	if (th32 < 0) {
		printk("Did not get timer handle\n");
		return;
	}
	else
		printk("Got timer handle of %d\n", th32);

	memset((void *)&tv2, 0x0, sizeof(struct mobi_timeval));
	//tv2.tv_min  = 1;
	tv2.tv_sec  = 3;

	printk("mobi_set_timer is about to be called\n");
	ret = mobi_set_timer(th32, tv2, 0x0);
	printk("mobi_set_timer has returned\n");
	if (ret) {
		printk("Failed set_timer: %d\n", ret);
		return;
	}

	while(1) {
		wait_event_interruptible(timer_wq, timer_waitq_flag != 0);
		timer_waitq_flag = 0;
		if (timer_tick_count >= timer_stop_tick_count)
			break;
	}

	printk("exited wait loop, shutting down\n");

	if (th32)
		ret = mobi_del_timer(th32);

	if (ret)
		printk("Error deleting timer: %d\n", ret);
	else
		printk("Timer deleted\n");
}

int fiq_counter;
uint8_t fiqStack[128];

static void fiq_handler(void)
{

#define FIQ_TIMER_EOI_ADDR \
	(TIMER4_BASE+TIMER_EOI)
	/* a simple inline asm handler to count the number of fiq we get */
	/* r8 contains the address of a variable(fiq_counter above), so we */
	/* also read timer4 EOI reg to clear the interrupt                */
	asm volatile (
			"mov	r9, %0\n\t"
			"ldr 	r9, [r9]\n\t"
			"ldr 	r9, [r8]\n\t"
			"add 	r9, r9, #1\n\t"
			"str 	r9, [r8]\n\t"
			"subs	pc, lr, #4" /* must do this to get back to svc mode */
			: : "r" IO_ADDRESS(FIQ_TIMER_EOI_ADDR));
}

void mobi_timers_fiq_tst()
{
	int ret;
	struct pt_regs fiq_regs;
	struct mobi_timeval tv2;

	printk("Requesting FIQ\n");
	ret = mobi_claim_fiq(MOBI_FIQ_TIMER);
	if (ret) {
		printk("Error requesting FIQ\n");
		return;
	}
	fiq_counter = 0;
	/* fill in the register in FIQ mode so we
	 * can access data correctly.  If the fiq_handler
	 * is a c function, better create some stack
	 * too because the compiler will create code to
	 * save register onto the stack when it enters
	 * the function and if sp doesn't point to
	 * valid memory, well....
	 */
	fiq_regs.ARM_r8 = (uint32_t)&fiq_counter;
	fiq_regs.ARM_sp = (long)fiqStack + sizeof(fiqStack) - 4;
	mobi_set_fiq_handler(fiq_handler, fiq_regs);
	mobi_enable_fiq();

	printk("Requesting FIQ timer\n");
	fiq_timer = mobi_request_timer(NULL, TIMER_USE_FIQ);
	if (fiq_timer < 0) {
		printk("Did not get timer handle\n");
		return;
	}
	else
		printk("Got timer handle of %d\n", fiq_timer);

	memset((void *)&tv2, 0x0, sizeof(struct mobi_timeval));
	tv2.tv_sec  = 5;

	ret = mobi_set_timer(fiq_timer, tv2, 0x0);
	if (ret) {
		printk("Failed set_timer: %d\n", ret);
		return;
	}

	printk("Requesting normal timer\n");
	th32 = mobi_request_timer((void *)timer_callback, 0x0);
	if (th32 < 0) {
		printk("Did not get timer handle\n");
		return;
	}
	else
		printk("Got timer handle of %d\n", th32);

	memset((void *)&tv2, 0x0, sizeof(struct mobi_timeval));
	tv2.tv_sec  = 2;

	ret = mobi_set_timer(th32, tv2, 0x0);
	if (ret) {
		printk("Failed set_timer: %d\n", ret);
		return;
	}

	while(1) {
		wait_event_interruptible(timer_wq, timer_waitq_flag != 0);
		timer_waitq_flag = 0;
		if (timer_tick_count >= timer_stop_tick_count)
			break;
	}
	printk("exited wait loop, shutting down\n");
	ret = mobi_del_timer(th32);
	if (ret)
		printk("Error deleting timer: %d\n", ret);
	else
		printk("Timer deleted\n");

	ret = mobi_del_timer(fiq_timer);
	if (ret)
		printk("Error deleting fiq_timer: %d\n", ret);
	else
		printk("FIQ Timer deleted\n");

	mobi_disable_fiq();
	mobi_release_fiq();
}

static int dma_waitq_flag = 0;
static DECLARE_WAIT_QUEUE_HEAD(dma_waitq);

void dma_handler(mobi_dma_handle dmah, mobi_dma_event dma_event, void *data)
{
	switch (dma_event) {
		case MOBI_DMA_EVENT_TRANSFER_COMPLETE:
			//printk("DMA_TEST: got a transfer complete event!\n");
			break;
		case MOBI_DMA_EVENT_TRANSFER_ERROR:
			printk("*** DMA_TEST ERROR: got a transfer error event! ***\n");
			break;
		default:
			printk("DMA_TEST got an unrecognized dma_event: 0x%x\n", dma_event);
			break;
	}
	dma_waitq_flag = dma_event;
	wake_up_interruptible(&dma_waitq);
}

static void __attribute__((unused)) dma_single_test(int size, int loops)
{
	mobi_dma_handle handle;
	char *src_buffer, *dst_buffer;
	int retval, n;
	dma_addr_t src_dma_addr, dst_dma_addr;
	int bytes_transfered, do_memcmp = 0;

	printk("DMA_SINGLE_TEST: buffer size %d, loops %d\n", size, loops);

	src_buffer = (char*) kmalloc(size, GFP_KERNEL);
	if (src_buffer == NULL) {
		printk("Can't get enough src memory\n");
		return;
	}
	memset(src_buffer, 0x0, size);
	printk("src_buffers: 0x%x\n", (uint32_t)src_buffer);

	dst_buffer = (char*) kmalloc(size, GFP_KERNEL);
	if (dst_buffer == NULL) {
		printk("Can't get enough dst memory\n");
		kfree(src_buffer);
		return;
	}
	memset(dst_buffer, 0x0, size);
	printk("dst_buffer : 0x%x\n", (uint32_t)dst_buffer);

	if ((handle = mobi_dma_request("single_test", MOBI_DMA_O_NONE)) < 0) {
		printk("Failed to get free dma channel\n");
		return;
	}

	if ((retval = mobi_dma_setup_handler(handle,
					(void *)dma_handler, NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32  |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32 |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_XFER,
					MOBI_DMA_CONFIG_DATA_WIDTH_8,
					NULL)))

		goto err;

	src_dma_addr = dma_map_single(NULL,
			src_buffer,
			size,
			DMA_TO_DEVICE);
	if (src_dma_addr <= 0) {
		printk("ack, no src dma address!\n");
		return;
	}

	dst_dma_addr = dma_map_single(NULL,
			dst_buffer,
			size,
			DMA_FROM_DEVICE);
	if (dst_dma_addr <= 0) {
		printk("ack, no dst dma address!\n");
		return;
	}

	for (n = 0;n <= loops; n++) {

		if (do_memcmp) {
			memset(src_buffer, 0xa, size);
			memset(dst_buffer, 0x0, size);
		}
		bytes_transfered = 0;
		if (mobi_dma_setup_single(handle,
					src_dma_addr,
					dst_dma_addr,
					size)) {
			printk("dma setup single failed\n");
			return;
		}

		if (mobi_dma_enable(handle) < 0) {
			printk("dma_enable failed\n");
			return;
		}

		wait_event_interruptible(dma_waitq, dma_waitq_flag != 0);
		if (dma_waitq_flag == MOBI_DMA_EVENT_TRANSFER_ERROR) {
			printk("DMA transfer error\n");
		}
		else {
			bytes_transfered = mobi_dma_get_bytes(handle);
			printk("DMA xfer_complete: status 0x%x, bytes transfered %d\n",
					mobi_dma_get_status(handle), bytes_transfered);
		}
		dma_waitq_flag = 0;

		if (bytes_transfered == size)
			printk("PASS:  correct number of bytes transfer\n");
		else
			printk("FAILED: size != bytes_transferr - %d != %d\n",
					size, bytes_transfered);

		if (do_memcmp) {
			if (memcmp(src_buffer, dst_buffer, size))
				printk("PASS: memory compare\n");
			else
				printk("FAIL: memory compare\n");
		}

		mobi_dma_disable(handle);
	}

	dma_unmap_single(NULL,
			src_dma_addr,
			size,
			DMA_TO_DEVICE);

	dma_unmap_single(NULL,
			dst_dma_addr,
			size,
			DMA_FROM_DEVICE);

	printk("DMA_SINGLE_TEST: completed...\n");

err:
	mobi_dma_free(handle);
	kfree(src_buffer);
	kfree(dst_buffer);

	return;
}

/* just has a preset number of subtest of different buffers sizes and alignments */
static __attribute__((unused))void dma_simple_list_test(int sub_test, int num_buffers)
{
	mobi_dma_handle handle = -1;
	char *src_buffer, *dst_buffer, *pr_buffer;
	int retval, i,j,k;
	dma_addr_t src_dma_addr, dst_dma_addr;
	struct mobi_dma_list *mlist = NULL, *mlist_head = NULL;
	int size, xfer_len = 0;
	uint32_t *free_list = NULL, *free_list_head = NULL;
	int32_t show_src_buff = 0, show_dst_buff = 0, show_both_buffs = 0;
	int bytes_transfered = 0, do_memcmp = 0;
	int size1, size2, printonce = 0;

	printk("DMA_SMPLE_LIST: num_buffers %d, sub_test number %d\n",
			num_buffers, sub_test);

	free_list = kmalloc(2*num_buffers*sizeof(uint32_t*), GFP_KERNEL);
	if (free_list == NULL)  {
		printk("can't get enough mem for free_list\n");
		return;
	}
	free_list_head = free_list;
	memset(free_list, 0x0, 2*num_buffers);

	mlist = kmalloc(num_buffers*sizeof(struct mobi_dma_list), GFP_KERNEL);
	if (mlist == NULL)  {
		printk("can't get enough mem for mlist\n");
		goto err;
	}
	mlist_head = mlist;
	memset(mlist, 0x0, num_buffers*sizeof(struct mobi_dma_list));

	if ((handle = mobi_dma_request("dmatst", MOBI_DMA_O_NONE)) < 0) {
		goto err;
	}

	if ((retval = mobi_dma_setup_handler(handle, (void *)dma_handler, NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32  |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32 |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_XFER,
					MOBI_DMA_CONFIG_DATA_WIDTH_8,
					NULL)))
		goto err;

	printk("DMA_SIMPLE_LIST: max_blk_size = %d\n",
			mobi_dma_get_max_blk_size(handle));
	for (i=0,k=0;i<num_buffers;i++, k+=2) {

		if (sub_test == 1) {
			/* multi-node mobi_list with size aligned members */
			/* lli list entries == 2*num_buffers		  */
			size1 = 1024;
			size2 = 16368;
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);
		}
		else if (sub_test == 2) {
			/* multi-node mobi_list with unaligned members */
			/* lli list entries == 2*num_buffers + num_buffer*3 byte dmas  */
			size1 = 67;
			size2 = 16368;
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);

		}
		else if (sub_test == 3) {
			/* multi-node mobi_list with one unaligned member */
			/* and one greater than max */
			size1 = 67;
			size2 = 16368 + 1024;
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);

		}
		else if (sub_test == 4) {
			/* multi-node mobi_list with all unaligned members */
			size1 = 67;
			size2 = 1027;
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);

		}
		else if (sub_test == 5) {
			/* multi-node, aligned size greater than max */
			size = 16368 + 1024; //17404;
			
			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size %d\n", size);

		}
		else if (sub_test == 6) {
			/* multi-node, unaligned size greater than max */
			size = 16380 + 1026; //17406;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size %d\n", size);
		}
		else if (sub_test == 7) {
			/* multi-node, all unaligned size */
			size = 55;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size %d\n", size);
		}
		else if (sub_test == 8) {
			/* multi-node mobi_list with all unaligned members */
			size1 = 4096;
			size2 = 16368 + 1024; //17404;
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);

		}
		else if (sub_test == 9) {
			/* multi-node, all unaligned size */
			size = 67;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size %d\n", size);
		}

		/* other test that just use a small aligned buffer */
		else {
			size = 4*1024;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size %d\n", size);
		}

		/* total size */
		xfer_len += size;

		src_buffer = (char*) kmalloc(size, GFP_KERNEL);
		if (src_buffer == NULL) {
			printk("Can't get enough src memory\n");
			goto err;
		}
		*free_list = (uint32_t) src_buffer;
		free_list++;

		if (do_memcmp)
			memset(src_buffer, 0xa, size);
		else
			memset(src_buffer, 0x0, size);

		dst_buffer = (char*) kmalloc(size, GFP_KERNEL);
		if (dst_buffer == NULL) {
			printk("Can't get enough dst memory\n");
			goto err;
		}
		*free_list = (uint32_t) dst_buffer;
		free_list++;
		memset(dst_buffer, 0x0, size);

		for (j=0;j<size;j++)
			*(src_buffer+j) = (char)(j & 0xff);

		src_dma_addr = dma_map_single(NULL,
				src_buffer,
				size,
				DMA_TO_DEVICE);

		if (src_dma_addr <= 0) {
			printk("ack, no src dma address!\n");
			goto err;
		}

		dst_dma_addr = dma_map_single(NULL,
				dst_buffer,
				size,
				DMA_FROM_DEVICE);
		if (dst_dma_addr <= 0) {
			printk("ack, no dst dma address!\n");
			goto err;
		}

		(&mlist[i])->src_addr 	= src_dma_addr;
		(&mlist[i])->dst_addr 	= dst_dma_addr;
		(&mlist[i])->size     	= size;
		(&mlist[i])->xfer_flags	= MOBI_DMA_LIST_FLAG_NONE;
		(&mlist[i])->src_flags  = MOBI_DMA_LIST_FLAG_NONE;
		(&mlist[i])->dst_flags  = MOBI_DMA_LIST_FLAG_NONE;

		if (i == num_buffers-1)
			(&mlist[i])->next = NULL;
		else
			(&mlist[i])->next = &mlist[i+1];
	}

	printk("DMA_SIMPLE_LIST: xfer_len %d\n", xfer_len);
	if (mobi_dma_setup_mlist(handle,
				mlist,
				num_buffers,
				xfer_len)) {
		printk("dma setup mlist failed\n");
		goto err;
	}

	if (mobi_dma_enable(handle) < 0) {
		printk("dma_enable failed\n");
		goto err;
	}

	wait_event_interruptible(dma_waitq, dma_waitq_flag != 0);

	if (dma_waitq_flag == MOBI_DMA_EVENT_TRANSFER_ERROR) {
		printk("DMA transfer error\n");
	}
	else {
		bytes_transfered = mobi_dma_get_bytes(handle);
		printk("DMA_SIMPLE_LIST: xfer_complete: status 0x%x, bytes transfered %d\n",
				mobi_dma_get_status(handle), bytes_transfered);
	}
	dma_waitq_flag = 0;

	if (bytes_transfered == xfer_len)
		printk("PASS:  correct number of bytes transfered\n");
	else
		printk("FAILED: size != bytes_transfered - %d != %d\n",
				xfer_len, bytes_transfered);

	if (do_memcmp) {
		if (free_list_head != NULL) {
			free_list = free_list_head;
			mlist = mlist_head;
			for (i=0, j=0;i<2*num_buffers;i += 2, j++)  {

				/* src is even, dst is odd, size we have to get from dma list */
				if (memcmp((void*)*(free_list), (void*)*(free_list+1), (&mlist[j])->size))
					printk("PASS: memory compare\n");
				else
					printk("FAIL: memory compare\n");

				free_list += 2;
				mlist += 2;
			}
		}
	}

	for (i=0;i<num_buffers;i++) {
		dma_unmap_single(NULL,
				(&mlist[i])->src_addr,
				(&mlist[i])->size,
				DMA_TO_DEVICE);

		dma_unmap_single(NULL,
				(&mlist[i])->dst_addr,
				(&mlist[i])->size,
				DMA_FROM_DEVICE);
	}

	if (show_both_buffs) {
		/* show_both_buffs is # of src & dst pairs, like 4 would print 8 bufs */
		show_both_buffs *= 2;
		for (i=0;i<show_both_buffs;i+=2) {

			pr_buffer = (char*) *(free_list_head+i);
			printk("\nDMA_WRITE_LIST: first 16 words of src buffer %d:\n", i);
			for (j=0;j<16;j++) {
				printk("word %d: 0x%x\n", j, *(uint32_t*)(pr_buffer+(j*4)));
			}
			// should be the address of the first dst buffer
			pr_buffer = (char*) *(free_list_head+1+i);
			printk("\nDMA_WRITE_LIST: first 16 words of dst buffer %d:\n", i);
			for (j=0;j<16;j++) {
				printk("word %d: 0x%x\n", j, *(uint32_t*)(pr_buffer+(j*4)));
			}
		}
	}

	if (show_src_buff) {
		pr_buffer = (char*) *(free_list_head+((2*show_src_buff)-2));
		printk("\nDMA_WRITE_LIST: first 16 words of src buffer %d:\n", show_src_buff);
		for (i=0;i<16;i++) {
			printk("word %d: 0x%x\n", i, *(uint32_t*)(pr_buffer+(i*4)));
		}
	}
	if (show_dst_buff) {
		// should be the address of the first dst buffer
		pr_buffer = (char*) *(free_list_head+((2*show_dst_buff)-1));
		printk("\nDMA_WRITE_LIST: first 16 words of dst buffer %d:\n", show_dst_buff);
		for (i=0;i<16;i++) {
			printk("word %d: 0x%x\n", i, *(uint32_t*)(pr_buffer+(i*4)));
		}
	}

err:
	mobi_dma_disable(handle);
	mobi_dma_free(handle);

	udelay(500);
	if (free_list_head != NULL) {
		free_list = free_list_head;
		for (i=0;i<2*num_buffers;i++)  {
			if ((char*)*(free_list) != NULL) {
				kfree((char*)*(free_list));
				free_list++;
			}
		}
	}

	if (free_list_head != NULL) {
		kfree(free_list_head);
	}
	if (mlist_head != NULL) {
		kfree(mlist_head);
	}

	return;
}

static __attribute__((unused))
void dma_custom_list_test(int sub_test, int num_buffers, int size1, int size2)
{
	mobi_dma_handle handle = -1;
	char *src_buffer, *dst_buffer;
	int retval, i,j,k;
	dma_addr_t src_dma_addr, dst_dma_addr;
	struct mobi_dma_list *mlist = NULL, *mlist_head = NULL;
	int size, xfer_len = 0;
	uint32_t *free_list = NULL, *free_list_head = NULL;
	int bytes_transfered = 0, do_memcmp = 0;
	int printonce = 0;

	printk("DMA_SMPLE_LIST: num_buffers %d, sub_test number %d\n",
			num_buffers, sub_test);

	free_list = kmalloc(2*num_buffers*sizeof(uint32_t*), GFP_KERNEL);
	if (free_list == NULL)  {
		printk("can't get enough mem for free_list\n");
		return;
	}
	free_list_head = free_list;
	memset(free_list, 0x0, 2*num_buffers);

	mlist = kmalloc(num_buffers*sizeof(struct mobi_dma_list), GFP_KERNEL);
	if (mlist == NULL)  {
		printk("can't get enough mem for mlist\n");
		goto err;
	}
	mlist_head = mlist;
	memset(mlist, 0x0, num_buffers*sizeof(struct mobi_dma_list));

	if ((handle = mobi_dma_request("dmatst", MOBI_DMA_O_NONE)) < 0) {
		goto err;
	}

	if ((retval = mobi_dma_setup_handler(handle, (void *)dma_handler, NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32  |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32 |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_XFER,
					MOBI_DMA_CONFIG_DATA_WIDTH_8,
					NULL)))
		goto err;

	printk("DMA_SIMPLE_LIST: max_blk_size = %d\n",
			mobi_dma_get_max_blk_size(handle));
	for (i=0,k=0;i<num_buffers;i++, k+=2) {

		if (sub_test == 1) {
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);
		}
		else if (sub_test == 2) {
			if (i%2)
				size = size1;
			else
				size = size2;

			if (!printonce++)
				printk("DMA_SIMPLE_LIST: size1 %d, size2 %d\n", size1, size2);

		}
		else {
			size = 1024;
			if (!printonce++)
				printk("DMA_SIMPLE_LIST: unknown subtest using default size %d\n", size);
		}

		/* total size */
		xfer_len += size;

		src_buffer = (char*) kmalloc(size, GFP_KERNEL);
		if (src_buffer == NULL) {
			printk("Can't get enough src memory\n");
			goto err;
		}
		*free_list = (uint32_t) src_buffer;
		free_list++;

		if (do_memcmp)
			memset(src_buffer, 0xa, size);
		else
			memset(src_buffer, 0x0, size);

		dst_buffer = (char*) kmalloc(size, GFP_KERNEL);
		if (dst_buffer == NULL) {
			printk("Can't get enough dst memory\n");
			goto err;
		}
		*free_list = (uint32_t) dst_buffer;
		free_list++;
		memset(dst_buffer, 0x0, size);

		for (j=0;j<size;j++)
			*(src_buffer+j) = (char)(j & 0xff);

		src_dma_addr = dma_map_single(NULL,
				src_buffer,
				size,
				DMA_TO_DEVICE);

		if (src_dma_addr <= 0) {
			printk("ack, no src dma address!\n");
			goto err;
		}

		dst_dma_addr = dma_map_single(NULL,
				dst_buffer,
				size,
				DMA_FROM_DEVICE);
		if (dst_dma_addr <= 0) {
			printk("ack, no dst dma address!\n");
			goto err;
		}

		(&mlist[i])->src_addr 	= src_dma_addr;
		(&mlist[i])->dst_addr 	= dst_dma_addr;
		(&mlist[i])->size     	= size;
		(&mlist[i])->xfer_flags	= MOBI_DMA_LIST_FLAG_NONE;
		(&mlist[i])->src_flags  = MOBI_DMA_LIST_FLAG_NONE;
		(&mlist[i])->dst_flags  = MOBI_DMA_LIST_FLAG_NONE;

		if (i == num_buffers-1)
			(&mlist[i])->next = NULL;
		else
			(&mlist[i])->next = &mlist[i+1];
	}

	printk("DMA_SIMPLE_LIST: xfer_len %d\n", xfer_len);
	if (mobi_dma_setup_mlist(handle,
				mlist,
				num_buffers,
				xfer_len)) {
		printk("dma setup mlist failed\n");
		goto err;
	}

	if (mobi_dma_enable(handle) < 0) {
		printk("dma_enable failed\n");
		goto err;
	}

	wait_event_interruptible(dma_waitq, dma_waitq_flag != 0);
	if (dma_waitq_flag == MOBI_DMA_EVENT_TRANSFER_ERROR) {
		printk("DMA transfer error\n");
	}
	else {
		bytes_transfered = mobi_dma_get_bytes(handle);
		printk("DMA_SIMPLE_LIST: xfer_complete: status 0x%x, bytes transfered %d\n",
				mobi_dma_get_status(handle), bytes_transfered);
	}
	dma_waitq_flag = 0;

	if (bytes_transfered == xfer_len)
		printk("PASS:  correct number of bytes transfered\n");
	else
		printk("FAILED: size != bytes_transfered - %d != %d\n",
				xfer_len, bytes_transfered);

	if (do_memcmp) {
		if (free_list_head != NULL) {
			free_list = free_list_head;
			mlist = mlist_head;
			for (i=0, j=0;i<2*num_buffers;i += 2, j++)  {

				/* src is even, dst is odd, size we have to get from dma list */
				if (memcmp((void*)*(free_list), (void*)*(free_list+1), (&mlist[j])->size))
					printk("PASS: memory compare\n");
				else
					printk("FAIL: memory compare\n");

				free_list += 2;
				mlist += 2;
			}
		}
	}

	for (i=0;i<num_buffers;i++) {
		dma_unmap_single(NULL,
				(&mlist[i])->src_addr,
				(&mlist[i])->size,
				DMA_TO_DEVICE);

		dma_unmap_single(NULL,
				(&mlist[i])->dst_addr,
				(&mlist[i])->size,
				DMA_FROM_DEVICE);
	}

err:
	mobi_dma_disable(handle);
	mobi_dma_free(handle);

	udelay(500);
	if (free_list_head != NULL) {
		free_list = free_list_head;
		for (i=0;i<2*num_buffers;i++)  {
			if ((char*)*(free_list) != NULL) {
				kfree((char*)*(free_list));
				free_list++;
			}
		}
	}

	if (free_list_head != NULL) {
		kfree(free_list_head);
	}
	if (mlist_head != NULL) {
		kfree(mlist_head);
	}

	return;
}

static __attribute__((unused))
void dma_complex_list_test(int sub_test, int num_buffers)
{
	mobi_dma_handle handle = -1;
	char *src_buffer, *dst_buffer, *pr_buffer;
	int retval, i,j,k;
	dma_addr_t src_dma_addr, dst_dma_addr;
	struct mobi_dma_list *mlist = NULL, *mlist_head = NULL;
	int size, xfer_len = 0;
	uint32_t *free_list = NULL, *free_list_head = NULL;
	struct sg_params sgparams;
	int32_t show_src_buff = 0, show_dst_buff = 0, show_both_buffs = 0;

	printk("DMA_LIST_TEST: num_buffers %d, test number %d\n",
			num_buffers, sub_test);

	free_list = kmalloc(2*num_buffers*sizeof(uint32_t*), GFP_KERNEL);
	if (free_list == NULL)  {
		printk("can't get enough mem for free_list\n");
		return;
	}
	free_list_head = free_list;
	memset(free_list, 0x0, 2*num_buffers);

	mlist = kmalloc(num_buffers*sizeof(struct mobi_dma_list), GFP_KERNEL);
	if (mlist == NULL)  {
		printk("can't get enough mem for mlist\n");
		goto err;
	}
	mlist_head = mlist;
	memset(mlist, 0x0, num_buffers*sizeof(struct mobi_dma_list));

	if ((handle = mobi_dma_request("dmatst", MOBI_DMA_O_NONE)) < 0) {
		goto err;
	}

	if ((retval = mobi_dma_setup_handler(handle, (void *)dma_handler, NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32  |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32 |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_XFER,
					MOBI_DMA_CONFIG_DATA_WIDTH_8,
					NULL)))
		goto err;

	for (i=0,k=0;i<num_buffers;i++, k+=2) {

		if (sub_test == 1) {
			/* multi-node mobi_list with size aligned members */
			/* lli list entries == 2*num_buffers		  */
			if (i%2)
				size = 1024;
			else
				size = 16368;
		}
		else if (sub_test == 2) {
			/* multi-node mobi_list with unaligned members */
			/* lli list entries == 2*num_buffers + num_buffer*3 byte dmas  */
			if (i%2)
				size = 67;
			else
				size = 16368;
		}
		else if (sub_test == 3) {
			/* multi-node mobi_list with one unaligned member */
			/* and one greater than max */
			if (i%2)
				size = 67;
			else
				size = 16368 + 1024;
		}
		else if (sub_test == 4) {
			/* multi-node mobi_list with all unaligned members */
			if (i%2)
				size = 67;
			else
				size = 1027;
		}
		else if (sub_test == 5) {
			/* multi-node, aligned size greater than max */
			size = 16368 + 1024; //17404;
		}
		else if (sub_test == 6) {
			/* multi-node, unaligned size greater than max */
			size = 16380 + 1026; //17406;
		}
		else if (sub_test == 7) {
			/* multi-node, all unaligned size */
			size = 55;
		}
		/* other test that just use a small aligned buffer */
		else {
			size = 4*1024;
		}

		xfer_len += size;

		src_buffer = (char*) kmalloc(size, GFP_KERNEL);
		if (src_buffer == NULL) {
			printk("Can't get enough src memory\n");
			goto err;
		}
		*free_list = (uint32_t) src_buffer;
		free_list++;

		memset(src_buffer, 0x0, size);
		dst_buffer = (char*) kmalloc(size, GFP_KERNEL);
		if (dst_buffer == NULL) {
			printk("Can't get enough dst memory\n");
			goto err;
		}
		*free_list = (uint32_t) dst_buffer;
		free_list++;

		memset(dst_buffer, 0x0, size);

		/* reverse node testing, just do the last buffer for simplicity */
		/* reverse with no s/g
		*  reverse with s/g params equal
		*  reverse with s/g params differ
		 */
		if (sub_test >=  15 && sub_test <= 20  && i == num_buffers-1) {
			/* reverse so have to put some data in dst */
			printk("setting reverse flag\n");
			for (j=0;j<size;j++)
				*(dst_buffer+j) = (char)(j & 0xff);

			src_dma_addr = dma_map_single(NULL,
					src_buffer,
					size,
					DMA_FROM_DEVICE);
			if (src_dma_addr <= 0) {
				printk("ack, no src dma address!\n");
				goto err;
			}

			dst_dma_addr = dma_map_single(NULL,
					dst_buffer,
					size,
					DMA_TO_DEVICE);
			if (dst_dma_addr <= 0) {
				printk("ack, no dst dma address!\n");
				goto err;
			}

			(&mlist[i])->src_addr = src_dma_addr;
			(&mlist[i])->dst_addr = dst_dma_addr;
			(&mlist[i])->size     = size;
			(&mlist[i])->xfer_flags    = MOBI_DMA_LIST_XFER_FLAG_REVERSE_DIR;
			(&mlist[i])->src_flags     = MOBI_DMA_LIST_FLAG_NONE;
			(&mlist[i])->dst_flags     = MOBI_DMA_LIST_FLAG_NONE;

		}
		else {
			for (j=0;j<size;j++)
				*(src_buffer+j) = (char)(j & 0xff);

			src_dma_addr = dma_map_single(NULL,
					src_buffer,
					size,
					DMA_TO_DEVICE);

			if (src_dma_addr <= 0) {
				printk("ack, no src dma address!\n");
				goto err;
			}

			dst_dma_addr = dma_map_single(NULL,
					dst_buffer,
					size,
					DMA_FROM_DEVICE);
			if (dst_dma_addr <= 0) {
				printk("ack, no dst dma address!\n");
				goto err;
			}

			(&mlist[i])->src_addr = src_dma_addr;
			(&mlist[i])->dst_addr = dst_dma_addr;
			(&mlist[i])->size     = size;
			(&mlist[i])->xfer_flags    = MOBI_DMA_LIST_FLAG_NONE;
			(&mlist[i])->src_flags     = MOBI_DMA_LIST_FLAG_NONE;
			(&mlist[i])->dst_flags     = MOBI_DMA_LIST_FLAG_NONE;

			/* s/g feature testing
			*  	  - modifies list entry 0 to use s/g to dst
			*  test 8:
			*     - scatter, contig source, dis-contig dst
			*     	- should see zeros every 2 words
			*  	  - transfer size less than max block size
			*  	  - s/g block size is 2 words(< max block size)
			*  	  - s/g interval is 2 words
			*  test 9:
			*     - gather, dis-contig src, contig dst
			*     	- should see two missing words every 2 words
			*     	  in dst
			*  	  - transfer size less than max block size
			*  	  - s/g block size is 2 words(< max block size)
			*  	  - s/g interval is 2 words
			*  test 10:
			*  	  - scatter in block 0, gather in block 1
			*
			*/
			if ((sub_test >= 8 && sub_test <= 15)) {
				switch (sub_test) {
					case 8: /* scatter, contig source, spaced dst */
						if (i == 0) {
							(&mlist[i])->dst_flags  = MOBI_DMA_LIST_NODE_FLAG_SG_ENABLE;
							/* either twice as much memory, or half as much data */
							(&mlist[i])->size        = size>>1;

							sgparams.count = 2;
							sgparams.interval = 2;
							if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
											MOBI_DMA_CONFIG_SG_ENABLE,
											&sgparams))) {

								printk("failed to set SG_ENABLE dst flag\n");
								goto err;
							}
							show_both_buffs=2;
						}
						break;
					case 9: /* gather, spaced src, contig dst */
						if (i == 0) {
							(&mlist[i])->src_flags  = MOBI_DMA_LIST_NODE_FLAG_SG_ENABLE;
							/* either twice as much memory, or half as much data */
							(&mlist[i])->size        = size>>1;

							sgparams.count = 2;
							sgparams.interval = 2;
							if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
											MOBI_DMA_CONFIG_SG_ENABLE,
											&sgparams))) {

								printk("failed to set SG_ENABLE src flag\n");
								goto err;
							}
							show_both_buffs=2;
						}
						break;
					case 10:
						/* now try both in the same list */
						if (i == 0) {
							/* test, should fail so don't worry about mapping */
							//(&mlist[i])->xfer_flags = MOBI_DMA_LIST_XFER_FLAG_REVERSE_DIR;
							(&mlist[i])->dst_flags  = MOBI_DMA_LIST_NODE_FLAG_SG_ENABLE;
							/* either twice as much memory, or half as much data */
							(&mlist[i])->size        = size>>1;

							sgparams.count = 1;
							sgparams.interval = 1;
							if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
											MOBI_DMA_CONFIG_SG_ENABLE,
											&sgparams))) {

								printk("failed to set SG_ENABLE dst flag\n");
								goto err;
							}
						} else if (i == 1) {
							(&mlist[i])->src_flags  = MOBI_DMA_LIST_NODE_FLAG_SG_ENABLE;
							/* either twice as much memory, or half as much data */
							(&mlist[i])->size        = size>>1;

							sgparams.count = 2;
							sgparams.interval = 2;
							if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
											MOBI_DMA_CONFIG_SG_ENABLE,
											&sgparams))) {

								printk("failed to set SG_ENABLE src flag\n");
								goto err;
							}
						}
						show_both_buffs=2;
						break;
					default:
						break;
				}
			}
			else {
				(&mlist[i])->dst_flags     = MOBI_DMA_LIST_FLAG_NONE;
			}
		}

		if (i == num_buffers-1)
			(&mlist[i])->next = NULL;
		else
			(&mlist[i])->next = &mlist[i+1];
	}

	printk("DMA_LIST_TEST: xfer_len %d\n", xfer_len);
	if (mobi_dma_setup_mlist(handle,
				mlist,
				num_buffers,
				xfer_len)) {
		printk("dma setup mlist failed\n");
		goto err;
	}

	if (mobi_dma_enable(handle) < 0) {
		printk("dma_enable failed\n");
		goto err;
	}

	wait_event_interruptible(dma_waitq, dma_waitq_flag != 0);
	dma_waitq_flag = 0;

	for (i=0;i<num_buffers;i++) {
		dma_unmap_single(NULL,
				(&mlist[i])->src_addr,
				(&mlist[i])->size,
				DMA_TO_DEVICE);

		dma_unmap_single(NULL,
				(&mlist[i])->dst_addr,
				(&mlist[i])->size,
				DMA_FROM_DEVICE);
	}

	if (show_both_buffs) {
		/* show_both_buffs is # of src & dst pairs, like 4 would print 8 bufs */
		show_both_buffs *= 2;
		for (i=0;i<show_both_buffs;i+=2) {

			pr_buffer = (char*) *(free_list_head+i);
			printk("\nDMA_WRITE_LIST: first 16 words of src buffer %d:\n", i);
			for (j=0;j<16;j++) {
				printk("word %d: 0x%x\n", j, *(uint32_t*)(pr_buffer+(j*4)));
			}
			// should be the address of the first dst buffer
			pr_buffer = (char*) *(free_list_head+1+i);
			printk("\nDMA_WRITE_LIST: first 16 words of dst buffer %d:\n", i);
			for (j=0;j<16;j++) {
				printk("word %d: 0x%x\n", j, *(uint32_t*)(pr_buffer+(j*4)));
			}
		}
	}

	if (show_src_buff) {
		pr_buffer = (char*) *(free_list_head+((2*show_src_buff)-2));
		printk("\nDMA_WRITE_LIST: first 16 words of src buffer %d:\n", show_src_buff);
		for (i=0;i<16;i++) {
			printk("word %d: 0x%x\n", i, *(uint32_t*)(pr_buffer+(i*4)));
		}
	}
	if (show_dst_buff) {
		// should be the address of the first dst buffer
		pr_buffer = (char*) *(free_list_head+((2*show_dst_buff)-1));
		printk("\nDMA_WRITE_LIST: first 16 words of dst buffer %d:\n", show_dst_buff);
		for (i=0;i<16;i++) {
			printk("word %d: 0x%x\n", i, *(uint32_t*)(pr_buffer+(i*4)));
		}
	}

err:
	mobi_dma_disable(handle);
	mobi_dma_free(handle);

	printk("\nDMA_WRITE_LIST: test complete, freeing memory\n");

	udelay(500);
	if (free_list_head != NULL) {
		free_list = free_list_head;
		for (i=0;i<2*num_buffers;i++)  {
			if ((char*)*(free_list) != NULL) {
				kfree((char*)*(free_list));
				free_list++;
			}
		}
	}

	if (free_list_head != NULL) {
		kfree(free_list_head);
	}
	if (mlist_head != NULL) {
		kfree(mlist_head);
	}

	return;
}


static void __attribute__((unused)) dma_list_loop(int num_buffers, int loops)
{

	mobi_dma_handle handle = -1;
	char *src_buffer = NULL, *dst_buffer = NULL;
	int retval, i,k;
	dma_addr_t src_dma_addr = 0, dst_dma_addr = 0;
	struct mobi_dma_list *mlist = NULL, *mlist_head = NULL;
	int size, xfer_len = 0;
	uint32_t *free_list = NULL, *free_list_head = NULL;
	int test = 1;

	printk("DMA_LIST_LOOP: num_buffers %d, loops %d\n",
			num_buffers, loops);

	free_list = kmalloc(2*num_buffers*sizeof(uint32_t*), GFP_KERNEL);
	if (free_list == NULL)  {
		printk("can't get enough mem for free_list\n");
		return;
	}
	free_list_head = free_list;
	memset(free_list, 0x0, 2*num_buffers);

	mlist = kmalloc(num_buffers*sizeof(struct mobi_dma_list), GFP_KERNEL);
	if (mlist == NULL)  {
		printk("can't get enough mem for mlist\n");
		goto err;
	}
	mlist_head = mlist;

	if ((handle = mobi_dma_request("dmatst", MOBI_DMA_O_NONE)) < 0) {
		goto err;
	}

	if ((retval = mobi_dma_setup_handler(handle, (void *)dma_handler, NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32  |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32 |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_XFER,
					MOBI_DMA_CONFIG_DATA_WIDTH_8,
					NULL)))
		goto err;

	for (k=0; k < loops; k++) {

		/* clear dma list top of every loop */
		memset(mlist, 0x0, num_buffers*sizeof(struct mobi_dma_list));
		printk("\nDMA_LIST_LOOP: loop %d running test %d with %d buffers\n",
				k, test, num_buffers);
		xfer_len = 0;
		for (i=0;i<num_buffers;i++) {

			if (test == 1) {
				/* multi-node mobi_list with size aligned members */
				/* lli list entries == 2*num_buffers		  */
				/*
				if (i%2)
					size = 1024;
				else
					size = 16368;
				*/
				size = 16368;
			}
			else if (test == 2) {
				/* multi-node mobi_list with unaligned members */
				/* lli list entries == 2*num_buffers + num_buffer*3 byte dmas  */
				if (i%2)
					size = 67;
				else
					size = 16368;
			}
			else if (test == 3) {
				/* multi-node mobi_list with one unaligned member */
				/* and one greater than max */
				if (i%2)
					size = 67;
				else
					size = 16368 + 1024;
			}
			else if (test == 4) {
				/* multi-node mobi_list with all unaligned members */
				if (i%2)
					size = 67;
				else
					size = 1027;
			}
			else if (test == 5) {
				/* multi-node, aligned size greater than max */
				size = 16368 + 1024; //17404;
			}
			else if (test == 6) {
				/* multi-node, unaligned size greater than max */
				size = 16380 + 1026; //17406;
			}
			else if (test == 7) {
				/* multi-node, all unaligned size */
				size = 55;
			}
			/* other test that just use a small aligned buffer */
			else {
				size = 4*1024;
			}
			xfer_len += size;

			if (test == 1 && src_buffer == NULL) {
				src_buffer = (char*) kmalloc(size, GFP_KERNEL);
				if (src_buffer == NULL) {
					printk("Can't get enough src memory\n");
					goto err;
				}
				*free_list = (uint32_t) src_buffer;
				free_list++;

				memset(src_buffer, 0x0, size);
				dst_buffer = (char*) kmalloc(size, GFP_KERNEL);
				if (dst_buffer == NULL) {
					printk("Can't get enough dst memory\n");
					goto err;
				}
				*free_list = (uint32_t) dst_buffer;
				free_list++;

				memset(dst_buffer, 0x0, size);

				src_dma_addr = dma_map_single(NULL,
						src_buffer,
						size,
						DMA_TO_DEVICE);

				if (src_dma_addr <= 0) {
					printk("ack, no src dma address!\n");
					goto err;
				}

				dst_dma_addr = dma_map_single(NULL,
						dst_buffer,
						size,
						DMA_FROM_DEVICE);
				if (dst_dma_addr <= 0) {
					printk("ack, no dst dma address!\n");
					goto err;
				}
			}

			/* only fill the list for test on loop 1 */
			(&mlist[i])->src_addr = src_dma_addr;
			(&mlist[i])->dst_addr = dst_dma_addr;
			(&mlist[i])->size     = size;
			(&mlist[i])->xfer_flags    = MOBI_DMA_LIST_FLAG_NONE;
			(&mlist[i])->src_flags     = MOBI_DMA_LIST_FLAG_NONE;
			(&mlist[i])->dst_flags     = MOBI_DMA_LIST_FLAG_NONE;

			if (i == num_buffers-1)
				(&mlist[i])->next = NULL;
			else
				(&mlist[i])->next = &mlist[i+1];
			/*
			printk("DMA_LIST_LOOP: buffer %d, src_addr 0x%x, dst_addr 0x%x, size %d\n",
					i, src_dma_addr, dst_dma_addr, size);
			*/
		}

		printk("DMA_LIST_LOOP: total xfer_len %d\n", xfer_len);
		if (mobi_dma_setup_mlist(handle,
					mlist,
					num_buffers,
					xfer_len)) {
			printk("dma setup mlist failed\n");
			goto err;
		}

		if (mobi_dma_enable(handle) < 0) {
			printk("dma_enable failed\n");
			goto err;
		}

		wait_event_interruptible(dma_waitq, dma_waitq_flag != 0);
		dma_waitq_flag = 0;

		mobi_dma_disable(handle);
		printk("DMA_LIST_LOOP: loop %d test %d completed\n", k, test);

		for (i=0;i<num_buffers;i++) {
			dma_unmap_single(NULL,
					(&mlist[i])->src_addr,
					(&mlist[i])->size,
					DMA_TO_DEVICE);

			dma_unmap_single(NULL,
					(&mlist[i])->dst_addr,
					(&mlist[i])->size,
					DMA_FROM_DEVICE);
		}
		if (free_list_head != NULL) {
			free_list = free_list_head;
			for (i=0;i<2*num_buffers;i++)  {
				if ((char*)*(free_list) != NULL) {
					kfree((char*)*(free_list));
					free_list++;
				}
			}
			free_list = free_list_head;
			memset(free_list, 0x0, 2*num_buffers);
		}
		/* do various buffers sizes */
		/* or comment out to do a large list that re-uses the same
		*  src/dst buffer for all entries in the dma list
		*/
		/*
		if (test == 8)
			test = 1;
		else
			test++;
		*/
	}
	mobi_dma_free(handle);

	return;

err:
	mobi_dma_disable(handle);
	mobi_dma_free(handle);
	for (i=0;i<num_buffers;i++) {
		if ((&mlist[i])->src_addr != 0x0)
			dma_unmap_single(NULL,
					(&mlist[i])->src_addr,
					(&mlist[i])->size,
					DMA_TO_DEVICE);

		if ((&mlist[i])->dst_addr != 0x0)
			dma_unmap_single(NULL,
					(&mlist[i])->dst_addr,
					(&mlist[i])->size,
					DMA_FROM_DEVICE);
	}

	printk("\nDMA_LOOP_LIST: test complete, freeing memory\n");
	udelay(500);

	if (free_list_head != NULL) {
		free_list = free_list_head;
		for (i=0;i<2*num_buffers;i++)  {
			if ((char*)*(free_list) != NULL) {
				kfree((char*)*(free_list));
				free_list++;
			}
		}
	}

	if (free_list_head != NULL) {
		kfree(free_list_head);
	}
	if (mlist_head != NULL) {
		kfree(mlist_head);
	}

	return;
}

static void __attribute__((unused)) dma_big_list_loop(int num_buffers, int loops)
{

	mobi_dma_handle handle = -1;
	char *src_buffer = NULL, *dst_buffer = NULL;
	int retval, i,k;
	dma_addr_t src_dma_addr = 0, dst_dma_addr = 0;
	struct mobi_dma_list *mlist = NULL, *mlist_head = NULL;
	int size, xfer_len = 0;
	uint32_t *free_list = NULL, *free_list_head = NULL;

	printk("DMA_BIG_LIST_LOOP: num_buffers %d, loops %d\n",
			num_buffers, loops);

	free_list = kmalloc(2*num_buffers*sizeof(uint32_t*), GFP_KERNEL);
	if (free_list == NULL)  {
		printk("can't get enough mem for free_list\n");
		return;
	}
	free_list_head = free_list;
	memset(free_list, 0x0, 2*num_buffers);

	mlist = kmalloc(num_buffers*sizeof(struct mobi_dma_list), GFP_KERNEL);
	if (mlist == NULL)  {
		printk("can't get enough mem for mlist\n");
		goto err;
	}
	mlist_head = mlist;

	if ((handle = mobi_dma_request("one_big_loop", MOBI_DMA_O_NONE)) < 0) {
		goto err;
	}

	if ((retval = mobi_dma_setup_handler(handle, (void *)dma_handler, NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_SRC,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32  |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_DST,
					MOBI_DMA_CONFIG_TRANSFER_WIDTH_32 |
					MOBI_DMA_CONFIG_ADDRADJ_INC,
					NULL)))
		goto err;

	if ((retval = mobi_dma_config(handle, DMA_CONFIG_XFER,
					MOBI_DMA_CONFIG_DATA_WIDTH_8,
					NULL)))
		goto err;

	for (k=0; k < loops; k++) {

		/* clear dma list top of every loop */
		printk("\nDMA_BIG_LIST_LOOP: loop %d running %d buffers\n",
				k, num_buffers);

		if (k == 0) {
			memset(mlist, 0x0, num_buffers*sizeof(struct mobi_dma_list));
			xfer_len = 0;

			size = 16368;
			for (i=0;i<num_buffers;i++) {

				xfer_len += size;

				if (src_buffer == NULL) {
					src_buffer = (char*) kmalloc(size, GFP_KERNEL);
					if (src_buffer == NULL) {
						printk("Can't get enough src memory\n");
						goto err;
					}
					*free_list = (uint32_t) src_buffer;
					free_list++;

					memset(src_buffer, 0x0, size);
					dst_buffer = (char*) kmalloc(size, GFP_KERNEL);
					if (dst_buffer == NULL) {
						printk("Can't get enough dst memory\n");
						goto err;
					}
					*free_list = (uint32_t) dst_buffer;
					free_list++;

					memset(dst_buffer, 0x0, size);

					src_dma_addr = dma_map_single(NULL,
							src_buffer,
							size,
							DMA_TO_DEVICE);

					if (src_dma_addr <= 0) {
						printk("ack, no src dma address!\n");
						goto err;
					}

					dst_dma_addr = dma_map_single(NULL,
							dst_buffer,
							size,
							DMA_FROM_DEVICE);
					if (dst_dma_addr <= 0) {
						printk("ack, no dst dma address!\n");
						goto err;
					}
				}

				/* only fill the list for test on loop 1 */
				(&mlist[i])->src_addr = src_dma_addr;
				(&mlist[i])->dst_addr = dst_dma_addr;
				(&mlist[i])->size     = size;
				(&mlist[i])->xfer_flags    = MOBI_DMA_LIST_FLAG_NONE;
				(&mlist[i])->src_flags     = MOBI_DMA_LIST_FLAG_NONE;
				(&mlist[i])->dst_flags     = MOBI_DMA_LIST_FLAG_NONE;

				if (i == num_buffers-1)
					(&mlist[i])->next = NULL;
				else
					(&mlist[i])->next = &mlist[i+1];
			}
		}

		printk("DMA_BIG_LIST_LOOP: total xfer_len %d\n", xfer_len);
		if (mobi_dma_setup_mlist(handle,
					mlist,
					num_buffers,
					xfer_len)) {
			printk("dma setup mlist failed\n");
			goto err;
		}

		if (mobi_dma_enable(handle) < 0) {
			printk("dma_enable failed\n");
			goto err;
		}

		wait_event_interruptible(dma_waitq, dma_waitq_flag != 0);
		dma_waitq_flag = 0;

		mobi_dma_disable(handle);
		printk("DMA_BIG_LIST_LOOP: loop %d completed\n", k);
	}

err:
	mobi_dma_disable(handle);
	mobi_dma_free(handle);
	for (i=0;i<num_buffers;i++) {
		if ((&mlist[i])->src_addr != 0x0)
			dma_unmap_single(NULL,
					(&mlist[i])->src_addr,
					(&mlist[i])->size,
					DMA_TO_DEVICE);

		if ((&mlist[i])->dst_addr != 0x0)
			dma_unmap_single(NULL,
					(&mlist[i])->dst_addr,
					(&mlist[i])->size,
					DMA_FROM_DEVICE);
	}

	printk("\nDMA_LOOP_LIST: test complete, freeing memory\n");
	udelay(500);

	if (free_list_head != NULL) {
		free_list = free_list_head;
		for (i=0;i<2*num_buffers;i++)  {
			if ((char*)*(free_list) != NULL) {
				kfree((char*)*(free_list));
				free_list++;
			}
		}
	}

	if (free_list_head != NULL) {
		kfree(free_list_head);
	}
	if (mlist_head != NULL) {
		kfree(mlist_head);
	}

	return;
}

#define DMA_TEST_SINGLE			0x1
#define DMA_TEST_LIST_SIMPLE	0x2
#define DMA_TEST_LIST_COMPLEX 	0x3
#define DMA_TEST_LIST_LOOP		0x4
#define DMA_TEST_LIST_CUSTOM	0x5

static int dma_proc_wr_test(struct file *file,
		const char *buffer, unsigned long count, void *data)
{
	char *ptr = (char *)buffer;
	int dma_test = 0, arg1 = 0, arg2 = 0, arg3 = 0, arg4 = 0;

	if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
		dma_test = simple_strtoul(ptr, &ptr, 0);
		if (dma_test < 0) {
			printk(KERN_ERR "Invalid DMA test\n");
			return -1;
		}
	}
	else {
		printk("Must provide a DMA test number\n");
		return -1;
	}
	
	switch (dma_test) {
		case DMA_TEST_SINGLE:
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg1 = simple_strtoul(ptr, &ptr, 0);
				if (arg1 < 0) {
					printk("single: invalide buffer size\n");
					return -1;
				}
			}

			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg2 = simple_strtoul(ptr, &ptr, 0);
				if (arg2 < 0) {
					printk("single: invalide number of test loops\n");
					return -1;
				}
			}
			dma_single_test(arg1, arg2);
			break;

		case DMA_TEST_LIST_SIMPLE:
		case DMA_TEST_LIST_COMPLEX:
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg1 = simple_strtoul(ptr, &ptr, 0);
				if (arg1 < 0) {
					printk("list: Invalid DMA subtest\n");
					return -1;
				}
			}
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg2 = simple_strtoul(ptr, &ptr, 0);
				if (arg2 < 0) {
					printk("list: invalid number of buffers\n");
					return -1;
				}
			}
			if (dma_test ==  DMA_TEST_LIST_SIMPLE)
				dma_simple_list_test(arg1, arg2);
			else
				dma_complex_list_test(arg1, arg2);

			break;
		case DMA_TEST_LIST_CUSTOM:
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg1 = simple_strtoul(ptr, &ptr, 0);
				if (arg1 < 0) {
					printk("list: Invalid DMA subtest\n");
					return -1;
				}
			}
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg2 = simple_strtoul(ptr, &ptr, 0);
				if (arg2 < 0) {
					printk("list: invalid number of buffers\n");
					return -1;
				}
			}
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg3 = simple_strtoul(ptr, &ptr, 0);
				if (arg3 < 0) {
					printk("list: Invalid DMA subtest\n");
					return -1;
				}
			}
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg4 = simple_strtoul(ptr, &ptr, 0);
				if (arg4 < 0) {
					printk("list: invalid number of buffers\n");
					return -1;
				}
			}
			/* args are: subtest, num_buffers, buf_size1, buf_size2 */
			dma_custom_list_test(arg1, arg2, arg3, arg4);
			break;

		case DMA_TEST_LIST_LOOP:
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg1 = simple_strtoul(ptr, &ptr, 0);
				if (arg1 < 0) {
					printk("list_loop: invalid number of buffers\n");
					return -1;
				}
			}
			if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
				arg2 = simple_strtoul(ptr, &ptr, 0);
				if (arg2 < 0) {
					printk("list_loop: invalid number test loops\n");
					return -1;
				}
			}
			dma_list_loop(arg1, arg2);
			break;
		default:
			printk("Unrecognized DMA test\n");
			return -1;
	}

	/* read everything we don't care about */
	while(ptr-buffer<count)
		ptr++;

	return ptr - buffer;
}

static int dma_proc_wr_run(struct file *file,
		const char *buffer, unsigned long count, void *data)
{
	char *ptr = (char *)buffer;
	int size = 0, test_num = 0;

	if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
		size = simple_strtoul(ptr, &ptr, 0);
		if(size < 0) {
			printk(KERN_ERR "Invalid debug command\n");
			return -1;
		}
	}
	else {
		printk("Invalid cmd string\n");
		return -1;
	}
	if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
		test_num = simple_strtoul(ptr, &ptr, 0);
		if(size < 0) {
			printk(KERN_ERR "Invalid debug command\n");
			return -1;
		}
	}

#if 0
	/* XXX TODO */
	if (dma_test == 1) {
		dma_single_loop(size, loops);
	}
	else if (dma_test == 2) {
		/* in this case size is the number of buffers to use and
		*  loops is the test number to run */
		dma_write_list(size, loops);
	}
	else if (dma_test == 3) {
		/* size is the number of buffers to use, test loops N time
		*  over 9 different buffer size configs */
		dma_list_loop(size, loops);
	}
	else if (dma_test == 4) {
		/* one long list of fixed buffer size for N loops,
		*  src/dst buffers are the same for every entry in the
		*  dma list */
		dma_big_list_loop(size, loops);
	}
#endif
#if 0
	if (test_num == 0)  {
		printk("calling dma_write_test\n");
		dma_write_test(size);
	}
	else if (test_num <= 15) {
		printk("calling dma_write_list\n");
		dma_write_list(size, test_num);
	}
#else
	/* size of single buffer, test_num is number of loops to do */
	//dma_single_loop(size, test_num);
	/* size is # of buffers to transfer, test_num is number of loops to do */
	//dma_list_loop(size, test_num);
	dma_big_list_loop(size, test_num);
#endif

	/* read everything we don't care about */
	while(ptr-buffer<count)
		ptr++;

	return ptr - buffer;
}

static void dma_procfs(void)
{
	struct proc_dir_entry *pentryd;

	if (debug_proc_dir == NULL)
		debug_proc_dir = proc_mkdir("driver/debug", NULL);
	proc_mkdir("driver/debug/dma", NULL);
	pentryd = create_proc_entry("driver/debug/dma/run",
			S_IRUSR | S_IRGRP | S_IROTH, NULL);
	if (pentryd) {
		pentryd->write_proc = dma_proc_wr_run;
	}
	pentryd = create_proc_entry("driver/debug/dma/test",
			S_IRUSR | S_IRGRP | S_IROTH, NULL);
	if (pentryd) {
		pentryd->write_proc = dma_proc_wr_test;
	}
}


/***************************************************************************
*   fiq testing
*
*   1) first request the fiq
*   2) do something to trigger an intr on
*      one of the fiq devices
*   3) use the jtag to look at the fiq reg
*       - on chip, fiq vector is at 0xffff001c
*   4) disable the fiq
*
***************************************************************************/
static int __attribute__((unused)) fiq_proc_wr_run(struct file *file,
		const char *buffer, unsigned long count, void *data)
{
	char *ptr = (char *)buffer;
	uint32_t fiq;
	int ret;

	if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
		fiq = simple_strtoul(ptr, &ptr, 0);
		if(fiq < 0) {
			printk(KERN_ERR "Invalid debug command\n");
			return -1;
		}
	}
	else {
		printk("Invalid cmd string\n");
		return -1;
	}

	// send in greater than 7 to release
	if (fiq <= MOBI_FIQ_TIMER) {
		ret = mobi_claim_fiq(fiq);
		if (ret) {
			printk("Error request FIQ %d\n", fiq);
		}
		else {
			mobi_enable_fiq();
			printk("FIQ %d has been enabled\n", fiq);
		}
	}
	else {
		mobi_disable_fiq();
		mobi_release_fiq();
	}

	/* read everything we don't care about */
	while(ptr-buffer<count)
		ptr++;

	return ptr - buffer;
}

static int fiq_counter;

static void fiq_handler_tst(void)
{

#define FIQ_TIMER_EOI_ADDR (MOBI_TIMERS_BASE+TIMER4_OFFSET+MOBI_TIMERS_TIMER4_EOI_OFFSET)
	/* a simple inline asm handler to count the number of fiq we get */
	/* r8 contains the address of a variable(fiq_counter above), so we */
#if 0
	asm volatile (
			"ldr	r9, =FIQ_TIMER_EOI_ADDR\n\t"
			"ldr 	r9, [r9]\n\t"
			"ldr 	r9, [r8]\n\t"
			"add 	r9, r9, #1\n\t"
			"str 	r9, [r8]\n\t"
			"subs	pc, lr, #4"); /* must do this to get back to svc mode */

#endif
#if 0
	/* this is some code take from http://warmcat.com/_wp/?p=40, which
	*  can be used to program a handler in C along with a little asm setup
	*  and teardown
	*/
	/*
	*you can declare local vars here, take care to set the frame size
	* below accordingly if there are more than a few dozen bytes of them
	*/

	/* entry takes care to store registers we will be treading on here */
	asm __volatile__ (
		"mov     ip, sp ;"
		/* stash FIQ and r0-r8 normal regs */
		"stmdb	sp!, {r0-r8, r10-r12,  lr};"
		/* stash R9 separtely so we can have it first on exit */
		"stmdb	sp!, {r9};"
		/* !! THIS SETS THE FRAME, adjust to > sizeof locals */
		"sub     fp, ip, #256 ;"
		:
		:
		:"r9"
		);


	/*
	 * your C code goes here
	 *
	 * as an example, we bump a counter, you can rip that out when you
	 * customize
	 */
	at91rm9200_fiq_ipc.nCountFiqEvents++;


	/* exit back to normal mode restoring everything */
	asm __volatile__ (
		/* pop R9 to contain &AT91_SYS->AIC_FVR */
		"ldmia	sp!, {r9};"
		/* read from it to acknowledge FIQ source */
		"ldr	r0, [r9];"
		/* return FIQ regs back to pristine state
		 * and get normal regs back
		 */
		"ldmia	sp!, {r0-r8, r10-r12, lr};"

		/* return */
		"subs	pc, lr, #4;"
	);
#endif

}

static int fiq_proc_wr_handler(struct file *file,
		const char *buffer, unsigned long count, void *data)
{
	char *ptr = (char *)buffer;
	uint32_t fiq;
	int ret;
	struct pt_regs fiq_regs;

	if (proc_get_next_arg(&ptr, (uint32_t)buffer, count) == 0) {
		fiq = simple_strtoul(ptr, &ptr, 0);
		if(fiq < 0) {
			printk(KERN_ERR "Invalid debug command\n");
			return -1;
		}
	}
	else {
		printk("Invalid cmd string\n");
		return -1;
	}

	// send in greater than 7 to release
	if (fiq <= MOBI_FIQ_TIMER) {
		ret = mobi_claim_fiq(fiq);
		if (ret)
			printk("Error request FIQ %d\n", fiq);
		else
			printk("FIQ %d has been enabled\n", fiq);
		fiq_counter = 0;
	}
	/* fill in fiq reqs.  here we init. an register that
	*  our fiq handler will need to do it's work, we can
	*  even increase the size of the stack this way if we
	*  need to.  Just so I understand, these are the register
	*  values ONLY when we are in FIQ mode
	*/
	fiq_regs.ARM_r8 = (uint32_t)&fiq_counter;

	/* should check return value */
	mobi_set_fiq_handler(fiq_handler_tst, fiq_regs);

	mobi_enable_fiq();

	timer_stop_tick_count = 10;
	mobi_timers_tst();

	mobi_disable_fiq();
	mobi_release_fiq();
	printk("FIQ disabled and release, fiq_counter = %d\n", fiq_counter);

	/* read everything we don't care about */
	while(ptr-buffer<count)
		ptr++;

	return ptr - buffer;
}


static void __attribute__((unused)) fiq_procfs(void)
{
	struct proc_dir_entry *pentryd;

	if (debug_proc_dir == NULL)
		debug_proc_dir = proc_mkdir("driver/debug", NULL);
	proc_mkdir("driver/debug/fiq", NULL);
	pentryd = create_proc_entry("driver/debug/fiq/run",
			S_IRUSR | S_IRGRP | S_IROTH, NULL);
	if (pentryd) {
		//pentryd->write_proc = fiq_proc_wr_run;
		pentryd->write_proc = fiq_proc_wr_handler;
	}
}

struct mem_cfg_regs {
	char name[25];
	int offset;
	int count;
	int stride;
};

struct mem_cfg_regs mmu_cfg[] = {
	{ .name = "ArbPriConfig", .offset = 0x10, .count = 1, .stride = 0 },
	{ .name = "ArbLatConfig", .offset = 0x12, .count = 1, .stride = 0 },
	{ .name = "WrPriConfig",  .offset = 0x20, .count = 1, .stride = 8 },
	{ .name = "RdPriConfig",  .offset = 0x28, .count = 1, .stride = 8 },
	{ .name = "WrClBufAddr",  .offset = 0x28, .count = 1, .stride = 2 },
	{ .name = "WrClBufSize",  .offset = 0x40, .count = 1, .stride = 2 },
	{ .name = "RdClBufAddr",  .offset = 0x28, .count = 1, .stride = 2 },
	{ .name = "RdClBufSize",  .offset = 0x40, .count = 1, .stride = 2 },
};

struct mem_cfg_regs pmu_cfg[] = {
	{ .name = "VPATSegSize",  .offset = 0x008, .count = 1, .stride = 0 },
	{ .name = "FVSize",       .offset = 0x020, .count = 1, .stride = 6 },
	{ .name = "FHSize",       .offset = 0x022, .count = 1, .stride = 6 },
	{ .name = "FFormat",      .offset = 0x024, .count = 1, .stride = 6 },
	{ .name = "PartFormat",   .offset = 0x100, .count = 1, .stride = 2 },
	{ .name = "PartBaseSeg",  .offset = 0x200, .count = 128, .stride = 2 },
};

struct mem_cfg_regs pmc_cfg[] = {
	{ .name = "Master",       .offset = 0x010, .count = 1, .stride = 0 },
	{ .name = "Mode",         .offset = 0x011, .count = 4, .stride = 0 },
	{ .name = "TileSize",     .offset = 0x015, .count = 1, .stride = 0 },
	{ .name = "PageBankSize", .offset = 0x016, .count = 1, .stride = 0 },
	{ .name = "Timing",       .offset = 0x017, .count = 0, .stride = 1 },
};

static int mem_state_proc_rd(char *buf, char **start,
		off_t offset, int count, int *eof, void *data)
{
	static void __iomem *mmu_base = NULL;
	int i, j;
	int addr;
	uint32_t array_size;
	unsigned long reg;
	char cbuf[25];

	mmu_base = ioremap(0x0C000000, SZ_4K);
	if (!mmu_base) {
		printk("Failed to ioremap mmu bridge register space");
		return -EIO;
	}
	printk("MMU Bridge register settings\n");
	printk("partitionID0: 0x%08x\n", ioread32(mmu_base + 0x00));
	printk("partitionID1: 0x%08x\n", ioread32(mmu_base + 0x04));
	printk("partitionID2: 0x%08x\n", ioread32(mmu_base + 0x08));
	printk("partitionID3: 0x%08x\n", ioread32(mmu_base + 0x0C));
	printk("Lpartition  : 0x%08x\n", ioread32(mmu_base + 0x10));
	printk("MMU config  : 0x%08x\n", ioread32(mmu_base + 0x14));
	printk("masterWrAck : 0x%08x\n", ioread32(mmu_base + 0x18));
	iounmap(mmu_base);

	printk("\nMMU register settings\n");
	array_size = (sizeof(mmu_cfg) / sizeof((mmu_cfg)[0]));
	for (i=0;i<array_size; i++) {
		addr = mmu_cfg[i].offset;
		if (mmu_cfg[i].count == 1) {
			mobi_qcc_read(QCC_BID_MMU, addr, &reg, QCC_ACCESS_LEN_2);
			printk("%-15s: 0x%04lx\n", mmu_cfg[i].name, reg);
		}
		else {
			for (j=0; j < mmu_cfg[i].count ;j++) {
				mobi_qcc_read(QCC_BID_MMU, addr+(mmu_cfg[i].stride*j), &reg, QCC_ACCESS_LEN_2);
				memset(cbuf, 0x0, 25);
				sprintf(cbuf, "%s%d", mmu_cfg[i].name, j);
				printk("%-15s: 0x%04lx\n", cbuf, reg);
			}
		}
	}

	printk("\nPMU register settings\n");
	array_size = (sizeof(pmu_cfg) / sizeof((mmu_cfg)[0]));
	for (i=0;i<array_size; i++) {
		addr = pmu_cfg[i].offset;
		if (pmu_cfg[i].count == 1) {
			mobi_qcc_read(QCC_BID_PMU, addr, &reg, QCC_ACCESS_LEN_2);
			printk("%-15s: 0x%04lx\n", pmu_cfg[i].name, reg);
		}
		else {
			for (j=0; j < pmu_cfg[i].count ;j++) {
				mobi_qcc_read(QCC_BID_PMU, addr+(pmu_cfg[i].stride*j), &reg, QCC_ACCESS_LEN_2);
				memset(cbuf, 0x0, 25);
				sprintf(cbuf, "%s%d", pmu_cfg[i].name, j);
				printk("%-15s: 0x%04lx\n", cbuf, reg);
			}
		}
	}

	printk("\nPMC register settings\n");
	array_size = (sizeof(pmc_cfg) / sizeof((mmu_cfg)[0]));
	for (i=0;i<array_size; i++) {
		addr = pmc_cfg[i].offset;
		if (pmc_cfg[i].count == 1) {
			mobi_qcc_read(QCC_BID_PMC, addr, &reg, QCC_ACCESS_LEN_2);
			printk("%-15s: 0x%04lx\n", pmc_cfg[i].name, reg);
		}
		else {
			for (j=0; j < pmc_cfg[i].count ;j++) {
				mobi_qcc_read(QCC_BID_PMC, addr+(pmc_cfg[i].stride*j), &reg, QCC_ACCESS_LEN_2);
				memset(cbuf, 0x0, 25);
				sprintf(cbuf, "%s%d", pmc_cfg[i].name, j);
				printk("%-15s: 0x%04lx\n", cbuf, reg);
			}
		}
	}

	return 0;
}

static void __attribute__((unused)) memstuff_procfs(void)
{
	if (debug_proc_dir == NULL)
		debug_proc_dir = proc_mkdir("driver/debug", NULL);
	proc_mkdir("driver/debug/mem", NULL);

	create_proc_read_entry("driver/debug/mem",
			S_IRUSR | S_IRGRP | S_IROTH,
			NULL, mem_state_proc_rd, NULL);
}

/************************************************************************/

void setup_procfs(void)
{
	systimer_procfs_init();
	timers_procfs();
	dma_procfs();
	//fiq_procfs();
	memstuff_procfs();
}

static int __init mobi_drivertest_init(void)
{

	setup_procfs();
	//clk_test();
	return 0;
}
arch_initcall(mobi_drivertest_init);
