/*
 *  linux/arch/arm/mach-merlin/codec_reset.c
 *
 *  Copyright (C) 2008 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef DOXYGEN_SKIP

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/err.h>
#include <linux/proc_fs.h>
#include <linux/list.h>

#include <mach/platform.h>
#include <mach/mobi_codec_reset.h>

#if 0
#define dprintk(x...) printk(x)
#else
#define dprintk(x...)
#endif

#endif

extern int dmac_codec_suspend(void);
extern void dmac_codec_resume(void);

struct reset_device_node {
	struct list_head node;
	struct codec_reset_device *dev;
};


static LIST_HEAD(codec_reset_devices);

int32_t codec_reset_suspend_devices(void)
{
	struct reset_device_node *rdev_node = NULL;
	struct codec_reset_device *qrdev = NULL;
	struct list_head *lh;

	if (dmac_codec_suspend() == 0) {
		list_for_each(lh, &codec_reset_devices) {
			rdev_node =
				list_entry(lh, struct reset_device_node, node);
			qrdev = rdev_node->dev;
			dprintk("%s: Suspending device %s\n", __func__,
					qrdev->name);
			(*qrdev->suspend)(qrdev->data);
		}
	} else {
		printk(KERN_ERR "Failed to suspend DMA, codec reset aborted\n");
		return -1;
	}
	return 0;
}
EXPORT_SYMBOL(codec_reset_suspend_devices);

int32_t codec_reset_resume_devices(void)
{
	struct reset_device_node *rdev_node = NULL;
	struct codec_reset_device *qrdev = NULL;
	struct list_head *lh;

	list_for_each(lh, &codec_reset_devices) {
		rdev_node = list_entry(lh, struct reset_device_node, node);
		qrdev = rdev_node->dev;
		dprintk("%s: Resuming device %s\n", __func__, qrdev->name);
		(*qrdev->resume)(qrdev->data);
	}

	dmac_codec_resume();
	return 0;
}
EXPORT_SYMBOL(codec_reset_resume_devices);

int32_t codec_reset_device_register(struct codec_reset_device *qrdev)
{
	struct reset_device_node *rdev_node = NULL;

	rdev_node = (struct reset_device_node *)
		kmalloc(sizeof(struct reset_device_node), GFP_KERNEL);

	rdev_node->dev = qrdev;
	list_add(&rdev_node->node, &codec_reset_devices);

	return 0;
}
EXPORT_SYMBOL(codec_reset_device_register);

int32_t codec_reset_device_unregister(struct codec_reset_device *qrdev)
{
	struct list_head *lh;
	struct reset_device_node *rdev_node = NULL;

	list_for_each(lh, &codec_reset_devices) {
		rdev_node = list_entry(lh, struct reset_device_node, node);
		if (rdev_node->dev == qrdev) {
			list_del(&rdev_node->node);
			kfree(rdev_node);
			break;
		}
	}
	return 0;
}
EXPORT_SYMBOL(codec_reset_device_unregister);

static int __init codec_reset_init(void)
{
	return 0;
}
core_initcall(codec_reset_init);
