/**
 * @file op_model_merlin.c
 *
 * @author Stephan Lachowsky
 */

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/oprofile.h>
#include <linux/io.h>

#include <asm/fiq.h>

#include <mach/hardware.h>
#include <mach/mobi_fiq.h>
#include <mach/dw_timers_regs.h>

#include "op_arm_model.h"

static struct dw_timer_regs * const timer = __io_address(TIMER4_BASE);

static int counter[2];

static int merlin_setup_ctrs(void)
{
	return 0;
}

static void merlin_fiq_stop(void)
{
	timer->control = TIMER_DISABLE;
	printk("fiq counter: %d %d\n", counter[0], counter[1]);
}

static int merlin_fiq_start(void)
{
	counter[0] = counter[1] = 0;
	timer->load_count = 1000; /* 1000 per sec, given a 1 us timer  */
	timer->control = TIMER_ENABLE | TIMER_MODE_USER;
	return 0;
}

extern void fiq_handler(void);
extern int fiq_handler_size;
static int fiq_stack[256];

static int merlin_init(void)
{
	int ret;
	struct pt_regs regs;

	timer->control = TIMER_DISABLE;

	ret = mobi_claim_fiq(MOBI_FIQ_TIMER);
	if(ret)
	    return ret;

	regs.ARM_r8 = (long)&timer->eoi;
	regs.ARM_r9 = (long)&counter[0];
	regs.ARM_sp = (long)&fiq_stack[248];
	set_fiq_handler((void*)fiq_handler, fiq_handler_size);
	set_fiq_regs(&regs);

	mobi_enable_fiq();

	return 0;
}

struct op_arm_model_spec op_merlin_spec = {
	.init		= merlin_init,
	.num_counters	= 0,
	.setup_ctrs	= merlin_setup_ctrs,
	.start		= merlin_fiq_start,
	.stop		= merlin_fiq_stop,
	.name		= "timer" /*"arm/fiq"*/
};

