/*HEADER_START*//*
 * arch/arm/mach-merlin/qccsisc.h
 *
 * Copyright (C) Mobilygen Corp
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*HEADER_STOP*/

#ifndef __MACH_MERLIN_QCCSISC_H
#define __MACH_MERLIN_QCCSISC_H

#define CSR_CMD_WRITEACC        (1UL<<15)
#define CSR_CMD_READACC         (0UL<<15)
#define CSR_CMD_4BYTESACC       (0UL<<12)
#define CSR_CMD_1BYTESACC       (1UL<<12)
#define CSR_CMD_2BYTESACC       (2UL<<12)
#define CSR_CMD_LEN(X)          ((X)==4?0:((unsigned short)(X)&0x7UL)<<12)
#define CSR_CMD_BLOCKID(X)      (((unsigned short)(X)&0xffUL)<<0)
#define CSR_CMD_ADDR(X)         ((unsigned short)(X))

#define CSR_STAT_RESPID(X)      (((unsigned short)(X)&0xff00)>>8)
#define CSR_STAT_RESPLEN(X)     (((unsigned short)(X)&0x70)>>4)
#define CSR_STAT_ERR(X)         (((unsigned short)(X)&0x2)>>1)
#define CSR_STAT_DONE(X)        ((unsigned short)(X)&0x1)
#define CSR_ERR(X,Y,Z)          (CSR_STAT_RESPID(X)!=Y||CSR_STAT_RESPLEN(X)!=(Z==4?0:Z)||CSR_STAT_ERR(X))

#define CHECK_QCC_ADDR(addr)    ((addr & 0xFFFF)==addr)

#define PERIINT_CSR             0

#define QCC_REGADDR(reg) \
	(qcc_base+(uint32_t)MOBI_QCCSISC_##reg##_OFFSET)

#define READ_CSRAddr() \
	(readl(QCC_REGADDR(CSR_ADDR)) & 0xFFFF)

#define WRITE_CSRAddr(unsigned_short_value) \
	writel(unsigned_short_value, QCC_REGADDR(CSR_ADDR))

#define READ_CSRCmd() \
	(readl(QCC_REGADDR(CSR_CMD)) & 0xF0FF)

#define WRITE_CSRCmd(unsigned_short_value) \
	writel((unsigned_short_value) & 0xF0FF, QCC_REGADDR(CSR_CMD))

#define READ_CSRRdData() \
	readl(QCC_REGADDR(CSR_RDDATA))

#define READ_CSRWrData() \
	readl(QCC_REGADDR(CSR_WRDATA))

#define WRITE_CSRWrData(unsigned_long_value) \
	writel(unsigned_long_value, QCC_REGADDR(CSR_WRDATA))

#define READ_CSRStat() \
	(readl(QCC_REGADDR(CSR_STAT)) & 0xFF73)

#define WRITE_CSRStat(unsigned_short_value) \
	writel((unsigned_short_value) & 0xFF73, QCC_REGADDR(CSR_STAT))

#define READ_PeriIntPend() \
	(readl(QCC_REGADDR(PERI_INTPEND)) & 0x1F)

#define WRITE_PeriIntPend(unsigned_short_value) \
	writel((unsigned_short_value) & 0x1F, QCC_REGADDR(PERI_INTPEND))

#define WRITE_PeriIntEnSet(unsigned_short_value) \
	writel((unsigned_short_value) & 0x1F, QCC_REGADDR(PERI_INTENSET))

#define WRITE_PeriIntEnClr(unsigned_short_value) \
	writel((unsigned_short_value) & 0x1F, QCC_REGADDR(PERI_INTENCLR))

#define CSR_CMD_READ_WORD(unsigned_long_addr) \
	do \
{   WRITE_CSRAddr((unsigned_long_addr) & 0xFFFC); \
	WRITE_CSRCmd(CSR_CMD_READACC | CSR_CMD_4BYTESACC | CSR_CMD_BLOCKID((unsigned_long_addr)>>24)); \
} while(0)

#define CSR_CMD_READ_SHORT(unsigned_long_addr) \
	do \
{   WRITE_CSRAddr((unsigned_long_addr) & 0xFFFE); \
	WRITE_CSRCmd(CSR_CMD_READACC | CSR_CMD_2BYTESACC | CSR_CMD_BLOCKID((unsigned_long_addr)>>24)); \
} while(0)

#define CSR_CMD_READ_BYTE(unsigned_long_addr) \
	do \
	{   WRITE_CSRAddr((unsigned_long_addr) & 0xFFFF); \
		WRITE_CSRCmd(CSR_CMD_READACC | CSR_CMD_1BYTESACC | CSR_CMD_BLOCKID((unsigned_long_addr)>>24)); \
	} while(0)

#define CSR_CMD_WRITE_WORD(unsigned_long_addr,unsigned_long_data) \
	do \
	{   WRITE_CSRAddr((unsigned_long_addr) & 0xFFFC); \
		WRITE_CSRWrData(unsigned_long_data); \
		WRITE_CSRCmd(CSR_CMD_WRITEACC | CSR_CMD_4BYTESACC | CSR_CMD_BLOCKID((unsigned_long_addr)>>24)); \
	} while(0)

#define CSR_CMD_WRITE_SHORT(unsigned_long_addr,unsigned_short_data) \
	do \
	{   WRITE_CSRAddr((unsigned_long_addr) & 0xFFFE); \
		WRITE_CSRWrData(unsigned_short_data); \
		WRITE_CSRCmd(CSR_CMD_WRITEACC | CSR_CMD_2BYTESACC | CSR_CMD_BLOCKID((unsigned_long_addr)>>24)); \
	} while(0)

#define CSR_CMD_WRITE_BYTE(unsigned_long_addr,unsigned_char_data) \
	do \
	{   WRITE_CSRAddr((unsigned_long_addr) & 0xFFFF); \
		WRITE_CSRWrData(unsigned_char_data); \
		WRITE_CSRCmd(CSR_CMD_WRITEACC | CSR_CMD_1BYTESACC | CSR_CMD_BLOCKID((unsigned_long_addr)>>24)); \
	} while(0)

#define CSR_CMD_POLLDONE_TIMEOUT(int_timeout) \
	do \
	{   if(CSR_STAT_DONE(READ_CSRStat())) break; \
		qcc_wait(1); \
	} while(--int_timeout)

#define CSR_CMD_POLLDONE() \
	while(!CSR_STAT_DONE(READ_CSRStat()));

#endif
