/*
 * IOCTRL MACROS for the MX64180
 */

#include <linux/init.h>
#include <linux/version.h>
#include <linux/types.h>

#include "mach/mobi_ioctrl.h"
#include "mach/mx64180_gpio.h"

/* SPI_0 */
static const struct ioctrl_macro_func_s macro_func_spi0[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MASTER, IOCTRL_FUNC_ACTIVE_SPIMASTER)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MOSI, IOCTRL_FUNC_ACTIVE_SPIMOSI)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MCLK, IOCTRL_FUNC_ACTIVE_SPIMCLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MSS0, IOCTRL_FUNC_ACTIVE_MSS0)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MSS1, IOCTRL_FUNC_ACTIVE_MSS1)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_spi0[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMISO, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMSS0_BSEN, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMSS1_BSREQ, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMCLK_BSCLK, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMOSI_BSDATA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* SPI_1 */
static const struct ioctrl_macro_func_s macro_func_spi1[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V01_MCLK, IOCTRL_FUNC_ACTIVE_VXXMCLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V23_MCLK, IOCTRL_FUNC_ACTIVE_VXXMCLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V01_MOSI, IOCTRL_FUNC_ACTIVE_VXXMOSI)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V23_MOSI, IOCTRL_FUNC_ACTIVE_VXXMOSI)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_spi1[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MISO, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MSS, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MCLK_SCL, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MOSI_SDA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MSS, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MCLK_SCL, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MOSI_SDA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MISO, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* SPI_1.V01 */
static const struct ioctrl_macro_func_s macro_func_spi1v01[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V01_MCLK, IOCTRL_FUNC_ACTIVE_VXXMCLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V01_MOSI, IOCTRL_FUNC_ACTIVE_VXXMOSI)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_spi1v01[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MSS, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MCLK_SCL, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MOSI_SDA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MISO, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* SPI_1.V23 */

static const struct ioctrl_macro_func_s macro_func_spi1v23[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V23_MCLK, IOCTRL_FUNC_ACTIVE_VXXMCLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V23_MOSI, IOCTRL_FUNC_ACTIVE_VXXMOSI)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_spi1v23[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MISO, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MSS, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MCLK_SCL, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MOSI_SDA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* SPI_2 */
static const struct ioctrl_macro_func_s macro_func_spi2[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MASTER, IOCTRL_FUNC_ACTIVE_SPISLAVE)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MOSI, IOCTRL_FUNC_ACTIVE_SPIMOSI)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MCLK, IOCTRL_FUNC_ACTIVE_SPIMCLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MSS0, IOCTRL_FUNC_ACTIVE_MSS0)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MSS1, IOCTRL_FUNC_ACTIVE_MSS1)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_spi2[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMISO, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMSS0_BSEN, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMCLK_BSCLK, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMOSI_BSDATA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* BS */
static const struct ioctrl_macro_func_s macro_func_bs[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MOSI, IOCTRL_FUNC_ACTIVE_BS_DATA)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MCLK, IOCTRL_FUNC_ACTIVE_BS_CLK)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MSS0, IOCTRL_FUNC_ACTIVE_BS_ENABLE)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_SPI_MSS1, IOCTRL_FUNC_ACTIVE_BS_REQ)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_bs[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMSS0_BSEN, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMSS1_BSREQ, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMCLK_BSCLK, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SPIMOSI_BSDATA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* I2C_0 */
static const struct ioctrl_macro_func_s macro_func_i2c0[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_i2c0[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SCL0, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SDA0, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* I2C_1.V01 */
static const struct ioctrl_macro_func_s macro_func_i2c1v01[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V01_MCLK, IOCTRL_FUNC_ACTIVE_SCL)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V01_MOSI, IOCTRL_FUNC_ACTIVE_SDA)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_I2C_CFG, IOCTRL_FUNC_ACTIVE_I2CV01)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_i2c1v01[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MCLK_SCL, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MOSI_SDA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* I2C_1.V23 */
static const struct ioctrl_macro_func_s macro_func_i2c1v23[] = {
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V23_MCLK, IOCTRL_FUNC_ACTIVE_SCL)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_V23_MOSI, IOCTRL_FUNC_ACTIVE_SDA)
	IOCTRL_DECLARE_MACRO_FUNC(IOCTRL_FUNC_I2C_CFG, IOCTRL_FUNC_ACTIVE_I2CV23)
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_i2c1v23[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MCLK_SCL, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MOSI_SDA, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* I2C_0.GPIO */
static const struct ioctrl_macro_func_s macro_func_i2c0gpio[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_i2c0gpio[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SCL0, IOCTRL_GPIO_FUNCTION_GPIO)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_SDA0, IOCTRL_GPIO_FUNCTION_GPIO)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* I2C_0.V01.GPIO */
static const struct ioctrl_macro_func_s macro_func_i2c1v01gpio[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_i2c1v01gpio[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MCLK_SCL, IOCTRL_GPIO_FUNCTION_GPIO)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V01MOSI_SDA, IOCTRL_GPIO_FUNCTION_GPIO)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* I2C_0.V23.GPIO */
static const struct ioctrl_macro_func_s macro_func_i2c1v23gpio[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_i2c1v23gpio[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MCLK_SCL, IOCTRL_GPIO_FUNCTION_GPIO)
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_V23MOSI_SDA, IOCTRL_GPIO_FUNCTION_GPIO)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* PWM_0 */

static const struct ioctrl_macro_func_s macro_func_pwm0[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_pwm0[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_PWM0, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* PWM_1 */
static const struct ioctrl_macro_func_s macro_func_pwm1[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_pwm1[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_PWM1, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};

/* PWM_2 */
static const struct ioctrl_macro_func_s macro_func_pwm2[] = {
	IOCTRL_DECLARE_MACRO_FUNC_END()
};
static const struct ioctrl_macro_gpio_s macro_gpio_pwm2[] = {
	IOCTRL_DECLARE_MACRO_GPIO_U(MX64180_GPIO_PWM2, IOCTRL_GPIO_FUNCTION_PRIMARY)
	IOCTRL_DECLARE_MACRO_GPIO_END()
};


static const struct ioctrl_macro_s macros[] = {
	{ .name = "SPI_0", .func = macro_func_spi0, .gpio = macro_gpio_spi0 },
	{ .name = "SPI_1", .func = macro_func_spi1, .gpio = macro_gpio_spi1 },
	{ .name = "SPI_1.V01", .func = macro_func_spi1v01, .gpio = macro_gpio_spi1v01 },
	{ .name = "SPI_1.V23", .func = macro_func_spi1v23, .gpio = macro_gpio_spi1v23 },
	{ .name = "SPI_2", .func = macro_func_spi2, .gpio = macro_gpio_spi2 },
	{ .name = "BS", .func = macro_func_bs, .gpio = macro_gpio_bs },
	{ .name = "I2C_0", .func = macro_func_i2c0, .gpio = macro_gpio_i2c0 },
	{ .name = "I2C_1.V01", .func = macro_func_i2c1v01, .gpio = macro_gpio_i2c1v01 },
	{ .name = "I2C_1.V23", .func = macro_func_i2c1v23, .gpio = macro_gpio_i2c1v23 },
	{ .name = "I2C_0.GPIO", .func = macro_func_i2c0gpio, .gpio = macro_gpio_i2c0gpio },
	{ .name = "I2C_1.V01.GPIO", .func = macro_func_i2c1v01gpio, .gpio = macro_gpio_i2c1v01gpio },
	{ .name = "I2C_1.V23.GPIO", .func = macro_func_i2c1v23gpio, .gpio = macro_gpio_i2c1v23gpio },
	{ .name = "PWM_0", .func = macro_func_pwm0, .gpio = macro_gpio_pwm0 },
	{ .name = "PWM_1", .func = macro_func_pwm1, .gpio = macro_gpio_pwm1 },
	{ .name = "PWM_2", .func = macro_func_pwm2, .gpio = macro_gpio_pwm2 },
	{ .name = NULL, },
};


static int __init mg3500_ioctrl_macros_init(void)
{
	mobi_ioctrl_set_macros(macros);
	return 0;
}
arch_initcall(mg3500_ioctrl_macros_init);



