#ifndef MX64180_DEVICES_H
#define MX64180_DEVICES_H

#include <linux/dw_watchdog_device.h>
#include <linux/dw_sdmmc_device.h>
#include <linux/dw_otg_device.h>
#include <linux/dw_gmac_device.h>
#include <linux/aumb3000_nand_device.h>
#include <linux/i2c/dwapbi2c.h>
#include <linux/spi/dwapbssi.h>
#include <linux/cadpwm.h>
#include <linux/dwapbgpio.h>

enum board_device_types {
	BOARD_DEVICE_NAND,
	BOARD_DEVICE_WATCHDOG,
	BOARD_DEVICE_SDMMC,
	BOARD_DEVICE_GMAC,
	BOARD_DEVICE_USB,
	BOARD_DEVICE_MHIF,
	BOARD_DEVICE_GPIO,
	BOARD_DEVICE_I2C,
	BOARD_DEVICE_SPI,
	BOARD_DEVICE_PWM,
	BOARD_DEVICE_SATA,
};

static char __attribute__((unused)) *board_device_types_names[] = {
	"NAND",
	"WATCHDOG",
	"SDMMC",
	"GMAC",
	"USB",
	"GPIO",
	"I2C",
	"SPI",
	"PWM",
	"SATA",
};

struct board_device_desc {
	enum board_device_types device;
	uint8_t devid;
	void *platform_data;
};

struct nand_board_config_t {

	/* IP specific data passed to device driver */
	struct aumb3000_nand_device_data_t device_data;

	/* board/platform specific params */
	uint8_t rsvd;
};

struct sata_board_config_t {
    
#if 0
	/* IP specific data passed to device driver */
	struct dw_sata_device_data_t device_data;

	/* board/platform specific params */
#endif
};

struct sdmmc_board_config_t {

	struct dwc_sdmmc_device_data_t device_data;

	/* board specific data not passed to driver */
	uint8_t rsvd;
};

struct wdt_board_config_t {
	struct dw_wdt_driver_data_t wdt_data;
	/* board/platform specific params */
	uint8_t rsvd;
};

struct gmac_board_config_t {
	struct dw_gmac_driver_data_t gmac_data;
	/* board/platform specific params */
	uint8_t rsvd;
};

struct usb_board_config_t {
	struct dw_otg_driver_data_t otg_data;
	/* board/platform specific params */
	uint8_t rsvd;
};

int arch_add_board_devices(struct board_device_desc *board_devices, int num_devices);

#endif  /* MX64180_DEVICES_H */
