/*HEADER_START*/
/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*HEADER_STOP*/

#include <linux/err.h>
#include <linux/init.h>
#include <linux/io.h>

#include <asm/mach-types.h>
#include <asm/hardware/cache-l2x0.h>

#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>

#include <mach/hardware.h>
#include <mach/platform.h>
#include <mach/mobi_clock.h>
#include <mach/mobi_qcc.h>
#include <mach/mobi_reset.h>

void __init mx64180_map_io(void);
void __init mx64180_init_irq(void);
static void __init mx64180_board_init(void);

extern struct sys_timer mgx_sys_timer;
extern void __init mgx_ictl_init(void);
extern void __init __early_qccsisc_init(void);
extern void __early_clk_init(void);
extern void (*falcon_arch_reset)(void);
extern int mx64180_register_platform_drivers(void);

static struct map_desc mx64180_io_desc[] __initdata = {
	{
		.virtual	= IO_ADDRESS(UARTDBG_BASE),
		.pfn		= __phys_to_pfn(UARTDBG_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= IO_ADDRESS(ICTL_BASE),
		.pfn		= __phys_to_pfn(ICTL_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= IO_ADDRESS(TIMERS_BASE),
		.pfn		= __phys_to_pfn(TIMERS_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= IO_ADDRESS(QCC_BASE),
		.pfn		= __phys_to_pfn(QCC_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}
};

void __init mx64180_map_io(void)
{
	iotable_init(mx64180_io_desc, ARRAY_SIZE(mx64180_io_desc));
	/* after this runs, need to access the timer clock
	 *  and get it started so the sytem timer will start!
	 */
	__early_qccsisc_init();
	__early_clk_init();
}

void __init mx64180_init_irq(void)
{
	mgx_ictl_init();
}

static void mx64180_reset(void)
{
	mobi_reset_enable(RESET_ID_CHIP);
}

static void __init mx64180_board_init(void)
{
	falcon_arch_reset = mx64180_reset;

#ifdef CONFIG_CACHE_L2X0
	{

/* 16K way size, 8 ways, Wrap access disable */
#define L2_AUX_CTRL_INIT 0x31000

		void __iomem *l2x0_base;

		l2x0_base = ioremap(L210_REG_BASE, L210_REG_SIZE);
		if (IS_ERR(l2x0_base)) {
			printk(KERN_ERR "remapping L2 cache area failed with %ld\n",
					PTR_ERR(l2x0_base));
			return;
		}

		/* void __init l2x0_init(void __iomem *base,
		 * __u32 aux_val, __u32 aux_mask)
		 * */
		l2x0_init(l2x0_base, L2_AUX_CTRL_INIT, 0x00000000);

	}
#endif

	mx64180_register_platform_drivers();
	return;
}

MACHINE_START(FALCON, "Maxim Falcon MX64180")
	.phys_io       = 0x80000000,
	.io_pg_offst   = ((0xf0000000) >> 18) & 0xfffc,
	.boot_params   = MMU_DATA_BASE + 0x100,
	.map_io        = mx64180_map_io,
	.init_irq      = mx64180_init_irq,
	.timer         = &mgx_sys_timer,
	.init_machine  = mx64180_board_init,
MACHINE_END
