/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup SystemControlControlObject System Control Interface Object
/// \{

/// \page qsyscontrol System Control Interface Object
/// \latexonly
/// \chapter{System Control Interface Object}
/// \input{syscontrol}
/// \endlatexonly

#ifndef __QSYSCONTROL_HH
#define __QSYSCONTROL_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Global defines
//
#define Q_SYS_HVCAP_MAX_STREAM_ID   15
#define Q_SYS_HACAP_MAX_STREAM_ID   15
#define Q_SYS_AVCENC_MAX_STREAM_ID   31
#define Q_SYS_AUDENC_MAX_STREAM_ID  15 
#define Q_SYS_JPEGENC_MAX_STREAM_ID 15
#define Q_SYS_JPEGDEC_MAX_STREAM_ID 15

//////////////////////////////////////////////////////////////////////
//
// Commands

/// \brief This command forces the object to generate an ECHO event.  The
/// first argument to the command is sent back as the first payload entry
/// in the event/
/// \param arg[0] : Data to echo back
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_ECHO                              1 

/// \brief This command is a debug command.
/// \param  : 
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_THREAD_LIST                       2

/// \brief This command is a debug command.
/// \param  : 
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_PROFILE                           3

/// \brief This command is a debug command.
/// \param  : 
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_INFO                              4

/// \brief This command sets the verbose level for logging on the MG3500
/// debug serial port.  A level of zero is no output, a level of 10 is
/// a maximum level.
/// \param enable 1 for enable, 0 for disable
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_VERBOSE_LEVEL                     5

/// \brief This command enables debug printf. 
/// \param enable 1 for enable, 0 for disable
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_ENABLE_PRINTF                     6

/// \brief This command creates a Live Video Pre-Processor Object. 
/// \param  port : Specfies if the object is using port 0 or port 1
/// \param  slot : If the video port is configured to be interleaved, this parameter
/// sets the slot index of the interleave.
/// \param  maxWidth : Maximum width of the capture buffers 
/// \param  maxHeight : Maximum height of the capture buffers
/// \param  maxPMEDSFactor :  Maximum decimation factor for the downscaled 
/// images used for first-stage motion estimation.  Note the larger the factor, the less
/// memory is allocated.
/// \param  maxDeintMode : Maximum number of fields used for deinterlacing. 
/// \param  numVidFrame : Specifies the number of capture buffers allocated and managed
/// by the object.  This includes full capture and downscaled buffers.
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_LVPP_CREATE                       7

/// \brief This command creates a Non-Realtime Video Pre-Processor Object. 
/// \param maxWidth : Maximum width of the outut buffers
/// \param maxHeight : Maximum height of the output buffers
/// \param  maxPMEDSFactor :  Maximum decimation factor for the downscaled 
/// images used for first-stage motion estimation.  Note the larger the factor, the less
/// memory is allocated.
/// \param maxDeintMode : Maximum number of fields used for deinterlacing. 
/// \param numVidFrame : Number of capture buffers allocated and managed
/// by the object
/// \param numPMEDSFrame : Number of downscaled luma-buffers allocated 
/// and managed by the object
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_NVPP_CREATE                       8

/// \brief This command creates an Audio Video Output Compositor Object. 
/// \param maxWidth : Maximum width of the render buffers
/// \param maxHeight : Maximum height of the render buffers
/// \param numVidFrame : Number of render buffers to allocate
/// \param gfx0Size : Size of graphics memory allocated for OSD plane 0
/// \param gfx1Size : Size of graphics memory allocated for OSD plane 1
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_AVOC_CREATE                       9

/// \brief This command creates an Stereo Audio Input Object. 
/// \param port : Specifies if the object uses port 0 or port 1
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_SAIN_CREATE                       10

/// \brief This command creates an HVCAP Object. 
/// \param streamID : Unclear
/// \param maxFrameWidth : Maximum width of the capture buffers
/// \param maxFrameHeight : Maximum height of the capture buffers
/// \param numFramesInPool : Number of frames that are managed by the object
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_HVCAP_CREATE                      11

/// \brief This command create an AVC Encoder Object
/// \param maxFrameWidth : Maximum width of the reference frame buffers
/// \param maxFrameHeight : Maximum height of the reference frame buffers
/// \param numReferenceFrames : Number of reference frames managed by the object
/// \param outputBufferSize : Size of the compressed output buffer
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_AVCENC_CREATE                     12

/// \brief This command creates an Audio Video Synchronizer Object
/// \param  : 
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_AVSN_CREATE                       13

/// \brief This command creates an AVC Decoder Object
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_AVCDEC_CREATE                     14

/// \brief This command creates an HVOUT Object 
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_HVOUT_CREATE                      15

/// \brief This command creates an audio encoder
/// \param codec : Audio codec to use
/// \param streamId : Stream ID for generated stream 
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_AUDENC_CREATE                     16

/// \brief Not supported
#define Q_SYS_CMD_HAOUT_CREATE                      17

/// \brief This command sets the video port mode for the specified port
/// \param port Specifies port 0 or 1 to configure
/// \param live Set to 1 for live input, set to 0 for single channel input and allow NVPP creation
/// \param bottomfieldfirst Set to 1 if the field order is temporally bottom field first
/// \param videocontrol Sets the video control configuration as per the table below
/// \latexonly
/// \input{videocontrol.tex}
/// \endlatexonly
/// \param interleave In the case of multichannel operation sets the channel interleave, or 1 for no interleave
/// \param syncmode Must be set to Q_SYS_CFP_VPORT_SYNC_MODE_MOBI for multichannel interleaved operation or 0
/// for no synchronization in which case the assignment of channel 0 is random
/// \param syncheight Height of the synchronization blanking region in lines
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_SET_VPORT_MODE                    18

/// \brief This command creates a JPEG encoder object
/// \param maxFrameWidth Maximum width of the input buffers
/// \param maxFrameHeight Maximum height of the input buffers
/// \param outputBufferSize Size of the compressed data buffer
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_JPEGENC_CREATE                    19

/// \brief This command allocates memory on the codec and returns the address
/// \param size Size of the memory allocation in bytes
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Codec byte address
#define Q_SYS_CMD_MEMORY_ALLOC                      20

/// \brief This command loads the burn in font.
/// \param fontaddr Codec byte address of the font
/// \param fontsize Size of the font (8, 16 or 32)
/// \param binsize  Size of the font bin file in bytes
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_LOAD_BURNIN_FONT                   21

/// \brief This command creates an audio splitter object
/// \param numOutput Number of output ports for the splitter
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_ASPLIT_CREATE                     22

/// \brief This command creates a host audio capture object
/// \param streamID : Stream ID 
/// \param numFramesInPool : Number of frames that are managed by the object
/// \return Code : 1 for success, 0 for failure
/// \return Value : [0] Object Id
/// \return Value : [1] Status block pointer
#define Q_SYS_CMD_HACAP_CREATE                      23

/// \brief This command sets the video port mode for the specified port
/// \param port Specifies port 0 or 1 to configure
/// \param pri Memory client priority or 0, 1 or 2(default)
/// \param size Memory client transfer size of 16, 32, 64 or 128(default)
/// \return Code : 1 for success, 0 for failure
#define Q_SYS_CMD_SET_VPORT_PRI                     24

/// \brief This command creates a audio filter object
#define Q_SYS_CMD_AUDFLTR_CREATE                    25

/// \brief This is a special command that doesn't actually command a system
///        control object to execute certain action. Through this command 
///        application instructs the middleware to begin to queue incoming 
///        commands from host to codec rather than to send them directly.
///        After this command returns, all subsequent commands sent to the codec
///        will be queued in the middleware until the EXECUTE_QUEUED_CMD is
///        received. At this EXECUTE command, all queued commands will be
///        executed. Specify a delay value to delay the execution.
/// \param delay Delay the execution of queued command by 'delay' seconds.
#define Q_SYS_CMD_BEGIN_QUEUE_CMD                   26

/// \brief This is a special command that doesn't actually command a system
///        control object to execute certain action. This is used along with
///        Q_SYS_CMD_BEGIN_QUEUE_CMD to perform execution of queued commands
///        at once.
#define Q_SYS_CMD_EXECUTE_QUEUED_CMD                27

/// \brief This command set the interval of NTP updates
/// \param sec Number of seconds between NTP updates
#define Q_SYS_CMD_SET_NTP_INTERVAL                  28

/// \brief Allocate a block of memory in the codec partition for the storage
///        of saved COMMAND structs written by the direct command write system.
/// \param size Number of commands that can be saved in memory at one time.
#define Q_SYS_CMD_DIRECT_COMMAND_WRITE_ALLOC        29

/// \brief Signals the end of direct command writing. Also prompt the middleware
///        to execute all the commands written to memory.
/// \param numCommands Number of commands to execute. 0 for all commands
/// \param targetTimeSec The target time to execute all commands. Number of seconds
///        after Jan 1, 1970.
/// \param targetTimeUSec Added to targetTimeSec to provide a more precise target time.
#define Q_SYS_CMD_DIRECT_COMMAND_WRITE_DONE         30

#define Q_SYS_MAX_CMD                               31

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 
typedef struct
{
    unsigned int numMasks;
    unsigned int threadMask[4];
    unsigned int time;
    unsigned int videoQMM;
} STRUCT_Q_SYS_CMD_PROFILE;

typedef struct
{
    unsigned int streamID;
    unsigned int maxFrameWidth;
    unsigned int maxFrameHeight;
    unsigned int numFramesInPool;
} STRUCT_Q_SYS_CMD_HVCAP_CREATE;

typedef struct
{
    unsigned int maxFrameWidth;
    unsigned int maxFrameHeight;
    unsigned int numReferenceFrames;
    unsigned int outputBufferSize;
    unsigned int outputAUs;
    unsigned int useBitstreamBufferMem;
    unsigned int debugCapture;
    unsigned int objectTrackingEnable;
} STRUCT_Q_SYS_CMD_AVCENC_CREATE;

typedef struct
{
    int atype;
    int audioBufferSize;
    int vtype;
    int vstream;
    int videoBufferSize;
    int maxWidth;
    int maxHeight;
    int numOutputFrames;
    int maxAudFrameSize;
    int numAudOutFrames;
    unsigned int videoAUs;
    unsigned int audioAUs;
    int ioMode;
    int fastPassThrough;
} STRUCT_Q_SYS_CMD_AVDEC_CREATE;

typedef struct
{
    unsigned int port;
    unsigned int slot;
    unsigned int maxWidth;
    unsigned int maxHeight;
    unsigned int maxPMEDSFactor;
    unsigned int maxDeintMode;
    unsigned int numVidFrame;
    unsigned int audioInputClock;
    unsigned int motionBitMap;
    unsigned int burninEnable;
    unsigned int privacyRegionEnable;
    unsigned int motionDetectionEnable;
    unsigned int cameraTamperEnable;
} STRUCT_Q_SYS_CMD_LVPP_CREATE;

typedef struct
{
    unsigned int maxWidth;
    unsigned int maxHeight;
    unsigned int maxPMEDSFactor;
    unsigned int maxDeintMode;
    unsigned int numVidFrame;
    unsigned int numPMEDSFrame;
    unsigned int dis;
    unsigned int audioInputClock;
    unsigned int motionBitMap;
} STRUCT_Q_SYS_CMD_NVPP_CREATE;

typedef struct
{
    unsigned int port;
    unsigned int live;
    unsigned int interlaced;
    unsigned int bottomfieldfirst;
    unsigned int videocontrol;
    unsigned int interleave;
    unsigned int syncmode;
    unsigned int syncheight;
} STRUCT_Q_SYS_CMD_SET_VPORT_MODE;

typedef struct
{
    unsigned int port;
    unsigned int pri;
    unsigned int size;
} STRUCT_Q_SYS_CMD_SET_VPORT_PRI;

typedef struct
{
    unsigned int maxWidth;
    unsigned int maxHeight;
    unsigned int numVidFrame;
    unsigned int gfx0Size;
    unsigned int gfx1Size;
    unsigned int allocGfx;
} STRUCT_Q_SYS_CMD_AVOC_CREATE;

typedef struct {
    unsigned int maxFrameWidth;
    unsigned int maxFrameHeight;
    unsigned int outputBufferSize;
    unsigned int useBitstreamBufferMem;
} STRUCT_Q_SYS_CMD_JPEGENC_CREATE;

typedef struct
{
    unsigned int port;
    unsigned int numAudFrame;
    unsigned int maxFrameSize;
} STRUCT_Q_SYS_CMD_SAIN_CREATE;

typedef struct
{
    unsigned int size;
} STRUCT_Q_SYS_CMD_MEMORY_ALLOC;

typedef struct
{
    unsigned int fontaddr;
    unsigned int fontsize;
    unsigned int binsize;
} STRUCT_Q_SYS_CMD_LOAD_BURNIN_FONT;

typedef struct
{
    int port;
    int numOutput;
    int numAudFrame;
    int maxFrameSize;
    int splitMode;
} STRUCT_Q_SYS_CMD_ASPLIT_CREATE;

typedef struct
{
    unsigned int streamID;
    unsigned int maxFrameSize;
    unsigned int numFramesInPool;
} STRUCT_Q_SYS_CMD_HACAP_CREATE;

typedef struct
{
    unsigned int codec;
    unsigned int outputBufferSize;
    unsigned int useBitstreamBufferMem;
} STRUCT_Q_SYS_CMD_AUDENC_CREATE;

typedef struct
{
    int numOutputPorts;
    int numOutputFrames;
    int maxFrameSize;
    int filterType;
    int cBufferLen;
} STRUCT_Q_SYS_CMD_AUDFLTR_CREATE;

typedef struct
{
    unsigned int targetTimeSec;
    unsigned int targetTimeUSec;
} STRUCT_Q_SYS_CMD_BEGIN_QUEUE_CMD;

typedef struct
{
    unsigned int sec;
} STRUCT_Q_SYS_CMD_SET_NTP_INTERVAL;

typedef struct
{
    unsigned int size;
} STRUCT_Q_SYS_CMD_DIRECT_COMMAND_WRITE_ALLOC;

typedef struct
{
    unsigned int numCommands;
    unsigned int targetTimeSec;
    unsigned int targetTimeUSec;
} STRUCT_Q_SYS_CMD_DIRECT_COMMAND_WRITE_DONE;

///////////////////////////////////////////////////////////////////////
//
// Command Returns
// 

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//

//////////////////////////////////////////////////////////////////////
//
// Events
//

#define SYSCTRL_EVENT(ID) ((SYSCTRL_CTRLOBJ_TYPE << 16) | ID)

#define Q_SYS_EV_HEARTBEAT              SYSCTRL_EVENT(1)
#define Q_SYS_EV_ECHO                   SYSCTRL_EVENT(2)
#define Q_SYS_EV_FATAL_ERROR            SYSCTRL_EVENT(3)
#define Q_SYS_EV_DEMUX_ERROR            SYSCTRL_EVENT(4)
#define Q_SYS_EV_PLATFORM_VERSION       SYSCTRL_EVENT(5)


///////////////////////////////////////////////////////////////////////
//
// Event structure with payload definitions
// 

// generated from meevents.h ME_DEMUX_ERROR_ s/ME_DEMUX_ERROR/Q_SYS_EV_DEMUX_ERROR/
#define Q_SYS_EV_DEMUX_ERROR_NAL_TOO_BIG        0
#define Q_SYS_EV_DEMUX_ERROR_BAD_SAMPLE_SIZE    1
#define Q_SYS_EV_DEMUX_ERROR_SIZE_TOO_LARGE     2

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        errorType;
    unsigned int        sampleStreamType_ID;
    unsigned int        sampleSize;
    unsigned int        PTS_MSB;
    unsigned int        PTS_LSB;
} STRUCT_Q_SYS_EV_DEMUX_ERROR;

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        errorType;
    unsigned int        param0;
    unsigned int        param1;
    unsigned int        param2;
    unsigned int        param3;
} STRUCT_Q_SYS_EV_FATAL_ERROR;

// Generated from meevents.h ME_FWERR s/ME_FWERR/Q_SYS_EVP/
#define Q_SYS_EVP_UNKNOWN                            0
#define Q_SYS_EVP_IPC_FAILURE                        1
#define Q_SYS_EVP_MEMSCALE_NOT_AVAILABLE             2
#define Q_SYS_EVP_OUT_OF_AVCENCODER_OBJECTS          3
#define Q_SYS_EVP_OUT_OF_POOL_MEMORY                 4
#define Q_SYS_EVP_OUT_OF_HEAP_MEMORY                 5
#define Q_SYS_EVP_AVCENC_NEGATIVE_VIDEO_AU_SIZE      6
#define Q_SYS_EVP_VPP_CONFIG_PMEDS                   7
#define Q_SYS_EVP_INVALID_VPORT_CONFIG               8
#define Q_SYS_EVP_OUT_OF_DOUBLE_PID                  9
#define Q_SYS_EVP_OUT_OF_FORMAT_ID                  10
#define Q_SYS_EVP_OUT_OF_SINGLE_PID                 11
#define Q_SYS_EVP_VPP_CONFIG_DEINT                  12
#define Q_SYS_EVP_BUFFER_GUARD_BAND_OVERFLOW        13
#define Q_SYS_EVP_ME_EVENT_QUEUE_OVERFLOW           14
#define Q_SYS_EVP_AVCENC_HARDWARE_ERROR             15
#define Q_SYS_EVP_AVCENC_HARDWARE_HANG              16
#define Q_SYS_EVP_INVALID_PLATFORM                  17
#define Q_SYS_EVP_AVCENC_FRAME_TOO_LARGE            18
#define Q_SYS_EVP_AUDIO_RESET                       19
#define Q_SYS_EVP_AVCENC_DEFAULT_CONFIG_ARRAY_CORRUPTED  20


/// \brief The Serial I/O helps configure the SPI, UART, and I2C interface ports. The SPI interface 
/// can be configured as a Master or Slave, and support two devices. V01 and V23 are part of 
/// the Slave select configuration. The debug UART port is shared by both the QMM and the ARM 
/// debug ports.
/// \param SPIMasterSel Bit 10 : 0 = SPI interface is the Master (default) 1 = SPI interface is the Slave
/// \param SPI_MSS1_AltSel Bit 9 : 0 = SPI_MSS0 signal is active (default) 1 = BS_REQ signal is active. GPIOSel takes precedence
/// \param SPI_MSS0_AltSel Bit 8 : 0 = SPI_MSS0 signal is active (default) 1 = BS_ENABLE signal is active. GPIOSel takes precedence
/// \param SPI_MCLK_AltSel Bit 7 : 0 = SPI_MCLK signal is active (default) 1 = BS_CLK signal is active. GPIOSel takes precedence
/// \param SPI_MOSI_AltSel Bit 6 : 0 = SPI_MOSI signal is active (default) 1 = BS_DATA signal is active. GPIOSel takes precedence
/// \param V01_MCLK_AltSel Bit 5 : 0 = V01_MCLK signal is active (default) 1 = V01_SCL signal is active. GPIOSel takes precedence
/// \param V01_MOSI_AltSel Bit 4 : 0 = V01_MOSI signal is active (default) 1 = V01_SDA signal is active. GPIOSel takes precedence
/// \param V23_MCLK_AltSel Bit 3 : V23_MCLK signal is active (default) 1 = V23_SCL signal is active. GPIOSel takes precedence
/// \param V23_MOSI_AltSel Bit 2 : 0 = V23_MOSI signal is active (default) 1 = V23_SDA signal is active. GPIOSel takes precedence
/// \param I2C1Cfg Bit 1 : 0 = I2C_1 connects to the V01_* port 1 = I2C_1 connects to the V23_* port
/// \param DBGUARTSel Bit 0 : 0 = Connects ARM_DBG_UART to the DBG UART port (default) 1 = Connect QMM_DBG_UART to the DBG UART port
#define Q_SYS_CFG_SERIALIO_CONTROL                  1

/// \brief The drive strength and the slew rate are set by enabling specific bitfields. 
/// The strength and the rate can be set from slowest to fastest where in 00 is the 
/// slowest slew rate and 11 the fastest and drive strength spans between 1-6, 1 being 
/// the slowest and 6 the fastest.  The drive strength is encoded as a 3-bit value and 
/// different codes of the drive strength enable the different ports in the hardware. 
/// The DS0 fields enable the serial port pin list category in the hardware. The DS1 
/// fields set the SPI ports in the hardware. The DS2 fields enable the V0 SPI ports 
/// in the hardware. 
///
/// Reserved fields should be ignored (masked) when read and only 
/// zeros should be written to them.
/// \param SR0SlewRate Bit [0:1] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS0DriveStength Bit [2:4]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR1SlewRate Bit [5:6] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS1DriveStength Bit [7:9]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR2SlewRate Bit [10:11] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS2DriveStength Bit [12:14]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param Reserved Bit [15]: 
#define Q_SYS_CFG_SERIALIO_DRIVESTRENGTH_0          2

/// \brief The drive strength and the slew rate can be set by enabling specific bitfields. 
/// The strength and the rate can be set from slowest to fastest where in 00 is the slowest 
/// slew rate and 11 the fastest and drive strength spans between 1-6, 1 being the slowest 
/// and 6 the fastest. The DS3 fields enables the V23 SPI port on the hardware. The DS4 
/// fields enable Video 0 port in the hardware. The DS5 fields enable Video1 port in the hardware.
/// \param SR3SlewRate Bit [0:1] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS3DriveStength Bit [2:4]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR4SlewRate Bit [5:6] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS4DriveStength Bit [7:9]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR5SlewRate Bit [10:11] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS5DriveStength Bit [12:14]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param Reserved Bit [15]: 
#define Q_SYS_CFG_SERIALIO_DRIVESTRENGTH_1          3

/// \brief The drive strength and the slew rate can be set by enabling  specific 
/// bitfields. The strength and the rate can be set from slowest to fastest where in 00 is 
/// the slowest slew rate and 11 the fastest and drive strength spans between 1-6, 1 being 
/// the slowest and 6 the fastest. The DS6 fields enable Video2 port in the hardware. 
/// The DS7 fields enable the Video 3 port in the hardware. The DS8 fields enable the port to communicate with the HOST.
/// \param SR6SlewRate Bit [0:1] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS6DriveStength Bit [2:4]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR7SlewRate Bit [5:6] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS7DriveStength Bit [7:9]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR8SlewRate Bit [10:11] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS8DriveStength Bit [12:14]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param Reserved Bit [15]: 
#define Q_SYS_CFG_SERIALIO_DRIVESTRENGTH_2          4

/// \brief The drive strength and the slew rate can be set by enabling  specific bitfields. The strength 
/// and the rate can be set from slowest to fastest where in 00 is the slowest slew rate and 11 the 
/// fastest and drive strength spans between 1-6, 1 being the slowest and 6 the fastest. The DS9 
/// fields enable the Ethernet port on the hardware. The DS10 fields enable the Audio port in the 
/// hardware. The DS8 fields enable the SD/MMC port in the hardware.
/// \param SR9SlewRate Bit [0:1] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS9DriveStength Bit [2:4]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR10SlewRate Bit [5:6] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS10DriveStength Bit [7:9]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param SR11SlewRate Bit [10:11] : 00 = Slowest : 01 = Default : 10 = : 11 = Fastest
/// \param DS11DriveStength Bit [12:14]: 1 = Slowest : 2 = Default : 3 = : 4 = : 5 = : 6 = Fastest : Else = Invalid
/// \param Reserved Bit [15]: 
#define Q_SYS_CFG_SERIALIO_DRIVESTRENGTH_3          5 

/// \brief The GPIO pull-down parameter enables and disables the level for port 0. The pull-down sets all the GPIO_0 ports to a logical Low state. This state indicates usually indicates a start bit or start of transmission in any asynchronous serial communication protocol.
/// \param S7PDEn...S0PDEn Bit [0:7]: 0 = Pull-down is NOT enabled (default) : 1 = Pull-down is enabled
/// \param Reserved Bit [8:15]
/// \param Reserved Bit [16:31]
#define Q_SYS_CFG_SERIALIO_GPIO_0_PULLDOWN_ENABLE   6

/// \brief The GPIO pull-up parameter enables and disables the level for port 0. The pull-down sets all the GPIO_0 ports to a logical High state. 
/// This state indicates usually indicates the end  of communication  in any asynchronous serial communication protocol. 
/// This is done using weak pull-up resistors on the outputs of the ports.
/// \param S7PUEn...S0PUEn Bit [0:7]: 0 = Pull-up is NOT enabled (default) : 1 = Pull-up is enabled
/// \param Reserved Bit [8:15]
/// \param Reserved Bit [16:31]
#define Q_SYS_CFG_SERIALIO_GPIO_0_PULLUP_ENABLE     7

/// \brief The GPIO pull-down parameter enables and disables the level for port 1. The pull-down sets all the GPIO_1 ports to a logical Low state. This state indicates usually indicates a start bit or start of transmission in any asynchronous serial communication protocol.
/// \param S31PDEn...S0SPDEn Bit [0:31] : 0 = Pull-down is NOT enabled (default) : 1 = Pull-down is enabled
#define Q_SYS_CFG_SERIALIO_GPIO_1_PULLDOWN_ENABLE   9

/// \brief The GPIO pull-up parameter enables and disables the level for port 1. The pull-up sets all the GPIO_1 ports to a logical High state. This state indicates usually indicates the end of communication in any asynchronous serial communication protocol.
/// \param S31PUEn...S0SPUEn Bit [0:31] : 0 = Pull-up is NOT enabled (default) : 1 = Pull-up is enabled
#define Q_SYS_CFG_SERIALIO_GPIO_1_PULLUP_ENABLE     10

/// \brief The serial I/O GPIO parameter selects between the primary and GPIO functions.
///
/// S310S8 signals
/// \param S31GPIO1Sel...S0GPIO1Sel Bit [0:31] : 0 = Selects Primary/Alt function (default) : 1 = Selects GPIO function
#define Q_SYS_CFG_SERIALIO_GPIO_1_SEL               11

/// \brief The GPIO pull-down parameter enables and disables the level for port 2. The pull-down sets all the GPIO_2 ports to a logical Low state. This state indicates usually indicates a start bit or start of transmission in any asynchronous serial communication protocol.
/// \param S31PDEn...S0SPDEn Bit [0:31] : 0 =  PullDown is NOT enabled (default) : 1 = PullDown is Enabled 
#define Q_SYS_CFG_SERIALIO_GPIO_2_PULLDOWN_ENABLE   12

/// \brief The GPIO pull-up parameter enables and disables the level for port 2. The pull-up sets all the GPIO_2 ports to a logical High state. This state indicates usually indicates the end of communication in any asynchronous serial communication protocol.
/// \param S31PUEn...S0SPUEn Bit [0:31] : 0 =  PullUp is NOT enabled : 1 = PullUp is Enabled (default)
#define Q_SYS_CFG_SERIALIO_GPIO_2_PULLUP_ENABLE     13

/// \brief The serial I/O GPIO parameter selects between the primary and GPIO functions.
/// \param S31GPIO2Sel...S0GPIO2Sel Bit [0:31]: 0 = Select Primary/Alt Function (Default) : 1 = Selects GPIO Function
#define Q_SYS_CFG_SERIALIO_GPIO_2_SEL               14

/// \brief VIN0 can receive video sources from any of the four video channels, V0, V1, V2, and V3. It can also get video data from the VPU. The VIN1 control sets the corresponding source data, clocks, and the mode between HD and SD. Refer to table below.
/// \latexonly
/// \input{vin0control.tex}
/// \endlatexonly
#define Q_SYS_CFG_VIN0_CONTROL                      15

/// \brief VIN1 can receive video sources from any of the four video channels, V0, V1, V2, and V3. It can also get video data from the VPU. The VIN1 control sets the corresponding source data, clocks, and the mode between HD and SD. Refer to table below.
/// \latexonly
/// \input{vin1control.tex}
/// \endlatexonly
#define Q_SYS_CFG_VIN1_CONTROL                      16

/// \brief VOUT control is used to enable and disable the VOUT clock, and in to set the corresponding RGB mode.  Refer to table below.
/// \latexonly
/// \input{voutcontrol.tex}
/// \endlatexonly
#define Q_SYS_CFG_VOUT_CONTROL                      17

/// \brief This parameter controls the clock rate of the internal vidoe input pixel processing engine.  It does not
/// change any peripheral interface clocks.  It should not normally be changed from its default value.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_VPP0_CLOCK_HZ                     18 

/// \brief This parameter controls the clock rate of the internal video input pixel processing engine.  It does not
/// change any peripheral interface clocks.  It should not normally be changed from its default value.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_VPP1_CLOCK_HZ                     19 

/// \brief This parameter controls the clock rate of the internal video output pixel processing engine.  It does not
/// change any peripheral interface clocks.  It should not normally be changed from its default value.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_VPU_CLOCK_HZ                      20 

/// \brief This parameter changes the clock rate of the V0 pixel clock.  Typically this clock is not used as it
/// relates to a video input port.  Instead, the MG3500 normally slaves to an external video clock.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_V0_PIXEL_CLOCK_HZ                 21 

/// \brief This parameter changes the clock rate of the V0 pixel clock.  Typically this clock is not used as it
/// relates to a video input port.  Instead, the MG3500 normally slaves to an external video clock.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_V1_PIXEL_CLOCK_HZ                 22 

/// \brief This parameter changes the clock rate of the V2 pixel clock.  Since this clock relates to the video
/// output port, this clock is typically set to a value suitable for the video display device.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_V2_PIXEL_CLOCK_HZ                 23 

/// \brief This flag is used to internally invert the video clock in order to better meet peripheral timing
/// requirements
/// \param Enable 1 = invert, 0 = Do not invert
/// \param Bit    0 = Vin0 Clk
/// \param Bit    1 = Vin1 Clk
/// \param Bit    2 = Vout Clk
#define Q_SYS_CFG_VIDEO_INVERT_CONTROL              24 

/// \brief This parameter changes the clock rate for PLL2.  This clock is typically used to generate 
/// a video clock which is routed to video port 2.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_PLL2_CLOCK_HZ                     25 

/// \brief This parameter changes the clock rate for PLL3.  This clock is typically used to generate 
/// an audio clock which is routed to audio input and output (in case MG3500 masters both clocks).
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_PLL3_CLOCK_HZ                     26 

/// \brief The bitstream interface control register 0 is used to configure the high speed bitstream
/// port direction, timings, and protocol.
/// \param BSReqPol Bit 7: 0 for Active low (default) or 1 for active high
/// \param BSReqEn Bit 6: 0 for BS_REQ not generated or used (default) or 1 for generated or used
/// \param BSClkDrvEdge Bit 5: 0 for rising edge (default) or 1 for falling edge
/// \param BSClkSampEdge Bit 4: 0 for rising edge (default) or 1 for falling edge
/// \param BSClkDir Bit 3: 0 for input (default) or 1 for output
/// \param BSEnPol Bit 2: 0 for active high (default) or 1 for active low
/// \param BSDataDir Bit 1: 0 for Input (default) or 1 for output
/// \param BSIFEn Bit 0: 0 for disable (default) or 1 for enable
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_0     27

/// \brief The bitstream interface control register 2 is used to configure the high speed bitstream
/// port.
/// \param BSFlashTxEn Bit 7 : 0 to disable FIFO serializer when transmit disable (default) or 1 to enable
/// \param BSFlashRxEn Bit 6 : 0 to disable FIFO serializer when receive disable (default) or 1 to enable
/// \param BSClkEnMode Bit 5 : 0 Align clock enable to serial data out (default) or 1 to advance by one clock 
/// \param BSStopCond Bit 4 : 0 to stop on the current bit when BS_REQ is deasserted (default) (default) or 1 to stop at the end of the current byte
/// \param BSStrobeModeEn Bit 3 : 0 to operate in clock plus enable mode, 1 to operate in strobe mode
/// \param MSBFirst Bit 2 : 0 to send the LSB first, 1 to send the MSB first
/// \param BSThresh Bits 0-1 : Sets the threshold at which BS_REQ is asserted.  0 for 1 byte, 1 for 2 bytes (default), 2 for 3 bytes, or 3 for 4 bytes
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_2     28

/// \brief This parameter changes the clock rate for the internal media processing CPU.  It should
/// not normally be changed from the default.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_QMM_CLOCK_HZ                      29

/// \brief This parameter changes the clock rate for the AVC codec core.  It should
/// not normally be changed from the default.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_AVC_CLOCK_HZ                      30

/// \brief This parameter changes the clock rate for the first state motion estimation core.  It should
/// not normally be changed from the default.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_PME_CLOCK_HZ                      31

/// \brief This parameter changes the clock rate for the MPEG2 decoder core.  It should
/// not normally be changed from the default.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_MPEG2_CLOCK_HZ                    32

/// \brief This parameter changes the clock rate for the JPEG codec core.  It should
/// not normally be changed from the default.
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_JPEG_CLOCK_HZ                     33

/// \brief This parameter changes the clock rate for audio port 0.  
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_AUD0_CLOCK_HZ                     34

/// \brief This parameter changes the clock rate for audio port 1.  
/// \param Rate Clock rate in Hz
#define Q_SYS_CFG_AUD1_CLOCK_HZ                     35

#define Q_SYS_CFG_V0_PIXEL_CLOCK_FLAGS              36 
#define Q_SYS_CFG_V1_PIXEL_CLOCK_FLAGS              37 
#define Q_SYS_CFG_V2_PIXEL_CLOCK_FLAGS              38 

/// \brief This parameter must be initialized to 0xff for proper operation of the
/// high speed bitstream port.
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_4     39

/// \brief This parameter must be initialized to 0xff for proper operation of the
/// high speed bitstream port.
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_6     40

/// \brief This parameter controls the operation of the bitstream port
/// \param BSReqInSampleEn Bit 0 : This bit enables the sampling of the request pin as input
/// \param SyncModeEnable Bit 1 : Enables operation of sync mode 0
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_8     41

/// \brief This parameter controls the operation of the bitstream port
/// \param SMByteValue_l Bits 0-7 : Number of Valid Bytes after a sync in sync mode low
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_A     42

/// \brief This parameter controls the operation of the bitstream port
/// \param SMByteValue_h Bits 0-7 : Number of Valid Bytes after a sync in sync mode high
#define Q_SYS_CFG_BITSTREAM_INTERFACE_CONTROL_C     43

/// \brief This parameter controls the bitstream interface clock.  The core clock is
/// (typically 540Mhz) is fed into a high/low divider which can be used to reduce the 
/// clock rate as well as create non-50% duty cycles.
/// \param Clock enable Bit 18 : Clock enable
/// \param High divider Bits 17 - 9 : Controls the length of the clock when high
/// \param Low divider Bits 8 - 0 : Controls the length of the clock when low
#define Q_SYS_CFG_BITSTREAM_CLOCK_CONTROL           44

/// \brief This parameter is used to enable bitstream output using the high speed
/// bitstream port.
/// \param Enable 0 = disable, 1 = enable
#define Q_SYS_CFG_MUXER_HSBS_OUTPUT_ENABLE          45

/// \brief This parameter is used to set the size of the decoder memory partition.
/// This partition is used by all audio and video decoders to store compressed bit stream.
/// Therefore its size must be set to the sum of all decoders.
/// \param size in bytes.
#define Q_SYS_CFG_DECODER_INPUT_PARTITION_SIZE      46

/// \brief This parameter is used to switch AVC decode to have priority over AVC encode.
/// By default, encode runs at a higher priority.
/// \param 1 to enable decoder priority, 0 to disable.
#define Q_SYS_CFG_AVC_DECODE_PRIORITY               47

/// \brief This parameter is used to set how often events should be sent to the host
/// By default, batches of events will be sent to host every 10ms (10000us).
#define Q_SYS_CFG_EVENT_CYCLE_IN_USEC               48

/// \brief This parameter is used to enable the muxer to support gathering data from 
/// multiple stream in one buffer to send to the host
/// \param 0 to disable (default)
#define Q_SYS_CFG_MULTISTREAM_GATHER_BUFFER_SIZE    49

/// \brief This parameter controls the global software clock used to encode and decode
///        audio and video.  By default, the clock runs at 90,000 ticks per second.  An
///        NTSC frame at 29.97 frames per second has a length of 3003 clock ticks
///        (90000 / 29.97).  The clock should be changed to 120,000 ticks per second
///        to support 59.94 fps and 23.976 fps.  In this case, an NTSC frame has a length
///        of 4004 clock ticks.  Frequencies other than 90000 and 120000 should NOT be used.
///        NOTE that when this API is set to 120000, all clock tick parameters passed to the
///        firmware (for video input and output, for example) must be changed as well.
/// \param 90000 for default 90 KHz clock ticks, 120000 for 120 KHz
#define Q_SYS_CFG_PTS_PER_SECOND                    50

/// \brief This parameter is used to make Audio decode to have priority over Audio encode.
/// By default, decoder runs at a higher priority
/// \param 1 to enable decoder priority, 0 to disable
#define Q_SYS_CFG_AUD_DECODE_PRIORITY               51

/// \brief This parameter is used to control debug message.
//  By default, dlog is enable 
/// \param 1 to enable, 0 to disable
#define Q_SYS_CFG_DLOG_CONTROL                      52

/// \brief This parameter is used to enable the muxer to pack several ts packets 
/// together, 
/// \param 0 to disable (default)
#define Q_SYS_CFG_PACKETS_PACK_NUMBER               53

/// \brief This parameter is used to enable SHA hash function during encoding
/// \param 1 to enable, 0 to disable
#define Q_SYS_CFG_SHA_HASH_FUNCTION_ENABLE          54

/// \brief This parameter is used to set the SHA hash mode (valid only if 
///        Q_SYS_CFG_SHA_HASH_FUNCTION_ENABLE is set to 1
/// \param Q_SYS_CFP_HASH_FRAME_TYPE_[I_FRAME|EVERY_FRAME|GOP]
#define Q_SYS_CFG_SHA_HASH_MODE                     55

/// \brief This parameter is used to set the SHA hash algorithm (valid only if 
///        Q_SYS_CFG_SHA_HASH_FUNCTION_ENABLE is set to 1
/// \param Q_SYS_CFP_HASH_ALGORITHM_SHA[1|224|256]
#define Q_SYS_CFG_SHA_HASH_ALGORITHM                56

/// \brief This parameter is used to set the SHA hash frame type (valid only if 
///        Q_SYS_CFG_SHA_HASH_FUNCTION_ENABLE is set to 1
/// \param Q_SYS_CFP_HASH_MODE_[COMPLETE|PARTIAL]
#define Q_SYS_CFG_SHA_HASH_FRAME_TYPE               57

/// \brief This parameter is used to set the delay between pcr and pts in ts mux
/// \param is ms in ticks
#define Q_SYS_CFG_PCR_PTS_DELAY                     58



//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//

// Clock Flags - need to be same as hwclock.h
/// \brief This parameter sets the video pixel clock (V0, V1 or V2) to be input or output.
/// When the hardware starts up the clock is in input mode. Note this flag is reverse logic
/// and must be set if you want the clock in input mode.
#define Q_SYS_CFP_CLOCK_FLAG_INPUT                  2
/// \brief This parameter sets the video pixel output clock (V0 and V1 only) to be enabled or
/// disabled. When the hardware starts up the output clock is disabled. This flag needs to be
/// set to enable the output clock.
#define Q_SYS_CFP_CLOCK_FLAG_OUTPUT                 4

// Interleave Capture Sync Mode
// Generated from mediaware.h VPORT_CFG s/VPORT_CFG/Q_SYS_CFP_VPORT/
/// \brief This parameter sets the interleave capture frame sync mode to none.
#define Q_SYS_CFP_VPORT_SYNC_MODE_NONE               0
/// \brief This parameter sets the interleave capture frame sync mode to techwell 2x2 pixel format.
#define Q_SYS_CFP_VPORT_SYNC_MODE_TW                 1
/// \brief This parameter sets the interleave capture frame sync mode to mobilygen sync height format.
#define Q_SYS_CFP_VPORT_SYNC_MODE_MOBI               2
/// \brief This parameter sets the interleave capture frame sync mode to techwell 2880 sync format.
#define Q_SYS_CFP_VPORT_SYNC_MODE_TW2880             3
/// \brief This parameter sets the interleave capture frame sync mode to mobilygen pixel format 2.
#define Q_SYS_CFP_VPORT_SYNC_MODE_MOBI2              4
/// \brief This parameter sets the interleave capture frame sync mode to mobilygen pixel format 3.
#define Q_SYS_CFP_VPORT_SYNC_MODE_MOBI3              5

// Define hashed frame type
#define Q_SYS_CFP_HASH_FRAME_TYPE_NONE              0
#define Q_SYS_CFP_HASH_FRAME_TYPE_I_FRAME           1
#define Q_SYS_CFP_HASH_FRAME_TYPE_EVERY_FRAME       2
#define Q_SYS_CFP_HASH_FRAME_TYPE_GOP               3

// Define hash algorithm
#define Q_SYS_CFP_HASH_ALGORITHM_SHA224             0
#define Q_SYS_CFP_HASH_ALGORITHM_SHA256             1
#define Q_SYS_CFP_HASH_ALGORITHM_SHA1               4

// Define hash mode
#define Q_SYS_CFP_HASH_MODE_COMPLETE                0
#define Q_SYS_CFP_HASH_MODE_PARTIAL                 1

/// \}
#endif
