/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef __QSTATUS_HH 
#define __QSTATUS_HH

#ifndef __MEDIAWARE_H

#include "qglobal.h"

///////////////////////////////////////////////////////////////////////////////
// 
// Start status blocks

/// \brief Video input block structure.  This struct is contained within
/// the LVPP status block structure.
typedef struct
{
/// \brief Internal debug state variable.
    unsigned int       debug;
/// \brief Number of video input interrupts.
    unsigned int       interrupts;
/// \brief Most recent time between video interrupts (in usec)
    unsigned int       nowinttime;
/// \brief Maximum time between video interrupts (in usec)
    unsigned int       maxinttime;
/// \brief Minimum interrupt processing time (in usec)
    unsigned int       mintime;
/// \brief Average interrupt processing time (in usec)
    unsigned int       avgtime;
/// \brief Maximum interrupt processing time (in usec)
    unsigned int       maxtime;
/// \brief Number of synchronization errors in frame-interleaved mode.
    unsigned int       syncerror;
/// \brief Number of null-frames detected in frame-interleaved mode.
    unsigned int       nullframes;
/// \brief Sync value detected in frame-interleaved mode with Techwell Channel ID.
    unsigned int       twsync;
/// \brief Hardware processing time in non-live mode
    unsigned int       load_hw;
/// \brief Hardware idle time in non-live mode
    unsigned int       load_idle;
} VIN_STATUS;

/// \brief Audio input block structure.  
typedef struct
{
/// \brief Internal debug state variable.
    unsigned int       debug;
/// \brief Number of audio input interrupts.
    unsigned int       interrupts;
/// \brief Most recent time between audio interrupts (in usec)
    unsigned int       nowinttime;
/// \brief Maximum time between audio interrupts (in usec)
    unsigned int       maxinttime;
/// \brief Minimum interrupt processing time (in usec)
    unsigned int       mintime;
/// \brief Average interrupt processing time (in usec)
    unsigned int       avgtime;
/// \brief Maximum interrupt processing time (in usec)
    unsigned int       maxtime;
/// \brief Total number of captured audio frames
    unsigned int       framesCaptured;
/// \brief Total number of dropped frames due to capture failures (configuration error, missing interrupt etc.)
    unsigned int       captureFailures;
/// \brief Total number of dropped frames due to input buffer overflow
    unsigned int       captureOverflow;
/// \brief Sample numbers of an audio frame
    unsigned int       SampleNums; 
/// \brief rampup/rampdown time of audio input port (in msec)
    unsigned int       RampTime; 
} AIN_STATUS;

typedef struct
{
/// \brief Heartbeat for internal command processing thread
    int             heartbeat;
/// \brief Total number of events dropped due to slow host processing
    unsigned int    droppedEvents;
/// \brief Read/Write pointers into the event queue
    unsigned int    evReadWritePtrs;
/// \brief Flag indicating that an event has been sent to the host but no EVENT_DONE has been received
    int             pendingEvent;
/// \brief Number of bytes allocated from the pool of memory allocated to buffers
    unsigned int    allocatedPoolMemory;
/// \brief Maximum number of bytes available for buffer allocation
    unsigned int    totalPoolMemory;
/// \brief Total number of bytes allocated by processor 0
    unsigned int    heap0;
/// \brief Total number of bytes allocated by processor 1
    unsigned int    heap1;
/// \brief Maximum allowable heap size for each processor
    unsigned int    heapSize;
/// \brief Video input stats for video port 0 and 1
    VIN_STATUS      vinStatus[2];
/// \brief Audio input stats for audio port 0 and 1
    AIN_STATUS      ainStatus[2];
/// \brief Load average for the firmware's AVC encoder software control thread
    unsigned int    loadAVCEncSW;
/// \brief Load average for the firmware's AVC decoder software control thread
    unsigned int    loadAVCDecSW;
/// \brief Load average for the firmware's AVC encoder h/w block control thread
    unsigned int    loadAVCEncHW;
/// \brief Load average for the firmware's AVC decoder h/w block control thread
    unsigned int    loadAVCDecHW;
/// \brief Clock frequency for input clock (typically 12 or 27Mhz)
    unsigned int    XINClockHz;
/// \brief Clock frequency for PLL0
    unsigned int    PLL0ClockHz;
/// \brief Clock frequency for PLL1 (use for memory bus)
    unsigned int    PLL1ClockHz;
/// \brief Clock frequency for PLL2 (typically used for video I/O)
    unsigned int    PLL2ClockHz;
/// \brief Clock frequency for PLL3 (typically used for audio I/O)
    unsigned int    PLL3ClockHz;
/// \brief Clock frequency for pixel processing in VPP0.  Note that this is not an I/O clock but an internal clock that runs faster than the I/O clock.
    unsigned int    VPP0ClockHz;
/// \brief Clock frequency for pixel processing in VPP1.  Note that this is not an I/O clock but an internal clock that runs faster than the I/O clock.
    unsigned int    VPP1ClockHz;
/// \brief Clock frequency for pixel processing in the VPU.  Note that this is not an I/O clock but an internal clock that runs faster than the I/O clock.
    unsigned int    VPUClockHz;
/// \brief Clock rate in Hz of the V0 pixel clock.  This is an I/O clock.
    unsigned int    V0PixelClockHz;
/// \brief Clock rate in Hz of the V1 pixel clock.  This is an I/O clock.
    unsigned int    V1PixelClockHz;
/// \brief Clock rate in Hz of the V2 pixel clock.  This is an I/O clock.
    unsigned int    V2PixelClockHz;
/// \brief Clock rate in Hz of the interal media processors.
    unsigned int    QMMClockHz;
/// \brief Clock rate in Hz of the AVC codec block.
    unsigned int    AVCClockHz;
/// \brief Clock rate in Hz of the PME motion-estimation block.
    unsigned int    PMEClockHz;
/// \brief Clock rate in Hz of the MPEG2 decoder block.
    unsigned int    MPEG2ClockHz;
/// \brief Clock rate in Hz of the JPEG codec block.
    unsigned int    JPEGClockHz;
/// \brief Clock rate in Hz of the AUD0 master clock.  This is an I/O clock.
    unsigned int    Aud0ClockHz;
/// \brief Clock rate in Hz of the AUD1 master clock.  This is an I/O clock.
    unsigned int    Aud1ClockHz;
/// \brief Load average for the audio encoder thread
    unsigned int    loadAudEnc;
/// \brief Load average for the audio decoder thread
    unsigned int    loadAudDec;
/// \brief Load average for the firmware's mux thread
    unsigned int    loadMux;
} SYSTEM_CONTROL_STATUS;

typedef struct
{
/// \brief Internal debug variable
    unsigned int       vdebug;
/// \brief Total number of video output interrupts
    unsigned int       vinterrupts;
/// \brief Maximum time between video interrupts (in usec)
    unsigned int       vinttimemax;
/// \brief Minimum video interrupt processing time
    unsigned int       vmintime;
/// \brief Average video interrupt processing time
    unsigned int       vavgtime;
/// \brief Maximum video interrupt processing time
    unsigned int       vmaxtime;
/// \brief Minimum video rendering time (composition mode only)
    unsigned int       vminrend;
/// \brief Average video rendering time (composition mode only)
    unsigned int       vavgrend;
/// \brief Maximum video rendering time (composition mode only)
    unsigned int       vmaxrend;
/// \brief Total number of times the display buffer has been rendered (composition mode only)
    unsigned int       vrendcount;
/// \brief Minimum video display latency
    unsigned int       vminlatency;
/// \brief Average video display latency
    unsigned int       vavglatency;
/// \brief Maximum video display latency
    unsigned int       vmaxlatency;
/// \brief Total number of audio frames output
    unsigned int       audOutputCount;
/// \brief 32MSB of the PTS of the most recently output audio frame
    unsigned int       aoutPTSHi;
/// \brief 32LSB of the PTS of the most recently output audio frame
    unsigned int       aoutPTSLo;
/// \brief Most recent time between video interrupts (in usec)
    unsigned int       vinttimenow;
/// \brief Number of frames not rendered in time (composition mode only)
    unsigned int       vrendlate;
} AVOC_STATUS;

/// \brief AVSN status block
typedef struct
{
/// \brief Total number of video frames displayed
    unsigned int vidOutputCount;
/// \brief 32MSB of the PTS of the most recently displayed video frame
    unsigned int voutPTSHi;
/// \brief 32LSB of the PTS of the most recently displayed video frame
    unsigned int voutPTSLo;
/// \brief Total number of video frames dropped due to synchronization
    unsigned int framesDropped;
/// \brief Total number of video frames repeated due to synchronization
    unsigned int framesRepeated;
/// \brief Total number of video frames currently queued for display
    unsigned int videoQueued;
/// \brief Total number of audio frames currently queued for display
    unsigned int audioQueued;
/// \brief Audio underflows (no frame was available to play)
    unsigned int audioUnderflows;
/// \brief Video underflows (no frame was available to display)
    unsigned int videoUnderflows;
/// \brief Measured audio latency for the most recent frame
    unsigned int audioLatency;
/// \brief Audio resampling ratio used for latency control
    unsigned int audioResampleRatio;
/// \brief Measured video latency for the most recent frame, in fixed latency mode
    unsigned int videoLatency;
/// \brief Video resampling ratio used for latency control
    unsigned int videoResampleRatio;
/// \brief Measured mininum audio latency for the most recent frame
    unsigned int audioLatencyMin;
/// \brief Measured maximum audio latency for the most recent frame
    unsigned int audioLatencyMax;
/// \brief Measured mininum video latency for the most recent frame
    unsigned int videoLatencyMin;
/// \brief Measured maximum video latency for the most recent frame
    unsigned int videoLatencyMax;
} AVSN_STATUS;

/// \brief CameraTamper status block
typedef struct
{
/// \brief frame number of the frames that are passed through the camera tamper block
    unsigned int	tamperFrame;	
/// \brief edge threshold set for triggering out of focus detection    
    unsigned int 	tamperEdgeThd;
/// \brief variance threshold set for triggering block detection    
    unsigned int 	tamperVarThd;
/// \brief luma threshold set for triggering field of view change detection    
    unsigned int 	tamperLumaThd;
/// \brief processed edge measurement compared to edge threshold     
    unsigned int 	tamperEdgeComp;
/// \brief processed variance measurement compared to variance threshold     
    unsigned int 	tamperVarComp;
/// \brief processed luma measurement compared to luma threshold     
    unsigned int 	tamperLumaComp;
} TAMPER_STATUS;

/// \brief LVPP and NVPP status block
typedef struct
{
/// \brief Total number of captured video frames
    unsigned int        framesCaptured;
/// \brief Total number of dropped frames due to capture failures (configuration error, missing interrupt etc.)
    unsigned int        captureFailures;
/// \brief Total number of dropped frames due to input buffer overflow
    unsigned int        captureOverflow;
/// \brief Total number of frames dropped due to A/V synch
    unsigned int        avsynchDrops;
/// \brief Total number of frames repeated due to A/V synch
    unsigned int        avsynchRepeats;
/// \brief PTS of the most recently output frame (32 MSBs)
    unsigned int        outputPTS_High;
/// \brief PTS of the most recently output frame (32 LSBs)
    unsigned int        outputPTS_Low;
/// \brief Total number of input frames decimated
    unsigned int        inputDrops;
/// \brief Destination picture width
    unsigned int        destWidth;
/// \brief Destination picture height
    unsigned int        destHeight;
/// \brief Minimum video frame transit time (NVPP Only)
    unsigned int        mintime;
/// \brief Average video frame transit time (NVPP Only)
    unsigned int        avgtime;
/// \brief Maximum video frame transit time (NVPP Only)
    unsigned int        maxtime;
/// \brief camera tamper data 
    TAMPER_STATUS       tamperStatus;
} VPP_STATUS;


/// \brief AVDecoder status block
typedef struct
{
/// \brief Number of video frames decoded since start()
    unsigned int videoFramesDecoded;
/// \brief Number of audio frames decoded since start()
    unsigned int audioFramesDecoded;
/// \brief Number of video decoder errors detected since start()
    unsigned int videoDecodeErrors;
/// \brief Number of audio decoder errors detected since start()
    unsigned int audioDecodeErrors;
/// \brief Number of video frames dropped since start()
    unsigned int videoFramesDropped;
/// \brief Number of total video frames since start()
    unsigned int totalVideoFrames;
/// \brief Width of the most recently decoded video frame (pixels)
    unsigned int videoFrameWidth;
/// \brief Height of the most recently decoded video frame (pixels)
    unsigned int videoFrameHeight;
/// \brief 32 MSB of the PTS of the most recently demuxed video QBOX
    unsigned int vdmxPTSHi;
/// \brief 32 LSB of the PTS of the most recently demuxed video QBOX
    unsigned int vdmxPTSLo;
/// \brief 32 MSB of the PTS of the most recently demuxed audio QBOX
    unsigned int admxPTSHi;
/// \brief 32 LSB of the PTS of the most recently demuxed audio QBOX
    unsigned int admxPTSLo;
/// \brief 32 MSB of the PTS of the most recently decoded video frame
    unsigned int vdecPTSHi;
/// \brief 32 LSB of the PTS of the most recently decoded video frame
    unsigned int vdecPTSLo;
/// \brief 32 MSB of the PTS of the most recently demuxed audio frame
    unsigned int adecPTSHi;
/// \brief 32 LSB of the PTS of the most recently demuxed audio frame
    unsigned int adecPTSLo;
/// \brief Fullness of the video decoder input buffer (bytes)
    unsigned int vdecInputOccupancyBytes;
/// \brief Maximum size of the video decoder input buffer (bytes)
    unsigned int vdecInputBufferSizeBytes;
/// \brief Fullness of the video decoder input buffer (access units)
    unsigned int vdecInputOccupancyAus;
/// \brief Maximum size of the video decoder input buffer (access units)
    unsigned int vdecInputBufferSizeAus;
/// \brief Fullness of the audio decoder input buffer (bytes)
    unsigned int adecInputOccupancyBytes;
/// \brief Maximum size of the audio decoder input buffer (bytes)
    unsigned int adecInputBufferSizeBytes;
/// \brief Fullness of the audio decoder input buffer (access units)
    unsigned int adecInputOccupancyAus;
/// \brief Maximum size of the audio decoder input buffer (access units)
    unsigned int adecInputBufferSizeAus;
/// \brief The amount of time it takes to decode an I frame
    unsigned int vdecIFramePerf;
/// \brief The amount of time it takes to decode a P frame
    unsigned int vdecPFramePerf;
/// \brief The amount of time it takes to decode a B frame
    unsigned int vdecBFramePerf;
/// \brief Instantaneous frame frame, actually it's the average frame rate calculated between 2 queries.
    float vdecFrameRate;
/// \brief Fullness of the video decoder output buffer (frames)
    unsigned int vdecOutputOccupancyFrames;
/// \brief Maximum size of the video decoder output buffer (frames)
    unsigned int vdecOutputBufferSizeFrames;
/// \brief Video decoder debug state.  This is for debuggin purposes only, decoder is not making use of this state 
    int vdecState;
/// \brief Last error detected by video decoder.
    int vdecLastError;
/// \brief PTS of the frame where vdecLastError is detected
    unsigned int vdecLastErrorPTSHi;
    unsigned int vdecLastErrorPTSLo;
/// \brief Minimum video frame delta DEMUX
    unsigned int vdecMinOutputDeltaDMX;
/// \brief Maximum video frame delta DEMUX
    unsigned int vdecMaxOutputDeltaDMX;
/// \brief Minimum audio frame delta DEMUX
    unsigned int adecMinOutputDeltaDMX;
/// \brief Maximum audio frame delta DEMUX
    unsigned int adecMaxOutputDeltaDMX;
/// \brief Minimum video frame delta DECODE
    unsigned int vdecMinOutputDeltaDEC;
/// \brief Maximum video frame delta DECODE
    unsigned int vdecMaxOutputDeltaDEC;
/// \brief Minimum audio frame delta DECODE
    unsigned int adecMinOutputDeltaDEC;
/// \brief Maximum audio frame delta DECODE
    unsigned int adecMaxOutputDeltaDEC;
} AVDEC_STATUS;

/// \brief AVC Encoder debug state
typedef enum
{
/// \brief AVC decoder idle state(for debug only.)  AVC decoder is waiting to be called by the master thread.
    AVCDEC_CODEC_IDLE = 0,
/// \brief AVC decoder QBOX parsing state(for debug only.)  AVC decoder is parsing qboxes.  This state only exists for direct memory transfer mode.
    AVCDEC_CODEC_PARSING_QBOXES,
/// \brief AVC decoder Header Parsing state(for debug only.)  AVC decoder is pre-parsing NALU headers.
    AVCDEC_CODEC_PARSING_HEADERS,
/// \brief AVC decoder's Decoding state(for debug only.)  AVC decoder is decoding a frame, this is done by the worker thread
    AVCDEC_CODEC_DECODING,
/// \brief AVC decoder's VCIF state(for debug only.)  AVC decoder is waiting for hardware to finish decoding. This is done by the worker thread.
    AVCDEC_CODEC_VCIF,
/// \brief AVC decoder's Decoding operation is done, waiting for main thread to update DPB and output.
    AVCDEC_CODEC_UPDATE_DPB,
/// \brief AVC decoder's Waiting for Input state(for debug only.)  Input buffer is empty, AVC decoder is waiting for more input data.
    AVCDEC_CODEC_WAITING_FOR_INPUT,
/// \brief AVC decoder's Waiting for Output state(for debug only.)  Output buffer is full, AVC decoder is waiting for space in output buffer.
    AVCDEC_CODEC_WAITING_FOR_OUTPUT,
/// \brief AVC decoder is flushing its buffers.  Flushing is similar to decoding except that decoder will stop after it finishes this frame. 
    AVCDEC_CODEC_FLUSHING,
} AVCDEC_CODEC_STATE;

/// \brief AVC Encoder status block
/// \ingroup avcencgroup
typedef struct
{
/// \brief Time to encode I/P/B frames in microseconds
    unsigned int performance[3];
/// \brief Number of encoded I/P/B frames that has performance below target
    unsigned int performanceJitter[3];
/// \brief Count of numer of frames encoded
    unsigned int framesEncoded;
/// \brief Debug state of the object
    unsigned int state;
/// \brief Encoder latency measured from start of capture to bitstream output
    unsigned int latency;
/// \brief Current fullness in bytes of the bitstream output buffer
    unsigned int bufferFullness;
/// \brief Size of the bitstream output buffer
    unsigned int bufferSize;
/// \brief Highest maximum fullness reached during this encode session
    unsigned int bufferMaxFullness;
/// \brief Current picture level quantizer selected by rate control
    unsigned int baseQP;
/// \brief Number of frames input to the encoder
    unsigned int inputFrames;
/// \brief Number of frames dropped due to insufficient reference frames or bitstream space
    unsigned int inputFrameDrops;
/// \brief Number of frame drops initiated by rate control
    unsigned int rateControlFrameDrops;
/// \brief Number of field drops initiated by inverse telecine
    unsigned int telecineFieldDrops;
/// \brief Address of the most recent bitstream block acknowledged by the host
    unsigned int lastBlockDoneAddr;
/// \brief Size of the most recent bitstream block acknowledged by the host
    unsigned int lastBlockDoneSize;
/// \brief Address of the most recent bitstream block sent to the host
    unsigned int lastBlockReadyAddr;
/// \brief Size of the most recent bitstream block sent to the host
    unsigned int lastBlockReadySize;
/// \brief Number of slices which have exceeded the maximum NALU size
    unsigned int nalusExceedLimit;
/// \brief Number of frames which have had their quantizer overridden by the frame complexity algorithm
    unsigned int complexityRCOverride;
/// \brief PTS of the currently encoding frame.  May move backwards in the case of B frames.  32 LSBs.
    unsigned int currentPTS_High;
/// \brief 32 MSBs of the PTS of the currently encoding frame.
    unsigned int currentPTS_Low;
///  \brief Y distortion
    unsigned int distortion;
/// \brief Internal frame buffers used
    unsigned int refPoolUsed;
/// \brief Reconstructed frame preview frames dropped due to overflow
    unsigned int reconPreviewOverflows;
/// \brief instantaneous frame rate
    float        frameRate;
/// \brief Buffer for generic debug data
    unsigned int debugBufferAddress;
/// \brief Number of bytes in debug buffer
    unsigned int debugBufferFullness;
/// \brief Minimum frame output delta ENCODER
    unsigned int minOutputDeltaENC;
/// \brief Maximum frame output delta ENCODER
    unsigned int maxOutputDeltaENC;
/// \brief Minimum frame output delta SYSTEM
    unsigned int minOutputDeltaSYS;
/// \brief Maximum frame output delta SYSTEM
    unsigned int maxOutputDeltaSYS;
/// \brief Signature of the frame
    unsigned int signature;
} AVCENC_STATUS;

typedef struct
{
/// \brief Total number of video frames captured
    unsigned int framesCaptured;
/// \brief Total number of times the capture object failed to obtain an empty frame buffer
/// from the datapath buffer pool
    unsigned int getTokenFailures;
} HVCAP_STATUS;

/// \brief Audio Encoder status block
typedef struct
{
/// \brief Count of numer of frames encoded
    unsigned int framesEncoded;
/// \brief Debug state of the object
    unsigned int state;
/// \brief Encoder latency measured from start of capture to bitstream output
    unsigned int latency;
/// \brief Current fullness in bytes of the bitstream output buffer
    unsigned int bufferFullness;
/// \brief Size of the bitstream output buffer
    unsigned int bufferSize;
/// \brief Number of frames input to the encoder
    unsigned int inputFrames;
/// \brief Number of frames dropped due to insufficient reference frames or bitstream space
    unsigned int inputFrameDrops;
/// \brief Minimum frame output delta ENCODER
    unsigned int minOutputDeltaENC;
/// \brief Maximum frame output delta ENCODER
    unsigned int maxOutputDeltaENC;
/// \brief Minimum frame output delta SYSTEM
    unsigned int minOutputDeltaSYS;
/// \brief Maximum frame output delta SYSTEM
    unsigned int maxOutputDeltaSYS;
/// \brief The lower 32-bits of the PTS of the last encoded frame.
    unsigned int currentPTS_Low;
/// \brief The higher 32-bits of the PTS of the last encoded frame.
    unsigned int currentPTS_High;
} AUDIOENC_STATUS;

/// \brief Audio Splitter status block
typedef struct
{
/// \brief Input AIN port index
    unsigned int inPortIdx;
/// \brief Number of output ports defined
    unsigned int numOutputPorts;
/// \brief Number of frames processed
    unsigned int numFrames;
/// \brief Number of frames dropped
    unsigned int framesDropped;
} ASPLIT_STATUS;

/// \brief JPEG Encoder status block
typedef struct
{
/// \brief encoder index
    int id;
/// \brief encoder state
    int state;
/// \brief Number of input DATA tokens dequeued from data-queue
    unsigned int inDataTokens;
/// \brief Number of frames encoded
    unsigned int framesEncoded;
/// \brief Number of input DATA tokens dropped
    unsigned int inDataTokensDropped;
/// \brief Quality factor used in the last encoded frame
    unsigned int lastQualityFactor;
/// \brief Size of last encoded frame, in bytes
    unsigned int lastFrameSize;
/// \brief Total size of all encoded frames
    unsigned int totalFrameSize;
/// \brief The lower 32-bits of the PTS of the last encoded frame.
    unsigned int PTS_low;
/// \brief The higher 32-bits of the PTS of the last encoded frame.
    unsigned int PTS_high;
/// \brief Time from the moment of notify to removal from data-queue for encoding 
    unsigned int inputTokenStandbyTime;
/// \brief Software setup time for the last encoded frame, in us
    unsigned int SWSetupTime;
/// \brief Time taken for sending HW instructions and waiting for encode done ISR
    unsigned int HWEncodeTime;
/// \brief Input DATA Queue occupancy
    unsigned int inputDQueLen;
/// \brief Input DATA Queue Availability
    unsigned int inputDQueAva;
/// \brief Input DATA Queue overflows counter
    unsigned int inputDQueOverflow;
/// \brief Output buffer size
    unsigned int outputBufferSize;
/// \brief Output buffer fullness
    unsigned int outputBufferFullness;
/// \brief Counts all downstream overflows
    unsigned int downstreamOverflows;
/// \brief Counts current downstream overflows
    unsigned int downstreamOverflowsCur;
/// \brief Encoder's own status
    int encStatus;
/// \brief Encoder's master ISR's status
    int isrStatus;
/// \brief Minimum quality factor allowed by the bitrate controller
    unsigned int minQF;
/// \brief Maximum quality factor allowed by the bitrate controller
    unsigned int maxQF;
/// \brief Current bitrate
    unsigned int currBitrate;
/// \brief Num of frames encoded since the last bitrate reset
    unsigned int recentFramesEncoded;
/// \brief Total frames size since the last bitrate reset
    unsigned int recentFramesSize;
} JPEGENC_STATUS;

/// \brief Host audio capture status block
typedef struct
{
/// \brief Stream ID
    unsigned int streamID;
/// \brief Total number of video frames captured
    unsigned int framesCaptured;
/// \brief Total number of times the capture object failed to obtain an empty frame buffer
/// from the datapath buffer pool
    unsigned int getTokenFailures;
} HACAP_STATUS;

/// \brief Audio Filter status block
typedef struct
{
/// \brief filter stream ID
    int streamID;
/// \brief filter state
    int state;
/// \brief the last notified interrupt type
    int lastInterrupt;
/// \brief number of connected input ports
    int inputPorts;
/// \brief number of output ports
    int outputPorts;
/// \brief number of input frames received in current round
    int recvFramesThisRound;
/// \brief number of rounds of successfully received input tokens from input ports
    int inFramesRound;
/// \brief number of output frames sent in current round
    int sentFramesThisRound;
/// \brief number of rounds of successfully sent output tokens to output ports
    int outFramesRound;
/// \brief current number of buffer full occurances; reset every time buffer space is available
    int currBufferFullCount;
/// \brief total number of buffer full occurances since filter started
    int totalBufferFullCount;
} AUDFLTR_STATUS;

// End status block


#endif
#endif
