/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef __QHAOUT_HH
#define __QHAOUT_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//
#define Q_HAOUT_CMD_START                   1
#define Q_HAOUT_CMD_STOP                    2
#define Q_HAOUT_CMD_FLUSH                   3
#define Q_HAOUT_CMD_BIND_INPUT              4
#define Q_HAOUT_CMD_UNBIND_INPUT            5
#define Q_HAOUT_CMD_FRAME_RELEASE           6

#define Q_HAOUT_MAX_CMD                     7

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 
typedef struct
{
    int objID;
    int portType;
} STRUCT_Q_HAOUT_CMD_BIND_INPUT;

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//


//////////////////////////////////////////////////////////////////////
//
// Events
//
#define HAOUT_EVENT(ID) ((HAOUT_CTRLOBJ_TYPE << 16) | ID)

#define Q_HAOUT_EV_BITSTREAM_BLOCK_READY  HAOUT_EVENT(1)
#define Q_HAOUT_EV_BITSTREAM_FLUSHED      HAOUT_EVENT(2)

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        addr;
    unsigned int        size;
    unsigned int        type; 
} STRUCT_Q_HAOUT_EV_BITSTREAM_BLOCK_READY;

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
} STRUCT_Q_HAOUT_EV_BITSTREAM_FLUSHED;


//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//


//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//


//////////////////////////////////////////////////////////////////////
//
// Status block
//
typedef struct
{
#ifdef _WIN32
    int dummy;
#endif
} HAOUT_STATUS;

#endif
