/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef __QHACAP_HH
#define __QHACAP_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//

/// \brief This command starts the HACAP block.
/// \param startFrameID The frame number of the first frame that needs to be captured
/// \return Code:  1 = Success, 0 = Failure
#define Q_HACAP_CMD_START                   1
/// \brief This command flushes and releases all the unfinished frames
/// \return Code:  1 = Success, 0 = Failure
#define Q_HACAP_CMD_FLUSH                   2
/// \brief This command notifies codec that the host is done writing a frame
/// \param frameID Frame number of the captured frame
/// \return Code:  1 = Success, 0 = Failure
#define Q_HACAP_CMD_FRAME_WRITTEN           3
/// \brief The command sets up a configuration parameter, which will be activated
/// through the Q_HACAP_CMD_ACTIVATE_CFG command.
/// \param param Parameter index
/// \param value Parameter value
/// \return Code:  1 = Success, 0 = Failure
#define Q_HACAP_CMD_SET_PARAM               4
/// \brief This command enables all modified configuration parameters since the last
/// activate command.
/// \return Code:  1 = Success, 0 = Failure
#define Q_HACAP_CMD_ACTIVATE_CFG            5
/// \brief This command stops the HACAP block and reset its parameters.
/// \return Code:  1 = Success, 0 = Failure
#define Q_HACAP_CMD_STOP                    6

#define Q_HACAP_MAX_CMD                     7

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 

typedef struct
{
    unsigned int startFrameID;
} STRUCT_Q_HACAP_CMD_START;

typedef struct
{
    unsigned int param;
    int value;
} STRUCT_Q_HACAP_CMD_SET_PARAM;

typedef struct
{
    unsigned int frameID;
} STRUCT_Q_HACAP_CMD_FRAME_WRITTEN;


//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//

//////////////////////////////////////////////////////////////////////
//
// Events
//
#define HACAP_EVENT(ID) ((HACAP_CTRLOBJ_TYPE << 16) | ID)

#define Q_HACAP_EV_FRAME_AVAILABLE  HACAP_EVENT(1)
#define Q_HACAP_EV_FLUSHED          HACAP_EVENT(2)

typedef struct
{
    unsigned int        streamID;
    unsigned int        frameID;
    unsigned int        address;
} STRUCT_Q_HACAP_EV_FRAME_AVAILABLE;

typedef struct
{
    unsigned int        streamID;
} STRUCT_Q_HACAP_EV_FLUSHED;


//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
// Generated from mediaware.h HACAP_CFG s/HACAP_CFG/Q_HACAP_CMP/
/// \brief Audio sample rate
/// \param value Integer number.
#define Q_HACAP_CMP_SAMPLE_RATE                      0
/// \brief Number of audio channels
/// \param value 1 = Mono, 2 = Stereo
#define Q_HACAP_CMP_NUM_CHANNELS                     1
/// \brief Number of samples per channel in a frame
/// \param value Integer number.
#define Q_HACAP_CMP_NUM_SAMPLES                      2
/// \brief Number of bits in a sample
/// \param value Integer number.
#define Q_HACAP_CMP_SAMPLE_SIZE                      3
/// \brief Indicates the endianess of the source file
/// \param value 0 = little endian, 1 = big endian
#define Q_HACAP_CMP_ENDIANESS                        4



//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//

#define Q_HACAP_CFP_CHANNEL_MONO                     1
#define Q_HACAP_CFP_CHANNEL_STEREO                   2

#define Q_HACAP_CFP_LITTLE_ENDIAN                    0
#define Q_HACAP_CFP_BIG_ENDIAN                       1


#endif
