/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup AudioVideoSynchronizerControlObject Audio/Video Synchronizer
/// \{

/// \page avsn Audio/Video Synchronizer
/// \latexonly
/// \chapter{Audio/Video Synchronizer}
/// \input{avsn}
/// \endlatexonly
///
/// \section avsnstatus Status Block
///
/// The AudioVideoSynchronizer status block contains information related to state and performance.
/// \latexonly
/// \input{structAVSN__STATUS}
/// \endlatexonly



#ifndef __QAVSN_HH
#define __QAVSN_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//

/// \brief This command starts the AVSN and allows frames to be sent to
/// the downstream AVOC.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_START                    1

/// \brief This command starts the AVSN and allows frames to be sent to
/// the downstream AVOC.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_STOP                     2

/// \brief Sets a parameter entry in the double buffered parameter set.
/// \param param Parameter index to change 
/// \param value Parameter value to set
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_SET_PARAM                3

/// \brief This command activates all pending parameter changes in the double buffered
/// set
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_ACTIVATE_CFG             4

/// \brief This command binds the AVSN to an upstream producer of either 4:2:0, 4:2:2,
/// raw or pre-processed video frames.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_BIND_VIDEO_INPUT         5

/// \brief This command unbinds the currently bound video source.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_UNBIND_VIDEO_INPUT       6

/// \brief This command binds the AVSN to an upstream producer of either 4:2:0, 4:2:2,
/// raw or pre-processed video frames.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_BIND_AUDIO               7

/// \brief This command unbinds the currently bound video source.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_UNBIND_AUDIO             8

/// \brief This command is not supported at this time.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_SET_CLOCK                9

/// \brief This command is not supported at this time.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_ENABLE_NETWORK_SYNC      10

/// \brief This commands pauses the AVSN causing the most recently displayed frame
/// to continue to display
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_PAUSE                    11

/// \brief This command resumes the AVSN from the PAUSE state (which was entered due
/// to the PAUSE or SINGLESTEP command), or resumes normal rate playback from
/// slow-motion.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_RESUME                   12

/// \brief This command changes the playback rate of the AVSN and inhibits the 
/// playback of audio.
/// \param speed Slow-motion rate (2 for 1/2, 4 for 1/4 etc.)
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_SLOW                     13

/// \brief This command advances the display by one frame after which the AVSN
/// enters the PAUSE state.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_FWD_STEP                 14

/// \brief This command forces playback of I-frames only for a specified 
/// multiple of frame times.
/// \param duration Number of frame times to display each frame
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_IFRAME_SCAN              15

/// \brief This command changes the playback rate of the AVSN and inhibits the 
/// playback of audio.
/// \param speed Fast-motion rate (2 for 2, 4 for 4 etc.)
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_FAST                     16

/// \brief This command resets the minimum and maximum stats reported in query.
/// \return 1 for success, 0 for failure
#define Q_AVSN_CMD_RESET_MIN_MAX            17

/// \brief This command enable the NTP sync modes to playback encoded bitstream with
/// NTP timestamps. This command will also set several parameters to customize the
/// timings of the playback. The offset paramters will determine whether the playback
/// is delayed or skipped. For example, if a bitstream is recorded 1000 seconds ago
/// for 500 seconds and we want to playback the bitstream at this moment, the offset 
/// parameters should be set to 1000 seconds. Setting the offset to 1002 seconds will
/// delay the playback by 2 seconds but the entire 500 seconds of content of the bitstream 
/// will still be presented. An offset value of 998 will skip the initial
/// 2 seconds content of the bitstream and only the last 498 seconds of content will
/// be presented.
/// To make it easier for applications to deal with the offset settings, this command
/// provides several "automatic" options. If the "auto" parameter is enabled, this
/// command will calculate the proper offset internally. In addition, there're 3
/// automatic modes:
/// Q_AVSN_NTP_AUTO_MODE_INSTANT (0): Playback instantly. Offset paramters are ignored.
/// Q_AVSN_NTP_AUTO_MODE_DELAY   (1): Playback is delayed. Amount of delay is set by
///                                   the offset paramters.
/// Q_AVSN_NTP_AUTO_MODE_SKIP    (2): Initial part of the bitstream content is skipped.
///                                   Amount of content skipped is set by the offset 
///                                   parameters. Note: During the "skipping" phase no
///                                   content is presented. So there may be a waiting period
///                                   before the first non-skip content is presented.
/// \param enable 1 to enable NTP sync, 0 to disable
/// \param auto 1 to enable the automatic options, 0 to disable
/// \param autoMode Q_AVSN_NTP_AUTO_MODE_INSTANT, Q_AVSN_NTP_AUTO_MODE_DELAY, or
///                 Q_AVSN_NTP_AUTO_MODE_SKIP
/// \param offsetSec Offset values in seconds. This value adds with offsetUSec to produce
///                  the total offset.
/// \param offsetUSec Offset values in microseconds. This value adds with offsetSec to
///                   produce total offset.
#define Q_AVSN_CMD_ENABLE_NTP_SYNC          18

#define Q_AVSN_MAX_CMD                      19

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 
typedef struct
{
    unsigned int param;
    int value;
} STRUCT_Q_AVSN_CMD_SET_PARAM;

typedef struct
{
    int objID;
    int portType;
} STRUCT_Q_AVSN_CMD_BIND_INPUT;

typedef struct
{
    unsigned int value;
} STRUCT_Q_AVSN_CMD_SET_CLOCK;

typedef struct
{
    unsigned int enable;
} STRUCT_Q_AVSN_CMD_ENABLE_NETWORK_SYNC;

typedef struct
{
    unsigned int speed;
} STRUCT_Q_AVSN_CMD_SLOW;

typedef struct
{
    unsigned int speed;
} STRUCT_Q_AVSN_CMD_FAST;

typedef struct
{
    unsigned int nFrameTime;
} STRUCT_Q_AVSN_CMD_IFRAME_SCAN;

typedef struct
{
    int enable;
    int automatic;
    int autoMode;
    unsigned int offsetSec;
    unsigned int offsetUSec;
} STRUCT_Q_AVSN_CMD_ENABLE_NTP_SYNC;

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//

// Parameters for used with Q_AVSN_CMD_BIND_VIDEO_INPUT and Q_AVSN_CMD_BIND_AUDIO_INPUT
#define Q_AVSN_CMP_SOME_PARAMETER                    1

//////////////////////////////////////////////////////////////////////
//
// Events
//
#define AVSN_EVENT(ID) ((AVSN_CTRLOBJ_TYPE << 16) | ID)

/// \brief The audio presentation start event indicates that the first audio frame
///        has been played back following the Start command.
#define Q_AVSN_EV_AUDIO_PRESENTATION_START      AVSN_EVENT(1)

/// \brief The video presentation start event indicates that the first video frame
///        has been displayed back following the Start command.
#define Q_AVSN_EV_VIDEO_PRESENTATION_START      AVSN_EVENT(2)

/// \brief The audio presentation complete event indicates that all of the audio
///        frames have been played back by the hardware following a flush message
///        (usually from SAIN flush or decoder flush).
#define Q_AVSN_EV_AUDIO_PRESENTATION_COMPLETE   AVSN_EVENT(3)

/// \brief The video presentation complete event indicates that all of the video
///        frames have been played back by the hardware following a flush message
///        (usually from VPP flush or decoder flush).
#define Q_AVSN_EV_VIDEO_PRESENTATION_COMPLETE   AVSN_EVENT(4)


//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
// Generated from mediaware.h OUTSTREAM_CFG s/OUTSTREAM_CFG/Q_AVSN_CMP/
/// \brief Set an offset for the STC between audio and video, by selecting an offet of video
///        relative to audio (may be positive or negative).  This is useful to correct for any
///        delays in the output software/hardware.
/// \param offset Integer number of STC ticks (90 KHz clock).
#define Q_AVSN_CMP_VID_STC_OFFSET                    0
/// \brief When pausing interlaced material, if the frame was frame coded (as opposed to field
///        or MBAFF coded) then display both fields as if it were a progressive source.  This is
///        not recommended.
/// \param enable
#define Q_AVSN_CMP_PAUSE_FRAME_CODING_AS_PROG        1
/// \brief Display only the top fields for fast playback.  This avoids slight jerkiness in the
///        display during fast playback of material whose original framerate was different than
///        the default display framerate.
/// \param enable
#define Q_AVSN_CMP_FAST_TOP_FIELD_ONLY               2
/// \brief Display only the top field for slow playback.  This avoids a slight shift in the
///        display when displaying one field for many field times followed by an opposite polarity
///        field for many field times.
/// \param enable
#define Q_AVSN_CMP_SLOW_TOP_FIELD_ONLY               3
/// \brief Force top field display at all times.
/// \param enable
#define Q_AVSN_CMP_FORCE_TOP_FIELD_ONLY              4
/// \brief Disable A/V synch.  Generally used for testing purposes.
/// \param disable
#define Q_AVSN_CMP_DISABLE_AV_SYNCH                  5
/// \brief Specify an STC offset to be used when an external clock is used.  This value will be
///        added to the value of the external clock to produce the internal STC used for A/V synch.
/// \param offset Integer number of STC ticks (90 KHz clock).
#define Q_AVSN_CMP_EXTERNAL_STC_OFFSET               6
/// \brief Enable fixed latency display for video, overriding part of the normal A/V synch and display timing.
///        The video output PTS will be adjusted in order to maintain a constant latency, based on how long
///        the average frame arrives at the output before it is scheduled to display.  The target time that
///        a frame should arrive before display is set by OUTSTREAM_CFG_VID_FIXED_LATENCY_TICKS.  Frames will
///        be dropped or repeated to meet the target.
/// \param enable
#define Q_AVSN_CMP_VID_FIXED_LATENCY_ENABLE          7
/// \brief Target video latency when fixed latency is enabled, in microseconds.
/// \param latency Target video latency, in microseconds.
#define Q_AVSN_CMP_VID_FIXED_LATENCY_TARGET          8
/// \brief In video-only playback, add latency at the beginning of playback.  When the first video
///        frame is received by the display, the display will wait the specified number of frame times
///        before displaying the frame.  Total time is therefore FIXED_LATENCY_TICKS * VID_OUTPUT_TICKS
///        (VID_OUTPUT_TICKS is set in the AVOC component).  Startup latency is only effective in video-only,
///        1x forward playback.
/// 
///        This API WILL NOT ensure that the given latency is maintained long term, in cases where
///        the video source clock is not synchronized with the display clock.  For example, a remote
///        encoder may run at a different speed than the local decoder, and this difference will
///        change the latency over time.
/// 
///        Note that high latency values require that the source object have enough frame buffers to hold
///        the delayed video.  Increasing FIXED_LATENCY_TICKS increases the required video frame buffers by
///        the same number.
/// \param ticks Initial startup latency, in frames
#define Q_AVSN_CMP_VIDEO_STARTUP_LATENCY             9
/// \brief Discard all video frames until the PTS reaches this start PTS, then start normal playback.
///        In forward play, frames with PTS lower than this value will be discarded.  In reverse play,
///        frames with PTS higher than this value will be discarded.
/// \param pts_high Most significant 32 bits of the 64 bit start PTS.
#define Q_AVSN_CMP_START_PTS_HIGH                   10
/// \brief Lower 32 bits of the start PTS.
/// \param pts_low Least significant 32 bits of the 64 bit start PTS.
#define Q_AVSN_CMP_START_PTS_LOW                    11
/// \brief Allow reverse playback mode to be enabled.  In reverse playback, the PTS should continuously
///        decrease instead of continuously increasing.  This allows the bitstream to be played back
///        in the exact reverse of its normal order.
/// \param enable Enable/disable reverse playback
#define Q_AVSN_CMP_REVERSE_MODE                     12
/// \brief Enable presentation events when the audio and video presentation has ended.
/// \param enable Enable/disable presentation events
#define Q_AVSN_CMP_ENABLE_PRESENTATION_EVENTS       13
/// \brief Enable events every audio and video frame indicating the current presentation PTS.
///        This will significantly increase event load.
/// \param enable Enable/disable presentation time events.
#define Q_AVSN_CMP_ENABLE_PRESENTATION_TIME_EVENTS  14
/// \brief In video master, reset the video PTS to a new frame's PTS if the difference from the
///        current PTS exceeds this threshold.
/// \param threshold PTS difference between current PTS and next frame PTS which leads to an STC reset
#define Q_AVSN_CMP_PTS_RESET_THRESHOLD              15
/// \brief Limits the number of video frames which can be queued awaiting display.  This is useful for a
///        decode application to control latency.  Only this many frames are allowed to be decoded
///        but not yet sent to the display hardware.  Additional video frames will be dropped, so that
///        decode continues and latency is controlled.
/// 
///        The default value is 0, which disables this feature.
/// \param maxframes Limit the video frames queued for display to this number, dropping extras.  Set to 0 to disable.
#define Q_AVSN_CMP_MAX_QUEUED_VIDEO_FRAMES          16
/// \brief Allow the output to drop input frames to achieve a synchronized startup.  If the audio or video
///        queue fills up and the other queue is empty, frames will be dropped until data is available in both
///        queues.  Once data is available, additional frames may be dropped to bring the PTS values as close
///        as possible when playback starts.
/// 
///        This parameter has no effect when startup synch is off (video only or audio only stream).
///        The default value is 0.
/// \param enable Enable frame drops on startup synch
#define Q_AVSN_CMP_STARTUP_SYNCH_DROP_FRAMES        17
/// \brief In audio master mode, this parameter set the audio start up latency.  This is the number of audio frames
/// the avsn must queue up before it starts playing.  Typically, for file based play back, set this to size of the audio
/// output buffer.  If you don't know what it is, just set this parameter to some really large value, recommend 32.  
/// if this value is too large, the avsn will automatically clamp it the size of the audio buffer.
/// For network based play back, set this to a value that is just enough to dampen out the network jitter, 4 should be enough.
///
/// For normal A/V play back with AV sync enabled, avsn will start out queueing up audio and video until the audio queue
/// reach the level set by this parameter.  If audio queue reaches this level yet no video has yet arrive, avsn will
/// start throwing away oldest audio frames to keep the audio queue at this level.  That way, decoders won't be choked up.
/// \param number of audio frames to buffer up
#define Q_AVSN_CMP_AUDIO_STARTUP_LATENCY            18
/// \brief When this algorithm is activated (set Q_AVSN_CMP_AUD_LATENCY_RESAMPLE_ENABLE to 1), it will monitor
/// the average latency between the arrival time of an audio frame and its actual display time.
///
/// If the latency is higher or lower than Q_AVSN_CMP_AUD_LATENCY_TARGET, then the audio will be resampled
/// to speed up or slow down playback.  The changed playback speed will consume incoming audio at a
/// different rate, and bring the latency back to the target.
///
/// This mode should be used for streaming, not playback from a file.  It will work with or without fixed
/// latency mode.
/// \param enable Enable audio latency based resampling
#define Q_AVSN_CMP_AUD_LATENCY_RESAMPLE_ENABLE      19
/// \brief When audio latency resampling is enabled, the resampling rate is recalculated at fixed intervals
/// in order to collect enough data for smooth changes in resampling.  This parameter sets this interval in
/// number of frames.
/// \param interval Interval to change the resampling rate, in frames.
#define Q_AVSN_CMP_AUD_LATENCY_CHECK_INTERVAL       20
/// \brief Audio latency based resampling uses audio resampling to target a specific audio latency.
/// This sets the target latency in microseonds.  To hit this target a resampling ratio will be maintained,
/// a value of 1 +/- delta which is multiplied by the input sample rate.  The delta is varied according to
/// the difference between the current latency and the target latency, to raise or lower the sampling rate.
/// It is only changed by one increment per check interval, to smooth out variation.
/// \param target Target audio latency in microseonds.
#define Q_AVSN_CMP_AUD_LATENCY_TARGET               21
/// \brief Internal parameter of the audio latency resampling algorithm.  The audio resampling rate is controlled
/// by multiplying the input sample rate by a ratio, an 8.23 fixed point integer.  When the ratio is changed, this
/// is the value by which it is changed (also an 8.23 fixed point number).
/// \param increment Amount to change audio resampling ratio every check interval, as an 8.23 fixed point integer.
#define Q_AVSN_CMP_AUD_LATENCY_RESAMPLE_INCREMENT   22
/// \brief The resampling ratio falls within the range of 1 +/- OUTSTREAM_CFG_AUD_LATENCY_RESAMPLE_MAX.  This
/// value is an 8.23 fixed point integer.  The maximum only applies when the current latency differs from the
/// target latency by less than LATENCY_THRESHOLD_1, after which a fixed ratio is applied.
/// \param maximum Maximum delta applied to the resampling ratio, as an 8.23 fixed point integer.
#define Q_AVSN_CMP_AUD_LATENCY_RESAMPLE_MAX         23
/// Unused.
#define Q_AVSN_CMP_AUD_LATENCY_DELTA_THRESHOLD      24
/// \brief If the latency differs from the target by more than this threshold (in microseconds), apply the fixed
/// resampling ratio THRESHOLD_RESAMPLE_1.  The normal increment method is suspended until the difference between
/// the current latency and the target latency is below LATENCY_THRESHOLD_1.
/// \param threshold Threshold at which to apply LATENCY_THRESHOLD_RESAMPLE_1.
#define Q_AVSN_CMP_AUD_LATENCY_THRESHOLD_1          25
/// \brief If the latency differs from the target by more than this threshold (in microseconds), apply the fixed
/// resampling ratio THRESHOLD_RESAMPLE_2.  The normal increment method is suspended until the difference between
/// the current latency and the target latency is below LATENCY_THRESHOLD_2.  LATENCY_THRESHOLD_2 must be greater
/// than LATENCY_THRESHOLD_1.
/// \param threshold Threshold at which to apply LATENCY_THRESHOLD_RESAMPLE_2.
#define Q_AVSN_CMP_AUD_LATENCY_THRESHOLD_2          26
/// \brief Latency resampling ratio to be applied when the latency differs from the target by more than 
/// LATENCY_THRESHOLD_1.
/// \param resample Resampling ratio used for LATENCY_THRESHOLD_1.
#define Q_AVSN_CMP_AUD_LATENCY_THRESHOLD_RESAMPLE_1  27
/// \brief Latency resampling ratio to be applied when the latency differs from the target by more than 
/// LATENCY_THRESHOLD_2.
/// \param resample Resampling ratio used for LATENCY_THRESHOLD_2.
#define Q_AVSN_CMP_AUD_LATENCY_THRESHOLD_RESAMPLE_2  28
/// \brief When video fixed latency is enabled, the video display PTS is recalculated at specified intervals
/// in order to collect enough data for smooth changes which avoid unnecessary frame drops or repeats.
/// This parameter sets this interval in frames.
/// \param interval Interval to change the video display clock, in frames
#define Q_AVSN_CMP_VID_FIXED_LATENCY_CHECK_INTERVAL  29
/// \brief If the latency differs from the target by more than this threshold (in microseconds), apply the fixed
/// latency control algorithm.
/// \param threshold Threshold at which to apply the fixed latency control algorithm.
#define Q_AVSN_CMP_VID_FIXED_LATENCY_THRESHOLD      30
/// \brief Limits the number of audio frames which can be queued awaiting output.  This is useful for a
///        decode application to control latency.  Only this many frames are allowed to be decoded
///        but not yet sent to the audio hardware.  Additional audio frames will be dropped, so that
///        decode continues and latency is controlled.
/// 
///        The default value is 0, which disables this feature.
/// \param maxframes Limit the audio frames queued for display to this number, dropping extras.  Set to 0 to disable.
#define Q_AVSN_CMP_MAX_QUEUED_AUDIO_FRAMES          31
/// \brief When AV sync is enabled, the following parameter sets the maximum number of audio frames allowed
/// to lead video.  As soon as audio leads video by this much, will start playing audio only.  If later video
/// is available, then start playing video too, if not, just continue on without video.
/// \param number of audio frames    
#define Q_AVSN_CMP_AUDIO_MAX_LEAD_FRAMES            32
/// \brief When AV sync is enabled, the following parameter sets the maximum number of video frames allowed
/// to lead audio.  As soon as video leads audio by this much, will start playing video only.  If later audio
/// is available, then start playing audio too, if not, just continue on without audio.
/// \param number of video frames    
#define Q_AVSN_CMP_VIDEO_MAX_LEAD_FRAMES            33
/// \brief For audio bitstream that uses NTP timestamps, its audio frame's PTS should ideally equal to (or 
///        slightly greater than) the time obtained from NTP clock when the audio hardware is ready to display.
///        The average divergence between the frame PTS and hardware interrupt STC is monitored by this
///        audio resampling algorithm.
///        The divergence value must be maintained to a target value. Otherwise the audio playback may be too
///        slow or too fast with respect to the NTP clock. Since the video playback is always in sync
///        with the NTP clock, an unstable divergence value will cause AV out-of-sync problem.
///        Thus, when divergence is higher than a target value, the rate of audio data coming into AVSN is too fast
///        compared to the audio hardware. Audio needs to be up-sampled to slow down the rate.
///        And when divergence is lower than the target, audio needs to be down-sampled to speed up.
/// \param 1 to enable, 0 to disable
#define Q_AVSN_CMP_NTP_DIVERGENCE_RESAMPLE_ENABLE   34
/// \brief When audio divergence resampling is enabled, the resampling rate is recalculated at fixed intervals
///        to collect enough data for smooth changes in resampling.  This parameter sets this interval in
///        number of frames.
/// \param value Number of frames.
#define Q_AVSN_CMP_NTP_DIVERGENCE_CHECK_INTERVAL    35
/// \brief The target divergence value to be maintained by the divergence resampling algorithm.
/// \param value Target divergence in clock ticks. 90,000 ticks for a 90khz clock means a second of divergence
#define Q_AVSN_CMP_NTP_DIVERGENCE_TARGET            36
/// \brief Internal parameter of the audio divergence resampling algorithm.  The audio resampling rate is controlled
///        by multiplying the input sample rate by a ratio, an 8.23 fixed point integer. 
///        When the average divergence is close to the target (just outside the interval of target+-THRESHOLD_0),
///        the algorithm uses an increment value to add to or subtract from the resampling ratio. A smaller
///        increment causes a smoother but slower converging to target while a bigger increment causes a more
///        uneven but faster converging.
/// \param value Positive integer (1 or above). This is a 8.23 fixed point number.
#define Q_AVSN_CMP_NTP_DIVERGENCE_RESAMPLE_INCREMENT  37
/// \brief In the "close" zone (see below), the resampling ratio is increased or decreased by the RESAMPLE_INCREMENT 
///        value repeatedly and accumulatively. The accumulated delta value has a maximum value set by this parameter.
/// \param value Positive integer (1 or above). This is a 8.23 fixed point number.
#define Q_AVSN_CMP_NTP_DIVERGENCE_RESAMPLE_MAX      38
/// \brief There are 3 threshold values in this algorithm. They're used to divide the average divergence into 3 zones
///        around the target value:
///        
///          (tar-THLD_2)    (tar-THLD_1)  (tar-THLD_0) (tar) (tar+THLD_0)  (tar+THLD_1)    (tar+THLD_2)
///               |                 |               |     |     |             |                  |
/// --------------|-----------------|---------------|-----|-----|-------------|------------------|-----------------> ticks
///               |                 |               |     |     |             |                  |
/// -OutOfControl |     -far        |      -close   |  stable   | +close      |     +far         | +OutOfControl
///
/// The resampling ratio is changed in different ways when the divergence is in difference zones.
/// In the stable zone, the resampling ratio is unchanged.
/// In the close zone, the resampling ratio is increased or decreased by the RESAMPLE_INCREMENT value repeatedly.
/// The change is usually small to ease the divergence smoothly to the target.
/// In the far zone, when divergence differs from the target by more than THRESHOLD_1, a fixed resample ratio is applied.
/// The fixed ratio is set by the parameter, OUTSTREAM_CFG_NTP_DIVERGENCE_THRESHOLD_RESAMPLE_1.
///
/// \param value Positive integer (1 or above). Number of clock ticks. This must be smaller than THRESHOLD_1&THRESHOLD_2.
#define Q_AVSN_CMP_NTP_DIVERGENCE_THRESHOLD_0       39
/// \brief See THRESHOLD_0.
/// \param value Positive integer (1 or above). Number of clock ticks. This must be smaller than THRESHOLD_2.
#define Q_AVSN_CMP_NTP_DIVERGENCE_THRESHOLD_1       40
/// \brief See THRESHOLD_0.
/// \param value Positive integer (1 or above). Number of clock ticks. This must be greater than THRESHOLD_1.
#define Q_AVSN_CMP_NTP_DIVERGENCE_THRESHOLD_2       41
/// \brief The fixed resampling ratio used when divergence is in the far zone. Note that this value is added to
/// or subtracted from the fixed point integer 1, ie 0x800000. For example, if divergence is in the +far zone
/// and this parameter value is 0x400, the actual internal resampling ratio is (0x800000 - 0x400). Also note
/// that ratio < 0x800000 is for up-sampling and ratio > 0x800000 is for down-sampling.
/// \param value Positive integer (1 or above). This is a 8.23 fixed point number.
#define Q_AVSN_CMP_NTP_DIVERGENCE_THRESHOLD_RESAMPLE_1  42
/// \brief The fixed resampling ratio used when divergence is in the out-of-control zone.
/// \param value Positive integer (1 or above). This is a 8.23 fixed point number.
#define Q_AVSN_CMP_NTP_DIVERGENCE_THRESHOLD_RESAMPLE_2  43

//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//
// Generated from mediaware.h OUTSTREAM_NTP_AUTO_MODE s/OUTSTREAM_NTP_AUTO_MODE/Q_AVSN_CFP_NTP_AUTO_MODE/
/// \brief When the NTP automatic option is enabled, this mode will start the presentation of audio
/// and video bitstream instantly.
#define Q_AVSN_CFP_NTP_AUTO_MODE_INSTANT             0
/// \brief When the NTP automatic option is enabled, this mode will delay the presentation of audio
/// and video bitstream by the time specified by the offset parameters in the command
/// Q_AVSN_CMD_ENABLE_NTP_SYNC.
#define Q_AVSN_CFP_NTP_AUTO_MODE_DELAY               1
/// \brief When the NTP automatic option is enabled, this mode will skip part of the presentation 
/// of audio and video bitstream. Amount skipped is specified by the offset parameters in the 
/// command Q_AVSN_CMD_ENABLE_NTP_SYNC.
#define Q_AVSN_CFP_NTP_AUTO_MODE_SKIP                2

/// \}
#endif
