/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


/// \defgroup AVDecoderControlObject Audio-Video Decode
///// \{

/// \page avdecoder Audio-Video Decoder
/// \latexonly
/// \chapter{Audio-Video Decoder}
/// \input{av_decoder}
/// \endlatexonly
///
/// The AVDecoder status block contains information related to state and performance.
/// 
/// \latexonly
/// \input{structAVDEC__STATUS}
/// \endlatexonly

#ifndef __QAVDEC_HH
#define __QAVDEC_HH

#include "qglobal.h"

//////////////////////////////////////////////////////////////////////
//
// Commands
//
#define Q_AVDEC_CMD_START                             1
#define Q_AVDEC_CMD_STOP                              2
#define Q_AVDEC_CMD_SET_PARAM                         3
#define Q_AVDEC_CMD_ACTIVATE                          4
#define Q_AVDEC_CMD_SET_CODEC                         5
#define Q_AVDEC_CMD_SET_AUDIO_CHANNEL_PARAM           6 
#define Q_AVDEC_CMD_GET_DEMUX_BUFFER                  7
#define Q_AVDEC_CMD_SET_SPEED                         8
#define Q_AVDEC_CMD_REVERSE                           9
#define Q_AVDEC_CMD_RESET_MIN_MAX                     10

#define Q_AVDEC_MAX_CMD                               11

///////////////////////////////////////////////////////////////////////
//
// Command Payloads
// 

typedef struct
{
    unsigned int param;
    int value;
} STRUCT_Q_AVDEC_CMD_SET_PARAM;

typedef struct
{
    int value;
} STRUCT_Q_AVDEC_CMD_SET_CODEC;

typedef struct
{
    unsigned int streamId;
} STRUCT_Q_AVDEC_CMD_GET_DEMUX_BUFFER;

typedef struct
{   
    int slow;
    unsigned int speed;   
} STRUCT_Q_AVDEC_CMD_SET_SPEED;

//////////////////////////////////////////////////////////////////////
//
// Command Parameter Values
//
#define Q_AVDEC_CMP_SOME_PARAMETER                  0

//////////////////////////////////////////////////////////////////////
//
// Events
//
#define AVDEC_EVENT(ID) ((AVDEC_CTRLOBJ_TYPE << 16) | ID)

//#define Q_AVDEC_EV_EXSAMPLE AVDEC_EVENT(1)
/// \brief Audio decoder sends this event when it detects errors in the bit stream.
#define Q_AVDEC_EV_AUDIO_ERROR              AVDEC_EVENT(1)
/// \brief Video decoder sends this event when it detects errors in the bit stream.
#define Q_AVDEC_EV_VIDEO_ERROR              AVDEC_EVENT(2)
/// \brief This event is sent by the demuxer when audio buffer level exceeds the level set
/// by command Q_AVDEC_CMP_AUDIO_OVERFLOW_THRESHOLD
#define Q_AVDEC_EV_AUDIO_OVERFLOW           AVDEC_EVENT(3)
/// \brief This event is sent by the audio decoder when its buffer level falls below the level set
/// by command Q_AVDEC_CMP_AUDIO_UNDERFLOW_THRESHOLD
#define Q_AVDEC_EV_AUDIO_UNDERFLOW          AVDEC_EVENT(4)
/// \brief This event is sent by the demuxer when video buffer level exceeds the level set
/// by command Q_AVDEC_CMP_VIDEO_OVERFLOW_THRESHOLD
#define Q_AVDEC_EV_VIDEO_OVERFLOW           AVDEC_EVENT(5)
/// \brief This event is sent by the video decoder when its buffer level falls below the level set
/// by command Q_AVDEC_CMP_VIDEO_UNDERFLOW_THRESHOLD
#define Q_AVDEC_EV_VIDEO_UNDERFLOW          AVDEC_EVENT(6)
/// \brief This event is sent by the audio decoder when the entire bit stream has been decoded.
#define Q_AVDEC_EV_AUDIO_END_OF_STREAM      AVDEC_EVENT(7)
/// \brief This event is sent by the video decoder either when the entire bit stream has been decoded or
/// when it has finished processing the Start command.
#define Q_AVDEC_EV_VIDEO_END_OF_STREAM      AVDEC_EVENT(8)
/// \brief This event is sent by the video decoder when a frame is decoded.  This event can be turned off or on
/// by command Q_AVDEC_CMP_ENABLE_PIC_DECODED_EVENT
#define Q_AVDEC_EV_VIDEO_FRAME_DECODED      AVDEC_EVENT(9)
/// \brief This event is sent by the audio decoder when a frame is decoded.  This event can be turned off or on
/// by command Q_AVDEC_CMP_ENABLE_PIC_DECODED_EVENT
#define Q_AVDEC_EV_AUDIO_FRAME_DECODED      AVDEC_EVENT(10)
/// \brief This event is sent by the video decoder when it detects a change in video resolution.
#define Q_AVDEC_EV_VIDEO_DECODER_NEW_RESOLUTION  AVDEC_EVENT(11)
#define Q_AVDEC_EV_VIDEO_TS_PID                  AVDEC_EVENT(12)

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        streamID;
    unsigned int        bufferLevel;
    unsigned int        bufferSize;
    unsigned int        bufferAuLevel;
    unsigned int        bufferAuSize;
} STRUCT_Q_AVDEC_EV_VIDEO_OVERFLOW;

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        streamID;
    unsigned int        cause;
} STRUCT_Q_AVDEC_EV_VIDEO_END_OF_STREAM;

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        width;
    unsigned int        height;
    unsigned int        ptsHi;
    unsigned int        ptsLo;
} STRUCT_Q_AVDEC_EV_VIDEO_NEW_RESOLUTION;

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        decodeTime;
    unsigned int        width;
    unsigned int        height;
} STRUCT_Q_AVDEC_EV_VIDEO_FRAME_DECODED;

/// \brief This error code is sent by video decoder when it detects an syntax error in the slice header.
///  Decoder is not able to decode the entire frame.  This erroneous frame will be dropped.
#define Q_AVDEC_VIDEO_ERROR_SLICE_HEADER_ERROR      1
/// \brief This error code is sent by video decoder when it encounters an internal error such as decoder
/// runs out of resource, or other self induced errors.  This error is generally unrecoverable and may 
/// cause decoder to crash.
#define Q_AVDEC_VIDEO_ERROR_INTERNAL_ERROR          2
/// \brief The following error is generated by the avc hardware block when it receives an invalid "Format"
/// instruction.
#define Q_AVDEC_VIDEO_ERROR_HW_0                    ((1<<13) + (1 << 0))
/// \brief The following error is generated by the avc hardware block when it receives decoding commands while 
/// the hardware is in encoding mode, or while it is uninitialized.
#define Q_AVDEC_VIDEO_ERROR_HW_1                    ((1<<13) + (1 << 1))
/// \brief The following error is asserted by the avc hardware module when firmware sends it an invalid instruction.
#define Q_AVDEC_VIDEO_ERROR_HW_2                    ((1<<13) + (1 << 2))
/// \brief The following error is asserted by the avc hardware module when firmware sends it wrong instructions
/// while it is waiting for Picture-class, Slice, or SliceData.
#define Q_AVDEC_VIDEO_ERROR_HW_3                    ((1<<13) + (1 << 3))
/// \brief The following error is asserted by the avc hardware module when it receives macro block level instructions
/// while it hasn't been properly initialized with valid slice level parameters.
#define Q_AVDEC_VIDEO_ERROR_HW_4                    ((1<<13) + (1 << 4))
/// \brief The following error is asserted by the avc hardware module when it receives macro block level instructions
/// while it hasn't been properly initialized with valid macro block level parameters.
#define Q_AVDEC_VIDEO_ERROR_HW_5                    ((1<<13) + (1 << 5))
/// \brief The following error is asserted by the avc hardware module if it receives wrong commands while encoding.
#define Q_AVDEC_VIDEO_ERROR_HW_6                    ((1<<13) + (1 << 6))
/// \brief The following error is asserted by the avc hardware module if it receives wrong commands while decoding.
#define Q_AVDEC_VIDEO_ERROR_HW_7                    ((1<<13) + (1 << 7))
/// \brief The following error is asserted by the avc hardware module if it detects syntax errors in the bit stream.
/// To be more specific, the avc module has detected an invalid emulation prevention byte.  An Emulation Prevention
/// Byte error occurs if a byte is anything other than [0x00-0x03] following the byte string 0x000003.  Please refer
/// to avc spec for more information.
#define Q_AVDEC_VIDEO_ERROR_HW_8                    ((1<<13) + (1 << 8))
/// \brief This error code is sent by video decoder when it detects a syntax error in the slice data section.
///  Decoder is not able to decode the entire frame.  This erroneous frame will be dropped.
#define Q_AVDEC_VIDEO_ERROR_SLICE_DATA              ((1<<13) + (1 << 9))

typedef struct
{
    CONTROLOBJECT_ID    controlObjectId;
    EVENT_ID            eventId;
    unsigned int        timestamp;
    unsigned int        errorCode;
    unsigned int        frameNumber;
    unsigned int        macroblockX;
    unsigned int        macroblockY;
} STRUCT_Q_AVDEC_EV_VIDEO_ERROR;


typedef STRUCT_Q_AVDEC_EV_VIDEO_OVERFLOW STRUCT_Q_AVDEC_EV_VIDEO_UNDERFLOW;
typedef STRUCT_Q_AVDEC_EV_VIDEO_OVERFLOW STRUCT_Q_AVDEC_EV_AUDIO_OVERFLOW;
typedef STRUCT_Q_AVDEC_EV_VIDEO_OVERFLOW STRUCT_Q_AVDEC_EV_AUDIO_UNDERFLOW;

typedef STRUCT_Q_AVDEC_EV_VIDEO_END_OF_STREAM STRUCT_Q_AVDEC_EV_AUDIO_END_OF_STREAM;

//////////////////////////////////////////////////////////////////////
//
// Configuration parameters
//
// Audio Decoder
/// \brief This command is reserved.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_BASE                 0
/// \brief This command sets type of audio stream to be decoded.
/// \param 0 Q_AVDEC_CFP_AUDIO_CODEC_QAC 
/// \param 1 Q_AVDEC_CFP_AUDIO_CODEC_QPCM
/// \param 2 Q_AVDEC_CFP_AUDIO_CODEC_QMA 
/// \param 3 Q_AVDEC_CFP_AUDIO_CODEC_Q711
/// \param 4 Q_AVDEC_CFP_AUDIO_CODEC_Q722
/// \param 5 Q_AVDEC_CFP_AUDIO_CODEC_Q726
/// \param 6 Q_AVDEC_CFP_AUDIO_CODEC_Q728
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_CODEC_TYPE           0
/// \brief This command sets endianness for pcm
#define Q_AVDEC_CMP_QPCM_ENDIANNESS             1
/// \brief This command sets the number audio channels.
/// \param 0 Q_AVDEC_CFP_AUDIO_CHANNEL_MONO
/// \param 1 Q_AVDEC_CFP_AUDIO_CHANNEL_STEREO
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_CHANNEL_NUM          2
/// \brief This command sets audio sampling rate.
/// \param value Audio sampling rate in Hz.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_SAMPLE_RATE          3
/// \brief This command sets the sizes of audio samples in bits.
/// \param value size of audio samples in bits.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_SAMPLE_SIZE          4
/// \brief This command sets stream type
#define Q_AVDEC_CMP_AUDIO_STREAM_TYPE          5
/// \ brief This command sets aac object type
#define Q_AVDEC_CMP_AAC_OBJECT_TYPE            6    

/*** The following Params are used to index an array! ***/
/*** Video Decoder: Parameter (PROG_DEFAULT - BASE) to (VDEC_CFG_NUM - BASE) must be the same as VDEC_CFG defined in mediaware.h ***/

/// \brief This command is reserved.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_BASE                           10
/// \brief This command is reserved.  For backward compatibility with Seve1 only.  Merlin decoder 
///  simply ignores this parameter.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_PROG_DEFAULT                   10
/// \brief This command is reserved.  For backward compatibility with Seve1 only.  Merlin decoder 
///  ignores this parameter.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_PROG_OVERRIDE                  11
/// \brief This command is reserved.  For backward compatibility with Seve1 only.  Merlin decoder 
///  ignores this parameter.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_DISPLAY_SEI_RC_FRAME_STATS     12
/// \brief This command is reserved.  For backward compatibility with Seve1 only.  Merlin decoder 
///  ignores this parameter.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_DISPLAY_SEI_RC_CALC_STATS      13
/// \brief This command is reserved.  For backward compatibility with Seve1 only.  Merlin decoder 
///  ignores this parameter.
/// \internal
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_USE_H264_TIMING                14
/// \brief This command sets video frame interval, i.e. time between 2 video frames, in units
/// of 90KHz ticks.  This parameter must be used together with VDEC_CFG_TICKS_PER_FRAME_OVERRIDE.
/// and it only takes effect when VDEC_CFG_TICKS_PER_FRAME_OVERRIDE=1.
/// \param value Number of ticks per frame in units of 90KHz ticks.
#define Q_AVDEC_CMP_VIDEO_TICKS_PER_FRAME_DEFAULT        15
/// \brief This command activates video decoder's PTS re-stamping feature.  Once it is activated, video
/// decoder will overrides the bit stream's PTS with its own generated values.  
/// \param value 1 = Activate, 0 = Deactivate.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_TICKS_PER_FRAME_OVERRIDE       16
/// \brief This command causes video decoder to discard all decoded outputs instead of displaying them.
///  Therefore if this feature is enabled the screen will be blanked.
/// \param value 1 = Disable output, 0 = Enable output.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_DISABLE_OUTPUT                 17
/// \brief This command sets the display field order.  
/// \param value 0 Q_AVDEC_CFP_VIDEO_FIELD_ORDER_AUTO
/// \param value 1 Q_AVDEC_CFP_VIDEO_FIELD_ORDER_FORCE_TOP_FIRST
/// \param value 2 Q_AVDEC_CFP_VIDEO_FIELD_ORDER_FORCE_BOTTOM_FIRST
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_FIELD_ORDER                    18
/// \brief This command selects decoder's output timing mode. The output timing mode determines
/// the amount of delay through decoder.  There are 3 modes available:
///
/// \param 0 ME_VIDEO_OUTPUT_TIMING_NORMAL This is the normal timing mode.  It is the default mode.  
/// Decoder won't output anything until it has decoded a number of frames equal to the number of 
/// reference frames.  This mode works for all bit streams but the delay is equal to the number reference frames.
///
/// \param 1 ME_VIDEO_OUTPUT_TIMING_LOW_DELAY Low delay mode causes decoder to output a frame as soon
/// as it is decoded.  This mode only works for bit streams which contain only I and P frames or fields.
/// The decoder delay is 1 frame time + Decoded Time.  Decoded Time is the time it takes to decode 1 frame.
/// and this time is typically around a few mili seconds.
///
/// \param 2 ME_VIDEO_OUTPUT_TIMING_ZERO_DELAY This mode causes decoder to pre-output a frame before it
/// is actually decoded.  The video frame is sent to output before it is actually decoded, the delay is almost zero.
/// However, there is a risk that the frame may be displayed before it is decoded which will cause display to 
/// show corrupted images.  The first frame is pre-outputed as soon as decoder receives the first SPS packet.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_OUTPUT_TIMING                  19
/// \brief This command activates slice decode mode.  In this mode, video decoder decodes
/// the bit stream 1 slice at a time.  This minimizes decoder delay.  However, decoder will 
/// not be able to run concurrently with encoder on the same chip.
/// \param value 1 = Enable, 0 = Disable
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_SLICE_DECODE_MODE              20
/// \brief This command causes video decoder to sent the event ME_EV_VIDEO_FRAME_DECODED after 
/// a frame is decoded.  It is disabled by default.
/// \param value 1 = Enable, 0 = Disable
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_ENABLE_PIC_DECODED_EVENT             21
/// \brief This command set decoder input format.  There are 2 supported formats ME_STREAM_QBOX and 
/// ME_STREAM_VIDEO.  The ME_STREAM_QBOX can only be used with the Direct Memory Transfer Read Streamer.
/// and the bit stream is fed into the decoder in QBOX format. ME_STREAM_VIDEO is elementary h.264 format.
/// \internal
/// \param ME_STREAM_VIDEO or ME_STREAM_QBOX
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_BIT_STREAM_FORMAT              22    //private, internal use only
/// \brief This command activates decoder's Sticky SPS feature.  Once active, decoder only parses SPS when
/// there is no active SPS.  Once the first SPS are activated, decoder stops parsing incoming SPS.
/// This feature is useful in error prone environment where there's a good chance that SPS may get corrupted.
/// However, it only works for bitstreams whose SPSes don't change for the entire video sequence.
/// Once activated, decoder accepts either first SPSes of the stream or ones following an end of sequence marker.
/// \param 1 = enable, 0 = disable.  Default is disable.
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_STICKY_SPS                     23
/// \brief This parameter set the start up latency of Slice Decode Mode.  It only works when VDEC_CFG_SLICE_DECODE_MODE=1
///  The start up latency is in units of picture slices.  This parameter causes the avc decoder to accumulate picture coded
///  slices before it starts decoding.  The latency can not be larger than 1 frame.  If it is, decoder will clamp it to 1 frame.
///  Only picture coded slices are counted.
/// \param Number of picture coded slices to accumulate before decoder start decoding.  Default is zero.
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_SLICE_DECODE_STARTUP_LATENCY   24
/// \brief This option enable the Intra Refresh feature.
/// \param either 1 or 0.  1 for enable and 0 for disable. Default is 0!
#define Q_AVDEC_CMP_INTRA_REFRESH_ENABLE                 25
/// \brief This option set the initial back ground color of the pseudo reference frame in YUV color format.
///  When enabled, decoder fills the pseudo reference frame with a solid color specified by this parameter.
///  Set it 0 to disable this feature.  When it is disables, decoder will just use garbage for the pseudo frame.
/// \param YUV color value.  0xffffffff means disable, otherwise = YUV color, for example to set it to black: 0x00008080. 
#define Q_AVDEC_CMP_INTRA_REFRESH_BACK_GROUND_COLOR      26
/// \brief This command is reserved.  It is used as a marker to mark then end of Video Decoder commands
/// \internal
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_VDEC_CFG_NUM                   27

//Middleware layer Misc. parameters
/// \brief This command is reserved.  It is used as a marker to mark the start of Demuxer's commands
/// \internal
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_BASE                                 40
/// \brief This command sets the qbox stream ID of the audio stream.
/// \param value Stream ID
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_STREAM_ID                      41
/// \brief This command sets the qbox stream ID of the video stream.
/// \param value Stream ID
/// \return 1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_STREAM_ID                      42

/// \brief This command sets the Overflow Threshold of the compressed video buffer(in bytes.)  Video decoder
/// will send Q_AVDEC_EV_VIDEO_OVERFLOW event when video decoder buffer level is higher than this level.
/// \param value Buffer Threshold in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_OVERFLOW_THRESHOLD             43
/// \brief This command sets the Overflow Margin of the compressed video buffer(in bytes.)  It is a sort
/// of a hysterisis mechanism which dictates how often decoder sends Q_AVDEC_EV_VIDEO_OVERFLOW event.
/// Initially, video decoder will send the event when buffer level is higher than Q_AVDEC_CMP_VIDEO_OVERFLOW_THRESHOLD.
/// Then the buffer remains in the overflow state until buffer level is lower than 
/// (Q_AVDEC_CMP_VIDEO_OVERFLOW_THRESHOLD - Q_AVDEC_CMP_VIDEO_OVERFLOW_MARGIN.)  While the buffer is in
/// overflow state, decoder will not send additional overflow event.
/// \param value Buffer Margin in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_OVERFLOW_MARGIN                44
/// \brief This command sets the Underflow Threshold of the compressed video buffer (in bytes.)  Video decoder
/// will send Q_AVDEC_EV_VIDEO_UNDERFLOW event when video decoder buffer level is lower than this level.
/// The underflow event is used to signal the Read Streamer to feed more data to video decoder.
/// \param value Buffer Threshold in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_UNDERFLOW_THRESHOLD            45
/// \brief This command sets the Underflow Margin of the compressed video buffer (in bytes.)  It is a sort
/// of a hysterisis mechanism which dictates how often decoder sends Q_AVDEC_EV_VIDEO_UNDERFLOW event.
/// Initially, video decoder sends the underflow event when buffer level is lower than Q_AVDEC_CMP_VIDEO_UNDERFLOW_THRESHOLD.
/// Then the buffer remains in the underflow state until buffer level is higher than 
/// (Q_AVDEC_CMP_VIDEO_UNDERFLOW_THRESHOLD + Q_AVDEC_CMP_VIDEO_UNDERFLOW_MARGIN.)  While the buffer is in
/// underflow state, decoder will not send additional underflow event.
/// \param value Buffer Margin in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_UNDERFLOW_MARGIN               46
/// \brief This command sets the Underflow Threshold of the compressed video buffer (in number of Access Units.)  Video decoder
/// will send Q_AVDEC_EV_VIDEO_UNDERFLOW event when video decoder buffer level is lower than this level.
/// The underflow event is used to signal the Read Streamer to feed more data to video decoder.
/// \param value Buffer Threshold in number of Access Units
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_UNDERFLOW_AU_THRESHOLD         47
/// \brief This command sets the Underflow Margin of the compressed video buffer (in number of Access Units.)  It is a sort
/// of a hysterisis mechanism which dictates how often decoder sends Q_AVDEC_EV_VIDEO_UNDERFLOW event.
/// Initially, video decoder sends the underflow event when buffer level is lower than Q_AVDEC_CMP_VIDEO_UNDERFLOW_THRESHOLD.
/// Then the buffer remains in the underflow state until buffer level is higher than 
/// (Q_AVDEC_CMP_VIDEO_UNDERFLOW_THRESHOLD + Q_AVDEC_CMP_VIDEO_UNDERFLOW_MARGIN.)  While the buffer is in
/// underflow state, decoder will not send additional underflow event.
/// \param value Buffer Margin in number of Access Units
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_UNDERFLOW_AU_MARGIN            48

/// \brief This command sets the Overflow Threshold of the compressed audio buffer(in bytes.)  Audio decoder
/// will send Q_AVDEC_EV_AUDIO_OVERFLOW event when audio decoder buffer level is higher than this level.
/// \param value Buffer Threshold in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_OVERFLOW_THRESHOLD             49
/// \brief This command sets the Overflow Margin of the compressed audio buffer(in bytes.)  It is a sort
/// of a hysterisis mechanism which dictates how often decoder sends Q_AVDEC_EV_AUDIO_OVERFLOW event.
/// Initially, audio decoder will send the event when buffer level is higher than Q_AVDEC_CMP_AUDIO_OVERFLOW_THRESHOLD.
/// Then the buffer remains in the overflow state until buffer level is lower than 
/// (Q_AVDEC_CMP_AUDIO_OVERFLOW_THRESHOLD - Q_AVDEC_CMP_AUDIO_OVERFLOW_MARGIN.)  While the buffer is in
/// overflow state, decoder will not send additional overflow event.
/// \param value Buffer Margin in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_OVERFLOW_MARGIN                50
/// \brief This command sets the Underflow Threshold of the compressed audio buffer (in bytes.)  Audio decoder
/// will send Q_AVDEC_EV_AUDIO_UNDERFLOW event when audio decoder buffer level is lower than this level.
/// The underflow event is used to signal the Read Streamer to feed more data to audio decoder.
/// \param value Buffer Threshold in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_UNDERFLOW_THRESHOLD            51
/// \brief This command sets the Underflow Margin of the compressed audio buffer (in bytes.)  It is a sort
/// of a hysterisis mechanism which dictates how often decoder sends Q_AVDEC_EV_AUDIO_UNDERFLOW event.
/// Initially, audio decoder sends the underflow event when buffer level is lower than Q_AVDEC_CMP_AUDIO_UNDERFLOW_THRESHOLD.
/// Then the buffer remains in the underflow state until buffer level is higher than 
/// (Q_AVDEC_CMP_AUDIO_UNDERFLOW_THRESHOLD + Q_AVDEC_CMP_AUDIO_UNDERFLOW_MARGIN.)  While the buffer is in
/// underflow state, decoder will not send additional underflow event.
/// \param value Buffer Margin in bytes
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_UNDERFLOW_MARGIN               52
/// \brief This command sets the Underflow Threshold of the compressed audio buffer (in number of Access Units.)  Audio decoder
/// will send Q_AVDEC_EV_AUDIO_UNDERFLOW event when audio decoder buffer level is lower than this level.
/// The underflow event is used to signal the Read Streamer to feed more data to audio decoder.
/// \param value Buffer Threshold in number of Access Units
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_UNDERFLOW_AU_THRESHOLD         53
/// \brief This command sets the Underflow Margin of the compressed audio buffer (in number of Access Units.)  It is a sort
/// of a hysterisis mechanism which dictates how often decoder sends Q_AVDEC_EV_AUDIO_UNDERFLOW event.
/// Initially, audio decoder sends the underflow event when buffer level is lower than Q_AVDEC_CMP_AUDIO_UNDERFLOW_THRESHOLD.
/// Then the buffer remains in the underflow state until buffer level is higher than 
/// (Q_AVDEC_CMP_AUDIO_UNDERFLOW_THRESHOLD + Q_AVDEC_CMP_AUDIO_UNDERFLOW_MARGIN.)  While the buffer is in
/// underflow state, decoder will not send additional underflow event.
/// \param value Buffer Margin in number of Access Units
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_UNDERFLOW_AU_MARGIN            54

/// \brief This command is reserved.  This is a demuxer's command.  It is used to set the initial video buffer 
/// level in access units.  Demux won't send any data to decode until it has accumulated this many access units.
/// \internal
/// \param value number of access units.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_INITIAL_BUFFER_LEVEL           55
/// \brief This command sets the Transport Stream Program ID of the video stream.
/// \param value Transport Stream Program ID.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_VIDEO_TS_PID                         56
#define Q_AVDEC_CMP_VIDEO_INPUT                          57

/***** The JPEG parameters must be placed consecutively, therefore some slots are reserved for *****/
/***** future use.                                                                             *****/
/// \brief This command set the motion-jpeg frame interval. Based on a 90khz clock.
/// \param value Number of ticks per frame in units of 90khz ticks.
#define Q_AVDEC_CMP_JPEG_TICKS_PER_FRAME                 58
/// \brief This command set the numerator of the frame drop ratio of the MJPEG decoder. Must
///  use together with Q_AVDEC_CMP_JPEG_FRAME_DROP_RATIO_M.
/// \param value Numerator of frame drop ratio.
#define Q_AVDEC_CMP_JPEG_FRAME_DROP_RATIO_N              59
/// \brief This command set the denumerator of the frame drop ratio of the MJPEG decoder. Must
///  use together with Q_AVDEC_CMP_JPEG_FRAME_DROP_RATIO_N.
/// \param value Denumerator of frame drop ratio.
#define Q_AVDEC_CMP_JPEG_FRAME_DROP_RATIO_M              60
/// \brief This command set the width of the aspect ratio of the decoded frame.
/// \param value Aspect ratio (width)
#define Q_AVDEC_CMP_JPEG_ASPECT_RATIO_WIDTH              61
/// \brief This command set the heigth of the aspect ratio of the decoded frame.
/// \param value Aspect ratio (height)
#define Q_AVDEC_CMP_JPEG_ASPECT_RATIO_HEIGHT             62
/// \brief Reserved for codec use. This command set the deocder input format. Two formats are supported:
///        QBOX format and elementary JPEG format. The QBOX format can only be used with the Direct 
///        Memory Transfer Read Streamer. Note that this command is set internally by the codec. The
///        host or application layer should not set it.
/// \param ME_STREAM_VIDEO or ME_STREAM_QBOX
#define Q_AVDEC_CMP_JPEG_BITSTREAM_FORMAT                63
/// \brief Reserved for future use.
#define Q_AVDEC_CMP_JPEG_RESERVED_START                  64
/// \brief Reserved for future use.
#define Q_AVDEC_CMP_JPEG_RESERVED_END                    72
/// \brief This command sets the Transport Stream Program ID of the audio stream.
/// \param value Transport Stream Program ID.
/// \return   1 = Success, 0 = Failure
#define Q_AVDEC_CMP_AUDIO_TS_PID                         73 

#define Q_AVDEC_CMD_MAX                                  74
//////////////////////////////////////////////////////////////////////
//
// Configuration parameter values
//
// Generated from mediaware.h ME_AUDIO_CODEC_TYPE s/ME_AUDIO_CODEC/Q_AVDEC_CFP_AUDIO_CODEC/
#define Q_AVDEC_CFP_AUDIO_CODEC_NONE                 0
#define Q_AVDEC_CFP_AUDIO_CODEC_QAC                  1
#define Q_AVDEC_CFP_AUDIO_CODEC_QPCM                 2
#define Q_AVDEC_CFP_AUDIO_CODEC_QMA                  3
#define Q_AVDEC_CFP_AUDIO_CODEC_Q711                 4
#define Q_AVDEC_CFP_AUDIO_CODEC_Q722                 5
#define Q_AVDEC_CFP_AUDIO_CODEC_Q726                 6
#define Q_AVDEC_CFP_AUDIO_CODEC_Q728                 7
#define Q_AVDEC_CFP_AUDIO_CODEC_ADTS                 8
#define Q_AVDEC_CFP_AUDIO_CODEC_NUM_TYPES            9

/// \brief This parameter is to be used with command Q_AVDEC_CMP_AUDIO_CHANNEL_NUM.
/// It sets the number of audio channel to 1
#define Q_AVDEC_CFP_AUDIO_CHANNEL_MONO                   1
/// \brief This parameter is to be used with command Q_AVDEC_CMP_AUDIO_CHANNEL_NUM.
/// It sets the number of audio channel to 2
#define Q_AVDEC_CFP_AUDIO_CHANNEL_STEREO                 2

#define Q_AVDEC_CFP_PORT_TYPE_VIDEO                1
#define Q_AVDEC_CFP_PORT_TYPE_AUDIO                2

// the following parameter must have the same numerical values as those in ME_VIDEO_CODEC_TYPE defined in mediaware.h
/// \brief This parameter is to be used with the object constructor.  It sets video codec type to none.
#define Q_AVDEC_CFP_VIDEO_CODEC_NONE                    0
/// \brief This parameter is to be used with the object constructor.  This parameter is not used.  
/// It is for backward compatibility only.
#define Q_AVDEC_CFP_VIDEO_CODEC_HVC                     1
/// \brief This parameter is to be used with the object constructor.  It sets video codec type to AVC.
#define Q_AVDEC_CFP_VIDEO_CODEC_AVC                     2
/// \brief This parameter is to be used with the object constructor.  It sets video codec type to Mpeg-2
#define Q_AVDEC_CFP_VIDEO_CODEC_M2V                     3
/// \brief This parameter is to be used with the object constructor.  It sets video codec type to Jpeg
#define Q_AVDEC_CFP_VIDEO_CODEC_JPEG                    4
/// \brief This parameter is to be used with the object constructor.  It sets video codec type to super low 
/// delay AVC.  This codec must be used with Direct Memory Transfer bit stream reader. 
#define Q_AVDEC_CFP_VIDEO_CODEC_AVC_INSTANT_DISPLAY     5
/// \brief This parameter is to be used with the object constructor.  It sets video codec type to super low 
/// delay Jpeg.  This codec must be used with Direct Memory Transfer bit stream reader. 
#define Q_AVDEC_CFP_VIDEO_CODEC_JPEG_INSTANT_DISPLAY    6

#define Q_AVDEC_CFP_VIDEO_FIELD_ORDER_AUTO                    0
#define Q_AVDEC_CFP_VIDEO_FIELD_ORDER_FORCE_TOP_FIRST         1
#define Q_AVDEC_CFP_VIDEO_FIELD_ORDER_FORCE_BOTTOM_FIRST      2

#define Q_AVDEC_CFP_FALSE                          0
#define Q_AVDEC_CFP_TRUE                           1

#define Q_AVDEC_CFP_VIDEO_STREAM_MP4               0
#define Q_AVDEC_CFP_VIDEO_STREAM_QBOX              1
#define Q_AVDEC_CFP_VIDEO_STREAM_TS                4
#define Q_AVDEC_CFP_VIDEO_STREAM_PS                5

#define Q_AVDEC_CFP_VIDEO_STREAM_TUNER             1 
#define Q_AVDEC_CFP_VIDEO_STREAM_FILE              2 

#define Q_AVDEC_CFP_AUDIO_STREAM_QBOX              4
#define Q_AVDEC_CFP_AUDIO_STREAM_TS                5


#define Q_AVDEC_CFP_AAC_LC                         2
#define Q_AVDEC_CFP_AAC_LTP                        4
#define Q_AVDEC_CFP_ER_AAC_LC                      17 
#define Q_AVDEC_CFP_ER_AAC_LTP                     19 
#define Q_AVDEC_CFP_ER_AAC_LD                      23 


// must have same numerical value as ME_VIDEO_OUTPUT_TIMING_TYPE
/// \brief This parameter is to be used with command Q_AVDEC_CMP_VIDEO_OUTPUT_TIMING.
/// It resets video output timing back to default.
#define Q_AVDEC_CFP_VIDEO_OUTPUT_TIMING_NORMAL     0
/// \brief This parameter is to be used with command Q_AVDEC_CMP_VIDEO_OUTPUT_TIMING.
/// It resets video output timing to low delay mode.  This mode only works with IP only bit streams.
#define Q_AVDEC_CFP_VIDEO_OUTPUT_TIMING_LOW_DELAY  1
/// \brief This parameter is to be used with command Q_AVDEC_CMP_VIDEO_OUTPUT_TIMING.
/// It resets video output timing to super low delay mode.  This mode only works with IP only bit streams.
#define Q_AVDEC_CFP_VIDEO_OUTPUT_TIMING_ZERO_DELAY 2
/// \brief This parameter sets the little endian type for the pcm decoder.
#define Q_AVDEC_CFP_AUDIO_QPCM_LITTLE_ENDIAN             1
/// \brief This parameter sets the big endian type for the pcm decoder.
#define Q_AVDEC_CFP_AUDIO_QPCM_BIG_ENDIAN                2
//////////////////////////////////////////////////////////////////////
//
// Status block
//

/// \brief The following constants are part of the Q_AVDEC_EV_VIDEO_END_OF_STREAM message.  They
/// show the cause of the EOS message.
#define Q_AVDEC_CFP_VIDEO_EOS_TYPE_NIL              0
#define Q_AVDEC_CFP_VIDEO_EOS_TYPE_END_OF_STREAM    1
#define Q_AVDEC_CFP_VIDEO_EOS_TYPE_END_OF_FILE      2
#define Q_AVDEC_CFP_VIDEO_EOS_TYPE_STOP_COMMAND     3


/// \}
#endif
