/*******************************************************************************
*
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
*
* Copyright 2010 Mobilygen Corporation.
* All rights reserved.
*
* QuArc is a registered trademark of Mobilygen Corporation.
*
* Version: SDK7r26554
*
*******************************************************************************/


#ifndef OBJECTTRACKING_H
#define OBJECTTRACKING_H


/****************************************************************************
DEFINES
*****************************************************************************/
//! \brief sate of objects
enum motObjectState_t {
        mot_UNTRACKED,           // 0 
        mot_ACTIVE,              // 1
        mot_ACTIVE_MERGED,       // 2
        mot_ACTIVE_SPLIT,        // 3
        mot_INACTIVE,            // 4
        mot_INACTIVE_NO_PROGENY, // 5
        mot_INACTIVE_MERGED,     // 6
        mot_INACTIVE_EXIT,       // 7
};

typedef struct _FinalObject
{
   uint32_t start_x;            // Top left x-coordinate in pixels of the rectangle enclosing the object 
   uint32_t end_x;              // Bottom right y-coordinate in pixels of the rectangle enclosing the object  
   uint32_t start_y;            // Top left y-coordinate in pixels of the rectangle enclosing the object 
   uint32_t end_y;              // Top left x-coordinate in pixels of the rectangle enclosing the object 

   uint32_t object_id;          // The id is a non-zero number that identifies the object from frame to frame.
   uint32_t frame_id;           // Current frame number 

   uint32_t contour_addr;       // Address where the contour information is stored

   uint32_t luma;               // Average luma content of the object. Value ranges from 0 to 255.
   uint32_t lumaMotion;         // Average luma motion corresponding to the object. Value ranges from 0 to 255.
   uint32_t chromaMotion;       // Average chroma motion corresponding to the object. Value ranges from 0 to 255.
   uint32_t color0;             // Average number of pixels in the object that have Color0. See VPP documentation for configuration of Color0.
   uint32_t color1;             // Average number of pixels in the object that have Color0. See VPP documentation for configuration of Color1.
   uint32_t color2;             // Average number of pixels in the object that have Color0. See VPP documentation for configuration of Color2.
   uint32_t color3;             // Average number of pixels in the object that have Color0. See VPP documentation for configuration of Color3.

   int      mvX;                // The x component of the motion vector corresponding to the object.
   int      mvY;                // The x component of the motion vector corresponding to the object.

   uint32_t numBlocksInMotion;  // The number of MB's that belong to the object. It represents the size of the object detected in number of MB's.

   uint32_t totalTime;          // cumulative time since object appeared                             
   uint32_t activeTime;         // count for current active state                                    
   uint32_t inactiveTime;       // count for current inactive state                                  
   enum motObjectState_t state; // object's tracking state

} FinalObject;

#endif  /* OBJECTTRACKING_H */
/*******************************************************************************
 * vi: set shiftwidth=4 tabstop=8 softtabstop=4 expandtab nosmarttab:
 *******************************************************************************/
