#ifndef __LINUX_MG3500FB_H__
#define __LINUX_MG3500FB_H__

#include <linux/ioctl.h>
#include <linux/types.h>

struct mg3500_screen_mode {
	__u8	enable;
#define MG3500FB_ALPHA_SELECT_SOURCE          0
#define MG3500FB_ALPHA_SELECT_SCREEN          1
	__u8	alpha_select;
#define MG3500FB_FTU_USE_TOP_FIELD            0
#define MG3500FB_FTU_USE_BOTTOM_FIELD         1
#define MG3500FB_FTU_USE_PARITY_FIELD         2
#define MG3500FB_FTU_USE_NON_PARITY_FIELD     3
	__u8	ftu;
	__u8	premultiply;
#define MG3500FB_FS_ZERO                      0
#define MG3500FB_FS_ONE                       1
#define MG3500FB_FS_COLOR_MODIFIER            2
#define MG3500FB_FS_ONE_MINUS_COLOR_MODIFIER  3
	__u8	fs;
#define MG3500FB_FD_ZERO                      0
#define MG3500FB_FD_ONE                       1
#define MG3500FB_FD_ALPHA_MODIFIER            2
#define MG3500FB_FD_ONE_MINUS_ALPHA_MODIFIER  3
	__u8	fd;
	__u8	z;
	__u8	alpha;
	__u8	color_modifier;
	__u8	alpha_modifier;
	__u8	hzoom;
	__u8	vzoom;
	__u16	hoffset;
	__u16	voffset;
#define MG3500FB_FLAGS_ENABLE                 0x00000001
#define MG3500FB_FLAGS_ALPHA_SELECT           0x00000002
#define MG3500FB_FLAGS_FTU                    0x00000004
#define MG3500FB_FLAGS_PREMULTIPLY            0x00000008
#define MG3500FB_FLAGS_FS                     0x00000010
#define MG3500FB_FLAGS_FD                     0x00000020
#define MG3500FB_FLAGS_Z                      0x00000040
#define MG3500FB_FLAGS_ALPHA                  0x00000080
#define MG3500FB_FLAGS_COLOR_MODIFIER         0x00000100
#define MG3500FB_FLAGS_ALPHA_MODIFIER         0x00000200
#define MG3500FB_FLAGS_HZOOM                  0x00000400
#define MG3500FB_FLAGS_VZOOM                  0x00000800
#define MG3500FB_FLAGS_HOFFSET                0x00001000
#define MG3500FB_FLAGS_VOFFSET                0x00004000
	__u32	flags;
};

struct mg3500_color_key {
	__u8	ck_y;
	__u8	ck_cb;
	__u8	ck_cr;
	__u8	ck_r;
	__u8	ck_g;
	__u8	ck_b;
#define MG3500FB_CK_MODE_NONE                 0
#define MG3500FB_CK_MODE_SCREEN               1
#define MG3500FB_CK_MODE_DISPLAY              2
	__u8	ck_mode;
#define MG3500FB_FLAGS_CK_YUV                 0x01
#define MG3500FB_FLAGS_CK_RGB                 0x02
#define MG3500FB_FLAGS_CK_MODE                0x04
	__u8	flags;
};

struct mg3500_physinfo {
	__u32	dmah;
	unsigned long	list_base;
	__u32	list_len;
	unsigned long	part_base;
	__u32	part_len;
};

#define MG3500FB_SET_SCREEN_MODE	_IOWR('m', 0x01, struct mg3500_screen_mode)
#define MG3500FB_GET_SCREEN_MODE	_IOR('m', 0x01, struct mg3500_screen_mode)
#define MG3500FB_SET_COLOR_KEY		_IOWR('m', 0x02, struct mg3500_color_key)
#define MG3500FB_GET_COLOR_KEY		_IOR('m', 0x02, struct mg3500_color_key)
#define MG3500FB_GET_PHYSINFO		_IOR('m', 0x03, struct mg3500_physinfo)

#endif  /* __LINUX_MG3500FB_H__ */
