/*
 *  This file Copyright (C) 2007 Mobilygen Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GPIOSPI_H_
#define _GPIOSPI_H_

/* 
 */
struct gpiospi_chip_data {
	
	/* Name/decsription for slave chip (can be empty but NOT null). */
	const char *name;
	
	/* Chip select GPIO pin (-1 if none). */
	int pin_cs_;
	
	/* Strobe pin (-1 if none). */
	int pin_strobe;
	
	/*
	 * Set to 1 if this slave chip shares either its 
	 * STROBE or CHIP SELECT pin with another slave chip.
	 */
	//int share_cs;
	
	/* Strobe delay in ns, not used if strobe pin == -1. */
	int strobe_delay_ns;
	
	/* Time to wait before the strobe pulse is done. */
	int strobe_predelay_ns;
	
	/* 
	 * Time to wait after the strobe pulse is done. 
	 * This field is equivalent to setting delay_usec field for each 
	 * spi_transfer, except that you can choose to delay only when a 
	 * probe is issued and not when a chip deselect is issued.
	 */
	int strobe_postdelay_ns; 
	
	/*
	 * Time to wait after a chip is deselected (prevents next transfer 
	 * to occur too soon, eg. if a computation needs to be done between transfers).
	 * This field is equivalent to setting delay_usec field for each spi_transfer, 
	 * except that you can choose to delay only when a chip deselect is issued and
	 * not when probe is issued.
	 */
	int cs__postdelay_ns;
	
	/* 
	 * Alternate output GPIO pin to used specifically with this slave.
	 * NOTE: the bus MOSI pin will NOT be used if this is defined.
	 * TO LEAVE UNDEFINED SET IT TO -1 *OR* ZERO (other pins -> undefined == -1 ONLY).
	 */
	int alt_pin_mosi;
	
	/* Same as above but for input */
	int alt_pin_miso;
};


struct gpiospi_chip {
	struct spi_board_info info;
	struct gpiospi_chip_data cdata;
};

/* Pass this as platform_data for each the BUS platform_devices. */

struct gpiospi_bus_data {
	
	/* GPIO driver or group to use. */
	const char *gpio_group;
	
	/* Clock GPIO pin. */
	int pin_sclk;
	
	/*
	 * Output GPIO pin.
	 * (can be -1 if an alternate MOSI pin is defined 
	 * for each slave on this bus, see struct below).
	 */
	int pin_mosi;
	
	/*
	 * Input GPIO pin.
	 * (can be -1 if an alternate MOSI pin is defined 
	 * for each slave on this bus, see struct below).
	 */
	int pin_miso;
	
	/* Devices on this bus. */
	struct gpiospi_chip *chips;
	u16 num_chips;
};


#endif /* #ifndef _GPIOSPI_H_ */
