/*
 *  This file Copyright (C) 2007 Mobilygen Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GPIOI2C_H_
#define _GPIOI2C_H_

#ifndef I2C_HW_B_GPIO
#define I2C_HW_B_GPIO 0x010022
#endif

/* Pass this as platform_data for each platform_devices. */

struct gpioi2c_bus_data {

	/* GPIO driver name or group to use. */
	const char *gpio_group;

	/* Clock GPIO pin. */
	int pin_scl;
	
	/* Data GPIO pin. */
	int pin_sda;
	
	/*
	 * Transfer timeout in msecs. 
	 * If zero, default will be set.
	 */
#define GPIOI2C_DEFAULT_TIMEOUT 	500
	unsigned long timeout_msecs;
	
	/*
	 * Half clock cycle time in us,
	 * minimum 2 us for fast-mode I2C,
	 * minimum 5 us for standard-mode I2C and SMBus,
	 * maximum 50 us for SMBus.
	 * If zero, default will be set.
	 */
#define GPIOI2C_DEFAULT_UDELAY 		2
	unsigned long udelay;
};

#endif /* #ifndef _GPIOI2C_H_ */
