#ifndef SPI_SLAVE_FRAMEWORK_H
#define SPI_SLAVE_FRAMEWORK_H


struct slave {
	int phase;
	int polarity;
	int position;
	int datasize;
	int threshold;
	int (*slave_transfer)(char *buffer, int size, int flags);
	int (*slave_prefill)(char *tab);
};

struct bus {
	int position;
	int num;
	int flags;
	int (*set_slave)(struct bus *bus, int phase, int polarity, int datasize, int threshold);
};

struct combination {
	struct slave *slave;
	struct bus *bus;
};

int spi_master_bus_register(struct bus *bus);
int spi_add_bus(struct bus *bus);
int spi_master_bus_unregister(struct bus *bus);
int spi_slave_register(struct slave *slave);
int spi_add_slave(struct slave *slave);
int spi_slave_unregister(struct slave *slave);
int spi_slave_flags(int position);
char spi_slave_access(int position, char *buffer, int size, int flags);
int spi_slave_prefill(int position, char *tab);

#endif
