/*
 *  This file Copyright (C) 2009 Maxim IC
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE   LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef PCI_BAR0_OFFSETS_H
#define PCI_BAR0_OFFSETS_H

/* 
 * BAR0 gives us mappings into some other blocks, these are just provided
 * to give the offsets of these other blocks within the BAR.  Full register
 * addresses for the given block will be defined in other header files
 */
#define BAR0_QCC_OFFSET         (0)
#define BAR0_QCC_END            (BAR0_QCC_OFFSET+0xFFFF)
#define BAR0_QCC_SIZE           (BAR0_QCC_END-BAR0_QCC_OFFSET+1)

#define BAR0_PCIE_PHY_OFFSET    (BAR0_QCC_END+1)
#define BAR0_PCIE_PHY_END       (BAR0_PCIE_PHY_OFFSET+0xFFFF)
#define BAR0_PCIE_PHY_SIZE      (BAR0_PCIE_PHY_END-BAR0_PCIE_PHY_OFFSET+1)

#define BAR0_VIDEO_DATA_OFFSET  (BAR0_PCIE_PHY_END+1)
#define BAR0_VIDEO_DATA_END     (BAR0_VIDEO_DATA_OFFSET+0xFFFF)
#define BAR0_VIDEO_DATA_SIZE    (BAR0_VIDEO_DATA_END-BAR0_VIDEO_DATA_OFFSET+1)

#define BAR0_AXI_MMU_OFFSET     (BAR0_VIDEO_DATA_END+1)
#define BAR0_AXI_MMU_END        (BAR0_AXI_MMU_OFFSET+0xFFF)
#define BAR0_AXI_MMU_SIZE       (BAR0_AXI_MMU_END-BAR0_AXI_MMU_OFFSET+1)

#define BAR0_VIDEO_REGS_OFFSET  (BAR0_AXI_MMU_END+1)
#define BAR0_VIDEO_REGS_END     (BAR0_VIDEO_REGS_OFFSET+0xFFF)
#define BAR0_VIDEO_REGS_SIZE    (BAR0_VIDEO_REGS_END-BAR0_VIDEO_REGS_OFFSET+1)

#define BAR0_PCIE_REGS_OFFSET   (BAR0_VIDEO_REGS_END+1)
#define BAR0_PCIE_REGS_END      (BAR0_PCIE_REGS_OFFSET+0xFFF)
#define BAR0_PCIE_REGS_SIZE     (BAR0_PCIE_REGS_END-BAR0_PCIE_REGS_OFFSET+1)

#endif  /* PCI_BAR0_OFFSETS_H */
