#ifndef __MACH_DW_TIMERS_REGS_H
#define __MACH_DW_TIMERS_REGS_H

#include <mach/platform.h>

/* Timer Registers */
#define TIMER_LOAD_COUNT    0x0
#define TIMER_CURRENT_VALUE 0x4
#define TIMER_CONTROL       0x08
#define TIMER_EOI           0x0c
#define TIMER_INT_STATUS    0x10

struct dw_timer_regs {
	unsigned long load_count;
	unsigned long current_value;
	unsigned long control;
	unsigned long eoi;
	unsigned long int_status;
};

/* Timer Control Values */
#define TIMER_INTERRUPT_MASK 0x4
#define TIMER_MODE_FREERUN   0x0
#define TIMER_MODE_USER      0x2
#define TIMER_ENABLE         0x1
#define TIMER_DISABLE        0x0

/*
 * There are five timer instances in the timers block:
 *  Timer1: clocked off the APB clock (pclk)
 *  Timer2: clocked off of Timer1's overflow toggle bit
 *  Timer3: clocked off of the timer clock
 *  Timer4: clocked off of the timer clock
 *  Timer5: clocked off of the timer clock
 *
 *  Timer4 is special as it is the only one that can be connected to the FIQ
 *
 *  Reading of the TIMER_CURRENT_VALUE register is not gauranteed to be
 *  correct unless the timer's clock is syncronous to the APB clock (pclk)
 */
#define TIMER1_OFFSET       0x0
#define TIMER2_OFFSET       0x14
#define TIMER3_OFFSET       0x28
#define TIMER4_OFFSET       0x3c
#define TIMER5_OFFSET       0x50

#define TIMER1_BASE         (TIMERS_BASE+TIMER1_OFFSET)
#define TIMER2_BASE         (TIMERS_BASE+TIMER2_OFFSET)
#define TIMER3_BASE         (TIMERS_BASE+TIMER3_OFFSET)
#define TIMER4_BASE         (TIMERS_BASE+TIMER4_OFFSET)
#define TIMER5_BASE         (TIMERS_BASE+TIMER5_OFFSET)

#endif  /* __MACH_DW_TIMERS_REGS_H */
