/*
 *  linux/include/asm-arm/arch-merlin/platform.h
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <mach/platform_device_names.h>

#ifndef PLATFORM_H
#define PLATFORM_H

#define MERLIN_SYSTEM_CLOCK	27000000

#define AHB_ARM_BUS_BASE	0x00000000
#define AHB_PERIPH_BUS_BASE	0x80000000
#define APB_BUS_BASE		0x88200000
#define AHB_DMA_BUS_BASE	0x90000000

/* from the Merlin SOC doc, 2.5.1 High level memory map */
/* AHB_ARM bus 
 * #define MMU_BRIDGE_ARM_BASE     AHB_ARM_BUS_BASE 
 * 
 */
#define MMU_BRIDGE_ARM_BASE     AHB_ARM_BUS_BASE
#define MMU_BRIDGE_ARM_END      (MMU_BRIDGE_ARM_BASE+0x3fffffff)
#define MMU_BRIDGE_ARM_SIZE     (MMU_BRIDGE_ARM_END-MMU_BRIDGE_ARM_BASE+1)

/* AHB_PERIPH bus */
#define DTCM_BASE               (AHB_PERIPH_BUS_BASE+0)
#define DTCM_END		(DTCM_BASE+0x3FFF)
#define DTCM_SIZE               (DTCM_END-DTCM_BASE+1)
#define AHB_ARB_PERIPH_BASE     (DTCM_END+1)
#define AHB_ARB_PERIPH_END 	(AHB_ARB_PERIPH_BASE+0x3FF)
#define AHB_ARB_PERIPH_SIZE     (AHB_ARB_PERIPH_END-AHB_ARB_PERIPH_BASE+1)
#define DMAC_BASE               (AHB_ARB_PERIPH_END+1)
#define DMAC_END		(DMAC_BASE+0x3FF)
#define DMAC_SIZE               (DMAC_END-DMAC_BASE+1)
#define ICTL_BASE               (DMAC_END+1)
#define ICTL_END 		(ICTL_BASE+0x3FF)
#define ICTL_SIZE               (ICTL_END-ICTL_BASE+1)
#define QCC_BASE           		(ICTL_END+1)
#define QCC_END 				(QCC_BASE+0x3FF)
#define QCC_SIZE           		(QCC_END-QCC_BASE+1)
#define SDMMC_BASE             	(QCC_END+1)
#define SDMMC_END 				(SDMMC_BASE+0xFFF)
#define SDMMC_SIZE             	(SDMMC_END-SD_MMC_BASE+1)
#define CF_REG_BASE             (SDMMC_END+1)
#define CF_REG_END 				(CF_REG_BASE+0xFFF)
#define CF_REG_SIZE             (CF_REG_END-CF_REG_BASE+1)
#define CF_DATA_BASE            (CF_REG_END+1)
#define CF_DATA_END 		(CF_DATA_BASE+0xFFF)
#define CF_DATA_SIZE            (CF_DATA_END-CF_DATA_BASE+1)
#define FLASH_REG_BASE       	(CF_DATA_END+1)
#define FLASH_REG_END 		(FLASH_REG_BASE+0xFFF)
#define FLASH_REG_SIZE       	(FLASH_REG_END-FLASH_REG_BASE+1)
#define RESERVED0_BASE		(FLASH_REG_END+1)
#define RESERVED0_END		(RESERVED0_BASE+0x6FFF)
#define RESERVED0_SIZE		(RESERVED0_END-RESERVED0_BASE+1)
#define AES_BASE                (RESERVED0_END+1)
#define AES_END 		(AES_BASE+0x3FFF)
#define AES_SIZE                (AES_END-AES_BASE+1)
#define SHA_BASE                (AES_END+1)
#define SHA_END			(SHA_BASE+0x3FFF)
#define SHA_SIZE                (SHA_END-SHA_BASE+1)
#define RESERVED1_BASE		(SHA_END+1)
#define RESERVED1_END		(RESERVED1_BASE+0xE7FFF)
#define RESERVED1_SIZE		(RESERVED1_END-RESERVED1_BASE+1)
#define MHIF_BASE		(RESERVED1_END+1+0x1F00000) // not sequential
#define MHIF_END 		(MHIF_BASE+0x1FFFFFF)
#define MHIF_SIZE		(MHIF_END-MHIF_BASE+1)
#define FLASH_DATA_BASE      	(MHIF_END+1)
#define FLASH_DATA_END 		(FLASH_DATA_BASE+0x3FFFFFF)
#define FLASH_DATA_SIZE      	(FLASH_DATA_END-FLASH_DATA_BASE+1)

/* APB bus */
#define SSI0_BASE           	APB_BUS_BASE //0x88200400
#define SSI0_END		(SSI0_BASE+0x3FF)
#define SSI0_SIZE          	(SSI0_END-SSI0_BASE+1)
#define SSI1_BASE           	(SSI0_END+1)
#define SSI1_END		(SSI1_BASE+0x3FF)
#define SSI1_SIZE          	(SSI1_END-SSI1_BASE+1)
#define SSI2_BASE           	(SSI1_END+1)
#define SSI2_END		(SSI2_BASE+0x3FF)
#define SSI2_SIZE          	(SSI2_END-SSI2_BASE+1)
#define I2C0_BASE           	(SSI2_END+1)
#define I2C0_END		(I2C0_BASE+0x3FF)
#define I2C0_SIZE          	(I2C0_END-I2C0_BASE+1) 
#define I2C1_BASE           	(I2C0_END+1)
#define I2C1_END		(I2C1_BASE+0x3FF)
#define I2C1_SIZE          	(I2C1_END-I2C1_BASE+1) 
#define UART0_BASE          	(I2C1_END+1)
#define UART0_END 		(UART0_BASE+0x3FF)
#define UART0_SIZE          	(UART0_END-UART0_BASE+1)
#define UART1_BASE          	(UART0_END+1)
#define UART1_END 		(UART1_BASE+0x3FF)
#define UART1_SIZE          	(UART1_END-UART1_BASE+1)
#define UARTDBG_BASE        	(UART1_END+1)
#define UARTDBG_END 		(UARTDBG_BASE+0x3FF)
#define UARTDBG_SIZE          	(UARTDBG_END-UARTDBG_BASE+1)
#define TIMERS_BASE         	(UARTDBG_END+1)
#define TIMERS_END 		(TIMERS_BASE+0x3FF)
#define TIMERS_SIZE         	(TIMERS_END-TIMERS_BASE+1)
#define WDT_BASE            	(TIMERS_END+1)
#define WDT_END 		(WDT_BASE+0x3FF)
#define WDT_SIZE         	(WDT_END-WDT_BASE+1)
#define GPIO0_BASE          	(WDT_END+1)
#define GPIO0_END 		(GPIO0_BASE+0x3FF)
#define GPIO0_SIZE         	(GPIO0_END-GPIO0_BASE+1)
#define GPIO1_BASE          	(GPIO0_END+1)
#define GPIO1_END 		(GPIO1_BASE+0x3FF)
#define GPIO1_SIZE         	(GPIO1_END-GPIO1_BASE+1)
#define GPIO2_BASE          	(GPIO1_END+1)
#define GPIO2_END 		(GPIO2_BASE+0x3FF)
#define GPIO2_SIZE         	(GPIO2_END-GPIO2_BASE+1)
#define PWM0_BASE           	(GPIO2_END+1)
#define PWM0_END 		(PWM0_BASE+0x3FF)
#define PWM0_SIZE         	(PWM0_END-PWM0_BASE+1)
#define PWM1_BASE           	(PWM0_END+1)
#define PWM1_END 		(PWM1_BASE+0x3FF)
#define PWM1_SIZE         	(PWM1_END-PWM1_BASE+1)
#define PWM2_BASE           	(PWM1_END+1)
#define PWM2_END 		(PWM2_BASE+0x3FF)
#define PWM2_SIZE         	(PWM2_END-PWM2_BASE+1)

/* AHB_DMA bus */
#define GMAC_BASE               AHB_DMA_BUS_BASE
#define GMAC_END 		(GMAC_BASE+0x1FFF)
#define GMAC_SIZE               (GMAC_END-GMAC_BASE+1)
#define AHB_ARB_DMA_BASE    	(GMAC_END+1)
#define AHB_ARB_DMA_END 	(AHB_ARB_DMA_BASE+0x3FF)
#define AHB_ARB_DMA_SIZE        (AHB_ARB_DMA_END-AHB_ARB_DMA_BASE+1)
#define USB_BASE                0x90100000
#define USB_END 		(USB_BASE+0x3FFFF)
#define USB_SIZE               	(USB_END-USB_BASE+1)

#define MMU_BRIDGE_DMA_BASE     0xC0000000
#define MMU_BRIDGE_DMA_END 	(MMU_BRIDGE_DMA_BASE+0x3FFFFFFF)
#define MMU_BRIDGE_DMA_SIZE     (MMU_BRIDGE_DMA_END-MMU_BRIDGE_DMA_BASE+1)

#endif  /* PLATFORM_H */
