/*
 * include/asm-arm/arch-merlin/entry-macro.S
 * 
 * Modified for Mobilygen Merlin platform
 *
 * Copyright (C) 2006 Mobilygen Corp.
 *
 * include/asm-arm/arch-versatile/entry-macro.S
 *
 * Low-level IRQ helper macros for Versatile platforms
 *
 * This file is licensed under  the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */
#include <mach/hardware.h>
#include <mach/platform.h>
#include <mach/dw_ictl_regs.h>

		.macro	disable_fiq
		.endm

		.macro  get_irqnr_preamble, base, tmp
		ldr     \base, =IO_ADDRESS(ICTL_BASE)
		.endm

		.macro  arch_ret_to_user, tmp1, tmp2
		.endm

		@ get_irqnr_and_base r0, r6, r5, lr
		.macro	get_irqnr_and_base, irqnr, irqstat, base, tmp
		ldr	\base, =IO_ADDRESS(ICTL_BASE)
		ldr	\irqstat, [\base, #MOBI_ICTL_IRQ_STATUS_L_OFFSET]	@ get masked status
		mov	\irqnr, #0
		teq	\irqstat, #0
		bne	1001f
		ldr	\irqstat, [\base, #MOBI_ICTL_IRQ_STATUS_H_OFFSET]	@ get masked status
		teq	\irqstat, #0
		beq	1003f
		@ if here no bits set in the status_l but at least 1 is set in status_h
		add	\irqnr, \irqnr, #32	@ add 32 to irqnr since in status_h

		@ irqnr returns the number of right shift to get to the first non-zero bit 
		@ in the status reg, which then gives us the irq number
1001:		tst	\irqstat, #15 	
		bne	1002f				@ branch if not equal zero
		add	\irqnr, \irqnr, #4		@ add 4 to irqnr
		movs	\irqstat, \irqstat, lsr #4 	@ shift right irqstat by 4
		bne	1001b

1002:		tst	\irqstat, #1
		bne	1003f
		add	\irqnr, \irqnr, #1
		movs	\irqstat, \irqstat, lsr #1
		bne	1002b

1003:		/* EQ will be set if no irqs pending */

		.endm

