/*
 * arch/arm/mach-merlin/include/mach/clock_ids.h
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _ARCH_MERLIN_INCLUDE_CLOCK_IDS_H
#define _ARCH_MERLIN_INCLUDE_CLOCK_IDS_H

#define CLOCK_FLAG_NONE  	0x00000000

#define VIDEO_CLOCK_INVERT_ENABLE 	0x00000001
#define VIDEO_CLOCK_INVERT_DISABLE 	0x00000002
#define VIDEO_CLOCK_INVERT_MASK 	0x00000003

#define VIDEO_CLOCK_OUTCLK_ENABLE	0x00000004
#define VIDEO_CLOCK_OUTCLK_DISABLE	0x00000008
#define VIDEO_CLOCK_OUTCLK_MASK		0x0000000C

#define VIDEO_CLOCK_PIXCLK_ENABLE	0x00000010
#define VIDEO_CLOCK_PIXCLK_DISABLE	0x00000020
#define VIDEO_CLOCK_PIXCLK_MASK		0x00000030

#define AUDIO_CLOCK_MCLK_ENABLE		0x00000001
#define AUDIO_CLOCK_MCLK_DISABLE	0x00000002
#define AUDIO_CLOCK_MCLK_MASK		0x00000003

enum clock_id {
	CLOCK_ID_NONE = 0,
	CLOCK_ID_PLL0 = 1,
	CLOCK_ID_PLL1,
	CLOCK_ID_PLL2,
	CLOCK_ID_PLL3,
	CLOCK_ID_SCALER0,
	CLOCK_ID_SCALER1,
	CLOCK_ID_SCALER2,
	CLOCK_ID_SCALER3,
	CLOCK_ID_QMM,
	CLOCK_ID_VIN0,
	CLOCK_ID_VIN1,
	CLOCK_ID_VOUT0,
	CLOCK_ID_UARTDBG,
	CLOCK_ID_UART0,
	CLOCK_ID_UART1,
	CLOCK_ID_I2C0,
	CLOCK_ID_I2C1,
	CLOCK_ID_PLL2HL,
	CLOCK_ID_PLL3HL,
	CLOCK_ID_TIMER,
	CLOCK_ID_SDMMC,
	CLOCK_ID_SSI0,
	CLOCK_ID_SSI1,
	CLOCK_ID_BS,
	CLOCK_ID_ARM,
	CLOCK_ID_AHB,
	CLOCK_ID_APB,
	CLOCK_ID_AUD0,
	CLOCK_ID_AUD1,
	CLOCK_ID_MEMBUS,
	CLOCK_ID_CORE,
	CLOCK_ID_MAX    /* this should always be the last entry */
};

typedef enum clock_id clock_id_t;

#endif
