/*
 *  linux/include/asm-arm/arch-falcon/irqs.h
 *
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* as of rev74464 of blocks/soc/rtl/m6_soc_intr_routing_defines.h */
/* irqs that have 'n' in the name are active low */
#define MOBI_IRQ_nPMU			0
#define MOBI_IRQ_TIMER1			1
#define MOBI_IRQ_TIMER2			2
#define MOBI_IRQ_TIMER3			3
#define MOBI_IRQ_TIMER4			4
#define MOBI_IRQ_TIMER5			5
#define MOBI_IRQ_WDT			6  
#define MOBI_IRQ_FLASH			7
#define MOBI_IRQ_USB			8
#define MOBI_IRQ_GMAC			9
#define MOBI_IRQ_SATA			10
#define MOBI_IRQ_SDMMC			11
#define MOBI_IRQ_DMAC0			12
#define MOBI_IRQ_DMAC1			13
#define MOBI_IRQ_DMAC2			14
#define MOBI_IRQ_DMAC3			15
#define MOBI_IRQ_SHA			16
#define MOBI_IRQ_AES			17
#define MOBI_IRQ_VPP			18
#define MOBI_IRQ_PCIE			19
#define MOBI_IRQ_nPCI_A			20
#define MOBI_IRQ_nPCI_B			21
#define MOBI_IRQ_nPCI_C			22
#define MOBI_IRQ_nPCI_D			23
#define MOBI_IRQ_PCI_DMA0		24
#define MOBI_IRQ_PCI_DMA1		25
#define MOBI_IRQ_SSI0			26
#define MOBI_IRQ_SSI1			27
#define MOBI_IRQ_SSI2			28
#define MOBI_IRQ_I2C0			29
#define MOBI_IRQ_I2C1			30
#define MOBI_IRQ_UARTDBG		31
#define MOBI_IRQ_UART1			32
#define MOBI_IRQ_UART0			33
#define MOBI_IRQ_PWM0			34
#define MOBI_IRQ_PWM1			35
#define MOBI_IRQ_PWM2			36
#define MOBI_IRQ_GPIO0			37
#define MOBI_IRQ_GPIO1			38
#define MOBI_IRQ_GPIO2			39
#define MOBI_IRQ_PCI_SERR		40
#define MOBI_IRQ_ARM_MBOX0		41
#define MOBI_IRQ_ARM_MBOX1		42
#define MOBI_IRQ_ARM_MBOX2		43
#define MOBI_IRQ_ARM_MBOX3		44
#define MOBI_IRQ_GPU0			45
#define MOBI_IRQ_GPU1			46
#define MOBI_IRQ_GPU2			47
#define MOBI_IRQ_GPU3			48
#define MOBI_IRQ_VPU0_TIM       49
#define MOBI_IRQ_VPU1_TIM       50
#define MOBI_IRQ_VPU0_CMDREQ    51
#define MOBI_IRQ_VPU1_CMDREQ    52
#define MOBI_IRQ_AXI_DECERR     53
#define MOBI_IRQ_AXI_SLVERR     54
/* XXX make sure this is always 1+ the last real IRQ */
#define NR_IRQS	 55

/* we don't use this but it must be define for fiq.c to compile */
#define FIQ_START	0
