/*
 * arch/arm/mach-falcon/include/mach/clock_ids.h
 *
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _ARCH_FALCON_INCLUDE_CLOCK_IDS_H
#define _ARCH_FALCON_INCLUDE_CLOCK_IDS_H

#define CLOCK_FLAG_NONE  	  0x00000000

#define CLOCK_CTRLREG_TYPE_PLL        0x80000000
#define CLOCK_CTRLREG_TYPE_HL         0x40000000
#define CLOCK_CTRLREG_TYPE_NR         0x20000000
/* indicates a derived clock that can be queried 
 * but not set, for example, ahb from arm */
#define CLOCK_CTRLREG_TYPE_NONE       0x10000000

#define CLOCK_ID_NONE         (CLOCK_CTRLREG_TYPE_NONE | 0x00000000)
#define CLOCK_ID_PLL0         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000001)
#define CLOCK_ID_PLL1         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000002)
#define CLOCK_ID_PLL2         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000003)
#define CLOCK_ID_PLL3         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000004)
#define CLOCK_ID_PLL4         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000005)
#define CLOCK_ID_PLL5         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000006)
#define CLOCK_ID_PLL6         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000007)
#define CLOCK_ID_PLL7         (CLOCK_CTRLREG_TYPE_PLL  | 0x00000008)
#define CLOCK_ID_QMM          (CLOCK_CTRLREG_TYPE_NR   | 0x00000009)
#define CLOCK_ID_UARTDBG      (CLOCK_CTRLREG_TYPE_HL   | 0x0000000a)
#define CLOCK_ID_UART0        (CLOCK_CTRLREG_TYPE_HL   | 0x0000000b)
#define CLOCK_ID_UART1        (CLOCK_CTRLREG_TYPE_HL   | 0x0000000c)
#define CLOCK_ID_I2C0         (CLOCK_CTRLREG_TYPE_HL   | 0x0000000d)
#define CLOCK_ID_I2C1         (CLOCK_CTRLREG_TYPE_HL   | 0x0000000e)
#define CLOCK_ID_TIMER        (CLOCK_CTRLREG_TYPE_HL   | 0x0000000f)
#define CLOCK_ID_SDMMC        (CLOCK_CTRLREG_TYPE_HL   | 0x00000010)
#define CLOCK_ID_ARM          (CLOCK_CTRLREG_TYPE_NR   | 0x00000011)
#define CLOCK_ID_AHB          (CLOCK_CTRLREG_TYPE_NONE | 0x00000012)
#define CLOCK_ID_APB          (CLOCK_CTRLREG_TYPE_NONE | 0x00000013)
#define CLOCK_ID_AXI          (CLOCK_CTRLREG_TYPE_NR   | 0x00000014)
#define CLOCK_ID_MEM          (CLOCK_CTRLREG_TYPE_NR   | 0x00000015)
#define CLOCK_ID_CORE         (CLOCK_CTRLREG_TYPE_NONE | 0x00000016)

/* can be used with linux API */
#define CLOCK_ID_NONE_NAME          "none"
#define CLOCK_ID_PLL0_NAME          "pll0"
#define CLOCK_ID_PLL1_NAME          "pll1"
#define CLOCK_ID_PLL2_NAME          "pll2"
#define CLOCK_ID_PLL3_NAME          "pll3"
#define CLOCK_ID_PLL4_NAME          "pll4"
#define CLOCK_ID_PLL5_NAME          "pll5"
#define CLOCK_ID_PLL6_NAME          "pll6"
#define CLOCK_ID_PLL7_NAME          "pll7"
#define CLOCK_ID_QMM_NAME           "qmm"
#define CLOCK_ID_UARTDBG_NAME       "uartdbg"
#define CLOCK_ID_UART0_NAME         "uart0"
#define CLOCK_ID_UART1_NAME         "uart1"
#define CLOCK_ID_I2C0_NAME          "i2c0"
#define CLOCK_ID_I2C1_NAME          "i2c1"
#define CLOCK_ID_TIMER_NAME         "timer"
#define CLOCK_ID_SDMMC_NAME         "sdmmc"
#define CLOCK_ID_ARM_NAME           "arm"
#define CLOCK_ID_AHB_NAME           "ahb"
#define CLOCK_ID_APB_NAME           "apb"
#define CLOCK_ID_AXI_NAME           "axi"
#define CLOCK_ID_MEM_NAME           "mem"
#define CLOCK_ID_CORE_NAME          "core"

typedef uint32_t clock_id_t;

/* we also have clock gating to enable/disable certain clocks, these 
 * do not necessarily have a corresponding match in CLOCK_IDs
 */

#define GATED_CLOCK_ID_NONE          0x0
#define GATED_CLOCK_ID_AHB_ARM       QCC_CHIPCTL_CLOCKENABLESET_AHB_ARM_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_GMAX      QCC_CHIPCTL_CLOCKENABLESET_AHB_GMAC_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_DMAC      QCC_CHIPCTL_CLOCKENABLESET_AHB_DMAC_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_USB       QCC_CHIPCTL_CLOCKENABLESET_AHB_USB_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_SATA      QCC_CHIPCTL_CLOCKENABLESET_AHB_SATA_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_DMAMMU    QCC_CHIPCTL_CLOCKENABLESET_AHB_DMAMMU_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_FLASH     QCC_CHIPCTL_CLOCKENABLESET_AHB_FLASH_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_SDMMC     QCC_CHIPCTL_CLOCKENABLESET_AHB_SDMMC_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_AES       QCC_CHIPCTL_CLOCKENABLESET_AHB_AES_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_SHA       QCC_CHIPCTL_CLOCKENABLESET_AHB_SHA_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_PCIE      QCC_CHIPCTL_CLOCKENABLESET_AHB_PCIE_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_PCI       QCC_CHIPCTL_CLOCKENABLESET_AHB_PCI_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_SPI       QCC_CHIPCTL_CLOCKENABLESET_AHB_SPI_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_AHBAXI    QCC_CHIPCTL_CLOCKENABLESET_AHB_AXI_SS_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_APB_SS        QCC_CHIPCTL_CLOCKENABLESET_APB_SS_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_H2HPER    QCC_CHIPCTL_CLOCKENABLESET_AHB_H2H_PER_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AHB_ICU       QCC_CHIPCTL_CLOCKENABLESET_AHB_ICU_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AXI_PCIE      QCC_CHIPCTL_CLOCKENABLESET_AXI_PCIE_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_AXI_SS        QCC_CHIPCTL_CLOCKENABLESET_AXI_AXI_SS_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_MEM_AXIMMU    QCC_CHIPCTL_CLOCKENABLESET_MEM_AXIMMU_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_MEM_ARMMMU    QCC_CHIPCTL_CLOCKENABLESET_MEM_ARMMMU_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_MEM_DMAMMU    QCC_CHIPCTL_CLOCKENABLESET_MEM_DMAMMU_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_MEM0          QCC_CHIPCTL_CLOCKENABLESET_MEM0_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_MEM1          QCC_CHIPCTL_CLOCKENABLESET_MEM1_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_VPU0          QCC_CHIPCTL_CLOCKENABLESET_VPU0_CLK_EN_SET_MASK
#define GATED_CLOCK_ID_VPU1          QCC_CHIPCTL_CLOCKENABLESET_VPU1_CLK_EN_SET_MASK

#define GATED_CLOCK_ID_VALID_MASK	~(QCC_CHIPCTL_CLOCKENABLESET_RSVD0_MASK)

typedef uint32_t gated_clock_id_t;

#endif
