#ifndef _MERLIN_SPI_H_
#define _MERLIN_SPI_H_

#include <linux/linux24-compat.h>

#define merlin_readl(reg)       ioread32(reg)
#define merlin_writel(val,reg)  iowrite32(val,reg)
#define merlin_readw(reg)       ioread16(reg)
#define merlin_writew(val,reg)  iowrite16(val,reg)
#define merlin_readb(reg)       ioread8(reg)
#define merlin_writeb(val,reg)  iowrite8(val,reg)
#define MERLIN_VA_BASE_SPI

#define MERLIN_SPI_CTRLR0       0x00
#define MERLIN_SPI_CTRLR1       0x04
#define MERLIN_SPI_SSIENR       0x08
#define MERLIN_SPI_MWCR         0x0c
#define MERLIN_SPI_SER          0x10
#define MERLIN_SPI_BAUDR        0x14
#define MERLIN_SPI_TXFTLR       0x18
#define MERLIN_SPI_RXFTLR       0x1c
#define MERLIN_SPI_TXFLR        0x20
#define MERLIN_SPI_RXFLR        0x24
#define MERLIN_SPI_SR           0x28
#define MERLIN_SPI_IMR          0x2c
#define MERLIN_SPI_ISR          0x30
#define MERLIN_SPI_RISR         0x34
#define MERLIN_SPI_TXOICR       0x38
#define MERLIN_SPI_RXOICR       0x3c
#define MERLIN_SPI_RXUICR       0x40
#define MERLIN_SPI_MSTICR       0x44
#define MERLIN_SPI_ICR          0x48
#define MERLIN_SPI_DMACR        0x4c
#define MERLIN_SPI_DMATDLR      0x50
#define MERLIN_SPI_DMARDLR      0x54
#define MERLIN_SPI_IDR          0x58
#define MERLIN_SPI_SSI_COMP_VERSION       0x5c
#define MERLIN_SPI_DR           0x60

int merlin_spi_add_device(char *dev_name, int cs_, unsigned long baudrate, int polarity, int phase, int datasize);

#endif
