/*
 * Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _LINUX_FMEM_H
#define _LINUX_FMEM_H

#include <linux/types.h>

/* udev will be used to created a link from /dev/fmem to /dev/falcon */
#define DEFAULT_FMEM_DEVICE  "/dev/fmem" 

struct fmem_access {
	unsigned int mem_addr;
	void *buffer;
	unsigned int size;
	unsigned char disable_swap;
};

#define FMEM_IOCTL_BASE     'F'

#define FMEMIOC_READ         	_IOR(FMEM_IOCTL_BASE, 0, struct fmem_access)
#define FMEMIOC_WRITE        	_IOR(FMEM_IOCTL_BASE, 1, struct fmem_access)

#endif
