#ifndef DW_GMAC_DEVICE_H
#define DW_GMAC_DEVICE_H

#include <linux/phy.h>

#define DW_GMAC_AMBA_NAME     "dw_gmac"

#define DW_GMAC_AMBA_DEVID		0x00001033
#define DW_GMAC_AMBA_DEVID_MASK	0x0000ffff

#define DWGMAC_O_NONE 				0x00000000

/* disable auto-neg and for a specific speed */
#define DWGMAC_O_FORCE_SPEED_1000 	0x00000002
#define DWGMAC_O_FORCE_SPEED_100 	0x00000004
#define DWGMAC_O_FORCE_SPEED_10  	0x00000008
#define DWGMAC_O_FORCE_SPEED_MASK	0x0000000e

#define DWGMAC_O_FORCE_DUPLEX_FULL	0x00000010
#define DWGMAC_O_FORCE_DUPLEX_HALF	0x00000020
#define DWGMAC_O_FORCE_DUPLEX_MASK	0x00000030

struct dw_gmac_driver_data_t {
	char clk_name[32];
	unsigned int options;
	phy_interface_t phy_interface;
};

#endif  /* DW_GMAC_DEVICE_H */
