/*
 * include/asm-arm/arch-merlin/mobi_reset.h
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __PLAT_MGX_MOBI_RESET_H
#define __PLAT_MGX_MOBI_RESET_H

#include <mach/reset_ids.h>
/**
* \brief mobi_reset_enable
*  	Put a device into reset
*
* \param device_id - id of device to be put into reset
*
* \retval -ENODEV
* 	- if invalid device id is provided
*  \retval Zero
*  	- on success
*/
uint32_t mobi_reset_enable(uint32_t device_id);

/**
* \brief mobi_reset_disable
*  	Put a device into reset
*
* \param device_id - id of device to be put into reset
*
* \retval -ENODEV
* 	- if invalid device id is provided
*  \retval Zero
*  	- on success
*/
uint32_t mobi_reset_disable(uint32_t device_id);

/**
* \brief mobi_reset_state
*  	Query the reset state of a device
*
* \param device_id - id of device to be put into reset
*
* \retval -ENODEV
* 	- if invalid device id is provided
*  \retval zero
*  	- if device is not in reset
*  \retval one
*  	- if device is in reset
*/
uint32_t mobi_reset_state(uint32_t device_id);


#endif
