/*
 * include/asm-arm/arch-merlin/mobi_qccsisc.h
 *
 * Copyright (C) Mobilygen Corp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PLAT_MGX_INCLUDE_MOBI_QCC_H
#define _PLAT_MGX_INCLUDE_MOBI_QCC_H

#ifdef CONFIG_MACH_MERLIN
#include <mach/qcc_bids.h>
#endif

#ifdef CONFIG_MACH_FALCON
#include <linux/falcon/qcc_bids.h>
#endif

#define QCC_ACCESS_LEN_1	1
#define QCC_ACCESS_LEN_2	2
#define QCC_ACCESS_LEN_4	4

/* These are used to access the register space within a given BID */
int mobi_qcc_read(int bid, int addr, unsigned long *datap, int len);
int mobi_qcc_write(int bid, int addr, unsigned long data, int len);

#ifdef CONFIG_MACH_MERLIN
/* these can be used to access the top level registers in the qcc block */
uint32_t mobi_qcc_readreg(uint32_t offset);
int mobi_qcc_writereg(uint32_t data, uint32_t offset);
#endif

#endif
