/*
 * include/asm-arm/arch-merlin/mobi_qccsisc.h
 *
 * Copyright (C) Mobilygen Corp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_MERLIN_QCC_BIDS_H
#define __ASM_ARCH_MERLIN_QCC_BIDS_H

#include <mach/mobi_qccsisc_regs.h>

/*
 *  These define the Block Ids for each unit in the QCC
 */
/* taken from /tools/pub/qmm/hsi/merlin/include/src/m5_qcc_bid.h */
#define QCC_BID_QDBG_SYS        1       /* QMM Debug Unit (System QMM) */
#define QCC_BID_MBOX            2       /* Inter-CPU Mailbox (between System QMM & Arm or external Host) */
#define QCC_BID_QDBG_VID        3       /* QMM Debug Unit (Video QMM) */
#define QCC_BID_UART            5       /* QMM UART */
#define QCC_BID_BITSIF          6       /* Bitstream Interface */
#define QCC_BID_CHIPCTL         8       /* Chip Control register block */
#define QCC_BID_MMU             16      /* Memory Management Unit */
#define QCC_BID_PMC             17      /* Physical Memory Ctl. (SDRAM) */
#define QCC_BID_PMU             18      /* Partition Management Unit */
#define QCC_BID_AII0            24      /* Audio Input 0 Interface */
#define QCC_BID_AII1            25      /* Audio Input 1 Interface */
#define QCC_BID_AOI             26      /* Audio Output  Interface */
#define QCC_BID_VPU             32      /* Video Processing Unit (Video Output) */
#define QCC_BID_PME             34      /* Pre-Motion Estimation */
#define QCC_BID_VPP0            48      /* Video Pre-Processor 0 */
#define QCC_BID_VIN0            49      /* Video Input 0 */
#define QCC_BID_FBR             50      /* Frame Buffer Read Module (loop back to VPP) */
#define QCC_BID_VPP1            54      /* Video Pre-Processor 1 */
#define QCC_BID_VIN1            55      /* Video Input 1 */

/*
 *  These define the individual addresses for registers in BID 8
 *  the chip control unit
 */
/* taken from /tools/pub/qmm/hsi/merlin/include/src/m5_reg.h */
#define QCC_CHIPCTL_PLL0_CONTROL			0x10
#define QCC_CHIPCTL_PLL1_CONTROL			0x14
#define QCC_CHIPCTL_PLL2_CONTROL			0x18
#define QCC_CHIPCTL_PLL3_CONTROL			0x1C
#define QCC_CHIPCTL_SCALER0_CONTROL			0x20
#define QCC_CHIPCTL_SCALER1_CONTROL			0x24
#define QCC_CHIPCTL_SCALER2_CONTROL			0x28
#define QCC_CHIPCTL_SCALER3_CONTROL			0x2C
#define QCC_CHIPCTL_AVCCLK_CONTROL			0x30
#define QCC_CHIPCTL_PMECLK_CONTROL			0x34
#define QCC_CHIPCTL_QMMCLK_CONTROL			0x38
#define QCC_CHIPCTL_VPP0CLK_CONTROL			0x3C
#define QCC_CHIPCTL_VPP1CLK_CONTROL			0x40
#define QCC_CHIPCTL_VPUCLK_CONTROL			0x44
#define QCC_CHIPCTL_MPEGCLK_CONTROL			0x48
#define QCC_CHIPCTL_JPEGCLK_CONTROL			0x4C
#define QCC_CHIPCTL_V0PIXCLK_CONTROL		0x50
#define QCC_CHIPCTL_V1PIXCLK_CONTROL		0x54
#define QCC_CHIPCTL_V2PIXCLK_CONTROL		0x58
#define QCC_CHIPCTL_VIDEOINVERT_CONTROL		0x60
#define QCC_CHIPCTL_UARTDBGCLK_CONTROL		0x70
#define QCC_CHIPCTL_UART0CLK_CONTROL		0x74
#define QCC_CHIPCTL_UART1CLK_CONTROL		0x78
#define QCC_CHIPCTL_I2C0CLK_CONTROL			0x80
#define QCC_CHIPCTL_I2C1CLK_CONTROL			0x84
#define QCC_CHIPCTL_PLL2CLK_CONTROL			0x88
#define QCC_CHIPCTL_PLL3CLK_CONTROL			0x8C
#define QCC_CHIPCTL_TIMERCLK_CONTROL		0x90
#define QCC_CHIPCTL_SDMMCCLK_CONTROL		0x94
#define QCC_CHIPCTL_SSI0CLK_CONTROL			0x98
#define QCC_CHIPCTL_SSI1CLK_CONTROL			0x9C
#define QCC_CHIPCTL_BSCLK_CONTROL			0xA0
#define QCC_CHIPCTL_AUD0CLK_CONTROL			0xA4
#define QCC_CHIPCTL_AUD1CLK_CONTROL			0xA8
#define QCC_CHIPCTL_SOC_RESETVEC_SET		0xB0
#define QCC_CHIPCTL_SOC_RESETVEC_CLR		0xB4
#define QCC_CHIPCTL_SOC_RESETTIMER_EN		0xB8
#define QCC_CHIPCTL_SOC_RESETTIMER_VALUE	0xBC
#define QCC_CHIPCTL_WDOG_RESET_CONTROL		0xC0
#define QCC_CHIPCTL_SWCHIP_RESET_SET		0xC4
#define QCC_CHIPCTL_CODEC_RESET_SET			0xC8
#define QCC_CHIPCTL_VIN0_CONTROL			0xD0
#define QCC_CHIPCTL_VIN1_CONTROL			0xD4
#define QCC_CHIPCTL_VOUT_CONTROL			0xD8
#define QCC_CHIPCTL_SERIALIO_CONTROL		0xE0
#define QCC_CHIPCTL_GPIO1_SEL				0xE4
#define QCC_CHIPCTL_GPIO2_SEL				0xE8
#define QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH0	0xF0
#define QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH1	0xF4
#define QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH2	0xF8
#define QCC_CHIPCTL_SERIALIO_DRIVESTRENGTH3	0xFC
#define QCC_CHIPCTL_GPIO0_PULLUP_ENABLE		0x100
#define QCC_CHIPCTL_GPIO1_PULLUP_ENABLE		0x104
#define QCC_CHIPCTL_GPIO2_PULLUP_ENABLE		0x108
#define QCC_CHIPCTL_GPIO0_PULLDOWN_ENABLE	0x110
#define QCC_CHIPCTL_GPIO1_PULLDOWN_ENABLE	0x114
#define QCC_CHIPCTL_GPIO2_PULLDOWN_ENABLE	0x118
#define QCC_CHIPCTL_LOWLEAK_CONTROL0		0x130
#define QCC_CHIPCTL_LOWLEAK_CONTROL1		0x134
#define QCC_CHIPCTL_HOSTMUX_CONTROL			0x140
#define QCC_CHIPCTL_DDRIO_CONTROL			0x150
#define QCC_CHIPCTL_DLL_CONTROL				0x160
#define QCC_CHIPCTL_TEST_CONTROL			0x170
#define QCC_CHIPCTL_RINGOSC_CONTROL			0x180
#define QCC_CHIPCTL_RINGOSC_COUNTER_READOUT 0x184

/* for the Mailbox module at BID 2 */
#define QCC_BID2_MBOX_CPU0_INT       		0x010
#define QCC_BID2_MBOX_CPU1_INT       		0x014
#define QCC_BID2_MBOX0_CPU0_TO_CPU1   		0x200
#define QCC_BID2_MBOX0_CPU1_TO_CPU0   		0x204
#define QCC_BID2_MBOX1_CPU0_TO_CPU1   		0x210
#define QCC_BID2_MBOX1_CPU1_TO_CPU0   		0x214
#define QCC_BID2_MBOX2_CPU0_TO_CPU1   		0x220
#define QCC_BID2_MBOX2_CPU1_TO_CPU0   		0x224
#define QCC_BID2_MBOX3_CPU0_TO_CPU1   		0x230
#define QCC_BID2_MBOX3_CPU1_TO_CPU0   		0x234
#define QCC_BID2_MBOX4_CPU0_TO_CPU1   		0x240
#define QCC_BID2_MBOX4_CPU1_TO_CPU0   		0x244
#define QCC_BID2_MBOX5_CPU0_TO_CPU1   		0x250
#define QCC_BID2_MBOX5_CPU1_TO_CPU0   		0x254

#endif
