
/*
*  linux/include/asm-arm/arch-falcon/platform.h
*
*  Copyright (C) 2009 Maxim IC
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <mach/platform_device_names.h>

#ifndef PLATFORM_H
#define PLATFORM_H

#define FALCON_SYSTEM_CLOCK     27000000

/* this info is take from  */
/* svn info svn://hwrepos:3692/trunk/falcon/chip/blocks/soc/rtl/m6_soc_addr_defines.h */
/* REV: 74398 */

/* sub-system start base addresses */
#define APB_IO_SS_BASE             0x80000000
#define APB_SPI_SS_BASE            0x800D0000
#define AHB_PERIPH_SS_BASE         0x90000000
#define ARM_SS_BASE                0x98000000
#define DMA_SS_BASE                0xA0000000
#define AXI_SS_BASE                0xB0000000
#define BAR_SS_BASE                0xB8000000

#define MMU_DATA_BASE              (0x00000000)
#define MMU_DATA_END               (MMU_DATA_BASE+0x7FFFFFFF)
#define MMU_DATA_SIZE              (MMU_DATA_END-MMU_DATA_BASE+1)

#define L210_REG_BASE              (0x78000000)
#define L210_REG_END               (L210_REG_BASE+0x3FFFFFF)
#define L210_REG_SIZE              (L210_REG_END-L210_REG_BASE+1)

#define ARM_ROM_BASE               (0x7C000000)
#define ARM_ROM_END                (ARM_ROM_BASE+0x3FFFFFF)
#define ARM_ROM_SIZE               (ARM_ROM_END-ARM_ROM_BASE+1)

/****************************************************/
/* APB Serial Bus defines - APB_SS (APB Sub-system) */
/****************************************************/
/* start 0x80000000, size 0x10000 */
#define I2C0_BASE                  (APB_IO_SS_BASE+0)
#define I2C0_END                   (I2C0_BASE+0xFFFF)
#define I2C0_SIZE                  (I2C0_END-I2C0_BASE+1)

/* start 0x80010000, size 0x10000 */
#define I2C1_BASE                  (I2C0_END+1)
#define I2C1_END                   (I2C1_BASE+0xFFFF)
#define I2C1_SIZE                  (I2C1_END-I2C1_BASE+1)

/* start 0x80020000, size 0x10000 */
#define UART0_BASE                 (I2C1_END+1)
#define UART0_END                  (UART0_BASE+0xFFFF)
#define UART0_SIZE                 (UART0_END-UART0_BASE+1)

/* start 0x80030000, size 0x10000 */
#define UART1_BASE                 (UART0_END+1)
#define UART1_END                  (UART1_BASE+0xFFFF)
#define UART1_SIZE                 (UART1_END-UART1_BASE+1)

/* start 0x80040000, size 0x10000 */
#define UARTDBG_BASE               (UART1_END+1)
#define UARTDBG_END                (UARTDBG_BASE+0xFFFF)
#define UARTDBG_SIZE               (UARTDBG_END-UARTDBG_BASE+1)

/* start 0x80050000, size 0x10000 */
#define GPIO0_BASE                 (UARTDBG_END+1)
#define GPIO0_END                  (GPIO0_BASE+0xFFFF)
#define GPIO0_SIZE                 (GPIO0_END-GPIO0_BASE+1)

/* start 0x80060000, size 0x10000 */
#define GPIO1_BASE                 (GPIO0_END+1)
#define GPIO1_END                  (GPIO1_BASE+0xFFFF)
#define GPIO1_SIZE                 (GPIO1_END-GPIO1_BASE+1)

/* start 0x80070000, size 0x10000 */
#define GPIO2_BASE                 (GPIO1_END+1)
#define GPIO2_END                  (GPIO2_BASE+0xFFFF)
#define GPIO2_SIZE                 (GPIO2_END-GPIO2_BASE+1)

/* start 0x80080000, size 0x10000 */
#define PWM0_BASE                  (GPIO2_END+1)
#define PWM0_END                   (PWM0_BASE+0xFFFF)
#define PWM0_SIZE                  (PWM0_END-PWM0_BASE+1)

/* start 0x80090000, size 0x10000 */
#define PWM1_BASE                  (PWM0_END+1)
#define PWM1_END                   (PWM1_BASE+0xFFFF)
#define PWM1_SIZE                  (PWM1_END-PWM1_BASE+1)

/* start 0x800A0000, size 0x10000 */
#define PWM2_BASE                  (PWM1_END+1)
#define PWM2_END                   (PWM2_BASE+0xFFFF)
#define PWM2_SIZE                  (PWM2_END-PWM2_BASE+1)

/* start 0x800B0000, size 0x10000 */
#define TIMERS_BASE                (PWM2_END+1)
#define TIMERS_END                 (TIMERS_BASE+0xFFFF)
#define TIMERS_SIZE                (TIMERS_END-TIMERS_BASE+1)

/* start 0x800C0000, size 0x10000 */
#define WDT_BASE                   (TIMERS_END+1)
#define WDT_END                    (WDT_BASE+0xFFFF)
#define WDT_SIZE                   (WDT_END-WDT_BASE+1)

/******************************************************/
/* APB SPI Bus defines - APB_SPI (APB SPI Sub-system) */
/******************************************************/
/* start 0x800D0000, size 0x10000 */
#define SSI0_BASE                  (WDT_END+1)
#define SSI0_END                   (SSI0_BASE+0xFFFF)
#define SSI0_SIZE                  (SSI0_END-SSI0_BASE+1)

/* start 0x800E0000, size 0x10000 */
#define SSI1_BASE                  (SSI0_END+1)
#define SSI1_END                   (SSI1_BASE+0xFFFF)
#define SSI1_SIZE                  (SSI1_END-SSI1_BASE+1)

/* start 0x800F0000, size 0x10000 */
#define SSI2_BASE                  (SSI1_END+1)
#define SSI2_END                   (SSI2_BASE+0xFFFF)
#define SSI2_SIZE                  (SSI2_END-SSI2_BASE+1)

/* start 0x80100000, size 0xFF00000 */
#define RESERVED1_BASE             (SSI2_END+1)
#define RESERVED1_END              (RESERVED1_BASE+0xFEFFFFF)
#define RESERVED1_SIZE             (RESERVED1_END-RESERVED1_BASE+1)

/***********************************************************************/
/* AHB Peripheral Bus defines - AHB_PERIPH (APB Peripheral Sub-system) */
/***********************************************************************/
/* start 0x90000000, size 0x4000000 */
#define FLASH_DATA_BASE            (RESERVED1_END+1)
#define FLASH_DATA_END             (FLASH_DATA_BASE+0x3FFFFFF)
#define FLASH_DATA_SIZE            (FLASH_DATA_END-FLASH_DATA_BASE+1)

/* start 0x94000000, size 0x1000000 */
#define FLASH_REG_BASE             (FLASH_DATA_END+1)
#define FLASH_REG_END              (FLASH_REG_BASE+0xFFFFFF)
#define FLASH_REG_SIZE             (FLASH_REG_END-FLASH_REG_BASE+1)

/* start 0x95000000, size 0x1000000 */
#define SDMMC_BASE                 (FLASH_REG_END+1)
#define SDMMC_END                  (SDMMC_BASE+0xFFFFFF)
#define SDMMC_SIZE                 (SDMMC_END-SDMMC_BASE+1)

/* start 0x96000000, size 0x800000 */
#define AES_BASE                   (SDMMC_END+1)
#define AES_END                    (AES_BASE+0x7FFFFF)
#define AES_SIZE                   (AES_END-AES_BASE+1)

/* start 0x96800000, size 0x800000 */
#define SHA_BASE                   (AES_END+1)
#define SHA_END                    (SHA_BASE+0x7FFFFF)
#define SHA_SIZE                   (SHA_END-SHA_BASE+1)

/* start 0x97000000, size 0x1000000 */
#define AHB_P_ARB_BASE             (SHA_END+1)
#define AHB_P_ARB_END              (AHB_P_ARB_BASE+0xFFFFFF)
#define AHB_P_ARB_SIZE             (AHB_P_ARB_END-AHB_P_ARB_BASE+1)

/**********************************************/
/* ARM Only defines - ARM_SS (ARM Sub-system) */
/**********************************************/
/* start 0x98000000, size 0x2000 */
#define DTCM_BASE                  (AHB_P_ARB_END+1)
#define DTCM_END                   (DTCM_BASE+0x1FFF)
#define DTCM_SIZE                  (DTCM_END-DTCM_BASE+1)

/* start 0x98002000, size 0xFFE000 */
#define RESERVED2_BASE             (DTCM_END+1)
#define RESERVED2_END              (RESERVED2_BASE+0xFFDFFF)
#define RESERVED2_SIZE             (RESERVED2_END-RESERVED2_BASE+1)

/* start 0x99000000, size 0x2000 */
#define ITCM_BASE                  (RESERVED2_END+1)
#define ITCM_END                   (ITCM_BASE+0x1FFF)
#define ITCM_SIZE                  (ITCM_END-ITCM_BASE+1)

/* start 0x99002000, size 0x6FFE000 */
#define RESERVED3_BASE             (ITCM_END+1)
#define RESERVED3_END              (RESERVED3_BASE+0x6FFDFFF)
#define RESERVED3_SIZE             (RESERVED3_END-RESERVED3_BASE+1)

/*************************************************/
/* AHB DMA Bus defines - DMA_SS (DMA Sub-system) */
/*************************************************/
/* start 0xA0000000, size 0x1000000 */
#define USB_BASE                   (RESERVED3_END+1)
#define USB_END                    (USB_BASE+0xFFFFFF)
#define USB_SIZE                   (USB_END-USB_BASE+1)

/* start 0xA1000000, size 0x1000000 */
#define GMAC_BASE                  (USB_END+1)
#define GMAC_END                   (GMAC_BASE+0xFFFFFF)
#define GMAC_SIZE                  (GMAC_END-GMAC_BASE+1)

/* start 0xA2000000, size 0x1000000 */
#define SATA_BASE                  (GMAC_END+1)
#define SATA_END                   (SATA_BASE+0xFFFFFF)
#define SATA_SIZE                  (SATA_END-SATA_BASE+1)

/* start 0xA3000000, size 0x1000000 */
#define DMAC_BASE                  (SATA_END+1)
#define DMAC_END                   (DMAC_BASE+0xFFFFFF)
#define DMAC_SIZE                  (DMAC_END-DMAC_BASE+1)

/* start 0xA4000000, size 0x1000000 */
#define DESC_RAM_BASE              (DMAC_END+1)
#define DESC_RAM_END               (DESC_RAM_BASE+0xFFFFFF)
#define DESC_RAM_SIZE              (DESC_RAM_END-DESC_RAM_BASE+1)

/* start 0xA5000000, size 0x1000000 */
#define DMA_MMU_BASE               (DESC_RAM_END+1)
#define DMA_MMU_END                (DMA_MMU_BASE+0xFFFFFF)
#define DMA_MMU_SIZE               (DMA_MMU_END-DMA_MMU_BASE+1)

/* start 0xA6000000, size 0x1000000 */
#define ICTL_BASE                  (DMA_MMU_END+1)
#define ICTL_END                   (ICTL_BASE+0xFFFFFF)
#define ICTL_SIZE                  (ICTL_END-ICTL_BASE+1)

/* start 0xA7000000, size 0x1000000 */
#define ARM_MMU_BASE               (ICTL_END+1)
#define ARM_MMU_END                (ARM_MMU_BASE+0xFFFFFF)
#define ARM_MMU_SIZE               (ARM_MMU_END-ARM_MMU_BASE+1)

/* start 0xA8000000, size 0x8000000 */
#define RESERVED4_BASE             (ARM_MMU_END+1)
#define RESERVED4_END              (RESERVED4_BASE+0x7FFFFFF)
#define RESERVED4_SIZE             (RESERVED4_END-RESERVED4_BASE+1)

/*********************************************/
/* AXI Bus defines - AXI_SS (AXI Sub-system) */
/*********************************************/
/* start 0xB0000000, size 0x1000000 */
#define PCIE_DMA_DESC_BASE         (RESERVED4_END+1)
#define PCIE_DMA_DESC_END          (PCIE_DMA_DESC_BASE+0xFFFFFF)
#define PCIE_DMA_DESC_SIZE         (PCIE_DMA_DESC_END-PCIE_DMA_DESC_BASE+1)

/* start 0xB1000000, size 0x3000000 */
#define RESERVED5_BASE             (PCIE_DMA_DESC_END+1)
#define RESERVED5_END              (RESERVED5_BASE+0x2FFFFFF)
#define RESERVED5_SIZE             (RESERVED5_END-RESERVED5_BASE+1)

/* start 0xB4000000, size 0x1000000 */
#define PCI_CFGIO_BASE             (RESERVED5_END+1)
#define PCI_CFGIO_END              (PCI_CFGIO_BASE+0xFFFFFF)
#define PCI_CFGIO_SIZE             (PCI_CFGIO_END-PCI_CFGIO_BASE+1)

/* start 0xB5000000, size 0x3000000 */
#define RESERVED6_BASE             (PCI_CFGIO_END+1)
#define RESERVED6_END              (RESERVED6_BASE+0x2FFFFFF)
#define RESERVED6_SIZE             (RESERVED6_END-RESERVED6_BASE+1)

/* start 0xB8000000, size 0x10000 */
#define BAR_QCC_BASE               (RESERVED6_END+1)
#define BAR_QCC_END                (BAR_QCC_BASE+0xFFFF)
#define BAR_QCC_SIZE               (BAR_QCC_END-BAR_QCC_BASE+1)

/* start 0xB8010000, size 0x10000 */
#define BAR_PHY_BASE               (BAR_QCC_END+1)
#define BAR_PHY_END                (BAR_PHY_BASE+0xFFFF)
#define BAR_PHY_SIZE               (BAR_PHY_END-BAR_PHY_BASE+1)

/* start 0xB8020000, size 0x10000 */
#define BAR_AXI_VIDEO_BASE         (BAR_PHY_END+1)
#define BAR_AXI_VIDEO_END          (BAR_AXI_VIDEO_BASE+0xFFFF)
#define BAR_AXI_VIDEO_SIZE         (BAR_AXI_VIDEO_END-BAR_AXI_VIDEO_BASE+1)

/* start 0xB8030000, size 0x1000 */
#define BAR_AXI_MMU_BASE           (BAR_AXI_VIDEO_END+1)
#define BAR_AXI_MMU_END            (BAR_AXI_MMU_BASE+0xFFF)
#define BAR_AXI_MMU_SIZE           (BAR_AXI_MMU_END-BAR_AXI_MMU_BASE+1)

/* start 0xB8031000, size 0x1000 */
#define BAR_AXI_VIDEO_REGS_BASE    (BAR_AXI_MMU_END+1)
#define BAR_AXI_VIDEO_REGS_END     (BAR_AXI_VIDEO_REGS_BASE+0xFFF)
#define BAR_AXI_VIDEO_REGS_SIZE    (BAR_AXI_VIDEO_REGS_END-BAR_AXI_VIDEO_REGS_BASE+1)

/* start 0xB8032000, size 0x1000 */
#define BAR_PCIE_CSR_BASE          (BAR_AXI_VIDEO_REGS_END+1)
#define BAR_PCIE_CSR_END           (BAR_PCIE_CSR_BASE+0xFFF)
#define BAR_PCIE_CSR_SIZE          (BAR_PCIE_CSR_END-BAR_PCIE_CSR_BASE+1)

/* start 0xB8033000, size 0xD000 */
#define RESERVED7_BASE             (BAR_PCIE_CSR_END+1)
#define RESERVED7_END              (RESERVED7_BASE+0xCFFF)
#define RESERVED7_SIZE             (RESERVED7_END-RESERVED7_BASE+1)

/* start 0xB8040000, size 0xFC0000 */
#define RESERVED8_BASE             (RESERVED7_END+1)
#define RESERVED8_END              (RESERVED8_BASE+0xFBFFFF)
#define RESERVED8_SIZE             (RESERVED8_END-RESERVED8_BASE+1)

/* this is the same address range as BAR_AXI_MMU_PCI_PIO */
/* start 0xB9000000, size 0x1000000 */
#define BAR_AXI_MMU_PIO_BASE       (RESERVED8_END+1)
#define BAR_AXI_MMU_PIO_END        (BAR_AXI_MMU_PIO_BASE+0xFFFFFF)
#define BAR_AXI_MMU_PIO_SIZE       (BAR_AXI_MMU_PIO_END-BAR_AXI_MMU_PIO_BASE+1)

/* start 0xBA000000, size 0x6000000 */
#define RESERVED9_BASE             (BAR_AXI_MMU_PIO_END+1)
#define RESERVED9_END              (RESERVED9_BASE+0x5FFFFFF)
#define RESERVED9_SIZE             (RESERVED9_END-RESERVED9_BASE+1)

/*************************************/
/* PCI/PCIe Bus defines - PIO Memory */
/*************************************/
/* start 0xC0000000, size 0x20000000 */
#define AXI_PCI_PIO_BASE           (RESERVED9_END+1)
#define AXI_PCI_PIO_END            (AXI_PCI_PIO_BASE+0x1FFFFFFF)
#define AXI_PCI_PIO_SIZE           (AXI_PCI_PIO_END-AXI_PCI_PIO_BASE+1)

/* start 0xE0000000, size 0x20000000 */
#define AXI_PCIE_PIO_BASE          (AXI_PCI_PIO_END+1)
#define AXI_PCIE_PIO_END           (AXI_PCIE_PIO_BASE+0x1FFFFFFF)
#define AXI_PCIE_PIO_SIZE          (AXI_PCIE_PIO_END-AXI_PCIE_PIO_BASE+1)


/* this is an alias to simplify things */
#define QCC_BASE                   (BAR_QCC_BASE)
#define QCC_END                    (BAR_QCC_END)
#define QCC_SIZE                   (BAR_QCC_SIZE)


#endif  /* PLATFORM_H */
