///
///	@file 	simpleModule.cpp
/// @brief 	Create a simple AppWeb dynamically loadable module
///
////////////////////////////////////////////////////////////////////////////
//
//	Copyright (c) Mbedthis Software LLC, 2003-2007. All Rights Reserved.
//	The latest version of this code is available at http://www.mbedthis.com
//
//	This software is open source; you can redistribute it and/or modify it 
//	under the terms of the GNU General Public License as published by the 
//	Free Software Foundation; either version 2 of the License, or (at your 
//	option) any later version.
//
//	This program is distributed WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
//	See the GNU General Public License for more details at:
//	http://www.mbedthis.com/downloads/gplLicense.html
//	
//	This General Public License does NOT permit incorporating this software 
//	into proprietary programs. If you are unable to comply with the GPL, a 
//	commercial license for this software and support services are available
//	from Mbedthis Software at http://www.mbedthis.com
//
////////////////////////////// Includes ////////////////////////////////

#include	"simpleModule.h"
#include	"msgq.h"
#include	"function_sys.h"
#include	"inf_func.h"
struct SHM_INFO_STRUCT share_memory, *shm;
////////////////////////////////////////////////////////////////////////
///////////////////////////// SimpleModule /////////////////////////////
////////////////////////////////////////////////////////////////////////

///
///	This function is called when the module is dynamically loaded
///

int mprSimpleModuleInit(void *handle)
{
	mprLog(0, (char*)"In mprSimpleModuleInit()\n");
	new SimpleModule(handle);
	return 0;
}

////////////////////////////////////////////////////////////////////////

///
///	The constructor is called by either the DLL load entry point 
///	above, or if not using DLLs, it should be called directly from 
///	your application at initialization time.
///
static int Pinit(EspRequest *ep, int argc, char **argv){
	MprVar		status ;
	status = mprCreateNullVar();
	espSetReturn(ep, status);
	espDestroyVar(&status);
	return 0;
}

static int Pget_form(EspRequest *ep, int argc, char **argv){
	MprVar		status ;
	char		strs[ 256 ];
	char		name[ 128 ], *pos;
	int		i, j, len;

	Read_Lock;
	len = strlen( argv[0]);
	if( shm->id <= 0 ) return -1;
	mprLog(0, (char*)"%s: argv[0]=%s\n", __FUNCTION__, argv[0] );
	for( i = 0 ; i < MAX_GROUP ; i++){
		if( shm->header->group[i][0] == 0 ) break;
		if( memcmp( shm->header->group[i], argv[0], GROUP_LEN ) != 0 ) continue;
		for( j = shm->header->ptr[i]; j < shm->header->ptr[i] + shm->header->count[i]; j++ ){
			if( shm->data[j].valid == 0 || memcmp( shm->data[j].name, argv[0], len) != 0 ) continue;
			sprintf( name, "%s", shm->data[j].name );
			do{
				pos = strchr( name, '.' );
				if( pos != NULL ) *pos = '_';
			}while( pos != NULL );
			sprintf( strs, "<INPUT type=hidden value=\"%s\" name=\"%s\">\n", shm->data[j].value, name);
			mprLog( 0, (char*)"%s", strs );
			espWriteString( ep, strs);
		}
	}
#if 0
	for( i = 0; i < shm.header->dataCount; ++i ){
		if ( strncmp( shm.data[i].name, argv[0], strlen(argv[0]) ) )	continue;

		sprintf( name, "%s", shm.data[i].name );
		do{
			pos = strchr( name, '.' );
			if( pos != NULL ) *pos = '_';
		}while( pos != NULL );
		sprintf( strs, "<INPUT type=hidden value=\"%s\" name=\"%s\">\n", shm.data[i].value, name);
		mprLog( -1, (char*)"%s", strs );
		espWriteString( ep, strs);
	}
#endif
	Read_unLock;
done:
	status = mprCreateNullVar();
	espSetReturn(ep, status);
	espDestroyVar(&status);
	return 0;
}
static int Pget_system(EspRequest *ep, int argc, char **argv){
	MprVar		status;
	char		retVal[32]="";
	time_t		now_time;	
	struct tm	datetime;

	time(&now_time);	
	localtime_r(&now_time, &datetime);
	mprLog( -1, (char*)"[%.4d-%.2d-%.2d:%.2d:%.2d]",datetime.tm_year+1900,
			 datetime.tm_mday, datetime.tm_hour, datetime.tm_min, datetime.tm_sec);
	if(	! strcmp( argv[0], "date" ) )
		sprintf( retVal, "%.4d-%.2d-%.2d", datetime.tm_year+1900, datetime.tm_mon+1, datetime.tm_mday );
	else if(! strcmp( argv[0], "time" ) )
		sprintf( retVal, "%.2d:%.2d:%.2d", datetime.tm_hour, datetime.tm_min, datetime.tm_sec );

	status = ( retVal == NULL || strlen(retVal) == 0 ) ? mprCreateNullVar() : mprCreateStringVar( retVal, false);

	espSetReturn(ep, status);
	espDestroyVar(&status);
	mprLog(0, (char*)"SimpleModule:get %s ret=%s \n", argv[0], retVal);
	return 0;
}
static int Pget(EspRequest *ep, int argc, char **argv){
	MprVar		status;
	char		*retVal = NULL;
	static	char	str[ 128 ];

	sprintf( str, "%s.%s", argv[1], argv[0] );

	Read_Lock;
	retVal = INF_get( shm, str, NULL );
	mprLog(0, (char*)"SimpleModule:get [%s]=[%s] \n", str, retVal);
	status = ( retVal == NULL || strlen(retVal) == 0 ) ? mprCreateStringVar( (char*)"", false) : mprCreateStringVar( retVal, false);
	Read_unLock;

done:
	espSetReturn(ep, status);
	espDestroyVar(&status);
	return 0;
}

static int Pget_gpio(EspRequest *ep, int argc, char **argv){
	MprVar		status;
	char		*retVal = NULL , *prodnbr = NULL;
	static	char	str[ 128 ],cmd[128];
	int fd;
	unsigned char c;
	
	prodnbr = INF_get (shm , "Brand.ProdNbr", NULL);

	if (!strcmp(prodnbr,"P636") || !strcmp(prodnbr, "P636W")) {
	    if (!strcmp(argv[1],"Input.I00"))
		fd=open( "/dev/gpio/native/gpio001", O_RDONLY);
	    else if (!strcmp(argv[1],"Input.I01"))
		fd=open( "/dev/gpio/native/gpio000", O_RDONLY);
	    else if (!strcmp(argv[1],"Input.I02"))
		fd=open( "/dev/gpio/native/gpio002", O_RDONLY);
	    else if (!strcmp(argv[1],"Input.I03"))
		fd=open( "/dev/gpio/native/gpio004", O_RDONLY);
	    else if (!strcmp(argv[1],"Output.O00"))
		fd=open( "/dev/gpio/native/gpio007", O_RDONLY);

	}
	else {
	    if (!strcmp(argv[1],"Input.I00"))
		fd=open( "/dev/gpio/native/gpio001", O_RDONLY);
	    else if (!strcmp(argv[1],"Output.O00"))
		fd=open( "/dev/gpio/native/gpio007", O_RDONLY);

	}
	
	read(fd,&c,1);
	close(fd);

	if (c==1)
		sprintf(str,"high");
	else
		sprintf(str,"low");

	retVal=str;
    sprintf(cmd,"%s.Status",argv[1]);
	INF_update( shm, cmd, retVal );
	mprLog(0, (char*)"SimpleModule:get [%s]=[%s] \n", str, retVal);
	status = ( retVal == NULL || strlen(retVal) == 0 ) ? mprCreateStringVar( (char*)"", false) : mprCreateStringVar( retVal, false);

	espSetReturn(ep, status);
	espDestroyVar(&status);
	return 0;
}

SimpleModule::SimpleModule(void *handle) : MaModule( (char*)"simpleModule", handle)
{
	espDefineStringCFunction(0, (char*)"Pget",		Pget, 0);
	espDefineStringCFunction(0, (char*)"Pget_system",	Pget_system, 0);
	espDefineStringCFunction(0, (char*)"Pget_form",		Pget_form, 0);
	espDefineStringCFunction(0, (char*)"Pinit",		Pinit, 0);
	espDefineStringCFunction(0, (char*)"Pget_gpio",		Pget_gpio, 0);
	mprLog(0, (char*) "In SimpleModule()\n");
}

////////////////////////////////////////////////////////////////////////

SimpleModule::~SimpleModule()
{
	//
	//	Put cleanup code here for when AppWeb is exiting
	//
	mprLog(0, (char*)"In ~SimpleModule()\n");
}

////////////////////////////////////////////////////////////////////////
int SimpleModule::parseConfig(char *key, char *value, MaServer *server, 
	MaHost *host, MaAuth *auth, MaDir* dir, MaLocation *location)
{
	if (mprStrCmpAnyCase(key, (char*)"simpleDirective") == 0) {
		//
		//	Put code here to parse the "value". Return 1 to indicate
		//	we have processed this directive.
		//
		return 1;
	}
	return 0;
}

////////////////////////////////////////////////////////////////////////
//
//	AppWeb is starting up
//

int SimpleModule::start()
{
	//
	//	Put startup code here
	//
	if( INF_attach( &share_memory, SYSTEM_INF_FILE) != EXIT_SUCCESS ){
		mprLog( -1, (char*)"%s) Load %s fail\n", __FUNCTION__, SYSTEM_INF_FILE);
		return EXIT_SUCCESS;
	}
	else    mprLog( 0, (char*)"%s) Load %s success! \n", __FUNCTION__, SYSTEM_INF_FILE);
	shm = &share_memory;
	char *brand;
	brand = INF_get(shm, "Brand.ProdNbr", NULL);
	return 0;
}

////////////////////////////////////////////////////////////////////////
//
//	AppWeb is shutting down
//

void SimpleModule::stop()
{
	//
	//	Put shutdown code here
	//
	const char *brand;
	brand = INF_get(shm, "Brand.ProdNbr", NULL);
	INF_detach( &share_memory );
}

////////////////////////////////////////////////////////////////////////

//
// Local variables:
// tab-width: 4
// c-basic-offset: 4
// End:
// vim: sw=4 ts=4 
//
