///
///	@file 	PushHandler.h
/// @brief 	Header for PushHandler
//	@copy	default
//	
//	Copyright (c) Mbedthis Software LLC, 2003-2007. All Rights Reserved.
//	
//	This software is distributed under commercial and open source licenses.
//	You may use the GPL open source license described below or you may acquire 
//	a commercial license from Mbedthis Software. You agree to be fully bound 
//	by the terms of either license. Consult the LICENSE.TXT distributed with 
//	this software for full details.
//	
//	This software is open source; you can redistribute it and/or modify it 
//	under the terms of the GNU General Public License as published by the 
//	Free Software Foundation; either version 2 of the License, or (at your 
//	option) any later version. See the GNU General Public License for more 
//	details at: http://www.mbedthis.com/downloads/gplLicense.html
//	
//	This program is distributed WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
//	
//	This GPL license does NOT permit incorporating this software into 
//	proprietary programs. If you are unable to comply with the GPL, you must
//	acquire a commercial license to use this software. Commercial licenses 
//	for this software and support services are available from Mbedthis 
//	Software at http://www.mbedthis.com 
//	
//	@end
////////////////////////////////// Includes ////////////////////////////////////

#ifndef _h_PUSH_MODULE
#define _h_PUSH_MODULE 1

#include	"appweb/appweb.h"

/////////////////////////////// Forward Definitions ////////////////////////////

//#if BLD_FEATURE_PUSH_MODULE
class	MaPushModule;
class	MaPushHandler;
class	MaPushHandlerService;
class	MaPushCmd;

extern "C" {
	extern int mprPushInit(void *handle);
}

////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// PushCmd //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class MaPushCmd : public MprCmd {
  private:
	//  MprCmdFiles	  files;			  // Stdin, stdout for the command

  public:
					MaPushCmd();
					~MaPushCmd();
	int 			makeStdio();
};


////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// PushModule //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class MaPushModule : public MaModule {
  private:
	MaPushHandlerService	
					*pushHandlerService;
  public:
					MaPushModule(void *handle);
					~MaPushModule();
};

////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// PushHandler /////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

class MaPushHandlerService : public MaHandlerService {
  private:
	MprLogModule	*log;
	MaPushHandler	*PushHandler;

  public:
					MaPushHandlerService();
					~MaPushHandlerService();
	MaHandler		*newHandler(MaServer *server, MaHost *host, char *ex);
};

//
//	PushFlags
//
#define MPR_Push_NON_PARSED_HEADER	0x1		// PUSH program creates HTTP headers
#define MPR_Push_HEADER_SEEN			0x2		// Server has parsed PUSH response

class MaPushHandler : public MaHandler {
  private:
	MprBuf			*headerBuf;
	int				pushFlags;
	//MprCmd			*cmd;
	MaPushCmd		*cmd;
	MprLogModule	*log;
	MprStr			newLocation;

	unsigned int	count;
	unsigned int	buf_len;
	char			*buf;

  public:
					MaPushHandler(char *ext, MprLogModule *log);
					~MaPushHandler();
	void			buildArgs(int *argcp, char ***argvp, MprCmd *cmd, 
						MaRequest *rq);
	int				PushDone(MaRequest *rq, int exitCode);
	MaHandler		*cloneHandler();
	void			parseHeader(MaRequest *rq);
//	int             matchRequest(MaRequest *rq, char *uri, int uriLen);
	void			postData(MaRequest *rq, char *buf, int buflen);
	int				gatherOutputData(MaRequest *rq);
	int				run(MaRequest *rq);
	int				setup(MaRequest *rq);
#if WIN
	void			findExecutable(char **program, char **script, 
						char **bangScript, MaRequest *rq, char *fileName);
#endif

#if BLD_FEATURE_CONFIG_PARSE
	int				parseConfig(char *key, char *value, MaServer *server, 
						MaHost *host, MaAuth *auth, MaDir* dir, 
						MaLocation *location);
#endif

#if CYGWIN || LINUX || MACOSX || SOLARIS || VXWORKS || FREEBSD
//		void			processStatus(ulong pid, int status);
		void			initSignals();
#endif
};

//#endif // BLD_FEATURE_PUSH_MODULE
////////////////////////////////////////////////////////////////////////////////
#endif // _h_PUSH_MODULE 

//
// Local variables:
// tab-width: 4
// c-basic-offset: 4
// End:
// vim: sw=4 ts=4 
//
