/*
 *  authPam.c - Authorization using PAM (Pluggable Authorization Module)
 *
 *  Copyright (c) All Rights Reserved. See details at the end of the file.
 */

/********************************* Includes ***********************************/

#include    "http.h"

#if BLD_FEATURE_AUTH_PAM

#if MACOSX
#include    <pam/pam_appl.h>
#else
#include    <security/pam_appl.h>
#endif

/********************************* Defines ************************************/

typedef struct {
    MprCtx  ctx;
    char    *name;
    char    *password;
} UserInfo;

/********************************* Forwards ***********************************/

static int pamChat(int msgCount, const struct pam_message **msg, struct pam_response **resp, void *data);

/*********************************** Code *************************************/

cchar *maGetPamPassword(MaConn *conn, cchar *realm, cchar *user)
{
    /*
     *  Can't return the password.
     */
    return "";
}


bool maValidatePamCredentials(MaConn *conn, cchar *realm, cchar *user, cchar *password, cchar *requiredPass, char **msg)
{
    pam_handle_t        *pamh;
    UserInfo            info;
    struct pam_conv     conv = { pamChat, &info };
    int                 res;
   
    info.ctx = conn->request;
    info.name = (char*) user;
    info.password = (char*) password;
    pamh = NULL;
        
    if ((res = pam_start("login", user, &conv, &pamh)) != PAM_SUCCESS) {
        return 0;
    }
    if ((res = pam_authenticate(pamh, 0)) != PAM_SUCCESS) {
        return 0;
    }
    pam_end(pamh, PAM_SUCCESS);
    return 1;
}


/*
 *  Callback invoked by the pam_authenticate function
 */
static int pamChat(int msgCount, const struct pam_message **msg, struct pam_response **resp, void *data) 
{
	UserInfo                *info;
	struct pam_response     *reply;
    int                     i;
	
    i = 0;
    reply = 0;
	info = (UserInfo*) data;

	if (resp == 0 || msg == 0 || info == 0) {
		return PAM_CONV_ERR;
	}
	
	if ((reply = mprAlloc(info->ctx, msgCount * sizeof(struct pam_response))) == 0) {
		return PAM_CONV_ERR;
	}
	
	for (i = 0; i < msgCount; i++) {
		reply[i].resp_retcode = 0;
		reply[i].resp = 0;
		
		switch (msg[i]->msg_style) {
		case PAM_PROMPT_ECHO_ON:
			reply[i].resp = mprStrdup(info->ctx, info->name);
			break;

		case PAM_PROMPT_ECHO_OFF:
			reply[i].resp = mprStrdup(info->ctx, info->password);
			break;

		default:
			return PAM_CONV_ERR;
		}
	}
	*resp = reply;
	return PAM_SUCCESS;
}


#else
void __pamAuth() {}
#endif /* BLD_FEATURE_AUTH_PAM */

/*
 *  @copy   default
 *  
 *  Copyright (c) Embedthis Software LLC, 2003-2009. All Rights Reserved.
 *  Copyright (c) Michael O'Brien, 1993-2009. All Rights Reserved.
 *  
 *  This software is distributed under commercial and open source licenses.
 *  You may use the GPL open source license described below or you may acquire 
 *  a commercial license from Embedthis Software. You agree to be fully bound 
 *  by the terms of either license. Consult the LICENSE.TXT distributed with 
 *  this software for full details.
 *  
 *  This software is open source; you can redistribute it and/or modify it 
 *  under the terms of the GNU General Public License as published by the 
 *  Free Software Foundation; either version 2 of the License, or (at your 
 *  option) any later version. See the GNU General Public License for more 
 *  details at: http://www.embedthis.com/downloads/gplLicense.html
 *  
 *  This program is distributed WITHOUT ANY WARRANTY; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *  
 *  This GPL license does NOT permit incorporating this software into 
 *  proprietary programs. If you are unable to comply with the GPL, you must
 *  acquire a commercial license to use this software. Commercial licenses 
 *  for this software and support services are available from Embedthis 
 *  Software at http://www.embedthis.com 
 *  
 *  @end
 */
