/*
 * 2007/07/16
 * Jack.
 * very small mail client functions.
 * Include attach files , user login AUTH 
 */

#include <time.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdlib.h>
#include "mailfunc.h"

int Base64Encode(char *data ,int len, char *ret){
	int	i, retcount;
	char    c;

	retcount =0;
	for (i = 0; i < len; ++i){
        	c = (data[i] >> 2) & 0x3f;
		//ret[ retcount++ ] = CVT[c];
		ret[ retcount++ ] = CVT[ (int)c ];
	        c = (data[i] << 4) & 0x3f;
        	if (++i < len)		c |= (data[i] >> 4) & 0x0f;
	        ret[ retcount++ ] = CVT[ (int)c ];
		if (i < len){
        		c = (data[i] << 2) & 0x3f;
			if (++i < len)	c |= (data[i] >> 6) & 0x03;
		        ret[ retcount++ ] = CVT[ (int)c ];
        	}
	        else{
        	    ++i;
	            ret[ retcount++ ] = '='; 
        	}

	        if (i < len){
			c = data[i] & 0x3f;
	        	ret[ retcount++ ] = CVT[ (int)c ];
 		}
		else	ret[ retcount++ ] = '=';
	}

    return(retcount);
}

int codescan(char *line, char *str, int len){
	int i;
	for (i = 0 ; i < strlen( line ) - len ; i++){
		if ( line[ i ] == str[ 0 ]) {
			if (!strncmp( line, str, len)) return( i );
		}
  	}
	return -1;
}
int writea( int fd, char *data, int size, char *retstr ){
	int ret;
	char result[ 256 ];

	ret = write( fd, data, size);
	if ( ret != size ) return -1;
	if( retstr != NULL ){
		ret = read( fd, result , 255);
		result[ ret ] = 0;
		if (codescan( result, retstr, 3) == -1){
			printf("CMD[%s] return code error[%s]\n",data, result );
			return -1;
		}
	}
	return ret;
}

#define NETWORK_PACKET 1440
int sendfile(struct MAILSTRUCT *mail){
	FILE	*fd;
	char	encode_data[ NETWORK_PACKET ], decode_data[ NETWORK_PACKET*2 ];
	int	encode_len, decode_len;
	int	sendbytes, totalsize;
	int	filecount;
	char	line[ 512 ];

	filecount = mail->nfile;
	while( filecount > 0 ){
		sprintf( line, "--%s\r\n", mail->boundary);
		writea(	mail->connfd, line, strlen(line), NULL );
    		sprintf( line, "Content-Type:%s;name=%s\r\n", mail->contentype[ filecount-1 ], mail->filename[ filecount-1 ]);
		writea( mail->connfd, line, strlen(line), NULL);
    		sprintf( line, "Content-Disposition: attachment; filename=\"%s\"\r\n",	mail->filename[ filecount-1 ]);
		writea( mail->connfd, line, strlen(line), NULL);
//    		sprintf(line, "'Content-Length: %d\r\n", 6311);
//		writea( mail->connfd, line, strlen(line), NULL);
		sprintf( line, "Content-Transfer-Encoding: base64\r\n\r\n");
		writea( mail->connfd, line, strlen(line), NULL);
		fd = fopen( mail->filename[ filecount-1 ], "r" );
		if( fd == NULL ){
			printf("%s)%s: [ %s ] error!\n", __FILE__, __FUNCTION__, mail->filename[ filecount-1 ] );
			return -1;
		}
		totalsize = 0;
		do{
			encode_len = fread( encode_data, 1, NETWORK_PACKET , fd ); 
			decode_len = Base64Encode( encode_data, encode_len, decode_data + totalsize);
			totalsize += decode_len;
			if( feof( fd ) ){
				decode_data[ totalsize++ ] = '\r';
				decode_data[ totalsize++ ] = '\n';
				write( mail->connfd, decode_data, totalsize);
				//printf("end of file\n");
				break;
			}
			do{
				sendbytes = ( totalsize >= NETWORK_PACKET ) ? NETWORK_PACKET : totalsize;
				write( mail->connfd, decode_data, sendbytes );
				totalsize -= sendbytes;
				if( decode_len ) memcpy( decode_data, decode_data + sendbytes, totalsize );
			}while( totalsize >= NETWORK_PACKET );
		} while( totalsize >= 0 );
		filecount--;
		write( mail->connfd, "\r\n", 2 );
		fclose( fd );
	}
	return 0;
}
int GetIPFromDomain(struct MAILSTRUCT *mail){
	mail->connfd = socket(AF_INET, SOCK_STREAM, 0);
 	if( mail->connfd == -1 ) return -1;
	bzero( &mail->servaddr, sizeof( mail->servaddr ) );
	mail->servaddr.sin_family	= AF_INET;
	mail->servaddr.sin_port	= htons( MAIL_PORT );
	//if not a raw IP address 
	if (!isdigit( mail->mailserver[0] )) {
		struct hostent *hptr = (struct hostent *)gethostbyname( mail->mailserver );
		if (hptr == NULL) {
			printf("Bad Domainname of mailserver!...\n");
			return -1;
		}
		else{
			struct in_addr **addrs;
			addrs = (struct in_addr **)hptr->h_addr_list;
			memcpy(&mail->servaddr.sin_addr, *addrs, sizeof(struct in_addr));
		}
	}
	else    mail->servaddr.sin_addr.s_addr = inet_addr( mail->mailserver );
	return 0;
}
int mailSend(struct MAILSTRUCT *mail ){
	char	line[2048];
	char	userb[64],passb[64];
	int	ret;
	memset( userb,	0, 64 );	
	memset( passb,	0, 64 );	
	memset( line,	0, 2048 );	

	GetIPFromDomain( mail );
	if ( connect( mail->connfd, (struct sockaddr *)&mail->servaddr, sizeof(mail->servaddr)) == -1 ) return -1;
		/* Look for initial salutation */
		ret = read( mail->connfd, line, sizeof(line)-1); line[ret] = 0;
		if ( codescan( line, "220", 3) == -1) return -1;
		/* Send HELO and await response */

		if( writea( mail->connfd, MAIL_MSG_HELLO, strlen( MAIL_MSG_HELLO ), "250" ) == -1 ) return -1;

		/* Send AUTH and await response */
		if ( mail->blogin ){
			sprintf( line, MAIL_MSG_AUTH);
			if( writea( mail->connfd, MAIL_MSG_AUTH, strlen( MAIL_MSG_AUTH ), "334" ) == -1) return -1;

			Base64Encode( mail->username ,strlen( mail->username ), userb );
			Base64Encode( mail->password ,strlen( mail->password ), passb );

			sprintf(line,"%s\n", userb);
			if( writea( mail->connfd, line, strlen( line ), "334" ) == -1 ) return -1;

			sprintf(line,"%s\n", passb);
			if( writea( mail->connfd, line, strlen( line ), "235" ) == -1 ) return -1;
		}
		/* Send MAIL FROM and await response */
		sprintf(line, "MAIL FROM: %s\n", mail->from);
		if( writea( mail->connfd, line, strlen(line) , "250" ) == -1 ) return -1;
  		/* Send RCPT TO and await response */
		sprintf(line, "RCPT TO: %s\n", mail->to);    
		if( writea( mail->connfd, line, strlen(line), "250" ) == -1 ) return -1;
		/* Send DATA and await response */
		if( writea( mail->connfd, MAIL_MSG_DATA, strlen(MAIL_MSG_DATA), "354") == -1 ) return -1;
		/* Send out the header first */
		sprintf(line, "From: %s\n", mail->from);
		if( writea( mail->connfd, line, strlen(line), NULL ) == -1 ) return -1;

		sprintf(line, "To: %s\n", mail->to);
		if( writea( mail->connfd, line, strlen(line), NULL ) == -1 ) return -1;
 
		sprintf(line,"subject:%s\r\n",mail->subject);
		if( writea( mail->connfd, line,strlen(line), NULL ) == -1 ) return -1;

        	sprintf(line,"Content-type: multipart/mixed; boundary=\"%s\"\r\n",mail->boundary);
		if( writea( mail->connfd, line, strlen(line), NULL ) == -1 ) return -1;

        	sprintf(line,"Mime-version: 1.0\r\n");
		if( writea(mail->connfd, line, strlen(line), NULL ) == -1 ) return -1;;

		sprintf(line,"\r\n--%s\r\n", mail->boundary);
		if( writea(mail->connfd, line, strlen(line), NULL) == -1 ) return -1;

		sprintf(line,"Content-Type: text/plain; charset=us-ascii\r\n");
		if( writea(mail->connfd, line, strlen(line), NULL ) == -1 ) return -1;

		sprintf(line,"Content-Disposition: inline\r\n");
		if( writea(mail->connfd, line, strlen(line), NULL ) == -1 ) return -1;

		if( mail->content != NULL ){
			writea(mail->connfd, mail->content, strlen( mail->content ), NULL);
			writea(mail->connfd, "\r\n", 2, NULL );
		}

		if( mail->nfile >0 ){
			if( sendfile( mail ) == -1 ) return -1;
		}

		sprintf(line,"\r\n--%s--\r\n", mail->boundary);
		writea(mail->connfd, line, strlen(line), NULL);

		if( writea(mail->connfd, MAIL_MSG_END, strlen( MAIL_MSG_END ), "250") == -1 ) return -1;
		if( writea(mail->connfd, MAIL_MSG_QUIT, strlen(MAIL_MSG_QUIT), "221")== -1 )return -1;
		close(mail->connfd);
		return 0;
}
int mailAddFile( struct MAILSTRUCT *mail, char *filename, char *contentype ){
	if( mail->nfile > MAX_ATTACHFILE ) return -1;
	mail->filename[ mail->nfile ] = ( char* ) malloc ( strlen(filename)+1 );
	sprintf( mail->filename[ mail->nfile ], "%s", filename );

	
	mail->contentype[ mail->nfile ] =
			( contentype == NULL ) ? ( char* ) malloc ( 30 ):( char* ) malloc ( strlen(contentype)+1 );
	if( contentype == NULL )	sprintf( mail->contentype[ mail->nfile ], "%s", " application/octet-stream");
	else				sprintf( mail->contentype[ mail->nfile ], "%s", contentype);

	mail->nfile++;
	return 0;
}
int mailAddSubjectContent( struct MAILSTRUCT *mail,char *subject,  char *content ){
	mail->content =( char* ) malloc( strlen( content ) );
	mail->subject =( char* ) malloc( strlen( subject ) );
	sprintf( mail->content, "%s", content );
	sprintf( mail->subject,	"%s", subject);
	return 0;
}

int mailSet(struct MAILSTRUCT *mail, char *user, char *password, char *from, char *to, char *server){
//	sprintf(mail.to,"jackchen@pixord.com");
	sprintf( mail->mailserver, server);
	if( mail->username != NULL ){
		mail->blogin = 1;
		sprintf(mail->username, "%s", user);
		sprintf(mail->password, "%s", password);
	}
	else	mail->blogin = 0;
	sprintf( mail->from,	"%s", from);
	sprintf( mail->to,	"%s", to);
	return 0;
}
void mailQuit( struct MAILSTRUCT *mail ){
	int i;
	for(i = 0; i < MAX_ATTACHFILE ; ++i ){
		if( mail->filename[i] != NULL ) free( mail->filename[i] );
	}
	if( mail->content != NULL ) free( mail->content );
	if( mail->subject != NULL ) free( mail->subject );
	free( mail );
	
}
struct MAILSTRUCT* mailInit(){
	int i;
	struct MAILSTRUCT *mailnew;

	mailnew  = (struct MAILSTRUCT *) malloc( sizeof(struct MAILSTRUCT) ) ;
	mailnew->set		= ( FUNC_SET ) mailSet;
	mailnew->addsubcon	= ( FUNC_SUBCONTENT ) mailAddSubjectContent;
	mailnew->addfile	= ( FUNC_FILE ) mailAddFile;
	mailnew->send		= ( FUNC_SEND ) mailSend;
	mailnew->quit		= ( FUNC_QUIT ) mailQuit;

	sprintf(mailnew->boundary,	"%s", MAIL_BOUNDARY);
	mailnew->blogin	 = 0;
	mailnew->nfile	 = 0;
	mailnew->content = NULL;
	mailnew->subject = NULL;
	for(i = 0; i < MAX_ATTACHFILE ; ++i ){
		mailnew->filename[i] = NULL;
		mailnew->contentype[i] = NULL;
	}
	return mailnew;
}

